/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCampaignDateRangeKpiResponse extends PinpointResponse implements
        ToCopyableBuilder<GetCampaignDateRangeKpiResponse.Builder, GetCampaignDateRangeKpiResponse> {
    private static final SdkField<CampaignDateRangeKpiResponse> CAMPAIGN_DATE_RANGE_KPI_RESPONSE_FIELD = SdkField
            .<CampaignDateRangeKpiResponse> builder(MarshallingType.SDK_POJO)
            .memberName("CampaignDateRangeKpiResponse")
            .getter(getter(GetCampaignDateRangeKpiResponse::campaignDateRangeKpiResponse))
            .setter(setter(Builder::campaignDateRangeKpiResponse))
            .constructor(CampaignDateRangeKpiResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignDateRangeKpiResponse")
                    .build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CAMPAIGN_DATE_RANGE_KPI_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CampaignDateRangeKpiResponse campaignDateRangeKpiResponse;

    private GetCampaignDateRangeKpiResponse(BuilderImpl builder) {
        super(builder);
        this.campaignDateRangeKpiResponse = builder.campaignDateRangeKpiResponse;
    }

    /**
     * Returns the value of the CampaignDateRangeKpiResponse property for this object.
     * 
     * @return The value of the CampaignDateRangeKpiResponse property for this object.
     */
    public final CampaignDateRangeKpiResponse campaignDateRangeKpiResponse() {
        return campaignDateRangeKpiResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaignDateRangeKpiResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignDateRangeKpiResponse)) {
            return false;
        }
        GetCampaignDateRangeKpiResponse other = (GetCampaignDateRangeKpiResponse) obj;
        return Objects.equals(campaignDateRangeKpiResponse(), other.campaignDateRangeKpiResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCampaignDateRangeKpiResponse")
                .add("CampaignDateRangeKpiResponse", campaignDateRangeKpiResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignDateRangeKpiResponse":
            return Optional.ofNullable(clazz.cast(campaignDateRangeKpiResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CampaignDateRangeKpiResponse", CAMPAIGN_DATE_RANGE_KPI_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignDateRangeKpiResponse, T> g) {
        return obj -> g.apply((GetCampaignDateRangeKpiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCampaignDateRangeKpiResponse> {
        /**
         * Sets the value of the CampaignDateRangeKpiResponse property for this object.
         *
         * @param campaignDateRangeKpiResponse
         *        The new value for the CampaignDateRangeKpiResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignDateRangeKpiResponse(CampaignDateRangeKpiResponse campaignDateRangeKpiResponse);

        /**
         * Sets the value of the CampaignDateRangeKpiResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CampaignDateRangeKpiResponse.Builder}
         * avoiding the need to create one manually via {@link CampaignDateRangeKpiResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CampaignDateRangeKpiResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #campaignDateRangeKpiResponse(CampaignDateRangeKpiResponse)}.
         * 
         * @param campaignDateRangeKpiResponse
         *        a consumer that will call methods on {@link CampaignDateRangeKpiResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaignDateRangeKpiResponse(CampaignDateRangeKpiResponse)
         */
        default Builder campaignDateRangeKpiResponse(Consumer<CampaignDateRangeKpiResponse.Builder> campaignDateRangeKpiResponse) {
            return campaignDateRangeKpiResponse(CampaignDateRangeKpiResponse.builder()
                    .applyMutation(campaignDateRangeKpiResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private CampaignDateRangeKpiResponse campaignDateRangeKpiResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignDateRangeKpiResponse model) {
            super(model);
            campaignDateRangeKpiResponse(model.campaignDateRangeKpiResponse);
        }

        public final CampaignDateRangeKpiResponse.Builder getCampaignDateRangeKpiResponse() {
            return campaignDateRangeKpiResponse != null ? campaignDateRangeKpiResponse.toBuilder() : null;
        }

        public final void setCampaignDateRangeKpiResponse(CampaignDateRangeKpiResponse.BuilderImpl campaignDateRangeKpiResponse) {
            this.campaignDateRangeKpiResponse = campaignDateRangeKpiResponse != null ? campaignDateRangeKpiResponse.build()
                    : null;
        }

        @Override
        public final Builder campaignDateRangeKpiResponse(CampaignDateRangeKpiResponse campaignDateRangeKpiResponse) {
            this.campaignDateRangeKpiResponse = campaignDateRangeKpiResponse;
            return this;
        }

        @Override
        public GetCampaignDateRangeKpiResponse build() {
            return new GetCampaignDateRangeKpiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
