/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJourneyExecutionActivityMetricsResponse extends PinpointResponse implements
        ToCopyableBuilder<GetJourneyExecutionActivityMetricsResponse.Builder, GetJourneyExecutionActivityMetricsResponse> {
    private static final SdkField<JourneyExecutionActivityMetricsResponse> JOURNEY_EXECUTION_ACTIVITY_METRICS_RESPONSE_FIELD = SdkField
            .<JourneyExecutionActivityMetricsResponse> builder(MarshallingType.SDK_POJO)
            .memberName("JourneyExecutionActivityMetricsResponse")
            .getter(getter(GetJourneyExecutionActivityMetricsResponse::journeyExecutionActivityMetricsResponse))
            .setter(setter(Builder::journeyExecutionActivityMetricsResponse))
            .constructor(JourneyExecutionActivityMetricsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("JourneyExecutionActivityMetricsResponse").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(JOURNEY_EXECUTION_ACTIVITY_METRICS_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final JourneyExecutionActivityMetricsResponse journeyExecutionActivityMetricsResponse;

    private GetJourneyExecutionActivityMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.journeyExecutionActivityMetricsResponse = builder.journeyExecutionActivityMetricsResponse;
    }

    /**
     * Returns the value of the JourneyExecutionActivityMetricsResponse property for this object.
     * 
     * @return The value of the JourneyExecutionActivityMetricsResponse property for this object.
     */
    public final JourneyExecutionActivityMetricsResponse journeyExecutionActivityMetricsResponse() {
        return journeyExecutionActivityMetricsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(journeyExecutionActivityMetricsResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJourneyExecutionActivityMetricsResponse)) {
            return false;
        }
        GetJourneyExecutionActivityMetricsResponse other = (GetJourneyExecutionActivityMetricsResponse) obj;
        return Objects.equals(journeyExecutionActivityMetricsResponse(), other.journeyExecutionActivityMetricsResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJourneyExecutionActivityMetricsResponse")
                .add("JourneyExecutionActivityMetricsResponse", journeyExecutionActivityMetricsResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JourneyExecutionActivityMetricsResponse":
            return Optional.ofNullable(clazz.cast(journeyExecutionActivityMetricsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JourneyExecutionActivityMetricsResponse", JOURNEY_EXECUTION_ACTIVITY_METRICS_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJourneyExecutionActivityMetricsResponse, T> g) {
        return obj -> g.apply((GetJourneyExecutionActivityMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetJourneyExecutionActivityMetricsResponse> {
        /**
         * Sets the value of the JourneyExecutionActivityMetricsResponse property for this object.
         *
         * @param journeyExecutionActivityMetricsResponse
         *        The new value for the JourneyExecutionActivityMetricsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyExecutionActivityMetricsResponse(
                JourneyExecutionActivityMetricsResponse journeyExecutionActivityMetricsResponse);

        /**
         * Sets the value of the JourneyExecutionActivityMetricsResponse property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link JourneyExecutionActivityMetricsResponse.Builder} avoiding the need to create one manually via
         * {@link JourneyExecutionActivityMetricsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JourneyExecutionActivityMetricsResponse.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #journeyExecutionActivityMetricsResponse(JourneyExecutionActivityMetricsResponse)}.
         * 
         * @param journeyExecutionActivityMetricsResponse
         *        a consumer that will call methods on {@link JourneyExecutionActivityMetricsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #journeyExecutionActivityMetricsResponse(JourneyExecutionActivityMetricsResponse)
         */
        default Builder journeyExecutionActivityMetricsResponse(
                Consumer<JourneyExecutionActivityMetricsResponse.Builder> journeyExecutionActivityMetricsResponse) {
            return journeyExecutionActivityMetricsResponse(JourneyExecutionActivityMetricsResponse.builder()
                    .applyMutation(journeyExecutionActivityMetricsResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private JourneyExecutionActivityMetricsResponse journeyExecutionActivityMetricsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJourneyExecutionActivityMetricsResponse model) {
            super(model);
            journeyExecutionActivityMetricsResponse(model.journeyExecutionActivityMetricsResponse);
        }

        public final JourneyExecutionActivityMetricsResponse.Builder getJourneyExecutionActivityMetricsResponse() {
            return journeyExecutionActivityMetricsResponse != null ? journeyExecutionActivityMetricsResponse.toBuilder() : null;
        }

        public final void setJourneyExecutionActivityMetricsResponse(
                JourneyExecutionActivityMetricsResponse.BuilderImpl journeyExecutionActivityMetricsResponse) {
            this.journeyExecutionActivityMetricsResponse = journeyExecutionActivityMetricsResponse != null ? journeyExecutionActivityMetricsResponse
                    .build() : null;
        }

        @Override
        public final Builder journeyExecutionActivityMetricsResponse(
                JourneyExecutionActivityMetricsResponse journeyExecutionActivityMetricsResponse) {
            this.journeyExecutionActivityMetricsResponse = journeyExecutionActivityMetricsResponse;
            return this;
        }

        @Override
        public GetJourneyExecutionActivityMetricsResponse build() {
            return new GetJourneyExecutionActivityMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
