/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTemplatesRequest extends PinpointRequest implements
        ToCopyableBuilder<ListTemplatesRequest.Builder, ListTemplatesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTemplatesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<String> PAGE_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageSize").getter(getter(ListTemplatesRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("page-size").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(ListTemplatesRequest::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("prefix").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateType").getter(getter(ListTemplatesRequest::templateType)).setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("template-type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PAGE_SIZE_FIELD, PREFIX_FIELD, TEMPLATE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final String pageSize;

    private final String prefix;

    private final String templateType;

    private ListTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
        this.prefix = builder.prefix;
        this.templateType = builder.templateType;
    }

    /**
     * <p>
     * The string that specifies which page of results to return in a paginated response. This parameter is not
     * supported for application, campaign, and journey metrics.
     * </p>
     * 
     * @return The string that specifies which page of results to return in a paginated response. This parameter is not
     *         supported for application, campaign, and journey metrics.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to include in each page of a paginated response. This parameter is not supported for
     * application, campaign, and journey metrics.
     * </p>
     * 
     * @return The maximum number of items to include in each page of a paginated response. This parameter is not
     *         supported for application, campaign, and journey metrics.
     */
    public final String pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The substring to match in the names of the message templates to include in the results. If you specify this
     * value, Amazon Pinpoint returns only those templates whose names begin with the value that you specify.
     * </p>
     * 
     * @return The substring to match in the names of the message templates to include in the results. If you specify
     *         this value, Amazon Pinpoint returns only those templates whose names begin with the value that you
     *         specify.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To include
     * all types of templates in the results, don't include this parameter in your request.
     * </p>
     * 
     * @return The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To
     *         include all types of templates in the results, don't include this parameter in your request.
     */
    public final String templateType() {
        return templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(templateType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplatesRequest)) {
            return false;
        }
        ListTemplatesRequest other = (ListTemplatesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(prefix(), other.prefix()) && Objects.equals(templateType(), other.templateType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTemplatesRequest").add("NextToken", nextToken()).add("PageSize", pageSize())
                .add("Prefix", prefix()).add("TemplateType", templateType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "TemplateType":
            return Optional.ofNullable(clazz.cast(templateType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("next-token", NEXT_TOKEN_FIELD);
        map.put("page-size", PAGE_SIZE_FIELD);
        map.put("prefix", PREFIX_FIELD);
        map.put("template-type", TEMPLATE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTemplatesRequest, T> g) {
        return obj -> g.apply((ListTemplatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTemplatesRequest> {
        /**
         * <p>
         * The string that specifies which page of results to return in a paginated response. This parameter is not
         * supported for application, campaign, and journey metrics.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies which page of results to return in a paginated response. This parameter is
         *        not supported for application, campaign, and journey metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to include in each page of a paginated response. This parameter is not supported
         * for application, campaign, and journey metrics.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to include in each page of a paginated response. This parameter is not
         *        supported for application, campaign, and journey metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(String pageSize);

        /**
         * <p>
         * The substring to match in the names of the message templates to include in the results. If you specify this
         * value, Amazon Pinpoint returns only those templates whose names begin with the value that you specify.
         * </p>
         * 
         * @param prefix
         *        The substring to match in the names of the message templates to include in the results. If you specify
         *        this value, Amazon Pinpoint returns only those templates whose names begin with the value that you
         *        specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE. To
         * include all types of templates in the results, don't include this parameter in your request.
         * </p>
         * 
         * @param templateType
         *        The type of message template to include in the results. Valid values are: EMAIL, PUSH, SMS, and VOICE.
         *        To include all types of templates in the results, don't include this parameter in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateType(String templateType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String nextToken;

        private String pageSize;

        private String prefix;

        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplatesRequest model) {
            super(model);
            nextToken(model.nextToken);
            pageSize(model.pageSize);
            prefix(model.prefix);
            templateType(model.templateType);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPageSize() {
            return pageSize;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTemplatesRequest build() {
            return new ListTemplatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
