/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the message configuration settings for a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageConfiguration.Builder, MessageConfiguration> {
    private static final SdkField<Message> ADM_MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .memberName("ADMMessage").getter(getter(MessageConfiguration::admMessage)).setter(setter(Builder::admMessage))
            .constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADMMessage").build()).build();

    private static final SdkField<Message> APNS_MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .memberName("APNSMessage").getter(getter(MessageConfiguration::apnsMessage)).setter(setter(Builder::apnsMessage))
            .constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSMessage").build()).build();

    private static final SdkField<Message> BAIDU_MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .memberName("BaiduMessage").getter(getter(MessageConfiguration::baiduMessage)).setter(setter(Builder::baiduMessage))
            .constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaiduMessage").build()).build();

    private static final SdkField<CampaignCustomMessage> CUSTOM_MESSAGE_FIELD = SdkField
            .<CampaignCustomMessage> builder(MarshallingType.SDK_POJO).memberName("CustomMessage")
            .getter(getter(MessageConfiguration::customMessage)).setter(setter(Builder::customMessage))
            .constructor(CampaignCustomMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomMessage").build()).build();

    private static final SdkField<Message> DEFAULT_MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultMessage").getter(getter(MessageConfiguration::defaultMessage))
            .setter(setter(Builder::defaultMessage)).constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMessage").build()).build();

    private static final SdkField<CampaignEmailMessage> EMAIL_MESSAGE_FIELD = SdkField
            .<CampaignEmailMessage> builder(MarshallingType.SDK_POJO).memberName("EmailMessage")
            .getter(getter(MessageConfiguration::emailMessage)).setter(setter(Builder::emailMessage))
            .constructor(CampaignEmailMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()).build();

    private static final SdkField<Message> GCM_MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .memberName("GCMMessage").getter(getter(MessageConfiguration::gcmMessage)).setter(setter(Builder::gcmMessage))
            .constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GCMMessage").build()).build();

    private static final SdkField<CampaignSmsMessage> SMS_MESSAGE_FIELD = SdkField
            .<CampaignSmsMessage> builder(MarshallingType.SDK_POJO).memberName("SMSMessage")
            .getter(getter(MessageConfiguration::smsMessage)).setter(setter(Builder::smsMessage))
            .constructor(CampaignSmsMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMessage").build()).build();

    private static final SdkField<CampaignInAppMessage> IN_APP_MESSAGE_FIELD = SdkField
            .<CampaignInAppMessage> builder(MarshallingType.SDK_POJO).memberName("InAppMessage")
            .getter(getter(MessageConfiguration::inAppMessage)).setter(setter(Builder::inAppMessage))
            .constructor(CampaignInAppMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InAppMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_MESSAGE_FIELD,
            APNS_MESSAGE_FIELD, BAIDU_MESSAGE_FIELD, CUSTOM_MESSAGE_FIELD, DEFAULT_MESSAGE_FIELD, EMAIL_MESSAGE_FIELD,
            GCM_MESSAGE_FIELD, SMS_MESSAGE_FIELD, IN_APP_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Message admMessage;

    private final Message apnsMessage;

    private final Message baiduMessage;

    private final CampaignCustomMessage customMessage;

    private final Message defaultMessage;

    private final CampaignEmailMessage emailMessage;

    private final Message gcmMessage;

    private final CampaignSmsMessage smsMessage;

    private final CampaignInAppMessage inAppMessage;

    private MessageConfiguration(BuilderImpl builder) {
        this.admMessage = builder.admMessage;
        this.apnsMessage = builder.apnsMessage;
        this.baiduMessage = builder.baiduMessage;
        this.customMessage = builder.customMessage;
        this.defaultMessage = builder.defaultMessage;
        this.emailMessage = builder.emailMessage;
        this.gcmMessage = builder.gcmMessage;
        this.smsMessage = builder.smsMessage;
        this.inAppMessage = builder.inAppMessage;
    }

    /**
     * <p>
     * The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this message
     * overrides the default message.
     * </p>
     * 
     * @return The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this
     *         message overrides the default message.
     */
    public final Message admMessage() {
        return admMessage;
    }

    /**
     * <p>
     * The message that the campaign sends through the APNs (Apple Push Notification service) channel. If specified,
     * this message overrides the default message.
     * </p>
     * 
     * @return The message that the campaign sends through the APNs (Apple Push Notification service) channel. If
     *         specified, this message overrides the default message.
     */
    public final Message apnsMessage() {
        return apnsMessage;
    }

    /**
     * <p>
     * The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this message
     * overrides the default message.
     * </p>
     * 
     * @return The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this
     *         message overrides the default message.
     */
    public final Message baiduMessage() {
        return baiduMessage;
    }

    /**
     * <p>
     * The message that the campaign sends through a custom channel, as specified by the delivery configuration
     * (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default
     * message.
     * </p>
     * 
     * @return The message that the campaign sends through a custom channel, as specified by the delivery configuration
     *         (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default
     *         message.
     */
    public final CampaignCustomMessage customMessage() {
        return customMessage;
    }

    /**
     * <p>
     * The default message that the campaign sends through all the channels that are configured for the campaign.
     * </p>
     * 
     * @return The default message that the campaign sends through all the channels that are configured for the
     *         campaign.
     */
    public final Message defaultMessage() {
        return defaultMessage;
    }

    /**
     * <p>
     * The message that the campaign sends through the email channel. If specified, this message overrides the default
     * message.
     * </p>
     * 
     * @return The message that the campaign sends through the email channel. If specified, this message overrides the
     *         default message.
     */
    public final CampaignEmailMessage emailMessage() {
        return emailMessage;
    }

    /**
     * <p>
     * The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push
     * notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. If
     * specified, this message overrides the default message.
     * </p>
     * 
     * @return The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push
     *         notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
     *         If specified, this message overrides the default message.
     */
    public final Message gcmMessage() {
        return gcmMessage;
    }

    /**
     * <p>
     * The message that the campaign sends through the SMS channel. If specified, this message overrides the default
     * message.
     * </p>
     * 
     * @return The message that the campaign sends through the SMS channel. If specified, this message overrides the
     *         default message.
     */
    public final CampaignSmsMessage smsMessage() {
        return smsMessage;
    }

    /**
     * <p>
     * The in-app message configuration.
     * </p>
     * 
     * @return The in-app message configuration.
     */
    public final CampaignInAppMessage inAppMessage() {
        return inAppMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(admMessage());
        hashCode = 31 * hashCode + Objects.hashCode(apnsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(baiduMessage());
        hashCode = 31 * hashCode + Objects.hashCode(customMessage());
        hashCode = 31 * hashCode + Objects.hashCode(defaultMessage());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(gcmMessage());
        hashCode = 31 * hashCode + Objects.hashCode(smsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(inAppMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageConfiguration)) {
            return false;
        }
        MessageConfiguration other = (MessageConfiguration) obj;
        return Objects.equals(admMessage(), other.admMessage()) && Objects.equals(apnsMessage(), other.apnsMessage())
                && Objects.equals(baiduMessage(), other.baiduMessage()) && Objects.equals(customMessage(), other.customMessage())
                && Objects.equals(defaultMessage(), other.defaultMessage())
                && Objects.equals(emailMessage(), other.emailMessage()) && Objects.equals(gcmMessage(), other.gcmMessage())
                && Objects.equals(smsMessage(), other.smsMessage()) && Objects.equals(inAppMessage(), other.inAppMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageConfiguration").add("ADMMessage", admMessage()).add("APNSMessage", apnsMessage())
                .add("BaiduMessage", baiduMessage()).add("CustomMessage", customMessage())
                .add("DefaultMessage", defaultMessage()).add("EmailMessage", emailMessage()).add("GCMMessage", gcmMessage())
                .add("SMSMessage", smsMessage()).add("InAppMessage", inAppMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ADMMessage":
            return Optional.ofNullable(clazz.cast(admMessage()));
        case "APNSMessage":
            return Optional.ofNullable(clazz.cast(apnsMessage()));
        case "BaiduMessage":
            return Optional.ofNullable(clazz.cast(baiduMessage()));
        case "CustomMessage":
            return Optional.ofNullable(clazz.cast(customMessage()));
        case "DefaultMessage":
            return Optional.ofNullable(clazz.cast(defaultMessage()));
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        case "GCMMessage":
            return Optional.ofNullable(clazz.cast(gcmMessage()));
        case "SMSMessage":
            return Optional.ofNullable(clazz.cast(smsMessage()));
        case "InAppMessage":
            return Optional.ofNullable(clazz.cast(inAppMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ADMMessage", ADM_MESSAGE_FIELD);
        map.put("APNSMessage", APNS_MESSAGE_FIELD);
        map.put("BaiduMessage", BAIDU_MESSAGE_FIELD);
        map.put("CustomMessage", CUSTOM_MESSAGE_FIELD);
        map.put("DefaultMessage", DEFAULT_MESSAGE_FIELD);
        map.put("EmailMessage", EMAIL_MESSAGE_FIELD);
        map.put("GCMMessage", GCM_MESSAGE_FIELD);
        map.put("SMSMessage", SMS_MESSAGE_FIELD);
        map.put("InAppMessage", IN_APP_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageConfiguration, T> g) {
        return obj -> g.apply((MessageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageConfiguration> {
        /**
         * <p>
         * The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this
         * message overrides the default message.
         * </p>
         * 
         * @param admMessage
         *        The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified,
         *        this message overrides the default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder admMessage(Message admMessage);

        /**
         * <p>
         * The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this
         * message overrides the default message.
         * </p>
         * This is a convenience method that creates an instance of the {@link Message.Builder} avoiding the need to
         * create one manually via {@link Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #admMessage(Message)}.
         * 
         * @param admMessage
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #admMessage(Message)
         */
        default Builder admMessage(Consumer<Message.Builder> admMessage) {
            return admMessage(Message.builder().applyMutation(admMessage).build());
        }

        /**
         * <p>
         * The message that the campaign sends through the APNs (Apple Push Notification service) channel. If specified,
         * this message overrides the default message.
         * </p>
         * 
         * @param apnsMessage
         *        The message that the campaign sends through the APNs (Apple Push Notification service) channel. If
         *        specified, this message overrides the default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apnsMessage(Message apnsMessage);

        /**
         * <p>
         * The message that the campaign sends through the APNs (Apple Push Notification service) channel. If specified,
         * this message overrides the default message.
         * </p>
         * This is a convenience method that creates an instance of the {@link Message.Builder} avoiding the need to
         * create one manually via {@link Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #apnsMessage(Message)}.
         * 
         * @param apnsMessage
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apnsMessage(Message)
         */
        default Builder apnsMessage(Consumer<Message.Builder> apnsMessage) {
            return apnsMessage(Message.builder().applyMutation(apnsMessage).build());
        }

        /**
         * <p>
         * The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this message
         * overrides the default message.
         * </p>
         * 
         * @param baiduMessage
         *        The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this
         *        message overrides the default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baiduMessage(Message baiduMessage);

        /**
         * <p>
         * The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this message
         * overrides the default message.
         * </p>
         * This is a convenience method that creates an instance of the {@link Message.Builder} avoiding the need to
         * create one manually via {@link Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #baiduMessage(Message)}.
         * 
         * @param baiduMessage
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baiduMessage(Message)
         */
        default Builder baiduMessage(Consumer<Message.Builder> baiduMessage) {
            return baiduMessage(Message.builder().applyMutation(baiduMessage).build());
        }

        /**
         * <p>
         * The message that the campaign sends through a custom channel, as specified by the delivery configuration
         * (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default
         * message.
         * </p>
         * 
         * @param customMessage
         *        The message that the campaign sends through a custom channel, as specified by the delivery
         *        configuration (CustomDeliveryConfiguration) settings for the campaign. If specified, this message
         *        overrides the default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMessage(CampaignCustomMessage customMessage);

        /**
         * <p>
         * The message that the campaign sends through a custom channel, as specified by the delivery configuration
         * (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default
         * message.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignCustomMessage.Builder} avoiding
         * the need to create one manually via {@link CampaignCustomMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CampaignCustomMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #customMessage(CampaignCustomMessage)}.
         * 
         * @param customMessage
         *        a consumer that will call methods on {@link CampaignCustomMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customMessage(CampaignCustomMessage)
         */
        default Builder customMessage(Consumer<CampaignCustomMessage.Builder> customMessage) {
            return customMessage(CampaignCustomMessage.builder().applyMutation(customMessage).build());
        }

        /**
         * <p>
         * The default message that the campaign sends through all the channels that are configured for the campaign.
         * </p>
         * 
         * @param defaultMessage
         *        The default message that the campaign sends through all the channels that are configured for the
         *        campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultMessage(Message defaultMessage);

        /**
         * <p>
         * The default message that the campaign sends through all the channels that are configured for the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link Message.Builder} avoiding the need to
         * create one manually via {@link Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #defaultMessage(Message)}.
         * 
         * @param defaultMessage
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultMessage(Message)
         */
        default Builder defaultMessage(Consumer<Message.Builder> defaultMessage) {
            return defaultMessage(Message.builder().applyMutation(defaultMessage).build());
        }

        /**
         * <p>
         * The message that the campaign sends through the email channel. If specified, this message overrides the
         * default message.
         * </p>
         * 
         * @param emailMessage
         *        The message that the campaign sends through the email channel. If specified, this message overrides
         *        the default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(CampaignEmailMessage emailMessage);

        /**
         * <p>
         * The message that the campaign sends through the email channel. If specified, this message overrides the
         * default message.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignEmailMessage.Builder} avoiding
         * the need to create one manually via {@link CampaignEmailMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CampaignEmailMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #emailMessage(CampaignEmailMessage)}.
         * 
         * @param emailMessage
         *        a consumer that will call methods on {@link CampaignEmailMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailMessage(CampaignEmailMessage)
         */
        default Builder emailMessage(Consumer<CampaignEmailMessage.Builder> emailMessage) {
            return emailMessage(CampaignEmailMessage.builder().applyMutation(emailMessage).build());
        }

        /**
         * <p>
         * The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push
         * notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. If
         * specified, this message overrides the default message.
         * </p>
         * 
         * @param gcmMessage
         *        The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send
         *        push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM),
         *        service. If specified, this message overrides the default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gcmMessage(Message gcmMessage);

        /**
         * <p>
         * The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push
         * notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. If
         * specified, this message overrides the default message.
         * </p>
         * This is a convenience method that creates an instance of the {@link Message.Builder} avoiding the need to
         * create one manually via {@link Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #gcmMessage(Message)}.
         * 
         * @param gcmMessage
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gcmMessage(Message)
         */
        default Builder gcmMessage(Consumer<Message.Builder> gcmMessage) {
            return gcmMessage(Message.builder().applyMutation(gcmMessage).build());
        }

        /**
         * <p>
         * The message that the campaign sends through the SMS channel. If specified, this message overrides the default
         * message.
         * </p>
         * 
         * @param smsMessage
         *        The message that the campaign sends through the SMS channel. If specified, this message overrides the
         *        default message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMessage(CampaignSmsMessage smsMessage);

        /**
         * <p>
         * The message that the campaign sends through the SMS channel. If specified, this message overrides the default
         * message.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignSmsMessage.Builder} avoiding the
         * need to create one manually via {@link CampaignSmsMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CampaignSmsMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #smsMessage(CampaignSmsMessage)}.
         * 
         * @param smsMessage
         *        a consumer that will call methods on {@link CampaignSmsMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smsMessage(CampaignSmsMessage)
         */
        default Builder smsMessage(Consumer<CampaignSmsMessage.Builder> smsMessage) {
            return smsMessage(CampaignSmsMessage.builder().applyMutation(smsMessage).build());
        }

        /**
         * <p>
         * The in-app message configuration.
         * </p>
         * 
         * @param inAppMessage
         *        The in-app message configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inAppMessage(CampaignInAppMessage inAppMessage);

        /**
         * <p>
         * The in-app message configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignInAppMessage.Builder} avoiding
         * the need to create one manually via {@link CampaignInAppMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CampaignInAppMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #inAppMessage(CampaignInAppMessage)}.
         * 
         * @param inAppMessage
         *        a consumer that will call methods on {@link CampaignInAppMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inAppMessage(CampaignInAppMessage)
         */
        default Builder inAppMessage(Consumer<CampaignInAppMessage.Builder> inAppMessage) {
            return inAppMessage(CampaignInAppMessage.builder().applyMutation(inAppMessage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Message admMessage;

        private Message apnsMessage;

        private Message baiduMessage;

        private CampaignCustomMessage customMessage;

        private Message defaultMessage;

        private CampaignEmailMessage emailMessage;

        private Message gcmMessage;

        private CampaignSmsMessage smsMessage;

        private CampaignInAppMessage inAppMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageConfiguration model) {
            admMessage(model.admMessage);
            apnsMessage(model.apnsMessage);
            baiduMessage(model.baiduMessage);
            customMessage(model.customMessage);
            defaultMessage(model.defaultMessage);
            emailMessage(model.emailMessage);
            gcmMessage(model.gcmMessage);
            smsMessage(model.smsMessage);
            inAppMessage(model.inAppMessage);
        }

        public final Message.Builder getAdmMessage() {
            return admMessage != null ? admMessage.toBuilder() : null;
        }

        public final void setAdmMessage(Message.BuilderImpl admMessage) {
            this.admMessage = admMessage != null ? admMessage.build() : null;
        }

        @Override
        public final Builder admMessage(Message admMessage) {
            this.admMessage = admMessage;
            return this;
        }

        public final Message.Builder getApnsMessage() {
            return apnsMessage != null ? apnsMessage.toBuilder() : null;
        }

        public final void setApnsMessage(Message.BuilderImpl apnsMessage) {
            this.apnsMessage = apnsMessage != null ? apnsMessage.build() : null;
        }

        @Override
        public final Builder apnsMessage(Message apnsMessage) {
            this.apnsMessage = apnsMessage;
            return this;
        }

        public final Message.Builder getBaiduMessage() {
            return baiduMessage != null ? baiduMessage.toBuilder() : null;
        }

        public final void setBaiduMessage(Message.BuilderImpl baiduMessage) {
            this.baiduMessage = baiduMessage != null ? baiduMessage.build() : null;
        }

        @Override
        public final Builder baiduMessage(Message baiduMessage) {
            this.baiduMessage = baiduMessage;
            return this;
        }

        public final CampaignCustomMessage.Builder getCustomMessage() {
            return customMessage != null ? customMessage.toBuilder() : null;
        }

        public final void setCustomMessage(CampaignCustomMessage.BuilderImpl customMessage) {
            this.customMessage = customMessage != null ? customMessage.build() : null;
        }

        @Override
        public final Builder customMessage(CampaignCustomMessage customMessage) {
            this.customMessage = customMessage;
            return this;
        }

        public final Message.Builder getDefaultMessage() {
            return defaultMessage != null ? defaultMessage.toBuilder() : null;
        }

        public final void setDefaultMessage(Message.BuilderImpl defaultMessage) {
            this.defaultMessage = defaultMessage != null ? defaultMessage.build() : null;
        }

        @Override
        public final Builder defaultMessage(Message defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public final CampaignEmailMessage.Builder getEmailMessage() {
            return emailMessage != null ? emailMessage.toBuilder() : null;
        }

        public final void setEmailMessage(CampaignEmailMessage.BuilderImpl emailMessage) {
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
        }

        @Override
        public final Builder emailMessage(CampaignEmailMessage emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final Message.Builder getGcmMessage() {
            return gcmMessage != null ? gcmMessage.toBuilder() : null;
        }

        public final void setGcmMessage(Message.BuilderImpl gcmMessage) {
            this.gcmMessage = gcmMessage != null ? gcmMessage.build() : null;
        }

        @Override
        public final Builder gcmMessage(Message gcmMessage) {
            this.gcmMessage = gcmMessage;
            return this;
        }

        public final CampaignSmsMessage.Builder getSmsMessage() {
            return smsMessage != null ? smsMessage.toBuilder() : null;
        }

        public final void setSmsMessage(CampaignSmsMessage.BuilderImpl smsMessage) {
            this.smsMessage = smsMessage != null ? smsMessage.build() : null;
        }

        @Override
        public final Builder smsMessage(CampaignSmsMessage smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final CampaignInAppMessage.Builder getInAppMessage() {
            return inAppMessage != null ? inAppMessage.toBuilder() : null;
        }

        public final void setInAppMessage(CampaignInAppMessage.BuilderImpl inAppMessage) {
            this.inAppMessage = inAppMessage != null ? inAppMessage.build() : null;
        }

        @Override
        public final Builder inAppMessage(CampaignInAppMessage inAppMessage) {
            this.inAppMessage = inAppMessage;
            return this;
        }

        @Override
        public MessageConfiguration build() {
            return new MessageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
