/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCampaignRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateCampaignRequest.Builder, UpdateCampaignRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(UpdateCampaignRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CampaignId").getter(getter(UpdateCampaignRequest::campaignId)).setter(setter(Builder::campaignId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("campaign-id").build()).build();

    private static final SdkField<WriteCampaignRequest> WRITE_CAMPAIGN_REQUEST_FIELD = SdkField
            .<WriteCampaignRequest> builder(MarshallingType.SDK_POJO)
            .memberName("WriteCampaignRequest")
            .getter(getter(UpdateCampaignRequest::writeCampaignRequest))
            .setter(setter(Builder::writeCampaignRequest))
            .constructor(WriteCampaignRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteCampaignRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CAMPAIGN_ID_FIELD, WRITE_CAMPAIGN_REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String campaignId;

    private final WriteCampaignRequest writeCampaignRequest;

    private UpdateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
        this.writeCampaignRequest = builder.writeCampaignRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier for the campaign.
     * </p>
     * 
     * @return The unique identifier for the campaign.
     */
    public final String campaignId() {
        return campaignId;
    }

    /**
     * Returns the value of the WriteCampaignRequest property for this object.
     * 
     * @return The value of the WriteCampaignRequest property for this object.
     */
    public final WriteCampaignRequest writeCampaignRequest() {
        return writeCampaignRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(writeCampaignRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignRequest)) {
            return false;
        }
        UpdateCampaignRequest other = (UpdateCampaignRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(campaignId(), other.campaignId())
                && Objects.equals(writeCampaignRequest(), other.writeCampaignRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCampaignRequest").add("ApplicationId", applicationId()).add("CampaignId", campaignId())
                .add("WriteCampaignRequest", writeCampaignRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CampaignId":
            return Optional.ofNullable(clazz.cast(campaignId()));
        case "WriteCampaignRequest":
            return Optional.ofNullable(clazz.cast(writeCampaignRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("application-id", APPLICATION_ID_FIELD);
        map.put("campaign-id", CAMPAIGN_ID_FIELD);
        map.put("WriteCampaignRequest", WRITE_CAMPAIGN_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCampaignRequest, T> g) {
        return obj -> g.apply((UpdateCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCampaignRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier for the campaign.
         * </p>
         * 
         * @param campaignId
         *        The unique identifier for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignId(String campaignId);

        /**
         * Sets the value of the WriteCampaignRequest property for this object.
         *
         * @param writeCampaignRequest
         *        The new value for the WriteCampaignRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeCampaignRequest(WriteCampaignRequest writeCampaignRequest);

        /**
         * Sets the value of the WriteCampaignRequest property for this object.
         *
         * This is a convenience method that creates an instance of the {@link WriteCampaignRequest.Builder} avoiding
         * the need to create one manually via {@link WriteCampaignRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WriteCampaignRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #writeCampaignRequest(WriteCampaignRequest)}.
         * 
         * @param writeCampaignRequest
         *        a consumer that will call methods on {@link WriteCampaignRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #writeCampaignRequest(WriteCampaignRequest)
         */
        default Builder writeCampaignRequest(Consumer<WriteCampaignRequest.Builder> writeCampaignRequest) {
            return writeCampaignRequest(WriteCampaignRequest.builder().applyMutation(writeCampaignRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String campaignId;

        private WriteCampaignRequest writeCampaignRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignRequest model) {
            super(model);
            applicationId(model.applicationId);
            campaignId(model.campaignId);
            writeCampaignRequest(model.writeCampaignRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getCampaignId() {
            return campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final WriteCampaignRequest.Builder getWriteCampaignRequest() {
            return writeCampaignRequest != null ? writeCampaignRequest.toBuilder() : null;
        }

        public final void setWriteCampaignRequest(WriteCampaignRequest.BuilderImpl writeCampaignRequest) {
            this.writeCampaignRequest = writeCampaignRequest != null ? writeCampaignRequest.build() : null;
        }

        @Override
        public final Builder writeCampaignRequest(WriteCampaignRequest writeCampaignRequest) {
            this.writeCampaignRequest = writeCampaignRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCampaignRequest build() {
            return new UpdateCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
