/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration and other settings for a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteJourneyRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<WriteJourneyRequest.Builder, WriteJourneyRequest> {
    private static final SdkField<Map<String, Activity>> ACTIVITIES_FIELD = SdkField
            .<Map<String, Activity>> builder(MarshallingType.MAP)
            .memberName("Activities")
            .getter(getter(WriteJourneyRequest::activities))
            .setter(setter(Builder::activities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Activities").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Activity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Activity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(WriteJourneyRequest::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(WriteJourneyRequest::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<JourneyLimits> LIMITS_FIELD = SdkField.<JourneyLimits> builder(MarshallingType.SDK_POJO)
            .memberName("Limits").getter(getter(WriteJourneyRequest::limits)).setter(setter(Builder::limits))
            .constructor(JourneyLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()).build();

    private static final SdkField<Boolean> LOCAL_TIME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LocalTime").getter(getter(WriteJourneyRequest::localTime)).setter(setter(Builder::localTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(WriteJourneyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<QuietTime> QUIET_TIME_FIELD = SdkField.<QuietTime> builder(MarshallingType.SDK_POJO)
            .memberName("QuietTime").getter(getter(WriteJourneyRequest::quietTime)).setter(setter(Builder::quietTime))
            .constructor(QuietTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuietTime").build()).build();

    private static final SdkField<String> REFRESH_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RefreshFrequency").getter(getter(WriteJourneyRequest::refreshFrequency))
            .setter(setter(Builder::refreshFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshFrequency").build()).build();

    private static final SdkField<JourneySchedule> SCHEDULE_FIELD = SdkField.<JourneySchedule> builder(MarshallingType.SDK_POJO)
            .memberName("Schedule").getter(getter(WriteJourneyRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(JourneySchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> START_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartActivity").getter(getter(WriteJourneyRequest::startActivity))
            .setter(setter(Builder::startActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartActivity").build()).build();

    private static final SdkField<StartCondition> START_CONDITION_FIELD = SdkField
            .<StartCondition> builder(MarshallingType.SDK_POJO).memberName("StartCondition")
            .getter(getter(WriteJourneyRequest::startCondition)).setter(setter(Builder::startCondition))
            .constructor(StartCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartCondition").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(WriteJourneyRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Boolean> WAIT_FOR_QUIET_TIME_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WaitForQuietTime").getter(getter(WriteJourneyRequest::waitForQuietTime))
            .setter(setter(Builder::waitForQuietTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitForQuietTime").build()).build();

    private static final SdkField<Boolean> REFRESH_ON_SEGMENT_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RefreshOnSegmentUpdate").getter(getter(WriteJourneyRequest::refreshOnSegmentUpdate))
            .setter(setter(Builder::refreshOnSegmentUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshOnSegmentUpdate").build())
            .build();

    private static final SdkField<JourneyChannelSettings> JOURNEY_CHANNEL_SETTINGS_FIELD = SdkField
            .<JourneyChannelSettings> builder(MarshallingType.SDK_POJO).memberName("JourneyChannelSettings")
            .getter(getter(WriteJourneyRequest::journeyChannelSettings)).setter(setter(Builder::journeyChannelSettings))
            .constructor(JourneyChannelSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyChannelSettings").build())
            .build();

    private static final SdkField<Boolean> SENDING_SCHEDULE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SendingSchedule").getter(getter(WriteJourneyRequest::sendingSchedule))
            .setter(setter(Builder::sendingSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingSchedule").build()).build();

    private static final SdkField<OpenHours> OPEN_HOURS_FIELD = SdkField.<OpenHours> builder(MarshallingType.SDK_POJO)
            .memberName("OpenHours").getter(getter(WriteJourneyRequest::openHours)).setter(setter(Builder::openHours))
            .constructor(OpenHours::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenHours").build()).build();

    private static final SdkField<ClosedDays> CLOSED_DAYS_FIELD = SdkField.<ClosedDays> builder(MarshallingType.SDK_POJO)
            .memberName("ClosedDays").getter(getter(WriteJourneyRequest::closedDays)).setter(setter(Builder::closedDays))
            .constructor(ClosedDays::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClosedDays").build()).build();

    private static final SdkField<List<String>> TIMEZONE_ESTIMATION_METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TimezoneEstimationMethods")
            .getter(getter(WriteJourneyRequest::timezoneEstimationMethodsAsStrings))
            .setter(setter(Builder::timezoneEstimationMethodsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimezoneEstimationMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITIES_FIELD,
            CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, LIMITS_FIELD, LOCAL_TIME_FIELD, NAME_FIELD, QUIET_TIME_FIELD,
            REFRESH_FREQUENCY_FIELD, SCHEDULE_FIELD, START_ACTIVITY_FIELD, START_CONDITION_FIELD, STATE_FIELD,
            WAIT_FOR_QUIET_TIME_FIELD, REFRESH_ON_SEGMENT_UPDATE_FIELD, JOURNEY_CHANNEL_SETTINGS_FIELD, SENDING_SCHEDULE_FIELD,
            OPEN_HOURS_FIELD, CLOSED_DAYS_FIELD, TIMEZONE_ESTIMATION_METHODS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, Activity> activities;

    private final String creationDate;

    private final String lastModifiedDate;

    private final JourneyLimits limits;

    private final Boolean localTime;

    private final String name;

    private final QuietTime quietTime;

    private final String refreshFrequency;

    private final JourneySchedule schedule;

    private final String startActivity;

    private final StartCondition startCondition;

    private final String state;

    private final Boolean waitForQuietTime;

    private final Boolean refreshOnSegmentUpdate;

    private final JourneyChannelSettings journeyChannelSettings;

    private final Boolean sendingSchedule;

    private final OpenHours openHours;

    private final ClosedDays closedDays;

    private final List<String> timezoneEstimationMethods;

    private WriteJourneyRequest(BuilderImpl builder) {
        this.activities = builder.activities;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.localTime = builder.localTime;
        this.name = builder.name;
        this.quietTime = builder.quietTime;
        this.refreshFrequency = builder.refreshFrequency;
        this.schedule = builder.schedule;
        this.startActivity = builder.startActivity;
        this.startCondition = builder.startCondition;
        this.state = builder.state;
        this.waitForQuietTime = builder.waitForQuietTime;
        this.refreshOnSegmentUpdate = builder.refreshOnSegmentUpdate;
        this.journeyChannelSettings = builder.journeyChannelSettings;
        this.sendingSchedule = builder.sendingSchedule;
        this.openHours = builder.openHours;
        this.closedDays = builder.closedDays;
        this.timezoneEstimationMethods = builder.timezoneEstimationMethods;
    }

    /**
     * For responses, this returns true if the service returned a value for the Activities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActivities() {
        return activities != null && !(activities instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity
     * object, the key is the unique identifier (string) for an activity and the value is the settings for the activity.
     * An activity identifier can contain a maximum of 100 characters. The characters must be alphanumeric characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActivities} method.
     * </p>
     * 
     * @return A map that contains a set of Activity objects, one object for each activity in the journey. For each
     *         Activity object, the key is the unique identifier (string) for an activity and the value is the settings
     *         for the activity. An activity identifier can contain a maximum of 100 characters. The characters must be
     *         alphanumeric characters.
     */
    public final Map<String, Activity> activities() {
        return activities;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the journey was created.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the journey was created.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the journey was last modified.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the journey was last modified.
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The messaging and entry limits for the journey.
     * </p>
     * 
     * @return The messaging and entry limits for the journey.
     */
    public final JourneyLimits limits() {
        return limits;
    }

    /**
     * <p>
     * Specifies whether the journey's scheduled start and end times use each participant's local time. To base the
     * schedule on each participant's local time, set this value to true.
     * </p>
     * 
     * @return Specifies whether the journey's scheduled start and end times use each participant's local time. To base
     *         the schedule on each participant's local time, set this value to true.
     */
    public final Boolean localTime() {
        return localTime;
    }

    /**
     * <p>
     * The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be
     * alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can't contain any
     * spaces.
     * </p>
     * 
     * @return The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be
     *         alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can't contain
     *         any spaces.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send messages
     * to participants, if all the following conditions are met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.
     * </p>
     * </li>
     * <li>
     * <p>
     * The current time in the participant's time zone is later than or equal to the time specified by the
     * QuietTime.Start property for the journey.
     * </p>
     * </li>
     * <li>
     * <p>
     * The current time in the participant's time zone is earlier than or equal to the time specified by the
     * QuietTime.End property for the journey.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if
     * quiet time is enabled.
     * </p>
     * 
     * @return The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send
     *         messages to participants, if all the following conditions are met:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The current time in the participant's time zone is later than or equal to the time specified by the
     *         QuietTime.Start property for the journey.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The current time in the participant's time zone is earlier than or equal to the time specified by the
     *         QuietTime.End property for the journey.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If any of the preceding conditions isn't met, the participant will receive messages from the journey,
     *         even if quiet time is enabled.
     */
    public final QuietTime quietTime() {
        return quietTime;
    }

    /**
     * <p>
     * The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO
     * 8601 format.
     * </p>
     * 
     * @return The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration
     *         in ISO 8601 format.
     */
    public final String refreshFrequency() {
        return refreshFrequency;
    }

    /**
     * <p>
     * The schedule settings for the journey.
     * </p>
     * 
     * @return The schedule settings for the journey.
     */
    public final JourneySchedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The unique identifier for the first activity in the journey. The identifier for this activity can contain a
     * maximum of 128 characters. The characters must be alphanumeric characters.
     * </p>
     * 
     * @return The unique identifier for the first activity in the journey. The identifier for this activity can contain
     *         a maximum of 128 characters. The characters must be alphanumeric characters.
     */
    public final String startActivity() {
        return startActivity;
    }

    /**
     * <p>
     * The segment that defines which users are participants in the journey.
     * </p>
     * 
     * @return The segment that defines which users are participants in the journey.
     */
    public final StartCondition startCondition() {
        return startCondition;
    }

    /**
     * <p>
     * The status of the journey. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DRAFT - Saves the journey and doesn't publish it.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running
     * immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or remove
     * activities from it.
     * </p>
     * </li>
     * </ul>
     * <p>
     * PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey. To
     * cancel, pause, or resume a journey, use the <link linkend="apps-application-id-journeys-journey-id-state">Journey
     * State</link> resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the journey. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DRAFT - Saves the journey and doesn't publish it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running
     *         immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or
     *         remove activities from it.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a
     *         journey. To cancel, pause, or resume a journey, use the <link
     *         linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.
     * @see State
     */
    public final State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The status of the journey. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DRAFT - Saves the journey and doesn't publish it.
     * </p>
     * </li>
     * <li>
     * <p>
     * ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running
     * immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or remove
     * activities from it.
     * </p>
     * </li>
     * </ul>
     * <p>
     * PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey. To
     * cancel, pause, or resume a journey, use the <link linkend="apps-application-id-journeys-journey-id-state">Journey
     * State</link> resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the journey. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DRAFT - Saves the journey and doesn't publish it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running
     *         immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or
     *         remove activities from it.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a
     *         journey. To cancel, pause, or resume a journey, use the <link
     *         linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.
     * @see State
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.
     * </p>
     * 
     * @return Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.
     */
    public final Boolean waitForQuietTime() {
        return waitForQuietTime;
    }

    /**
     * <p>
     * Indicates whether the journey participants should be refreshed when a segment is updated.
     * </p>
     * 
     * @return Indicates whether the journey participants should be refreshed when a segment is updated.
     */
    public final Boolean refreshOnSegmentUpdate() {
        return refreshOnSegmentUpdate;
    }

    /**
     * <p>
     * The channel-specific configurations for the journey.
     * </p>
     * 
     * @return The channel-specific configurations for the journey.
     */
    public final JourneyChannelSettings journeyChannelSettings() {
        return journeyChannelSettings;
    }

    /**
     * <p>
     * Indicates if journey has Advance Quiet Time enabled. This flag should be set to true in order to allow using
     * OpenHours and ClosedDays.
     * </p>
     * 
     * @return Indicates if journey has Advance Quiet Time enabled. This flag should be set to true in order to allow
     *         using OpenHours and ClosedDays.
     */
    public final Boolean sendingSchedule() {
        return sendingSchedule;
    }

    /**
     * <p>
     * The time when journey allow to send messages. QuietTime should be configured first and SendingSchedule should be
     * set to true.
     * </p>
     * 
     * @return The time when journey allow to send messages. QuietTime should be configured first and SendingSchedule
     *         should be set to true.
     */
    public final OpenHours openHours() {
        return openHours;
    }

    /**
     * <p>
     * The time when journey will stop sending messages. QuietTime should be configured first and SendingSchedule should
     * be set to true.
     * </p>
     * 
     * @return The time when journey will stop sending messages. QuietTime should be configured first and
     *         SendingSchedule should be set to true.
     */
    public final ClosedDays closedDays() {
        return closedDays;
    }

    /**
     * <p>
     * An array of time zone estimation methods, if any, to use for determining an <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
     * >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.
     * </p>
     * <ul>
     * <li>
     * <p>
     * PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
     * </p>
     * </li>
     * <li>
     * <p>
     * POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and Endpoint.Location.Country.
     * </p>
     * <note>
     * <p>
     * POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada,
     * France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimezoneEstimationMethods} method.
     * </p>
     * 
     * @return An array of time zone estimation methods, if any, to use for determining an <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
     *         >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone
     *         attribute.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and
     *         Endpoint.Location.Country.
     *         </p>
     *         <note>
     *         <p>
     *         POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand,
     *         Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
     *         </p>
     *         </note></li>
     */
    public final List<__TimezoneEstimationMethodsElement> timezoneEstimationMethods() {
        return ListOf__TimezoneEstimationMethodsElementCopier.copyStringToEnum(timezoneEstimationMethods);
    }

    /**
     * For responses, this returns true if the service returned a value for the TimezoneEstimationMethods property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTimezoneEstimationMethods() {
        return timezoneEstimationMethods != null && !(timezoneEstimationMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of time zone estimation methods, if any, to use for determining an <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
     * >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.
     * </p>
     * <ul>
     * <li>
     * <p>
     * PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
     * </p>
     * </li>
     * <li>
     * <p>
     * POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and Endpoint.Location.Country.
     * </p>
     * <note>
     * <p>
     * POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada,
     * France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimezoneEstimationMethods} method.
     * </p>
     * 
     * @return An array of time zone estimation methods, if any, to use for determining an <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
     *         >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone
     *         attribute.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and
     *         Endpoint.Location.Country.
     *         </p>
     *         <note>
     *         <p>
     *         POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand,
     *         Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
     *         </p>
     *         </note></li>
     */
    public final List<String> timezoneEstimationMethodsAsStrings() {
        return timezoneEstimationMethods;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasActivities() ? activities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        hashCode = 31 * hashCode + Objects.hashCode(localTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(quietTime());
        hashCode = 31 * hashCode + Objects.hashCode(refreshFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(startActivity());
        hashCode = 31 * hashCode + Objects.hashCode(startCondition());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(waitForQuietTime());
        hashCode = 31 * hashCode + Objects.hashCode(refreshOnSegmentUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(journeyChannelSettings());
        hashCode = 31 * hashCode + Objects.hashCode(sendingSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(openHours());
        hashCode = 31 * hashCode + Objects.hashCode(closedDays());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimezoneEstimationMethods() ? timezoneEstimationMethodsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteJourneyRequest)) {
            return false;
        }
        WriteJourneyRequest other = (WriteJourneyRequest) obj;
        return hasActivities() == other.hasActivities() && Objects.equals(activities(), other.activities())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(limits(), other.limits())
                && Objects.equals(localTime(), other.localTime()) && Objects.equals(name(), other.name())
                && Objects.equals(quietTime(), other.quietTime()) && Objects.equals(refreshFrequency(), other.refreshFrequency())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(startActivity(), other.startActivity())
                && Objects.equals(startCondition(), other.startCondition())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(waitForQuietTime(), other.waitForQuietTime())
                && Objects.equals(refreshOnSegmentUpdate(), other.refreshOnSegmentUpdate())
                && Objects.equals(journeyChannelSettings(), other.journeyChannelSettings())
                && Objects.equals(sendingSchedule(), other.sendingSchedule()) && Objects.equals(openHours(), other.openHours())
                && Objects.equals(closedDays(), other.closedDays())
                && hasTimezoneEstimationMethods() == other.hasTimezoneEstimationMethods()
                && Objects.equals(timezoneEstimationMethodsAsStrings(), other.timezoneEstimationMethodsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WriteJourneyRequest").add("Activities", hasActivities() ? activities() : null)
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate()).add("Limits", limits())
                .add("LocalTime", localTime()).add("Name", name()).add("QuietTime", quietTime())
                .add("RefreshFrequency", refreshFrequency()).add("Schedule", schedule()).add("StartActivity", startActivity())
                .add("StartCondition", startCondition()).add("State", stateAsString())
                .add("WaitForQuietTime", waitForQuietTime()).add("RefreshOnSegmentUpdate", refreshOnSegmentUpdate())
                .add("JourneyChannelSettings", journeyChannelSettings()).add("SendingSchedule", sendingSchedule())
                .add("OpenHours", openHours()).add("ClosedDays", closedDays())
                .add("TimezoneEstimationMethods", hasTimezoneEstimationMethods() ? timezoneEstimationMethodsAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Activities":
            return Optional.ofNullable(clazz.cast(activities()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "LocalTime":
            return Optional.ofNullable(clazz.cast(localTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "QuietTime":
            return Optional.ofNullable(clazz.cast(quietTime()));
        case "RefreshFrequency":
            return Optional.ofNullable(clazz.cast(refreshFrequency()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "StartActivity":
            return Optional.ofNullable(clazz.cast(startActivity()));
        case "StartCondition":
            return Optional.ofNullable(clazz.cast(startCondition()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "WaitForQuietTime":
            return Optional.ofNullable(clazz.cast(waitForQuietTime()));
        case "RefreshOnSegmentUpdate":
            return Optional.ofNullable(clazz.cast(refreshOnSegmentUpdate()));
        case "JourneyChannelSettings":
            return Optional.ofNullable(clazz.cast(journeyChannelSettings()));
        case "SendingSchedule":
            return Optional.ofNullable(clazz.cast(sendingSchedule()));
        case "OpenHours":
            return Optional.ofNullable(clazz.cast(openHours()));
        case "ClosedDays":
            return Optional.ofNullable(clazz.cast(closedDays()));
        case "TimezoneEstimationMethods":
            return Optional.ofNullable(clazz.cast(timezoneEstimationMethodsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Activities", ACTIVITIES_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("Limits", LIMITS_FIELD);
        map.put("LocalTime", LOCAL_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("QuietTime", QUIET_TIME_FIELD);
        map.put("RefreshFrequency", REFRESH_FREQUENCY_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("StartActivity", START_ACTIVITY_FIELD);
        map.put("StartCondition", START_CONDITION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("WaitForQuietTime", WAIT_FOR_QUIET_TIME_FIELD);
        map.put("RefreshOnSegmentUpdate", REFRESH_ON_SEGMENT_UPDATE_FIELD);
        map.put("JourneyChannelSettings", JOURNEY_CHANNEL_SETTINGS_FIELD);
        map.put("SendingSchedule", SENDING_SCHEDULE_FIELD);
        map.put("OpenHours", OPEN_HOURS_FIELD);
        map.put("ClosedDays", CLOSED_DAYS_FIELD);
        map.put("TimezoneEstimationMethods", TIMEZONE_ESTIMATION_METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WriteJourneyRequest, T> g) {
        return obj -> g.apply((WriteJourneyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WriteJourneyRequest> {
        /**
         * <p>
         * A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity
         * object, the key is the unique identifier (string) for an activity and the value is the settings for the
         * activity. An activity identifier can contain a maximum of 100 characters. The characters must be alphanumeric
         * characters.
         * </p>
         * 
         * @param activities
         *        A map that contains a set of Activity objects, one object for each activity in the journey. For each
         *        Activity object, the key is the unique identifier (string) for an activity and the value is the
         *        settings for the activity. An activity identifier can contain a maximum of 100 characters. The
         *        characters must be alphanumeric characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Map<String, Activity> activities);

        /**
         * <p>
         * The date, in ISO 8601 format, when the journey was created.
         * </p>
         * 
         * @param creationDate
         *        The date, in ISO 8601 format, when the journey was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The date, in ISO 8601 format, when the journey was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date, in ISO 8601 format, when the journey was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The messaging and entry limits for the journey.
         * </p>
         * 
         * @param limits
         *        The messaging and entry limits for the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(JourneyLimits limits);

        /**
         * <p>
         * The messaging and entry limits for the journey.
         * </p>
         * This is a convenience method that creates an instance of the {@link JourneyLimits.Builder} avoiding the need
         * to create one manually via {@link JourneyLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JourneyLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #limits(JourneyLimits)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link JourneyLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(JourneyLimits)
         */
        default Builder limits(Consumer<JourneyLimits.Builder> limits) {
            return limits(JourneyLimits.builder().applyMutation(limits).build());
        }

        /**
         * <p>
         * Specifies whether the journey's scheduled start and end times use each participant's local time. To base the
         * schedule on each participant's local time, set this value to true.
         * </p>
         * 
         * @param localTime
         *        Specifies whether the journey's scheduled start and end times use each participant's local time. To
         *        base the schedule on each participant's local time, set this value to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localTime(Boolean localTime);

        /**
         * <p>
         * The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be
         * alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can't contain any
         * spaces.
         * </p>
         * 
         * @param name
         *        The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be
         *        alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can't
         *        contain any spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send
         * messages to participants, if all the following conditions are met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the participant's time zone is later than or equal to the time specified by the
         * QuietTime.Start property for the journey.
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the participant's time zone is earlier than or equal to the time specified by the
         * QuietTime.End property for the journey.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if
         * quiet time is enabled.
         * </p>
         * 
         * @param quietTime
         *        The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't
         *        send messages to participants, if all the following conditions are met:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The current time in the participant's time zone is later than or equal to the time specified by the
         *        QuietTime.Start property for the journey.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The current time in the participant's time zone is earlier than or equal to the time specified by the
         *        QuietTime.End property for the journey.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If any of the preceding conditions isn't met, the participant will receive messages from the journey,
         *        even if quiet time is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quietTime(QuietTime quietTime);

        /**
         * <p>
         * The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn't send
         * messages to participants, if all the following conditions are met:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the participant's time zone is later than or equal to the time specified by the
         * QuietTime.Start property for the journey.
         * </p>
         * </li>
         * <li>
         * <p>
         * The current time in the participant's time zone is earlier than or equal to the time specified by the
         * QuietTime.End property for the journey.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If any of the preceding conditions isn't met, the participant will receive messages from the journey, even if
         * quiet time is enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuietTime.Builder} avoiding the need to
         * create one manually via {@link QuietTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuietTime.Builder#build()} is called immediately and its result
         * is passed to {@link #quietTime(QuietTime)}.
         * 
         * @param quietTime
         *        a consumer that will call methods on {@link QuietTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quietTime(QuietTime)
         */
        default Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return quietTime(QuietTime.builder().applyMutation(quietTime).build());
        }

        /**
         * <p>
         * The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in
         * ISO 8601 format.
         * </p>
         * 
         * @param refreshFrequency
         *        The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a
         *        duration in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshFrequency(String refreshFrequency);

        /**
         * <p>
         * The schedule settings for the journey.
         * </p>
         * 
         * @param schedule
         *        The schedule settings for the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(JourneySchedule schedule);

        /**
         * <p>
         * The schedule settings for the journey.
         * </p>
         * This is a convenience method that creates an instance of the {@link JourneySchedule.Builder} avoiding the
         * need to create one manually via {@link JourneySchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JourneySchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #schedule(JourneySchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link JourneySchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(JourneySchedule)
         */
        default Builder schedule(Consumer<JourneySchedule.Builder> schedule) {
            return schedule(JourneySchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The unique identifier for the first activity in the journey. The identifier for this activity can contain a
         * maximum of 128 characters. The characters must be alphanumeric characters.
         * </p>
         * 
         * @param startActivity
         *        The unique identifier for the first activity in the journey. The identifier for this activity can
         *        contain a maximum of 128 characters. The characters must be alphanumeric characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startActivity(String startActivity);

        /**
         * <p>
         * The segment that defines which users are participants in the journey.
         * </p>
         * 
         * @param startCondition
         *        The segment that defines which users are participants in the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startCondition(StartCondition startCondition);

        /**
         * <p>
         * The segment that defines which users are participants in the journey.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartCondition.Builder} avoiding the need
         * to create one manually via {@link StartCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #startCondition(StartCondition)}.
         * 
         * @param startCondition
         *        a consumer that will call methods on {@link StartCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startCondition(StartCondition)
         */
        default Builder startCondition(Consumer<StartCondition.Builder> startCondition) {
            return startCondition(StartCondition.builder().applyMutation(startCondition).build());
        }

        /**
         * <p>
         * The status of the journey. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DRAFT - Saves the journey and doesn't publish it.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running
         * immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or remove
         * activities from it.
         * </p>
         * </li>
         * </ul>
         * <p>
         * PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey.
         * To cancel, pause, or resume a journey, use the <link
         * linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.
         * </p>
         * 
         * @param state
         *        The status of the journey. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DRAFT - Saves the journey and doesn't publish it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts
         *        running immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add,
         *        change, or remove activities from it.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a
         *        journey. To cancel, pause, or resume a journey, use the <link
         *        linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The status of the journey. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DRAFT - Saves the journey and doesn't publish it.
         * </p>
         * </li>
         * <li>
         * <p>
         * ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts running
         * immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add, change, or remove
         * activities from it.
         * </p>
         * </li>
         * </ul>
         * <p>
         * PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey.
         * To cancel, pause, or resume a journey, use the <link
         * linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.
         * </p>
         * 
         * @param state
         *        The status of the journey. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DRAFT - Saves the journey and doesn't publish it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ACTIVE - Saves and publishes the journey. Depending on the journey's schedule, the journey starts
         *        running immediately or at the scheduled start time. If a journey's status is ACTIVE, you can't add,
         *        change, or remove activities from it.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a
         *        journey. To cancel, pause, or resume a journey, use the <link
         *        linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * <p>
         * Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.
         * </p>
         * 
         * @param waitForQuietTime
         *        Specifies whether endpoints in quiet hours should enter a wait till the end of their quiet hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitForQuietTime(Boolean waitForQuietTime);

        /**
         * <p>
         * Indicates whether the journey participants should be refreshed when a segment is updated.
         * </p>
         * 
         * @param refreshOnSegmentUpdate
         *        Indicates whether the journey participants should be refreshed when a segment is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshOnSegmentUpdate(Boolean refreshOnSegmentUpdate);

        /**
         * <p>
         * The channel-specific configurations for the journey.
         * </p>
         * 
         * @param journeyChannelSettings
         *        The channel-specific configurations for the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyChannelSettings(JourneyChannelSettings journeyChannelSettings);

        /**
         * <p>
         * The channel-specific configurations for the journey.
         * </p>
         * This is a convenience method that creates an instance of the {@link JourneyChannelSettings.Builder} avoiding
         * the need to create one manually via {@link JourneyChannelSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JourneyChannelSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #journeyChannelSettings(JourneyChannelSettings)}.
         * 
         * @param journeyChannelSettings
         *        a consumer that will call methods on {@link JourneyChannelSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #journeyChannelSettings(JourneyChannelSettings)
         */
        default Builder journeyChannelSettings(Consumer<JourneyChannelSettings.Builder> journeyChannelSettings) {
            return journeyChannelSettings(JourneyChannelSettings.builder().applyMutation(journeyChannelSettings).build());
        }

        /**
         * <p>
         * Indicates if journey has Advance Quiet Time enabled. This flag should be set to true in order to allow using
         * OpenHours and ClosedDays.
         * </p>
         * 
         * @param sendingSchedule
         *        Indicates if journey has Advance Quiet Time enabled. This flag should be set to true in order to allow
         *        using OpenHours and ClosedDays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingSchedule(Boolean sendingSchedule);

        /**
         * <p>
         * The time when journey allow to send messages. QuietTime should be configured first and SendingSchedule should
         * be set to true.
         * </p>
         * 
         * @param openHours
         *        The time when journey allow to send messages. QuietTime should be configured first and SendingSchedule
         *        should be set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openHours(OpenHours openHours);

        /**
         * <p>
         * The time when journey allow to send messages. QuietTime should be configured first and SendingSchedule should
         * be set to true.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenHours.Builder} avoiding the need to
         * create one manually via {@link OpenHours#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenHours.Builder#build()} is called immediately and its result
         * is passed to {@link #openHours(OpenHours)}.
         * 
         * @param openHours
         *        a consumer that will call methods on {@link OpenHours.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openHours(OpenHours)
         */
        default Builder openHours(Consumer<OpenHours.Builder> openHours) {
            return openHours(OpenHours.builder().applyMutation(openHours).build());
        }

        /**
         * <p>
         * The time when journey will stop sending messages. QuietTime should be configured first and SendingSchedule
         * should be set to true.
         * </p>
         * 
         * @param closedDays
         *        The time when journey will stop sending messages. QuietTime should be configured first and
         *        SendingSchedule should be set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closedDays(ClosedDays closedDays);

        /**
         * <p>
         * The time when journey will stop sending messages. QuietTime should be configured first and SendingSchedule
         * should be set to true.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClosedDays.Builder} avoiding the need to
         * create one manually via {@link ClosedDays#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClosedDays.Builder#build()} is called immediately and its result
         * is passed to {@link #closedDays(ClosedDays)}.
         * 
         * @param closedDays
         *        a consumer that will call methods on {@link ClosedDays.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #closedDays(ClosedDays)
         */
        default Builder closedDays(Consumer<ClosedDays.Builder> closedDays) {
            return closedDays(ClosedDays.builder().applyMutation(closedDays).build());
        }

        /**
         * <p>
         * An array of time zone estimation methods, if any, to use for determining an <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
         * >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
         * </p>
         * </li>
         * <li>
         * <p>
         * POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and
         * Endpoint.Location.Country.
         * </p>
         * <note>
         * <p>
         * POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada,
         * France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param timezoneEstimationMethods
         *        An array of time zone estimation methods, if any, to use for determining an <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
         *        >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone
         *        attribute.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and
         *        Endpoint.Location.Country.
         *        </p>
         *        <note>
         *        <p>
         *        POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand,
         *        Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
         *        </p>
         *        </note></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezoneEstimationMethodsWithStrings(Collection<String> timezoneEstimationMethods);

        /**
         * <p>
         * An array of time zone estimation methods, if any, to use for determining an <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
         * >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
         * </p>
         * </li>
         * <li>
         * <p>
         * POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and
         * Endpoint.Location.Country.
         * </p>
         * <note>
         * <p>
         * POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada,
         * France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param timezoneEstimationMethods
         *        An array of time zone estimation methods, if any, to use for determining an <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
         *        >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone
         *        attribute.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and
         *        Endpoint.Location.Country.
         *        </p>
         *        <note>
         *        <p>
         *        POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand,
         *        Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
         *        </p>
         *        </note></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezoneEstimationMethodsWithStrings(String... timezoneEstimationMethods);

        /**
         * <p>
         * An array of time zone estimation methods, if any, to use for determining an <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
         * >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
         * </p>
         * </li>
         * <li>
         * <p>
         * POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and
         * Endpoint.Location.Country.
         * </p>
         * <note>
         * <p>
         * POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada,
         * France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param timezoneEstimationMethods
         *        An array of time zone estimation methods, if any, to use for determining an <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
         *        >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone
         *        attribute.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and
         *        Endpoint.Location.Country.
         *        </p>
         *        <note>
         *        <p>
         *        POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand,
         *        Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
         *        </p>
         *        </note></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezoneEstimationMethods(Collection<__TimezoneEstimationMethodsElement> timezoneEstimationMethods);

        /**
         * <p>
         * An array of time zone estimation methods, if any, to use for determining an <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
         * >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
         * </p>
         * </li>
         * <li>
         * <p>
         * POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and
         * Endpoint.Location.Country.
         * </p>
         * <note>
         * <p>
         * POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada,
         * France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param timezoneEstimationMethods
         *        An array of time zone estimation methods, if any, to use for determining an <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html"
         *        >Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone
         *        attribute.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and
         *        Endpoint.Location.Country.
         *        </p>
         *        <note>
         *        <p>
         *        POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand,
         *        Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.
         *        </p>
         *        </note></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezoneEstimationMethods(__TimezoneEstimationMethodsElement... timezoneEstimationMethods);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Activity> activities = DefaultSdkAutoConstructMap.getInstance();

        private String creationDate;

        private String lastModifiedDate;

        private JourneyLimits limits;

        private Boolean localTime;

        private String name;

        private QuietTime quietTime;

        private String refreshFrequency;

        private JourneySchedule schedule;

        private String startActivity;

        private StartCondition startCondition;

        private String state;

        private Boolean waitForQuietTime;

        private Boolean refreshOnSegmentUpdate;

        private JourneyChannelSettings journeyChannelSettings;

        private Boolean sendingSchedule;

        private OpenHours openHours;

        private ClosedDays closedDays;

        private List<String> timezoneEstimationMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WriteJourneyRequest model) {
            activities(model.activities);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            limits(model.limits);
            localTime(model.localTime);
            name(model.name);
            quietTime(model.quietTime);
            refreshFrequency(model.refreshFrequency);
            schedule(model.schedule);
            startActivity(model.startActivity);
            startCondition(model.startCondition);
            state(model.state);
            waitForQuietTime(model.waitForQuietTime);
            refreshOnSegmentUpdate(model.refreshOnSegmentUpdate);
            journeyChannelSettings(model.journeyChannelSettings);
            sendingSchedule(model.sendingSchedule);
            openHours(model.openHours);
            closedDays(model.closedDays);
            timezoneEstimationMethodsWithStrings(model.timezoneEstimationMethods);
        }

        public final Map<String, Activity.Builder> getActivities() {
            Map<String, Activity.Builder> result = MapOfActivityCopier.copyToBuilder(this.activities);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActivities(Map<String, Activity.BuilderImpl> activities) {
            this.activities = MapOfActivityCopier.copyFromBuilder(activities);
        }

        @Override
        public final Builder activities(Map<String, Activity> activities) {
            this.activities = MapOfActivityCopier.copy(activities);
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final JourneyLimits.Builder getLimits() {
            return limits != null ? limits.toBuilder() : null;
        }

        public final void setLimits(JourneyLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        @Override
        public final Builder limits(JourneyLimits limits) {
            this.limits = limits;
            return this;
        }

        public final Boolean getLocalTime() {
            return localTime;
        }

        public final void setLocalTime(Boolean localTime) {
            this.localTime = localTime;
        }

        @Override
        public final Builder localTime(Boolean localTime) {
            this.localTime = localTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final QuietTime.Builder getQuietTime() {
            return quietTime != null ? quietTime.toBuilder() : null;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final String getRefreshFrequency() {
            return refreshFrequency;
        }

        public final void setRefreshFrequency(String refreshFrequency) {
            this.refreshFrequency = refreshFrequency;
        }

        @Override
        public final Builder refreshFrequency(String refreshFrequency) {
            this.refreshFrequency = refreshFrequency;
            return this;
        }

        public final JourneySchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(JourneySchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(JourneySchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStartActivity() {
            return startActivity;
        }

        public final void setStartActivity(String startActivity) {
            this.startActivity = startActivity;
        }

        @Override
        public final Builder startActivity(String startActivity) {
            this.startActivity = startActivity;
            return this;
        }

        public final StartCondition.Builder getStartCondition() {
            return startCondition != null ? startCondition.toBuilder() : null;
        }

        public final void setStartCondition(StartCondition.BuilderImpl startCondition) {
            this.startCondition = startCondition != null ? startCondition.build() : null;
        }

        @Override
        public final Builder startCondition(StartCondition startCondition) {
            this.startCondition = startCondition;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Boolean getWaitForQuietTime() {
            return waitForQuietTime;
        }

        public final void setWaitForQuietTime(Boolean waitForQuietTime) {
            this.waitForQuietTime = waitForQuietTime;
        }

        @Override
        public final Builder waitForQuietTime(Boolean waitForQuietTime) {
            this.waitForQuietTime = waitForQuietTime;
            return this;
        }

        public final Boolean getRefreshOnSegmentUpdate() {
            return refreshOnSegmentUpdate;
        }

        public final void setRefreshOnSegmentUpdate(Boolean refreshOnSegmentUpdate) {
            this.refreshOnSegmentUpdate = refreshOnSegmentUpdate;
        }

        @Override
        public final Builder refreshOnSegmentUpdate(Boolean refreshOnSegmentUpdate) {
            this.refreshOnSegmentUpdate = refreshOnSegmentUpdate;
            return this;
        }

        public final JourneyChannelSettings.Builder getJourneyChannelSettings() {
            return journeyChannelSettings != null ? journeyChannelSettings.toBuilder() : null;
        }

        public final void setJourneyChannelSettings(JourneyChannelSettings.BuilderImpl journeyChannelSettings) {
            this.journeyChannelSettings = journeyChannelSettings != null ? journeyChannelSettings.build() : null;
        }

        @Override
        public final Builder journeyChannelSettings(JourneyChannelSettings journeyChannelSettings) {
            this.journeyChannelSettings = journeyChannelSettings;
            return this;
        }

        public final Boolean getSendingSchedule() {
            return sendingSchedule;
        }

        public final void setSendingSchedule(Boolean sendingSchedule) {
            this.sendingSchedule = sendingSchedule;
        }

        @Override
        public final Builder sendingSchedule(Boolean sendingSchedule) {
            this.sendingSchedule = sendingSchedule;
            return this;
        }

        public final OpenHours.Builder getOpenHours() {
            return openHours != null ? openHours.toBuilder() : null;
        }

        public final void setOpenHours(OpenHours.BuilderImpl openHours) {
            this.openHours = openHours != null ? openHours.build() : null;
        }

        @Override
        public final Builder openHours(OpenHours openHours) {
            this.openHours = openHours;
            return this;
        }

        public final ClosedDays.Builder getClosedDays() {
            return closedDays != null ? closedDays.toBuilder() : null;
        }

        public final void setClosedDays(ClosedDays.BuilderImpl closedDays) {
            this.closedDays = closedDays != null ? closedDays.build() : null;
        }

        @Override
        public final Builder closedDays(ClosedDays closedDays) {
            this.closedDays = closedDays;
            return this;
        }

        public final Collection<String> getTimezoneEstimationMethods() {
            if (timezoneEstimationMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return timezoneEstimationMethods;
        }

        public final void setTimezoneEstimationMethods(Collection<String> timezoneEstimationMethods) {
            this.timezoneEstimationMethods = ListOf__TimezoneEstimationMethodsElementCopier.copy(timezoneEstimationMethods);
        }

        @Override
        public final Builder timezoneEstimationMethodsWithStrings(Collection<String> timezoneEstimationMethods) {
            this.timezoneEstimationMethods = ListOf__TimezoneEstimationMethodsElementCopier.copy(timezoneEstimationMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timezoneEstimationMethodsWithStrings(String... timezoneEstimationMethods) {
            timezoneEstimationMethodsWithStrings(Arrays.asList(timezoneEstimationMethods));
            return this;
        }

        @Override
        public final Builder timezoneEstimationMethods(Collection<__TimezoneEstimationMethodsElement> timezoneEstimationMethods) {
            this.timezoneEstimationMethods = ListOf__TimezoneEstimationMethodsElementCopier
                    .copyEnumToString(timezoneEstimationMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timezoneEstimationMethods(__TimezoneEstimationMethodsElement... timezoneEstimationMethods) {
            timezoneEstimationMethods(Arrays.asList(timezoneEstimationMethods));
            return this;
        }

        @Override
        public WriteJourneyRequest build() {
            return new WriteJourneyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
