/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the times when message are allowed to be sent to endpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenHours implements SdkPojo, Serializable, ToCopyableBuilder<OpenHours.Builder, OpenHours> {
    private static final SdkField<Map<String, List<OpenHoursRule>>> EMAIL_FIELD = SdkField
            .<Map<String, List<OpenHoursRule>>> builder(MarshallingType.MAP)
            .memberName("EMAIL")
            .getter(getter(OpenHours::emailAsStrings))
            .setter(setter(Builder::emailWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EMAIL").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<OpenHoursRule>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<OpenHoursRule> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(OpenHoursRule::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, List<OpenHoursRule>>> SMS_FIELD = SdkField
            .<Map<String, List<OpenHoursRule>>> builder(MarshallingType.MAP)
            .memberName("SMS")
            .getter(getter(OpenHours::smsAsStrings))
            .setter(setter(Builder::smsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMS").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<OpenHoursRule>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<OpenHoursRule> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(OpenHoursRule::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, List<OpenHoursRule>>> PUSH_FIELD = SdkField
            .<Map<String, List<OpenHoursRule>>> builder(MarshallingType.MAP)
            .memberName("PUSH")
            .getter(getter(OpenHours::pushAsStrings))
            .setter(setter(Builder::pushWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PUSH").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<OpenHoursRule>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<OpenHoursRule> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(OpenHoursRule::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, List<OpenHoursRule>>> VOICE_FIELD = SdkField
            .<Map<String, List<OpenHoursRule>>> builder(MarshallingType.MAP)
            .memberName("VOICE")
            .getter(getter(OpenHours::voiceAsStrings))
            .setter(setter(Builder::voiceWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VOICE").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<OpenHoursRule>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<OpenHoursRule> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(OpenHoursRule::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, List<OpenHoursRule>>> CUSTOM_FIELD = SdkField
            .<Map<String, List<OpenHoursRule>>> builder(MarshallingType.MAP)
            .memberName("CUSTOM")
            .getter(getter(OpenHours::customAsStrings))
            .setter(setter(Builder::customWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CUSTOM").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<OpenHoursRule>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<OpenHoursRule> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(OpenHoursRule::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, SMS_FIELD,
            PUSH_FIELD, VOICE_FIELD, CUSTOM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, List<OpenHoursRule>> email;

    private final Map<String, List<OpenHoursRule>> sms;

    private final Map<String, List<OpenHoursRule>> push;

    private final Map<String, List<OpenHoursRule>> voice;

    private final Map<String, List<OpenHoursRule>> custom;

    private OpenHours(BuilderImpl builder) {
        this.email = builder.email;
        this.sms = builder.sms;
        this.push = builder.push;
        this.voice = builder.voice;
        this.custom = builder.custom;
    }

    /**
     * <p>
     * Specifies the schedule settings for the email channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmail} method.
     * </p>
     * 
     * @return Specifies the schedule settings for the email channel.
     */
    public final Map<DayOfWeek, List<OpenHoursRule>> email() {
        return MapOfListOfOpenHoursRulesCopier.copyStringToEnum(email);
    }

    /**
     * For responses, this returns true if the service returned a value for the EMAIL property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEmail() {
        return email != null && !(email instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the schedule settings for the email channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmail} method.
     * </p>
     * 
     * @return Specifies the schedule settings for the email channel.
     */
    public final Map<String, List<OpenHoursRule>> emailAsStrings() {
        return email;
    }

    /**
     * <p>
     * Specifies the schedule settings for the SMS channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSms} method.
     * </p>
     * 
     * @return Specifies the schedule settings for the SMS channel.
     */
    public final Map<DayOfWeek, List<OpenHoursRule>> sms() {
        return MapOfListOfOpenHoursRulesCopier.copyStringToEnum(sms);
    }

    /**
     * For responses, this returns true if the service returned a value for the SMS property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSms() {
        return sms != null && !(sms instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the schedule settings for the SMS channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSms} method.
     * </p>
     * 
     * @return Specifies the schedule settings for the SMS channel.
     */
    public final Map<String, List<OpenHoursRule>> smsAsStrings() {
        return sms;
    }

    /**
     * <p>
     * Specifies the schedule settings for the push channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPush} method.
     * </p>
     * 
     * @return Specifies the schedule settings for the push channel.
     */
    public final Map<DayOfWeek, List<OpenHoursRule>> push() {
        return MapOfListOfOpenHoursRulesCopier.copyStringToEnum(push);
    }

    /**
     * For responses, this returns true if the service returned a value for the PUSH property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPush() {
        return push != null && !(push instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the schedule settings for the push channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPush} method.
     * </p>
     * 
     * @return Specifies the schedule settings for the push channel.
     */
    public final Map<String, List<OpenHoursRule>> pushAsStrings() {
        return push;
    }

    /**
     * <p>
     * Specifies the schedule settings for the voice channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVoice} method.
     * </p>
     * 
     * @return Specifies the schedule settings for the voice channel.
     */
    public final Map<DayOfWeek, List<OpenHoursRule>> voice() {
        return MapOfListOfOpenHoursRulesCopier.copyStringToEnum(voice);
    }

    /**
     * For responses, this returns true if the service returned a value for the VOICE property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasVoice() {
        return voice != null && !(voice instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the schedule settings for the voice channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVoice} method.
     * </p>
     * 
     * @return Specifies the schedule settings for the voice channel.
     */
    public final Map<String, List<OpenHoursRule>> voiceAsStrings() {
        return voice;
    }

    /**
     * <p>
     * Specifies the schedule settings for the custom channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustom} method.
     * </p>
     * 
     * @return Specifies the schedule settings for the custom channel.
     */
    public final Map<DayOfWeek, List<OpenHoursRule>> custom() {
        return MapOfListOfOpenHoursRulesCopier.copyStringToEnum(custom);
    }

    /**
     * For responses, this returns true if the service returned a value for the CUSTOM property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCustom() {
        return custom != null && !(custom instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the schedule settings for the custom channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustom} method.
     * </p>
     * 
     * @return Specifies the schedule settings for the custom channel.
     */
    public final Map<String, List<OpenHoursRule>> customAsStrings() {
        return custom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEmail() ? emailAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSms() ? smsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPush() ? pushAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVoice() ? voiceAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustom() ? customAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenHours)) {
            return false;
        }
        OpenHours other = (OpenHours) obj;
        return hasEmail() == other.hasEmail() && Objects.equals(emailAsStrings(), other.emailAsStrings())
                && hasSms() == other.hasSms() && Objects.equals(smsAsStrings(), other.smsAsStrings())
                && hasPush() == other.hasPush() && Objects.equals(pushAsStrings(), other.pushAsStrings())
                && hasVoice() == other.hasVoice() && Objects.equals(voiceAsStrings(), other.voiceAsStrings())
                && hasCustom() == other.hasCustom() && Objects.equals(customAsStrings(), other.customAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenHours").add("EMAIL", hasEmail() ? emailAsStrings() : null)
                .add("SMS", hasSms() ? smsAsStrings() : null).add("PUSH", hasPush() ? pushAsStrings() : null)
                .add("VOICE", hasVoice() ? voiceAsStrings() : null).add("CUSTOM", hasCustom() ? customAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EMAIL":
            return Optional.ofNullable(clazz.cast(emailAsStrings()));
        case "SMS":
            return Optional.ofNullable(clazz.cast(smsAsStrings()));
        case "PUSH":
            return Optional.ofNullable(clazz.cast(pushAsStrings()));
        case "VOICE":
            return Optional.ofNullable(clazz.cast(voiceAsStrings()));
        case "CUSTOM":
            return Optional.ofNullable(clazz.cast(customAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EMAIL", EMAIL_FIELD);
        map.put("SMS", SMS_FIELD);
        map.put("PUSH", PUSH_FIELD);
        map.put("VOICE", VOICE_FIELD);
        map.put("CUSTOM", CUSTOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenHours, T> g) {
        return obj -> g.apply((OpenHours) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenHours> {
        /**
         * <p>
         * Specifies the schedule settings for the email channel.
         * </p>
         * 
         * @param email
         *        Specifies the schedule settings for the email channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailWithStrings(Map<String, ? extends Collection<OpenHoursRule>> email);

        /**
         * <p>
         * Specifies the schedule settings for the email channel.
         * </p>
         * 
         * @param email
         *        Specifies the schedule settings for the email channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> email);

        /**
         * <p>
         * Specifies the schedule settings for the SMS channel.
         * </p>
         * 
         * @param sms
         *        Specifies the schedule settings for the SMS channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsWithStrings(Map<String, ? extends Collection<OpenHoursRule>> sms);

        /**
         * <p>
         * Specifies the schedule settings for the SMS channel.
         * </p>
         * 
         * @param sms
         *        Specifies the schedule settings for the SMS channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sms(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> sms);

        /**
         * <p>
         * Specifies the schedule settings for the push channel.
         * </p>
         * 
         * @param push
         *        Specifies the schedule settings for the push channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pushWithStrings(Map<String, ? extends Collection<OpenHoursRule>> push);

        /**
         * <p>
         * Specifies the schedule settings for the push channel.
         * </p>
         * 
         * @param push
         *        Specifies the schedule settings for the push channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder push(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> push);

        /**
         * <p>
         * Specifies the schedule settings for the voice channel.
         * </p>
         * 
         * @param voice
         *        Specifies the schedule settings for the voice channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceWithStrings(Map<String, ? extends Collection<OpenHoursRule>> voice);

        /**
         * <p>
         * Specifies the schedule settings for the voice channel.
         * </p>
         * 
         * @param voice
         *        Specifies the schedule settings for the voice channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voice(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> voice);

        /**
         * <p>
         * Specifies the schedule settings for the custom channel.
         * </p>
         * 
         * @param custom
         *        Specifies the schedule settings for the custom channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customWithStrings(Map<String, ? extends Collection<OpenHoursRule>> custom);

        /**
         * <p>
         * Specifies the schedule settings for the custom channel.
         * </p>
         * 
         * @param custom
         *        Specifies the schedule settings for the custom channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> custom);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<OpenHoursRule>> email = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<OpenHoursRule>> sms = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<OpenHoursRule>> push = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<OpenHoursRule>> voice = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<OpenHoursRule>> custom = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpenHours model) {
            emailWithStrings(model.email);
            smsWithStrings(model.sms);
            pushWithStrings(model.push);
            voiceWithStrings(model.voice);
            customWithStrings(model.custom);
        }

        public final Map<String, List<OpenHoursRule.Builder>> getEmail() {
            Map<String, List<OpenHoursRule.Builder>> result = MapOfListOfOpenHoursRulesCopier.copyToBuilder(this.email);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEmail(Map<String, ? extends Collection<OpenHoursRule.BuilderImpl>> email) {
            this.email = MapOfListOfOpenHoursRulesCopier.copyFromBuilder(email);
        }

        @Override
        public final Builder emailWithStrings(Map<String, ? extends Collection<OpenHoursRule>> email) {
            this.email = MapOfListOfOpenHoursRulesCopier.copy(email);
            return this;
        }

        @Override
        public final Builder email(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> email) {
            this.email = MapOfListOfOpenHoursRulesCopier.copyEnumToString(email);
            return this;
        }

        public final Map<String, List<OpenHoursRule.Builder>> getSms() {
            Map<String, List<OpenHoursRule.Builder>> result = MapOfListOfOpenHoursRulesCopier.copyToBuilder(this.sms);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSms(Map<String, ? extends Collection<OpenHoursRule.BuilderImpl>> sms) {
            this.sms = MapOfListOfOpenHoursRulesCopier.copyFromBuilder(sms);
        }

        @Override
        public final Builder smsWithStrings(Map<String, ? extends Collection<OpenHoursRule>> sms) {
            this.sms = MapOfListOfOpenHoursRulesCopier.copy(sms);
            return this;
        }

        @Override
        public final Builder sms(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> sms) {
            this.sms = MapOfListOfOpenHoursRulesCopier.copyEnumToString(sms);
            return this;
        }

        public final Map<String, List<OpenHoursRule.Builder>> getPush() {
            Map<String, List<OpenHoursRule.Builder>> result = MapOfListOfOpenHoursRulesCopier.copyToBuilder(this.push);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPush(Map<String, ? extends Collection<OpenHoursRule.BuilderImpl>> push) {
            this.push = MapOfListOfOpenHoursRulesCopier.copyFromBuilder(push);
        }

        @Override
        public final Builder pushWithStrings(Map<String, ? extends Collection<OpenHoursRule>> push) {
            this.push = MapOfListOfOpenHoursRulesCopier.copy(push);
            return this;
        }

        @Override
        public final Builder push(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> push) {
            this.push = MapOfListOfOpenHoursRulesCopier.copyEnumToString(push);
            return this;
        }

        public final Map<String, List<OpenHoursRule.Builder>> getVoice() {
            Map<String, List<OpenHoursRule.Builder>> result = MapOfListOfOpenHoursRulesCopier.copyToBuilder(this.voice);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setVoice(Map<String, ? extends Collection<OpenHoursRule.BuilderImpl>> voice) {
            this.voice = MapOfListOfOpenHoursRulesCopier.copyFromBuilder(voice);
        }

        @Override
        public final Builder voiceWithStrings(Map<String, ? extends Collection<OpenHoursRule>> voice) {
            this.voice = MapOfListOfOpenHoursRulesCopier.copy(voice);
            return this;
        }

        @Override
        public final Builder voice(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> voice) {
            this.voice = MapOfListOfOpenHoursRulesCopier.copyEnumToString(voice);
            return this;
        }

        public final Map<String, List<OpenHoursRule.Builder>> getCustom() {
            Map<String, List<OpenHoursRule.Builder>> result = MapOfListOfOpenHoursRulesCopier.copyToBuilder(this.custom);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCustom(Map<String, ? extends Collection<OpenHoursRule.BuilderImpl>> custom) {
            this.custom = MapOfListOfOpenHoursRulesCopier.copyFromBuilder(custom);
        }

        @Override
        public final Builder customWithStrings(Map<String, ? extends Collection<OpenHoursRule>> custom) {
            this.custom = MapOfListOfOpenHoursRulesCopier.copy(custom);
            return this;
        }

        @Override
        public final Builder custom(Map<DayOfWeek, ? extends Collection<OpenHoursRule>> custom) {
            this.custom = MapOfListOfOpenHoursRulesCopier.copyEnumToString(custom);
            return this;
        }

        @Override
        public OpenHours build() {
            return new OpenHours(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
