/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.pinpoint.model.BadRequestException;
import software.amazon.awssdk.services.pinpoint.model.CreateAppRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateAppResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.ForbiddenException;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.InternalServerErrorException;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.MethodNotAllowedException;
import software.amazon.awssdk.services.pinpoint.model.NotFoundException;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateRequest;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateResponse;
import software.amazon.awssdk.services.pinpoint.model.PinpointException;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.PutEventsRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventsResponse;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesRequest;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateExportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAppsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignActivitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetChannelsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetExportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentExportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PhoneNumberValidateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.RemoveAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendUsersMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointsBatchRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateVoiceChannelRequestMarshaller;

/**
 * Internal implementation of {@link PinpointClient}.
 *
 * @see PinpointClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPinpointClient implements PinpointClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPinpointClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     *
     * @param createAppRequest
     * @return Result of the CreateApp operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAppResponse createApp(CreateAppRequest createAppRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>()
                .withOperationName("CreateApp").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createAppRequest)
                .withMarshaller(new CreateAppRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new campaign for an application or updates the settings of an existing campaign for an application.
     * </p>
     *
     * @param createCampaignRequest
     * @return Result of the CreateCampaign operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateCampaignRequest, CreateCampaignResponse>()
                .withOperationName("CreateCampaign").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createCampaignRequest)
                .withMarshaller(new CreateCampaignRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new export job for an application.
     * </p>
     *
     * @param createExportJobRequest
     * @return Result of the CreateExportJob operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateExportJobResponse createExportJob(CreateExportJobRequest createExportJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateExportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateExportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateExportJobRequest, CreateExportJobResponse>()
                .withOperationName("CreateExportJob").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createExportJobRequest)
                .withMarshaller(new CreateExportJobRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new import job for an application.
     * </p>
     *
     * @param createImportJobRequest
     * @return Result of the CreateImportJob operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateImportJobResponse createImportJob(CreateImportJobRequest createImportJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateImportJobRequest, CreateImportJobResponse>()
                .withOperationName("CreateImportJob").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createImportJobRequest)
                .withMarshaller(new CreateImportJobRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     *
     * @param createSegmentRequest
     * @return Result of the CreateSegment operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.CreateSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSegmentResponse createSegment(CreateSegmentRequest createSegmentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSegmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateSegmentRequest, CreateSegmentResponse>()
                .withOperationName("CreateSegment").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createSegmentRequest)
                .withMarshaller(new CreateSegmentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disables the ADM channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteAdmChannelRequest
     * @return Result of the DeleteAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAdmChannelResponse deleteAdmChannel(DeleteAdmChannelRequest deleteAdmChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAdmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteAdmChannelRequest, DeleteAdmChannelResponse>()
                .withOperationName("DeleteAdmChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteAdmChannelRequest)
                .withMarshaller(new DeleteAdmChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disables the APNs channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsChannelRequest
     * @return Result of the DeleteApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteApnsChannelResponse deleteApnsChannel(DeleteApnsChannelRequest deleteApnsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApnsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteApnsChannelRequest, DeleteApnsChannelResponse>()
                .withOperationName("DeleteApnsChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteApnsChannelRequest)
                .withMarshaller(new DeleteApnsChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsSandboxChannelRequest
     * @return Result of the DeleteApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteApnsSandboxChannelResponse deleteApnsSandboxChannel(
            DeleteApnsSandboxChannelRequest deleteApnsSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteApnsSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteApnsSandboxChannelRequest, DeleteApnsSandboxChannelResponse>()
                        .withOperationName("DeleteApnsSandboxChannel").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteApnsSandboxChannelRequest)
                        .withMarshaller(new DeleteApnsSandboxChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsVoipChannelRequest
     * @return Result of the DeleteApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteApnsVoipChannelResponse deleteApnsVoipChannel(DeleteApnsVoipChannelRequest deleteApnsVoipChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteApnsVoipChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteApnsVoipChannelRequest, DeleteApnsVoipChannelResponse>()
                .withOperationName("DeleteApnsVoipChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteApnsVoipChannelRequest)
                .withMarshaller(new DeleteApnsVoipChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsVoipSandboxChannelRequest
     * @return Result of the DeleteApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteApnsVoipSandboxChannelResponse deleteApnsVoipSandboxChannel(
            DeleteApnsVoipSandboxChannelRequest deleteApnsVoipSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteApnsVoipSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteApnsVoipSandboxChannelRequest, DeleteApnsVoipSandboxChannelResponse>()
                        .withOperationName("DeleteApnsVoipSandboxChannel").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteApnsVoipSandboxChannelRequest)
                        .withMarshaller(new DeleteApnsVoipSandboxChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteAppRequest
     * @return Result of the DeleteApp operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAppResponse deleteApp(DeleteAppRequest deleteAppRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>()
                .withOperationName("DeleteApp").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteAppRequest)
                .withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disables the Baidu channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteBaiduChannelRequest
     * @return Result of the DeleteBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBaiduChannelResponse deleteBaiduChannel(DeleteBaiduChannelRequest deleteBaiduChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBaiduChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteBaiduChannelRequest, DeleteBaiduChannelResponse>()
                .withOperationName("DeleteBaiduChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteBaiduChannelRequest)
                .withMarshaller(new DeleteBaiduChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a campaign from an application.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return Result of the DeleteCampaign operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteCampaignRequest, DeleteCampaignResponse>()
                .withOperationName("DeleteCampaign").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteCampaignRequest)
                .withMarshaller(new DeleteCampaignRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disables the email channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteEmailChannelRequest
     * @return Result of the DeleteEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEmailChannelResponse deleteEmailChannel(DeleteEmailChannelRequest deleteEmailChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEmailChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteEmailChannelRequest, DeleteEmailChannelResponse>()
                .withOperationName("DeleteEmailChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteEmailChannelRequest)
                .withMarshaller(new DeleteEmailChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an endpoint from an application.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                .withOperationName("DeleteEndpoint").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteEndpointRequest)
                .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the event stream for an application.
     * </p>
     *
     * @param deleteEventStreamRequest
     * @return Result of the DeleteEventStream operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteEventStreamResponse deleteEventStream(DeleteEventStreamRequest deleteEventStreamRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEventStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteEventStreamRequest, DeleteEventStreamResponse>()
                .withOperationName("DeleteEventStream").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteEventStreamRequest)
                .withMarshaller(new DeleteEventStreamRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disables the GCM channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteGcmChannelRequest
     * @return Result of the DeleteGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGcmChannelResponse deleteGcmChannel(DeleteGcmChannelRequest deleteGcmChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGcmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteGcmChannelRequest, DeleteGcmChannelResponse>()
                .withOperationName("DeleteGcmChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteGcmChannelRequest)
                .withMarshaller(new DeleteGcmChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a segment from an application.
     * </p>
     *
     * @param deleteSegmentRequest
     * @return Result of the DeleteSegment operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSegmentResponse deleteSegment(DeleteSegmentRequest deleteSegmentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSegmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteSegmentRequest, DeleteSegmentResponse>()
                .withOperationName("DeleteSegment").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteSegmentRequest)
                .withMarshaller(new DeleteSegmentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disables the SMS channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteSmsChannelRequest
     * @return Result of the DeleteSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSmsChannelResponse deleteSmsChannel(DeleteSmsChannelRequest deleteSmsChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSmsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteSmsChannelRequest, DeleteSmsChannelResponse>()
                .withOperationName("DeleteSmsChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteSmsChannelRequest)
                .withMarshaller(new DeleteSmsChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes all the endpoints that are associated with a specific user ID.
     * </p>
     *
     * @param deleteUserEndpointsRequest
     * @return Result of the DeleteUserEndpoints operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteUserEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteUserEndpointsResponse deleteUserEndpoints(DeleteUserEndpointsRequest deleteUserEndpointsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUserEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteUserEndpointsRequest, DeleteUserEndpointsResponse>()
                .withOperationName("DeleteUserEndpoints").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserEndpointsRequest)
                .withMarshaller(new DeleteUserEndpointsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disables the voice channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteVoiceChannelRequest
     * @return Result of the DeleteVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.DeleteVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteVoiceChannelResponse deleteVoiceChannel(DeleteVoiceChannelRequest deleteVoiceChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteVoiceChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteVoiceChannelRequest, DeleteVoiceChannelResponse>()
                .withOperationName("DeleteVoiceChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteVoiceChannelRequest)
                .withMarshaller(new DeleteVoiceChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the ADM channel for an application.
     * </p>
     *
     * @param getAdmChannelRequest
     * @return Result of the GetAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAdmChannelResponse getAdmChannel(GetAdmChannelRequest getAdmChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAdmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetAdmChannelRequest, GetAdmChannelResponse>()
                .withOperationName("GetAdmChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getAdmChannelRequest)
                .withMarshaller(new GetAdmChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs channel for an application.
     * </p>
     *
     * @param getApnsChannelRequest
     * @return Result of the GetApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetApnsChannelResponse getApnsChannel(GetApnsChannelRequest getApnsChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApnsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetApnsChannelRequest, GetApnsChannelResponse>()
                .withOperationName("GetApnsChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getApnsChannelRequest)
                .withMarshaller(new GetApnsChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs sandbox channel for an application.
     * </p>
     *
     * @param getApnsSandboxChannelRequest
     * @return Result of the GetApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetApnsSandboxChannelResponse getApnsSandboxChannel(GetApnsSandboxChannelRequest getApnsSandboxChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApnsSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetApnsSandboxChannelRequest, GetApnsSandboxChannelResponse>()
                .withOperationName("GetApnsSandboxChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getApnsSandboxChannelRequest)
                .withMarshaller(new GetApnsSandboxChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP channel for an application.
     * </p>
     *
     * @param getApnsVoipChannelRequest
     * @return Result of the GetApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetApnsVoipChannelResponse getApnsVoipChannel(GetApnsVoipChannelRequest getApnsVoipChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApnsVoipChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetApnsVoipChannelRequest, GetApnsVoipChannelResponse>()
                .withOperationName("GetApnsVoipChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getApnsVoipChannelRequest)
                .withMarshaller(new GetApnsVoipChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
     * </p>
     *
     * @param getApnsVoipSandboxChannelRequest
     * @return Result of the GetApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApnsVoipSandboxChannelResponse getApnsVoipSandboxChannel(
            GetApnsVoipSandboxChannelRequest getApnsVoipSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApnsVoipSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetApnsVoipSandboxChannelRequest, GetApnsVoipSandboxChannelResponse>()
                        .withOperationName("GetApnsVoipSandboxChannel").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getApnsVoipSandboxChannelRequest)
                        .withMarshaller(new GetApnsVoipSandboxChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about an application.
     * </p>
     *
     * @param getAppRequest
     * @return Result of the GetApp operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAppResponse getApp(GetAppRequest getAppRequest) throws BadRequestException, InternalServerErrorException,
            ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAppResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetAppRequest, GetAppResponse>().withOperationName("GetApp")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getAppRequest)
                .withMarshaller(new GetAppRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
     * </p>
     *
     * @param getApplicationDateRangeKpiRequest
     * @return Result of the GetApplicationDateRangeKpi operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApplicationDateRangeKpi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApplicationDateRangeKpiResponse getApplicationDateRangeKpi(
            GetApplicationDateRangeKpiRequest getApplicationDateRangeKpiRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApplicationDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApplicationDateRangeKpiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetApplicationDateRangeKpiRequest, GetApplicationDateRangeKpiResponse>()
                        .withOperationName("GetApplicationDateRangeKpi").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getApplicationDateRangeKpiRequest)
                        .withMarshaller(new GetApplicationDateRangeKpiRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the settings for an application.
     * </p>
     *
     * @param getApplicationSettingsRequest
     * @return Result of the GetApplicationSettings operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApplicationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetApplicationSettingsResponse getApplicationSettings(GetApplicationSettingsRequest getApplicationSettingsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApplicationSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetApplicationSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetApplicationSettingsRequest, GetApplicationSettingsResponse>()
                .withOperationName("GetApplicationSettings").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getApplicationSettingsRequest)
                .withMarshaller(new GetApplicationSettingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about all of your applications.
     * </p>
     *
     * @param getAppsRequest
     * @return Result of the GetApps operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetApps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAppsResponse getApps(GetAppsRequest getAppsRequest) throws BadRequestException, InternalServerErrorException,
            ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, AwsServiceException,
            SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAppsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAppsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetAppsRequest, GetAppsResponse>().withOperationName("GetApps")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getAppsRequest)
                .withMarshaller(new GetAppsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the Baidu Cloud Push channel for an application.
     * </p>
     *
     * @param getBaiduChannelRequest
     * @return Result of the GetBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBaiduChannelResponse getBaiduChannel(GetBaiduChannelRequest getBaiduChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBaiduChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetBaiduChannelRequest, GetBaiduChannelResponse>()
                .withOperationName("GetBaiduChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getBaiduChannelRequest)
                .withMarshaller(new GetBaiduChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a campaign.
     * </p>
     *
     * @param getCampaignRequest
     * @return Result of the GetCampaign operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCampaignResponse getCampaign(GetCampaignRequest getCampaignRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCampaignRequest, GetCampaignResponse>()
                .withOperationName("GetCampaign").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCampaignRequest)
                .withMarshaller(new GetCampaignRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the activity performed by a campaign.
     * </p>
     *
     * @param getCampaignActivitiesRequest
     * @return Result of the GetCampaignActivities operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignActivities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetCampaignActivitiesResponse getCampaignActivities(GetCampaignActivitiesRequest getCampaignActivitiesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignActivitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCampaignActivitiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCampaignActivitiesRequest, GetCampaignActivitiesResponse>()
                .withOperationName("GetCampaignActivities").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCampaignActivitiesRequest)
                .withMarshaller(new GetCampaignActivitiesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
     * </p>
     *
     * @param getCampaignDateRangeKpiRequest
     * @return Result of the GetCampaignDateRangeKpi operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignDateRangeKpi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCampaignDateRangeKpiResponse getCampaignDateRangeKpi(GetCampaignDateRangeKpiRequest getCampaignDateRangeKpiRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCampaignDateRangeKpiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCampaignDateRangeKpiRequest, GetCampaignDateRangeKpiResponse>()
                .withOperationName("GetCampaignDateRangeKpi").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCampaignDateRangeKpiRequest)
                .withMarshaller(new GetCampaignDateRangeKpiRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
     * </p>
     *
     * @param getCampaignVersionRequest
     * @return Result of the GetCampaignVersion operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetCampaignVersionResponse getCampaignVersion(GetCampaignVersionRequest getCampaignVersionRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCampaignVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCampaignVersionRequest, GetCampaignVersionResponse>()
                .withOperationName("GetCampaignVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCampaignVersionRequest)
                .withMarshaller(new GetCampaignVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all versions of a specific
     * campaign.
     * </p>
     *
     * @param getCampaignVersionsRequest
     * @return Result of the GetCampaignVersions operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaignVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetCampaignVersionsResponse getCampaignVersions(GetCampaignVersionsRequest getCampaignVersionsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCampaignVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCampaignVersionsRequest, GetCampaignVersionsResponse>()
                .withOperationName("GetCampaignVersions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCampaignVersionsRequest)
                .withMarshaller(new GetCampaignVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the campaigns that are
     * associated with an application.
     * </p>
     *
     * @param getCampaignsRequest
     * @return Result of the GetCampaigns operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetCampaigns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCampaignsResponse getCampaigns(GetCampaignsRequest getCampaignsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCampaignsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCampaignsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetCampaignsRequest, GetCampaignsResponse>()
                .withOperationName("GetCampaigns").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCampaignsRequest)
                .withMarshaller(new GetCampaignsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the history and status of each channel for an application.
     * </p>
     *
     * @param getChannelsRequest
     * @return Result of the GetChannels operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetChannelsResponse getChannels(GetChannelsRequest getChannelsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetChannelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetChannelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetChannelsRequest, GetChannelsResponse>()
                .withOperationName("GetChannels").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getChannelsRequest)
                .withMarshaller(new GetChannelsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the email channel for an application.
     * </p>
     *
     * @param getEmailChannelRequest
     * @return Result of the GetEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetEmailChannelResponse getEmailChannel(GetEmailChannelRequest getEmailChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEmailChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetEmailChannelRequest, GetEmailChannelResponse>()
                .withOperationName("GetEmailChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getEmailChannelRequest)
                .withMarshaller(new GetEmailChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the settings and attributes of a specific endpoint for an application.
     * </p>
     *
     * @param getEndpointRequest
     * @return Result of the GetEndpoint operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetEndpointResponse getEndpoint(GetEndpointRequest getEndpointRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetEndpointRequest, GetEndpointResponse>()
                .withOperationName("GetEndpoint").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getEndpointRequest)
                .withMarshaller(new GetEndpointRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the event stream settings for an application.
     * </p>
     *
     * @param getEventStreamRequest
     * @return Result of the GetEventStream operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetEventStreamResponse getEventStream(GetEventStreamRequest getEventStreamRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEventStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetEventStreamRequest, GetEventStreamResponse>()
                .withOperationName("GetEventStream").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getEventStreamRequest)
                .withMarshaller(new GetEventStreamRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific export job for an application.
     * </p>
     *
     * @param getExportJobRequest
     * @return Result of the GetExportJob operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetExportJobResponse getExportJob(GetExportJobRequest getExportJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetExportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetExportJobRequest, GetExportJobResponse>()
                .withOperationName("GetExportJob").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getExportJobRequest)
                .withMarshaller(new GetExportJobRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the export jobs for an application.
     * </p>
     *
     * @param getExportJobsRequest
     * @return Result of the GetExportJobs operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetExportJobsResponse getExportJobs(GetExportJobsRequest getExportJobsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetExportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetExportJobsRequest, GetExportJobsResponse>()
                .withOperationName("GetExportJobs").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getExportJobsRequest)
                .withMarshaller(new GetExportJobsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the GCM channel for an application.
     * </p>
     *
     * @param getGcmChannelRequest
     * @return Result of the GetGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGcmChannelResponse getGcmChannel(GetGcmChannelRequest getGcmChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGcmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetGcmChannelRequest, GetGcmChannelResponse>()
                .withOperationName("GetGcmChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getGcmChannelRequest)
                .withMarshaller(new GetGcmChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific import job for an application.
     * </p>
     *
     * @param getImportJobRequest
     * @return Result of the GetImportJob operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetImportJobResponse getImportJob(GetImportJobRequest getImportJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetImportJobRequest, GetImportJobResponse>()
                .withOperationName("GetImportJob").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getImportJobRequest)
                .withMarshaller(new GetImportJobRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the import jobs for an application.
     * </p>
     *
     * @param getImportJobsRequest
     * @return Result of the GetImportJobs operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetImportJobsResponse getImportJobs(GetImportJobsRequest getImportJobsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetImportJobsRequest, GetImportJobsResponse>()
                .withOperationName("GetImportJobs").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getImportJobsRequest)
                .withMarshaller(new GetImportJobsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific segment that's
     * associated with an application.
     * </p>
     *
     * @param getSegmentRequest
     * @return Result of the GetSegment operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSegmentResponse getSegment(GetSegmentRequest getSegmentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSegmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetSegmentRequest, GetSegmentResponse>()
                .withOperationName("GetSegment").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSegmentRequest)
                .withMarshaller(new GetSegmentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the export jobs for a segment.
     * </p>
     *
     * @param getSegmentExportJobsRequest
     * @return Result of the GetSegmentExportJobs operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSegmentExportJobsResponse getSegmentExportJobs(GetSegmentExportJobsRequest getSegmentExportJobsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSegmentExportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetSegmentExportJobsRequest, GetSegmentExportJobsResponse>()
                .withOperationName("GetSegmentExportJobs").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSegmentExportJobsRequest)
                .withMarshaller(new GetSegmentExportJobsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the import jobs for a segment.
     * </p>
     *
     * @param getSegmentImportJobsRequest
     * @return Result of the GetSegmentImportJobs operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSegmentImportJobsResponse getSegmentImportJobs(GetSegmentImportJobsRequest getSegmentImportJobsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSegmentImportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetSegmentImportJobsRequest, GetSegmentImportJobsResponse>()
                .withOperationName("GetSegmentImportJobs").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSegmentImportJobsRequest)
                .withMarshaller(new GetSegmentImportJobsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific version of a segment
     * that's associated with an application.
     * </p>
     *
     * @param getSegmentVersionRequest
     * @return Result of the GetSegmentVersion operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSegmentVersionResponse getSegmentVersion(GetSegmentVersionRequest getSegmentVersionRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSegmentVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetSegmentVersionRequest, GetSegmentVersionResponse>()
                .withOperationName("GetSegmentVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSegmentVersionRequest)
                .withMarshaller(new GetSegmentVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all versions of a specific
     * segment that's associated with an application.
     * </p>
     *
     * @param getSegmentVersionsRequest
     * @return Result of the GetSegmentVersions operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegmentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSegmentVersionsResponse getSegmentVersions(GetSegmentVersionsRequest getSegmentVersionsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSegmentVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetSegmentVersionsRequest, GetSegmentVersionsResponse>()
                .withOperationName("GetSegmentVersions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSegmentVersionsRequest)
                .withMarshaller(new GetSegmentVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the segments that are
     * associated with an application.
     * </p>
     *
     * @param getSegmentsRequest
     * @return Result of the GetSegments operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSegments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSegmentsResponse getSegments(GetSegmentsRequest getSegmentsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSegmentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSegmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetSegmentsRequest, GetSegmentsResponse>()
                .withOperationName("GetSegments").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSegmentsRequest)
                .withMarshaller(new GetSegmentsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the SMS channel for an application.
     * </p>
     *
     * @param getSmsChannelRequest
     * @return Result of the GetSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSmsChannelResponse getSmsChannel(GetSmsChannelRequest getSmsChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSmsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetSmsChannelRequest, GetSmsChannelResponse>()
                .withOperationName("GetSmsChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSmsChannelRequest)
                .withMarshaller(new GetSmsChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about all the endpoints that are associated with a specific user ID.
     * </p>
     *
     * @param getUserEndpointsRequest
     * @return Result of the GetUserEndpoints operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetUserEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetUserEndpointsResponse getUserEndpoints(GetUserEndpointsRequest getUserEndpointsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUserEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUserEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetUserEndpointsRequest, GetUserEndpointsResponse>()
                .withOperationName("GetUserEndpoints").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getUserEndpointsRequest)
                .withMarshaller(new GetUserEndpointsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the voice channel for an application.
     * </p>
     *
     * @param getVoiceChannelRequest
     * @return Result of the GetVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.GetVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetVoiceChannelResponse getVoiceChannel(GetVoiceChannelRequest getVoiceChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVoiceChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetVoiceChannelRequest, GetVoiceChannelResponse>()
                .withOperationName("GetVoiceChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getVoiceChannelRequest)
                .withMarshaller(new GetVoiceChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves all the tags (keys and values) that are associated with an application, campaign, or segment.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about a phone number.
     * </p>
     *
     * @param phoneNumberValidateRequest
     * @return Result of the PhoneNumberValidate operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PhoneNumberValidate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PhoneNumberValidateResponse phoneNumberValidate(PhoneNumberValidateRequest phoneNumberValidateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PhoneNumberValidateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PhoneNumberValidateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PhoneNumberValidateRequest, PhoneNumberValidateResponse>()
                .withOperationName("PhoneNumberValidate").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(phoneNumberValidateRequest)
                .withMarshaller(new PhoneNumberValidateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new event stream for an application or updates the settings of an existing event stream for an
     * application.
     * </p>
     *
     * @param putEventStreamRequest
     * @return Result of the PutEventStream operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PutEventStream
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutEventStreamResponse putEventStream(PutEventStreamRequest putEventStreamRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutEventStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutEventStreamRequest, PutEventStreamResponse>()
                .withOperationName("PutEventStream").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putEventStreamRequest)
                .withMarshaller(new PutEventStreamRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are
     * associated with.
     * </p>
     *
     * @param putEventsRequest
     * @return Result of the PutEvents operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.PutEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutEventsResponse putEvents(PutEventsRequest putEventsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutEventsRequest, PutEventsResponse>()
                .withOperationName("PutEvents").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putEventsRequest)
                .withMarshaller(new PutEventsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes one or more attributes, of the same attribute type, from all the endpoints that are associated with an
     * application.
     * </p>
     *
     * @param removeAttributesRequest
     * @return Result of the RemoveAttributes operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.RemoveAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RemoveAttributesResponse removeAttributes(RemoveAttributesRequest removeAttributesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveAttributesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemoveAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<RemoveAttributesRequest, RemoveAttributesResponse>()
                .withOperationName("RemoveAttributes").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(removeAttributesRequest)
                .withMarshaller(new RemoveAttributesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates and sends a direct message.
     * </p>
     *
     * @param sendMessagesRequest
     * @return Result of the SendMessages operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.SendMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SendMessagesResponse sendMessages(SendMessagesRequest sendMessagesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendMessagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendMessagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SendMessagesRequest, SendMessagesResponse>()
                .withOperationName("SendMessages").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(sendMessagesRequest)
                .withMarshaller(new SendMessagesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates and sends a message to a list of users.
     * </p>
     *
     * @param sendUsersMessagesRequest
     * @return Result of the SendUsersMessages operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.SendUsersMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SendUsersMessagesResponse sendUsersMessages(SendUsersMessagesRequest sendUsersMessagesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendUsersMessagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendUsersMessagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SendUsersMessagesRequest, SendUsersMessagesResponse>()
                .withOperationName("SendUsersMessages").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(sendUsersMessagesRequest)
                .withMarshaller(new SendUsersMessagesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds one or more tags (keys and values) to an application, campaign, or segment.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AwsServiceException, SdkClientException,
            PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withOperationName("TagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes one or more tags (keys and values) from an application, campaign, or segment.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AwsServiceException,
            SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withOperationName("UntagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the ADM channel settings for an application.
     * </p>
     *
     * @param updateAdmChannelRequest
     * @return Result of the UpdateAdmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateAdmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAdmChannelResponse updateAdmChannel(UpdateAdmChannelRequest updateAdmChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAdmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateAdmChannelRequest, UpdateAdmChannelResponse>()
                .withOperationName("UpdateAdmChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateAdmChannelRequest)
                .withMarshaller(new UpdateAdmChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the APNs channel settings for an application.
     * </p>
     *
     * @param updateApnsChannelRequest
     * @return Result of the UpdateApnsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateApnsChannelResponse updateApnsChannel(UpdateApnsChannelRequest updateApnsChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApnsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateApnsChannelRequest, UpdateApnsChannelResponse>()
                .withOperationName("UpdateApnsChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateApnsChannelRequest)
                .withMarshaller(new UpdateApnsChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the APNs sandbox channel settings for an application.
     * </p>
     *
     * @param updateApnsSandboxChannelRequest
     * @return Result of the UpdateApnsSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApnsSandboxChannelResponse updateApnsSandboxChannel(
            UpdateApnsSandboxChannelRequest updateApnsSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApnsSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateApnsSandboxChannelRequest, UpdateApnsSandboxChannelResponse>()
                        .withOperationName("UpdateApnsSandboxChannel").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateApnsSandboxChannelRequest)
                        .withMarshaller(new UpdateApnsSandboxChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the APNs VoIP channel settings for an application.
     * </p>
     *
     * @param updateApnsVoipChannelRequest
     * @return Result of the UpdateApnsVoipChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsVoipChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateApnsVoipChannelResponse updateApnsVoipChannel(UpdateApnsVoipChannelRequest updateApnsVoipChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApnsVoipChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateApnsVoipChannelRequest, UpdateApnsVoipChannelResponse>()
                .withOperationName("UpdateApnsVoipChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateApnsVoipChannelRequest)
                .withMarshaller(new UpdateApnsVoipChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the settings for the APNs VoIP sandbox channel for an application.
     * </p>
     *
     * @param updateApnsVoipSandboxChannelRequest
     * @return Result of the UpdateApnsVoipSandboxChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApnsVoipSandboxChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApnsVoipSandboxChannelResponse updateApnsVoipSandboxChannel(
            UpdateApnsVoipSandboxChannelRequest updateApnsVoipSandboxChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApnsVoipSandboxChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateApnsVoipSandboxChannelRequest, UpdateApnsVoipSandboxChannelResponse>()
                        .withOperationName("UpdateApnsVoipSandboxChannel").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateApnsVoipSandboxChannelRequest)
                        .withMarshaller(new UpdateApnsVoipSandboxChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the settings for an application.
     * </p>
     *
     * @param updateApplicationSettingsRequest
     * @return Result of the UpdateApplicationSettings operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateApplicationSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateApplicationSettingsResponse updateApplicationSettings(
            UpdateApplicationSettingsRequest updateApplicationSettingsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApplicationSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateApplicationSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateApplicationSettingsRequest, UpdateApplicationSettingsResponse>()
                        .withOperationName("UpdateApplicationSettings").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateApplicationSettingsRequest)
                        .withMarshaller(new UpdateApplicationSettingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the settings of the Baidu channel for an application.
     * </p>
     *
     * @param updateBaiduChannelRequest
     * @return Result of the UpdateBaiduChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateBaiduChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateBaiduChannelResponse updateBaiduChannel(UpdateBaiduChannelRequest updateBaiduChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBaiduChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateBaiduChannelRequest, UpdateBaiduChannelResponse>()
                .withOperationName("UpdateBaiduChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateBaiduChannelRequest)
                .withMarshaller(new UpdateBaiduChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the settings for a campaign.
     * </p>
     *
     * @param updateCampaignRequest
     * @return Result of the UpdateCampaign operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateCampaignResponse updateCampaign(UpdateCampaignRequest updateCampaignRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateCampaignResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateCampaignRequest, UpdateCampaignResponse>()
                .withOperationName("UpdateCampaign").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateCampaignRequest)
                .withMarshaller(new UpdateCampaignRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the status and settings of the email channel for an application.
     * </p>
     *
     * @param updateEmailChannelRequest
     * @return Result of the UpdateEmailChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEmailChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateEmailChannelResponse updateEmailChannel(UpdateEmailChannelRequest updateEmailChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEmailChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateEmailChannelRequest, UpdateEmailChannelResponse>()
                .withOperationName("UpdateEmailChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateEmailChannelRequest)
                .withMarshaller(new UpdateEmailChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an
     * application. You can also use this operation to define custom attributes (Attributes, Metrics, and UserAttributes
     * properties) for an endpoint.
     * </p>
     *
     * @param updateEndpointRequest
     * @return Result of the UpdateEndpoint operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest updateEndpointRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateEndpointRequest, UpdateEndpointResponse>()
                .withOperationName("UpdateEndpoint").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateEndpointRequest)
                .withMarshaller(new UpdateEndpointRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing
     * endpoints for an application. You can also use this operation to define custom attributes (Attributes, Metrics,
     * and UserAttributes properties) for a batch of endpoints.
     * </p>
     *
     * @param updateEndpointsBatchRequest
     * @return Result of the UpdateEndpointsBatch operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateEndpointsBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateEndpointsBatchResponse updateEndpointsBatch(UpdateEndpointsBatchRequest updateEndpointsBatchRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEndpointsBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEndpointsBatchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateEndpointsBatchRequest, UpdateEndpointsBatchResponse>()
                .withOperationName("UpdateEndpointsBatch").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateEndpointsBatchRequest)
                .withMarshaller(new UpdateEndpointsBatchRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the status and settings of the GCM channel for an application.
     * </p>
     *
     * @param updateGcmChannelRequest
     * @return Result of the UpdateGcmChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateGcmChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateGcmChannelResponse updateGcmChannel(UpdateGcmChannelRequest updateGcmChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateGcmChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateGcmChannelRequest, UpdateGcmChannelResponse>()
                .withOperationName("UpdateGcmChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateGcmChannelRequest)
                .withMarshaller(new UpdateGcmChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     *
     * @param updateSegmentRequest
     * @return Result of the UpdateSegment operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateSegment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSegmentResponse updateSegment(UpdateSegmentRequest updateSegmentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSegmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateSegmentRequest, UpdateSegmentResponse>()
                .withOperationName("UpdateSegment").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateSegmentRequest)
                .withMarshaller(new UpdateSegmentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the status and settings of the SMS channel for an application.
     * </p>
     *
     * @param updateSmsChannelRequest
     * @return Result of the UpdateSmsChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateSmsChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSmsChannelResponse updateSmsChannel(UpdateSmsChannelRequest updateSmsChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException,
            TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSmsChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateSmsChannelRequest, UpdateSmsChannelResponse>()
                .withOperationName("UpdateSmsChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateSmsChannelRequest)
                .withMarshaller(new UpdateSmsChannelRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the status and settings of the voice channel for an application.
     * </p>
     *
     * @param updateVoiceChannelRequest
     * @return Result of the UpdateVoiceChannel operation returned by the service.
     * @throws BadRequestException
     *         The request contains a syntax error (BadRequestException).
     * @throws InternalServerErrorException
     *         The request failed due to an unknown internal server error, exception, or failure
     *         (InternalServerErrorException).
     * @throws ForbiddenException
     *         The request was denied because access to the specified resource is forbidden (ForbiddenException).
     * @throws NotFoundException
     *         The request failed because the specified resource was not found (NotFoundException).
     * @throws MethodNotAllowedException
     *         The request failed because the method is not allowed for the specified resource
     *         (MethodNotAllowedException).
     * @throws TooManyRequestsException
     *         The request failed because too many requests were sent during a certain amount of time
     *         (TooManyRequestsException).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointClient.UpdateVoiceChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateVoiceChannelResponse updateVoiceChannel(UpdateVoiceChannelRequest updateVoiceChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            MethodNotAllowedException, TooManyRequestsException, AwsServiceException, SdkClientException, PinpointException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateVoiceChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateVoiceChannelRequest, UpdateVoiceChannelResponse>()
                .withOperationName("UpdateVoiceChannel").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateVoiceChannelRequest)
                .withMarshaller(new UpdateVoiceChannelRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(PinpointException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MethodNotAllowedException")
                                .exceptionBuilderSupplier(MethodNotAllowedException::builder).httpStatusCode(405).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
