/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEndpointResponse extends PinpointResponse implements
        ToCopyableBuilder<DeleteEndpointResponse.Builder, DeleteEndpointResponse> {
    private static final SdkField<EndpointResponse> ENDPOINT_RESPONSE_FIELD = SdkField
            .<EndpointResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteEndpointResponse::endpointResponse))
            .setter(setter(Builder::endpointResponse))
            .constructor(EndpointResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_RESPONSE_FIELD));

    private final EndpointResponse endpointResponse;

    private DeleteEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointResponse = builder.endpointResponse;
    }

    /**
     * Returns the value of the EndpointResponse property for this object.
     * 
     * @return The value of the EndpointResponse property for this object.
     */
    public EndpointResponse endpointResponse() {
        return endpointResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEndpointResponse)) {
            return false;
        }
        DeleteEndpointResponse other = (DeleteEndpointResponse) obj;
        return Objects.equals(endpointResponse(), other.endpointResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteEndpointResponse").add("EndpointResponse", endpointResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointResponse":
            return Optional.ofNullable(clazz.cast(endpointResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteEndpointResponse, T> g) {
        return obj -> g.apply((DeleteEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEndpointResponse> {
        /**
         * Sets the value of the EndpointResponse property for this object.
         *
         * @param endpointResponse
         *        The new value for the EndpointResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointResponse(EndpointResponse endpointResponse);

        /**
         * Sets the value of the EndpointResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link EndpointResponse.Builder} avoiding the need to
         * create one manually via {@link EndpointResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointResponse(EndpointResponse)}.
         * 
         * @param endpointResponse
         *        a consumer that will call methods on {@link EndpointResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointResponse(EndpointResponse)
         */
        default Builder endpointResponse(Consumer<EndpointResponse.Builder> endpointResponse) {
            return endpointResponse(EndpointResponse.builder().applyMutation(endpointResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private EndpointResponse endpointResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEndpointResponse model) {
            super(model);
            endpointResponse(model.endpointResponse);
        }

        public final EndpointResponse.Builder getEndpointResponse() {
            return endpointResponse != null ? endpointResponse.toBuilder() : null;
        }

        @Override
        public final Builder endpointResponse(EndpointResponse endpointResponse) {
            this.endpointResponse = endpointResponse;
            return this;
        }

        public final void setEndpointResponse(EndpointResponse.BuilderImpl endpointResponse) {
            this.endpointResponse = endpointResponse != null ? endpointResponse.build() : null;
        }

        @Override
        public DeleteEndpointResponse build() {
            return new DeleteEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
