/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the channel type and other settings for an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointResponse.Builder, EndpointResponse> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointResponse::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<Map<String, List<String>>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(EndpointResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointResponse::channelTypeAsString)).setter(setter(Builder::channelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelType").build()).build();

    private static final SdkField<String> COHORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointResponse::cohortId)).setter(setter(Builder::cohortId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CohortId").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<EndpointDemographic> DEMOGRAPHIC_FIELD = SdkField
            .<EndpointDemographic> builder(MarshallingType.SDK_POJO).getter(getter(EndpointResponse::demographic))
            .setter(setter(Builder::demographic)).constructor(EndpointDemographic::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Demographic").build()).build();

    private static final SdkField<String> EFFECTIVE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointResponse::effectiveDate)).setter(setter(Builder::effectiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveDate").build()).build();

    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointResponse::endpointStatus)).setter(setter(Builder::endpointStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<EndpointLocation> LOCATION_FIELD = SdkField
            .<EndpointLocation> builder(MarshallingType.SDK_POJO).getter(getter(EndpointResponse::location))
            .setter(setter(Builder::location)).constructor(EndpointLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<Map<String, Double>> METRICS_FIELD = SdkField
            .<Map<String, Double>> builder(MarshallingType.MAP)
            .getter(getter(EndpointResponse::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> OPT_OUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointResponse::optOut)).setter(setter(Builder::optOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOut").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EndpointResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<EndpointUser> USER_FIELD = SdkField.<EndpointUser> builder(MarshallingType.SDK_POJO)
            .getter(getter(EndpointResponse::user)).setter(setter(Builder::user)).constructor(EndpointUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD,
            APPLICATION_ID_FIELD, ATTRIBUTES_FIELD, CHANNEL_TYPE_FIELD, COHORT_ID_FIELD, CREATION_DATE_FIELD, DEMOGRAPHIC_FIELD,
            EFFECTIVE_DATE_FIELD, ENDPOINT_STATUS_FIELD, ID_FIELD, LOCATION_FIELD, METRICS_FIELD, OPT_OUT_FIELD,
            REQUEST_ID_FIELD, USER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String address;

    private final String applicationId;

    private final Map<String, List<String>> attributes;

    private final String channelType;

    private final String cohortId;

    private final String creationDate;

    private final EndpointDemographic demographic;

    private final String effectiveDate;

    private final String endpointStatus;

    private final String id;

    private final EndpointLocation location;

    private final Map<String, Double> metrics;

    private final String optOut;

    private final String requestId;

    private final EndpointUser user;

    private EndpointResponse(BuilderImpl builder) {
        this.address = builder.address;
        this.applicationId = builder.applicationId;
        this.attributes = builder.attributes;
        this.channelType = builder.channelType;
        this.cohortId = builder.cohortId;
        this.creationDate = builder.creationDate;
        this.demographic = builder.demographic;
        this.effectiveDate = builder.effectiveDate;
        this.endpointStatus = builder.endpointStatus;
        this.id = builder.id;
        this.location = builder.location;
        this.metrics = builder.metrics;
        this.optOut = builder.optOut;
        this.requestId = builder.requestId;
        this.user = builder.user;
    }

    /**
     * <p>
     * The destination address for messages or push notifications that you send to the endpoint. The address varies by
     * channel. For example, the address for a push-notification channel is typically the token provided by a push
     * notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud
     * Messaging (FCM) registration token. The address for the SMS channel is a phone number in E.164 format, such as
     * +12065550100. The address for the email channel is an email address.
     * </p>
     * 
     * @return The destination address for messages or push notifications that you send to the endpoint. The address
     *         varies by channel. For example, the address for a push-notification channel is typically the token
     *         provided by a push notification service, such as an Apple Push Notification service (APNs) device token
     *         or a Firebase Cloud Messaging (FCM) registration token. The address for the SMS channel is a phone number
     *         in E.164 format, such as +12065550100. The address for the email channel is an email address.
     */
    public String address() {
        return address;
    }

    /**
     * <p>
     * The unique identifier for the application that's associated with the endpoint.
     * </p>
     * 
     * @return The unique identifier for the application that's associated with the endpoint.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * One or more custom attributes that describe the endpoint by associating a name with an array of values. For
     * example, the value of a custom attribute named Interests might be: ["science", "music", "travel"]. You can use
     * these attributes as filter criteria when you create segments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more custom attributes that describe the endpoint by associating a name with an array of values.
     *         For example, the value of a custom attribute named Interests might be: ["science", "music", "travel"].
     *         You can use these attributes as filter criteria when you create segments.
     */
    public Map<String, List<String>> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The channel that's used when sending messages or push notifications to the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return The channel that's used when sending messages or push notifications to the endpoint.
     * @see ChannelType
     */
    public ChannelType channelType() {
        return ChannelType.fromValue(channelType);
    }

    /**
     * <p>
     * The channel that's used when sending messages or push notifications to the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return The channel that's used when sending messages or push notifications to the endpoint.
     * @see ChannelType
     */
    public String channelTypeAsString() {
        return channelType;
    }

    /**
     * <p>
     * A number from 0-99 that represents the cohort that the endpoint is assigned to. Endpoints are grouped into
     * cohorts randomly, and each cohort contains approximately 1 percent of the endpoints for an application. Amazon
     * Pinpoint assigns cohorts to the holdout or treatment allocations for campaigns.
     * </p>
     * 
     * @return A number from 0-99 that represents the cohort that the endpoint is assigned to. Endpoints are grouped
     *         into cohorts randomly, and each cohort contains approximately 1 percent of the endpoints for an
     *         application. Amazon Pinpoint assigns cohorts to the holdout or treatment allocations for campaigns.
     */
    public String cohortId() {
        return cohortId;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 format, when the endpoint was created.
     * </p>
     * 
     * @return The date and time, in ISO 8601 format, when the endpoint was created.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The demographic information for the endpoint, such as the time zone and platform.
     * </p>
     * 
     * @return The demographic information for the endpoint, such as the time zone and platform.
     */
    public EndpointDemographic demographic() {
        return demographic;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 format, when the endpoint was last updated.
     * </p>
     * 
     * @return The date and time, in ISO 8601 format, when the endpoint was last updated.
     */
    public String effectiveDate() {
        return effectiveDate;
    }

    /**
     * <p>
     * Not used.
     * </p>
     * 
     * @return Not used.
     */
    public String endpointStatus() {
        return endpointStatus;
    }

    /**
     * <p>
     * The unique identifier that you assigned to the endpoint. The identifier should be a globally unique identifier
     * (GUID) to ensure that it doesn't conflict with other endpoint identifiers that are associated with the
     * application.
     * </p>
     * 
     * @return The unique identifier that you assigned to the endpoint. The identifier should be a globally unique
     *         identifier (GUID) to ensure that it doesn't conflict with other endpoint identifiers that are associated
     *         with the application.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The geographic information for the endpoint.
     * </p>
     * 
     * @return The geographic information for the endpoint.
     */
    public EndpointLocation location() {
        return location;
    }

    /**
     * <p>
     * One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
     */
    public Map<String, Double> metrics() {
        return metrics;
    }

    /**
     * <p>
     * Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push
     * notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages
     * or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push
     * notifications.
     * </p>
     * 
     * @return Specifies whether the user who's associated with the endpoint has opted out of receiving messages and
     *         push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive
     *         any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all
     *         messages and push notifications.
     */
    public String optOut() {
        return optOut;
    }

    /**
     * <p>
     * The unique identifier for the most recent request to update the endpoint.
     * </p>
     * 
     * @return The unique identifier for the most recent request to update the endpoint.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated with
     * the endpoint.
     * </p>
     * 
     * @return One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated
     *         with the endpoint.
     */
    public EndpointUser user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cohortId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(demographic());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(endpointStatus());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(optOut());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointResponse)) {
            return false;
        }
        EndpointResponse other = (EndpointResponse) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(attributes(), other.attributes())
                && Objects.equals(channelTypeAsString(), other.channelTypeAsString())
                && Objects.equals(cohortId(), other.cohortId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(demographic(), other.demographic()) && Objects.equals(effectiveDate(), other.effectiveDate())
                && Objects.equals(endpointStatus(), other.endpointStatus()) && Objects.equals(id(), other.id())
                && Objects.equals(location(), other.location()) && Objects.equals(metrics(), other.metrics())
                && Objects.equals(optOut(), other.optOut()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EndpointResponse").add("Address", address()).add("ApplicationId", applicationId())
                .add("Attributes", attributes()).add("ChannelType", channelTypeAsString()).add("CohortId", cohortId())
                .add("CreationDate", creationDate()).add("Demographic", demographic()).add("EffectiveDate", effectiveDate())
                .add("EndpointStatus", endpointStatus()).add("Id", id()).add("Location", location()).add("Metrics", metrics())
                .add("OptOut", optOut()).add("RequestId", requestId()).add("User", user()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ChannelType":
            return Optional.ofNullable(clazz.cast(channelTypeAsString()));
        case "CohortId":
            return Optional.ofNullable(clazz.cast(cohortId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Demographic":
            return Optional.ofNullable(clazz.cast(demographic()));
        case "EffectiveDate":
            return Optional.ofNullable(clazz.cast(effectiveDate()));
        case "EndpointStatus":
            return Optional.ofNullable(clazz.cast(endpointStatus()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "OptOut":
            return Optional.ofNullable(clazz.cast(optOut()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointResponse, T> g) {
        return obj -> g.apply((EndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointResponse> {
        /**
         * <p>
         * The destination address for messages or push notifications that you send to the endpoint. The address varies
         * by channel. For example, the address for a push-notification channel is typically the token provided by a
         * push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud
         * Messaging (FCM) registration token. The address for the SMS channel is a phone number in E.164 format, such
         * as +12065550100. The address for the email channel is an email address.
         * </p>
         * 
         * @param address
         *        The destination address for messages or push notifications that you send to the endpoint. The address
         *        varies by channel. For example, the address for a push-notification channel is typically the token
         *        provided by a push notification service, such as an Apple Push Notification service (APNs) device
         *        token or a Firebase Cloud Messaging (FCM) registration token. The address for the SMS channel is a
         *        phone number in E.164 format, such as +12065550100. The address for the email channel is an email
         *        address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The unique identifier for the application that's associated with the endpoint.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that's associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * One or more custom attributes that describe the endpoint by associating a name with an array of values. For
         * example, the value of a custom attribute named Interests might be: ["science", "music", "travel"]. You can
         * use these attributes as filter criteria when you create segments.
         * </p>
         * 
         * @param attributes
         *        One or more custom attributes that describe the endpoint by associating a name with an array of
         *        values. For example, the value of a custom attribute named Interests might be: ["science", "music",
         *        "travel"]. You can use these attributes as filter criteria when you create segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, ? extends Collection<String>> attributes);

        /**
         * <p>
         * The channel that's used when sending messages or push notifications to the endpoint.
         * </p>
         * 
         * @param channelType
         *        The channel that's used when sending messages or push notifications to the endpoint.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(String channelType);

        /**
         * <p>
         * The channel that's used when sending messages or push notifications to the endpoint.
         * </p>
         * 
         * @param channelType
         *        The channel that's used when sending messages or push notifications to the endpoint.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(ChannelType channelType);

        /**
         * <p>
         * A number from 0-99 that represents the cohort that the endpoint is assigned to. Endpoints are grouped into
         * cohorts randomly, and each cohort contains approximately 1 percent of the endpoints for an application.
         * Amazon Pinpoint assigns cohorts to the holdout or treatment allocations for campaigns.
         * </p>
         * 
         * @param cohortId
         *        A number from 0-99 that represents the cohort that the endpoint is assigned to. Endpoints are grouped
         *        into cohorts randomly, and each cohort contains approximately 1 percent of the endpoints for an
         *        application. Amazon Pinpoint assigns cohorts to the holdout or treatment allocations for campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cohortId(String cohortId);

        /**
         * <p>
         * The date and time, in ISO 8601 format, when the endpoint was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time, in ISO 8601 format, when the endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The demographic information for the endpoint, such as the time zone and platform.
         * </p>
         * 
         * @param demographic
         *        The demographic information for the endpoint, such as the time zone and platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder demographic(EndpointDemographic demographic);

        /**
         * <p>
         * The demographic information for the endpoint, such as the time zone and platform.
         * </p>
         * This is a convenience that creates an instance of the {@link EndpointDemographic.Builder} avoiding the need
         * to create one manually via {@link EndpointDemographic#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointDemographic.Builder#build()} is called immediately and
         * its result is passed to {@link #demographic(EndpointDemographic)}.
         * 
         * @param demographic
         *        a consumer that will call methods on {@link EndpointDemographic.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #demographic(EndpointDemographic)
         */
        default Builder demographic(Consumer<EndpointDemographic.Builder> demographic) {
            return demographic(EndpointDemographic.builder().applyMutation(demographic).build());
        }

        /**
         * <p>
         * The date and time, in ISO 8601 format, when the endpoint was last updated.
         * </p>
         * 
         * @param effectiveDate
         *        The date and time, in ISO 8601 format, when the endpoint was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDate(String effectiveDate);

        /**
         * <p>
         * Not used.
         * </p>
         * 
         * @param endpointStatus
         *        Not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointStatus(String endpointStatus);

        /**
         * <p>
         * The unique identifier that you assigned to the endpoint. The identifier should be a globally unique
         * identifier (GUID) to ensure that it doesn't conflict with other endpoint identifiers that are associated with
         * the application.
         * </p>
         * 
         * @param id
         *        The unique identifier that you assigned to the endpoint. The identifier should be a globally unique
         *        identifier (GUID) to ensure that it doesn't conflict with other endpoint identifiers that are
         *        associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The geographic information for the endpoint.
         * </p>
         * 
         * @param location
         *        The geographic information for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(EndpointLocation location);

        /**
         * <p>
         * The geographic information for the endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link EndpointLocation.Builder} avoiding the need to
         * create one manually via {@link EndpointLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(EndpointLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link EndpointLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(EndpointLocation)
         */
        default Builder location(Consumer<EndpointLocation.Builder> location) {
            return location(EndpointLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
         * </p>
         * 
         * @param metrics
         *        One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Map<String, Double> metrics);

        /**
         * <p>
         * Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push
         * notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any
         * messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and
         * push notifications.
         * </p>
         * 
         * @param optOut
         *        Specifies whether the user who's associated with the endpoint has opted out of receiving messages and
         *        push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to
         *        receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive
         *        all messages and push notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOut(String optOut);

        /**
         * <p>
         * The unique identifier for the most recent request to update the endpoint.
         * </p>
         * 
         * @param requestId
         *        The unique identifier for the most recent request to update the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated
         * with the endpoint.
         * </p>
         * 
         * @param user
         *        One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's
         *        associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(EndpointUser user);

        /**
         * <p>
         * One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated
         * with the endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link EndpointUser.Builder} avoiding the need to
         * create one manually via {@link EndpointUser#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointUser.Builder#build()} is called immediately and its
         * result is passed to {@link #user(EndpointUser)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link EndpointUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(EndpointUser)
         */
        default Builder user(Consumer<EndpointUser.Builder> user) {
            return user(EndpointUser.builder().applyMutation(user).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String address;

        private String applicationId;

        private Map<String, List<String>> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String channelType;

        private String cohortId;

        private String creationDate;

        private EndpointDemographic demographic;

        private String effectiveDate;

        private String endpointStatus;

        private String id;

        private EndpointLocation location;

        private Map<String, Double> metrics = DefaultSdkAutoConstructMap.getInstance();

        private String optOut;

        private String requestId;

        private EndpointUser user;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointResponse model) {
            address(model.address);
            applicationId(model.applicationId);
            attributes(model.attributes);
            channelType(model.channelType);
            cohortId(model.cohortId);
            creationDate(model.creationDate);
            demographic(model.demographic);
            effectiveDate(model.effectiveDate);
            endpointStatus(model.endpointStatus);
            id(model.id);
            location(model.location);
            metrics(model.metrics);
            optOut(model.optOut);
            requestId(model.requestId);
            user(model.user);
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Map<String, ? extends Collection<String>> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, ? extends Collection<String>> attributes) {
            this.attributes = MapOfListOf__stringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, ? extends Collection<String>> attributes) {
            this.attributes = MapOfListOf__stringCopier.copy(attributes);
        }

        public final String getChannelTypeAsString() {
            return channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        public final String getCohortId() {
            return cohortId;
        }

        @Override
        public final Builder cohortId(String cohortId) {
            this.cohortId = cohortId;
            return this;
        }

        public final void setCohortId(String cohortId) {
            this.cohortId = cohortId;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final EndpointDemographic.Builder getDemographic() {
            return demographic != null ? demographic.toBuilder() : null;
        }

        @Override
        public final Builder demographic(EndpointDemographic demographic) {
            this.demographic = demographic;
            return this;
        }

        public final void setDemographic(EndpointDemographic.BuilderImpl demographic) {
            this.demographic = demographic != null ? demographic.build() : null;
        }

        public final String getEffectiveDate() {
            return effectiveDate;
        }

        @Override
        public final Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final void setEffectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        public final String getEndpointStatus() {
            return endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final EndpointLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(EndpointLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(EndpointLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Map<String, Double> getMetrics() {
            return metrics;
        }

        @Override
        public final Builder metrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
        }

        public final String getOptOut() {
            return optOut;
        }

        @Override
        public final Builder optOut(String optOut) {
            this.optOut = optOut;
            return this;
        }

        public final void setOptOut(String optOut) {
            this.optOut = optOut;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final EndpointUser.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        @Override
        public final Builder user(EndpointUser user) {
            this.user = user;
            return this;
        }

        public final void setUser(EndpointUser.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public EndpointResponse build() {
            return new EndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
