/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the status and settings of a job that exports endpoint definitions to a file. The file can
 * be added directly to an Amazon Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API or
 * downloaded directly to a computer by using the Amazon Pinpoint console.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportJobResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportJobResponse.Builder, ExportJobResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJobResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<Integer> COMPLETED_PIECES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ExportJobResponse::completedPieces)).setter(setter(Builder::completedPieces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedPieces").build()).build();

    private static final SdkField<String> COMPLETION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJobResponse::completionDate)).setter(setter(Builder::completionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJobResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<ExportJobResource> DEFINITION_FIELD = SdkField
            .<ExportJobResource> builder(MarshallingType.SDK_POJO).getter(getter(ExportJobResponse::definition))
            .setter(setter(Builder::definition)).constructor(ExportJobResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<Integer> FAILED_PIECES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ExportJobResponse::failedPieces)).setter(setter(Builder::failedPieces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedPieces").build()).build();

    private static final SdkField<List<String>> FAILURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ExportJobResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJobResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJobResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Integer> TOTAL_FAILURES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ExportJobResponse::totalFailures)).setter(setter(Builder::totalFailures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFailures").build()).build();

    private static final SdkField<Integer> TOTAL_PIECES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ExportJobResponse::totalPieces)).setter(setter(Builder::totalPieces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalPieces").build()).build();

    private static final SdkField<Integer> TOTAL_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ExportJobResponse::totalProcessed)).setter(setter(Builder::totalProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalProcessed").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExportJobResponse::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            COMPLETED_PIECES_FIELD, COMPLETION_DATE_FIELD, CREATION_DATE_FIELD, DEFINITION_FIELD, FAILED_PIECES_FIELD,
            FAILURES_FIELD, ID_FIELD, JOB_STATUS_FIELD, TOTAL_FAILURES_FIELD, TOTAL_PIECES_FIELD, TOTAL_PROCESSED_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final Integer completedPieces;

    private final String completionDate;

    private final String creationDate;

    private final ExportJobResource definition;

    private final Integer failedPieces;

    private final List<String> failures;

    private final String id;

    private final String jobStatus;

    private final Integer totalFailures;

    private final Integer totalPieces;

    private final Integer totalProcessed;

    private final String type;

    private ExportJobResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.completedPieces = builder.completedPieces;
        this.completionDate = builder.completionDate;
        this.creationDate = builder.creationDate;
        this.definition = builder.definition;
        this.failedPieces = builder.failedPieces;
        this.failures = builder.failures;
        this.id = builder.id;
        this.jobStatus = builder.jobStatus;
        this.totalFailures = builder.totalFailures;
        this.totalPieces = builder.totalPieces;
        this.totalProcessed = builder.totalProcessed;
        this.type = builder.type;
    }

    /**
     * <p>
     * The unique identifier for the application that's associated with the export job.
     * </p>
     * 
     * @return The unique identifier for the application that's associated with the export job.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The number of pieces that were processed successfully (completed) by the export job, as of the time of the
     * request.
     * </p>
     * 
     * @return The number of pieces that were processed successfully (completed) by the export job, as of the time of
     *         the request.
     */
    public Integer completedPieces() {
        return completedPieces;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the export job was completed.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the export job was completed.
     */
    public String completionDate() {
        return completionDate;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the export job was created.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the export job was created.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The resource settings that apply to the export job.
     * </p>
     * 
     * @return The resource settings that apply to the export job.
     */
    public ExportJobResource definition() {
        return definition;
    }

    /**
     * <p>
     * The number of pieces that weren't processed successfully (failed) by the export job, as of the time of the
     * request.
     * </p>
     * 
     * @return The number of pieces that weren't processed successfully (failed) by the export job, as of the time of
     *         the request.
     */
    public Integer failedPieces() {
        return failedPieces;
    }

    /**
     * <p>
     * An array of entries, one for each of the first 100 entries that weren't processed successfully (failed) by the
     * export job, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of entries, one for each of the first 100 entries that weren't processed successfully (failed)
     *         by the export job, if any.
     */
    public List<String> failures() {
        return failures;
    }

    /**
     * <p>
     * The unique identifier for the export job.
     * </p>
     * 
     * @return The unique identifier for the export job.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The status of the export job. The job status is FAILED if Amazon Pinpoint wasn't able to process one or more
     * pieces in the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the export job. The job status is FAILED if Amazon Pinpoint wasn't able to process one or
     *         more pieces in the job.
     * @see JobStatus
     */
    public JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the export job. The job status is FAILED if Amazon Pinpoint wasn't able to process one or more
     * pieces in the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the export job. The job status is FAILED if Amazon Pinpoint wasn't able to process one or
     *         more pieces in the job.
     * @see JobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The total number of endpoint definitions that weren't processed successfully (failed) by the export job,
     * typically because an error, such as a syntax error, occurred.
     * </p>
     * 
     * @return The total number of endpoint definitions that weren't processed successfully (failed) by the export job,
     *         typically because an error, such as a syntax error, occurred.
     */
    public Integer totalFailures() {
        return totalFailures;
    }

    /**
     * <p>
     * The total number of pieces that must be processed to complete the export job. Each piece consists of an
     * approximately equal portion of the endpoint definitions that are part of the export job.
     * </p>
     * 
     * @return The total number of pieces that must be processed to complete the export job. Each piece consists of an
     *         approximately equal portion of the endpoint definitions that are part of the export job.
     */
    public Integer totalPieces() {
        return totalPieces;
    }

    /**
     * <p>
     * The total number of endpoint definitions that were processed by the export job.
     * </p>
     * 
     * @return The total number of endpoint definitions that were processed by the export job.
     */
    public Integer totalProcessed() {
        return totalProcessed;
    }

    /**
     * <p>
     * The job type. This value is EXPORT for export jobs.
     * </p>
     * 
     * @return The job type. This value is EXPORT for export jobs.
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(completedPieces());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(failedPieces());
        hashCode = 31 * hashCode + Objects.hashCode(failures());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalFailures());
        hashCode = 31 * hashCode + Objects.hashCode(totalPieces());
        hashCode = 31 * hashCode + Objects.hashCode(totalProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobResponse)) {
            return false;
        }
        ExportJobResponse other = (ExportJobResponse) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(completedPieces(), other.completedPieces())
                && Objects.equals(completionDate(), other.completionDate())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(definition(), other.definition())
                && Objects.equals(failedPieces(), other.failedPieces()) && Objects.equals(failures(), other.failures())
                && Objects.equals(id(), other.id()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(totalFailures(), other.totalFailures()) && Objects.equals(totalPieces(), other.totalPieces())
                && Objects.equals(totalProcessed(), other.totalProcessed()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExportJobResponse").add("ApplicationId", applicationId())
                .add("CompletedPieces", completedPieces()).add("CompletionDate", completionDate())
                .add("CreationDate", creationDate()).add("Definition", definition()).add("FailedPieces", failedPieces())
                .add("Failures", failures()).add("Id", id()).add("JobStatus", jobStatusAsString())
                .add("TotalFailures", totalFailures()).add("TotalPieces", totalPieces()).add("TotalProcessed", totalProcessed())
                .add("Type", type()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "CompletedPieces":
            return Optional.ofNullable(clazz.cast(completedPieces()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "FailedPieces":
            return Optional.ofNullable(clazz.cast(failedPieces()));
        case "Failures":
            return Optional.ofNullable(clazz.cast(failures()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "TotalFailures":
            return Optional.ofNullable(clazz.cast(totalFailures()));
        case "TotalPieces":
            return Optional.ofNullable(clazz.cast(totalPieces()));
        case "TotalProcessed":
            return Optional.ofNullable(clazz.cast(totalProcessed()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportJobResponse, T> g) {
        return obj -> g.apply((ExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportJobResponse> {
        /**
         * <p>
         * The unique identifier for the application that's associated with the export job.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that's associated with the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The number of pieces that were processed successfully (completed) by the export job, as of the time of the
         * request.
         * </p>
         * 
         * @param completedPieces
         *        The number of pieces that were processed successfully (completed) by the export job, as of the time of
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedPieces(Integer completedPieces);

        /**
         * <p>
         * The date, in ISO 8601 format, when the export job was completed.
         * </p>
         * 
         * @param completionDate
         *        The date, in ISO 8601 format, when the export job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(String completionDate);

        /**
         * <p>
         * The date, in ISO 8601 format, when the export job was created.
         * </p>
         * 
         * @param creationDate
         *        The date, in ISO 8601 format, when the export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The resource settings that apply to the export job.
         * </p>
         * 
         * @param definition
         *        The resource settings that apply to the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(ExportJobResource definition);

        /**
         * <p>
         * The resource settings that apply to the export job.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportJobResource.Builder} avoiding the need to
         * create one manually via {@link ExportJobResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportJobResource.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(ExportJobResource)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link ExportJobResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(ExportJobResource)
         */
        default Builder definition(Consumer<ExportJobResource.Builder> definition) {
            return definition(ExportJobResource.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The number of pieces that weren't processed successfully (failed) by the export job, as of the time of the
         * request.
         * </p>
         * 
         * @param failedPieces
         *        The number of pieces that weren't processed successfully (failed) by the export job, as of the time of
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedPieces(Integer failedPieces);

        /**
         * <p>
         * An array of entries, one for each of the first 100 entries that weren't processed successfully (failed) by
         * the export job, if any.
         * </p>
         * 
         * @param failures
         *        An array of entries, one for each of the first 100 entries that weren't processed successfully
         *        (failed) by the export job, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<String> failures);

        /**
         * <p>
         * An array of entries, one for each of the first 100 entries that weren't processed successfully (failed) by
         * the export job, if any.
         * </p>
         * 
         * @param failures
         *        An array of entries, one for each of the first 100 entries that weren't processed successfully
         *        (failed) by the export job, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(String... failures);

        /**
         * <p>
         * The unique identifier for the export job.
         * </p>
         * 
         * @param id
         *        The unique identifier for the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the export job. The job status is FAILED if Amazon Pinpoint wasn't able to process one or more
         * pieces in the job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the export job. The job status is FAILED if Amazon Pinpoint wasn't able to process one
         *        or more pieces in the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the export job. The job status is FAILED if Amazon Pinpoint wasn't able to process one or more
         * pieces in the job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the export job. The job status is FAILED if Amazon Pinpoint wasn't able to process one
         *        or more pieces in the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The total number of endpoint definitions that weren't processed successfully (failed) by the export job,
         * typically because an error, such as a syntax error, occurred.
         * </p>
         * 
         * @param totalFailures
         *        The total number of endpoint definitions that weren't processed successfully (failed) by the export
         *        job, typically because an error, such as a syntax error, occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFailures(Integer totalFailures);

        /**
         * <p>
         * The total number of pieces that must be processed to complete the export job. Each piece consists of an
         * approximately equal portion of the endpoint definitions that are part of the export job.
         * </p>
         * 
         * @param totalPieces
         *        The total number of pieces that must be processed to complete the export job. Each piece consists of
         *        an approximately equal portion of the endpoint definitions that are part of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalPieces(Integer totalPieces);

        /**
         * <p>
         * The total number of endpoint definitions that were processed by the export job.
         * </p>
         * 
         * @param totalProcessed
         *        The total number of endpoint definitions that were processed by the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalProcessed(Integer totalProcessed);

        /**
         * <p>
         * The job type. This value is EXPORT for export jobs.
         * </p>
         * 
         * @param type
         *        The job type. This value is EXPORT for export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private Integer completedPieces;

        private String completionDate;

        private String creationDate;

        private ExportJobResource definition;

        private Integer failedPieces;

        private List<String> failures = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private String jobStatus;

        private Integer totalFailures;

        private Integer totalPieces;

        private Integer totalProcessed;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobResponse model) {
            applicationId(model.applicationId);
            completedPieces(model.completedPieces);
            completionDate(model.completionDate);
            creationDate(model.creationDate);
            definition(model.definition);
            failedPieces(model.failedPieces);
            failures(model.failures);
            id(model.id);
            jobStatus(model.jobStatus);
            totalFailures(model.totalFailures);
            totalPieces(model.totalPieces);
            totalProcessed(model.totalProcessed);
            type(model.type);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Integer getCompletedPieces() {
            return completedPieces;
        }

        @Override
        public final Builder completedPieces(Integer completedPieces) {
            this.completedPieces = completedPieces;
            return this;
        }

        public final void setCompletedPieces(Integer completedPieces) {
            this.completedPieces = completedPieces;
        }

        public final String getCompletionDate() {
            return completionDate;
        }

        @Override
        public final Builder completionDate(String completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(String completionDate) {
            this.completionDate = completionDate;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final ExportJobResource.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(ExportJobResource definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(ExportJobResource.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final Integer getFailedPieces() {
            return failedPieces;
        }

        @Override
        public final Builder failedPieces(Integer failedPieces) {
            this.failedPieces = failedPieces;
            return this;
        }

        public final void setFailedPieces(Integer failedPieces) {
            this.failedPieces = failedPieces;
        }

        public final Collection<String> getFailures() {
            return failures;
        }

        @Override
        public final Builder failures(Collection<String> failures) {
            this.failures = ListOf__stringCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(String... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        public final void setFailures(Collection<String> failures) {
            this.failures = ListOf__stringCopier.copy(failures);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getJobStatusAsString() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Integer getTotalFailures() {
            return totalFailures;
        }

        @Override
        public final Builder totalFailures(Integer totalFailures) {
            this.totalFailures = totalFailures;
            return this;
        }

        public final void setTotalFailures(Integer totalFailures) {
            this.totalFailures = totalFailures;
        }

        public final Integer getTotalPieces() {
            return totalPieces;
        }

        @Override
        public final Builder totalPieces(Integer totalPieces) {
            this.totalPieces = totalPieces;
            return this;
        }

        public final void setTotalPieces(Integer totalPieces) {
            this.totalPieces = totalPieces;
        }

        public final Integer getTotalProcessed() {
            return totalProcessed;
        }

        @Override
        public final Builder totalProcessed(Integer totalProcessed) {
            this.totalProcessed = totalProcessed;
            return this;
        }

        public final void setTotalProcessed(Integer totalProcessed) {
            this.totalProcessed = totalProcessed;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public ExportJobResponse build() {
            return new ExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
