/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCampaignVersionsResponse extends PinpointResponse implements
        ToCopyableBuilder<GetCampaignVersionsResponse.Builder, GetCampaignVersionsResponse> {
    private static final SdkField<CampaignsResponse> CAMPAIGNS_RESPONSE_FIELD = SdkField
            .<CampaignsResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetCampaignVersionsResponse::campaignsResponse))
            .setter(setter(Builder::campaignsResponse))
            .constructor(CampaignsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignsResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGNS_RESPONSE_FIELD));

    private final CampaignsResponse campaignsResponse;

    private GetCampaignVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.campaignsResponse = builder.campaignsResponse;
    }

    /**
     * Returns the value of the CampaignsResponse property for this object.
     * 
     * @return The value of the CampaignsResponse property for this object.
     */
    public CampaignsResponse campaignsResponse() {
        return campaignsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaignsResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignVersionsResponse)) {
            return false;
        }
        GetCampaignVersionsResponse other = (GetCampaignVersionsResponse) obj;
        return Objects.equals(campaignsResponse(), other.campaignsResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCampaignVersionsResponse").add("CampaignsResponse", campaignsResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignsResponse":
            return Optional.ofNullable(clazz.cast(campaignsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignVersionsResponse, T> g) {
        return obj -> g.apply((GetCampaignVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCampaignVersionsResponse> {
        /**
         * Sets the value of the CampaignsResponse property for this object.
         *
         * @param campaignsResponse
         *        The new value for the CampaignsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignsResponse(CampaignsResponse campaignsResponse);

        /**
         * Sets the value of the CampaignsResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link CampaignsResponse.Builder} avoiding the need to
         * create one manually via {@link CampaignsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignsResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #campaignsResponse(CampaignsResponse)}.
         * 
         * @param campaignsResponse
         *        a consumer that will call methods on {@link CampaignsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #campaignsResponse(CampaignsResponse)
         */
        default Builder campaignsResponse(Consumer<CampaignsResponse.Builder> campaignsResponse) {
            return campaignsResponse(CampaignsResponse.builder().applyMutation(campaignsResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private CampaignsResponse campaignsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignVersionsResponse model) {
            super(model);
            campaignsResponse(model.campaignsResponse);
        }

        public final CampaignsResponse.Builder getCampaignsResponse() {
            return campaignsResponse != null ? campaignsResponse.toBuilder() : null;
        }

        @Override
        public final Builder campaignsResponse(CampaignsResponse campaignsResponse) {
            this.campaignsResponse = campaignsResponse;
            return this;
        }

        public final void setCampaignsResponse(CampaignsResponse.BuilderImpl campaignsResponse) {
            this.campaignsResponse = campaignsResponse != null ? campaignsResponse.build() : null;
        }

        @Override
        public GetCampaignVersionsResponse build() {
            return new GetCampaignVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
