/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the default settings for a one-time SMS message that's sent directly to an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SMSMessage implements SdkPojo, Serializable, ToCopyableBuilder<SMSMessage.Builder, SMSMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SMSMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> KEYWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SMSMessage::keyword)).setter(setter(Builder::keyword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keyword").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SMSMessage::messageTypeAsString)).setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<String> ORIGINATION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SMSMessage::originationNumber)).setter(setter(Builder::originationNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationNumber").build()).build();

    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SMSMessage::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(SMSMessage::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, KEYWORD_FIELD,
            MESSAGE_TYPE_FIELD, ORIGINATION_NUMBER_FIELD, SENDER_ID_FIELD, SUBSTITUTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String keyword;

    private final String messageType;

    private final String originationNumber;

    private final String senderId;

    private final Map<String, List<String>> substitutions;

    private SMSMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.keyword = builder.keyword;
        this.messageType = builder.messageType;
        this.originationNumber = builder.originationNumber;
        this.senderId = builder.senderId;
        this.substitutions = builder.substitutions;
    }

    /**
     * <p>
     * The body of the SMS message.
     * </p>
     * 
     * @return The body of the SMS message.
     */
    public String body() {
        return body;
    }

    /**
     * <p>
     * The SMS program name that you provided to AWS Support when you requested your dedicated number.
     * </p>
     * 
     * @return The SMS program name that you provided to AWS Support when you requested your dedicated number.
     */
    public String keyword() {
        return keyword;
    }

    /**
     * <p>
     * The SMS message type. Valid values are: TRANSACTIONAL, the message is critical or time-sensitive, such as a
     * one-time password that supports a customer transaction; and, PROMOTIONAL, the message is not critical or
     * time-sensitive, such as a marketing message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The SMS message type. Valid values are: TRANSACTIONAL, the message is critical or time-sensitive, such as
     *         a one-time password that supports a customer transaction; and, PROMOTIONAL, the message is not critical
     *         or time-sensitive, such as a marketing message.
     * @see MessageType
     */
    public MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The SMS message type. Valid values are: TRANSACTIONAL, the message is critical or time-sensitive, such as a
     * one-time password that supports a customer transaction; and, PROMOTIONAL, the message is not critical or
     * time-sensitive, such as a marketing message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The SMS message type. Valid values are: TRANSACTIONAL, the message is critical or time-sensitive, such as
     *         a one-time password that supports a customer transaction; and, PROMOTIONAL, the message is not critical
     *         or time-sensitive, such as a marketing message.
     * @see MessageType
     */
    public String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * The number that the SMS message originates from. This should be one of the dedicated long codes or short codes
     * that you requested from AWS Support and is assigned to your AWS account. If you don't specify a long or short
     * code, Amazon Pinpoint assigns a random long code to the SMS message.
     * </p>
     * 
     * @return The number that the SMS message originates from. This should be one of the dedicated long codes or short
     *         codes that you requested from AWS Support and is assigned to your AWS account. If you don't specify a
     *         long or short code, Amazon Pinpoint assigns a random long code to the SMS message.
     */
    public String originationNumber() {
        return originationNumber;
    }

    /**
     * <p>
     * The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by
     * country or region.
     * </p>
     * 
     * @return The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs
     *         varies by country or region.
     */
    public String senderId() {
        return senderId;
    }

    /**
     * <p>
     * The message variables to use in the SMS message. You can override the default variables with individual address
     * variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The message variables to use in the SMS message. You can override the default variables with individual
     *         address variables.
     */
    public Map<String, List<String>> substitutions() {
        return substitutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(keyword());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        hashCode = 31 * hashCode + Objects.hashCode(substitutions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSMessage)) {
            return false;
        }
        SMSMessage other = (SMSMessage) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(keyword(), other.keyword())
                && Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && Objects.equals(originationNumber(), other.originationNumber()) && Objects.equals(senderId(), other.senderId())
                && Objects.equals(substitutions(), other.substitutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SMSMessage").add("Body", body()).add("Keyword", keyword())
                .add("MessageType", messageTypeAsString()).add("OriginationNumber", originationNumber())
                .add("SenderId", senderId()).add("Substitutions", substitutions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Keyword":
            return Optional.ofNullable(clazz.cast(keyword()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "OriginationNumber":
            return Optional.ofNullable(clazz.cast(originationNumber()));
        case "SenderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SMSMessage, T> g) {
        return obj -> g.apply((SMSMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SMSMessage> {
        /**
         * <p>
         * The body of the SMS message.
         * </p>
         * 
         * @param body
         *        The body of the SMS message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The SMS program name that you provided to AWS Support when you requested your dedicated number.
         * </p>
         * 
         * @param keyword
         *        The SMS program name that you provided to AWS Support when you requested your dedicated number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyword(String keyword);

        /**
         * <p>
         * The SMS message type. Valid values are: TRANSACTIONAL, the message is critical or time-sensitive, such as a
         * one-time password that supports a customer transaction; and, PROMOTIONAL, the message is not critical or
         * time-sensitive, such as a marketing message.
         * </p>
         * 
         * @param messageType
         *        The SMS message type. Valid values are: TRANSACTIONAL, the message is critical or time-sensitive, such
         *        as a one-time password that supports a customer transaction; and, PROMOTIONAL, the message is not
         *        critical or time-sensitive, such as a marketing message.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The SMS message type. Valid values are: TRANSACTIONAL, the message is critical or time-sensitive, such as a
         * one-time password that supports a customer transaction; and, PROMOTIONAL, the message is not critical or
         * time-sensitive, such as a marketing message.
         * </p>
         * 
         * @param messageType
         *        The SMS message type. Valid values are: TRANSACTIONAL, the message is critical or time-sensitive, such
         *        as a one-time password that supports a customer transaction; and, PROMOTIONAL, the message is not
         *        critical or time-sensitive, such as a marketing message.
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * The number that the SMS message originates from. This should be one of the dedicated long codes or short
         * codes that you requested from AWS Support and is assigned to your AWS account. If you don't specify a long or
         * short code, Amazon Pinpoint assigns a random long code to the SMS message.
         * </p>
         * 
         * @param originationNumber
         *        The number that the SMS message originates from. This should be one of the dedicated long codes or
         *        short codes that you requested from AWS Support and is assigned to your AWS account. If you don't
         *        specify a long or short code, Amazon Pinpoint assigns a random long code to the SMS message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationNumber(String originationNumber);

        /**
         * <p>
         * The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies
         * by country or region.
         * </p>
         * 
         * @param senderId
         *        The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs
         *        varies by country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);

        /**
         * <p>
         * The message variables to use in the SMS message. You can override the default variables with individual
         * address variables.
         * </p>
         * 
         * @param substitutions
         *        The message variables to use in the SMS message. You can override the default variables with
         *        individual address variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String keyword;

        private String messageType;

        private String originationNumber;

        private String senderId;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SMSMessage model) {
            body(model.body);
            keyword(model.keyword);
            messageType(model.messageType);
            originationNumber(model.originationNumber);
            senderId(model.senderId);
            substitutions(model.substitutions);
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getKeyword() {
            return keyword;
        }

        @Override
        public final Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public final void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        public final String getMessageTypeAsString() {
            return messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final String getOriginationNumber() {
            return originationNumber;
        }

        @Override
        public final Builder originationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
            return this;
        }

        public final void setOriginationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
        }

        public final String getSenderId() {
            return senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        @Override
        public SMSMessage build() {
            return new SMSMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
