/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the configuration, dimension, and other settings for a segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentResponse implements SdkPojo, Serializable, ToCopyableBuilder<SegmentResponse.Builder, SegmentResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<SegmentDimensions> DIMENSIONS_FIELD = SdkField
            .<SegmentDimensions> builder(MarshallingType.SDK_POJO).getter(getter(SegmentResponse::dimensions))
            .setter(setter(Builder::dimensions)).constructor(SegmentDimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<SegmentImportResource> IMPORT_DEFINITION_FIELD = SdkField
            .<SegmentImportResource> builder(MarshallingType.SDK_POJO).getter(getter(SegmentResponse::importDefinition))
            .setter(setter(Builder::importDefinition)).constructor(SegmentImportResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDefinition").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<SegmentGroupList> SEGMENT_GROUPS_FIELD = SdkField
            .<SegmentGroupList> builder(MarshallingType.SDK_POJO).getter(getter(SegmentResponse::segmentGroups))
            .setter(setter(Builder::segmentGroups)).constructor(SegmentGroupList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentGroups").build()).build();

    private static final SdkField<String> SEGMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentResponse::segmentTypeAsString)).setter(setter(Builder::segmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentType").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(SegmentResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SegmentResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ARN_FIELD, CREATION_DATE_FIELD, DIMENSIONS_FIELD, ID_FIELD, IMPORT_DEFINITION_FIELD, LAST_MODIFIED_DATE_FIELD,
            NAME_FIELD, SEGMENT_GROUPS_FIELD, SEGMENT_TYPE_FIELD, TAGS_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String arn;

    private final String creationDate;

    private final SegmentDimensions dimensions;

    private final String id;

    private final SegmentImportResource importDefinition;

    private final String lastModifiedDate;

    private final String name;

    private final SegmentGroupList segmentGroups;

    private final String segmentType;

    private final Map<String, String> tags;

    private final Integer version;

    private SegmentResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.dimensions = builder.dimensions;
        this.id = builder.id;
        this.importDefinition = builder.importDefinition;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.segmentGroups = builder.segmentGroups;
        this.segmentType = builder.segmentType;
        this.tags = builder.tags;
        this.version = builder.version;
    }

    /**
     * <p>
     * The unique identifier for the application that the segment is associated with.
     * </p>
     * 
     * @return The unique identifier for the application that the segment is associated with.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the segment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the segment.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time when the segment was created.
     * </p>
     * 
     * @return The date and time when the segment was created.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The dimension settings for the segment.
     * </p>
     * 
     * @return The dimension settings for the segment.
     */
    public SegmentDimensions dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The unique identifier for the segment.
     * </p>
     * 
     * @return The unique identifier for the segment.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The settings for the import job that's associated with the segment.
     * </p>
     * 
     * @return The settings for the import job that's associated with the segment.
     */
    public SegmentImportResource importDefinition() {
        return importDefinition;
    }

    /**
     * <p>
     * The date and time when the segment was last modified.
     * </p>
     * 
     * @return The date and time when the segment was last modified.
     */
    public String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The name of the segment.
     * </p>
     * 
     * @return The name of the segment.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A list of one or more segment groups that apply to the segment. Each segment group consists of zero or more base
     * segments and the dimensions that are applied to those base segments.
     * </p>
     * 
     * @return A list of one or more segment groups that apply to the segment. Each segment group consists of zero or
     *         more base segments and the dimensions that are applied to those base segments.
     */
    public SegmentGroupList segmentGroups() {
        return segmentGroups;
    }

    /**
     * <p>
     * The segment type. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is based on
     * endpoint data that's reported by your app. Dynamic segments can change over time.
     * </p>
     * </li>
     * <li>
     * <p>
     * IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on
     * endpoint definitions that you they don't change over time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentType} will
     * return {@link SegmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #segmentTypeAsString}.
     * </p>
     * 
     * @return The segment type. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is
     *         based on endpoint data that's reported by your app. Dynamic segments can change over time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based
     *         on endpoint definitions that you import from a file. Imported segments are static; they don't change over
     *         time.
     *         </p>
     *         </li>
     * @see SegmentType
     */
    public SegmentType segmentType() {
        return SegmentType.fromValue(segmentType);
    }

    /**
     * <p>
     * The segment type. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is based on
     * endpoint data that's reported by your app. Dynamic segments can change over time.
     * </p>
     * </li>
     * <li>
     * <p>
     * IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on
     * endpoint definitions that you import from a file. Imported segments are static; they don't change over time.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentType} will
     * return {@link SegmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #segmentTypeAsString}.
     * </p>
     * 
     * @return The segment type. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is
     *         based on endpoint data that's reported by your app. Dynamic segments can change over time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based
     *         on endpoint definitions that you import from a file. Imported segments are static; they don't change over
     *         time.
     *         </p>
     *         </li>
     * @see SegmentType
     */
    public String segmentTypeAsString() {
        return segmentType;
    }

    /**
     * <p>
     * A string-to-string map of key-value pairs that identifies the tags that are associated with the segment. Each tag
     * consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A string-to-string map of key-value pairs that identifies the tags that are associated with the segment.
     *         Each tag consists of a required tag key and an associated tag value.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The version number of the segment.
     * </p>
     * 
     * @return The version number of the segment.
     */
    public Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(importDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(segmentGroups());
        hashCode = 31 * hashCode + Objects.hashCode(segmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentResponse)) {
            return false;
        }
        SegmentResponse other = (SegmentResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(id(), other.id()) && Objects.equals(importDefinition(), other.importDefinition())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(name(), other.name())
                && Objects.equals(segmentGroups(), other.segmentGroups())
                && Objects.equals(segmentTypeAsString(), other.segmentTypeAsString()) && Objects.equals(tags(), other.tags())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SegmentResponse").add("ApplicationId", applicationId()).add("Arn", arn())
                .add("CreationDate", creationDate()).add("Dimensions", dimensions()).add("Id", id())
                .add("ImportDefinition", importDefinition()).add("LastModifiedDate", lastModifiedDate()).add("Name", name())
                .add("SegmentGroups", segmentGroups()).add("SegmentType", segmentTypeAsString()).add("Tags", tags())
                .add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ImportDefinition":
            return Optional.ofNullable(clazz.cast(importDefinition()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SegmentGroups":
            return Optional.ofNullable(clazz.cast(segmentGroups()));
        case "SegmentType":
            return Optional.ofNullable(clazz.cast(segmentTypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentResponse, T> g) {
        return obj -> g.apply((SegmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentResponse> {
        /**
         * <p>
         * The unique identifier for the application that the segment is associated with.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that the segment is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the segment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time when the segment was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the segment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The dimension settings for the segment.
         * </p>
         * 
         * @param dimensions
         *        The dimension settings for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(SegmentDimensions dimensions);

        /**
         * <p>
         * The dimension settings for the segment.
         * </p>
         * This is a convenience that creates an instance of the {@link SegmentDimensions.Builder} avoiding the need to
         * create one manually via {@link SegmentDimensions#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentDimensions.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(SegmentDimensions)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link SegmentDimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(SegmentDimensions)
         */
        default Builder dimensions(Consumer<SegmentDimensions.Builder> dimensions) {
            return dimensions(SegmentDimensions.builder().applyMutation(dimensions).build());
        }

        /**
         * <p>
         * The unique identifier for the segment.
         * </p>
         * 
         * @param id
         *        The unique identifier for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The settings for the import job that's associated with the segment.
         * </p>
         * 
         * @param importDefinition
         *        The settings for the import job that's associated with the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDefinition(SegmentImportResource importDefinition);

        /**
         * <p>
         * The settings for the import job that's associated with the segment.
         * </p>
         * This is a convenience that creates an instance of the {@link SegmentImportResource.Builder} avoiding the need
         * to create one manually via {@link SegmentImportResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentImportResource.Builder#build()} is called immediately and
         * its result is passed to {@link #importDefinition(SegmentImportResource)}.
         * 
         * @param importDefinition
         *        a consumer that will call methods on {@link SegmentImportResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importDefinition(SegmentImportResource)
         */
        default Builder importDefinition(Consumer<SegmentImportResource.Builder> importDefinition) {
            return importDefinition(SegmentImportResource.builder().applyMutation(importDefinition).build());
        }

        /**
         * <p>
         * The date and time when the segment was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time when the segment was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The name of the segment.
         * </p>
         * 
         * @param name
         *        The name of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of one or more segment groups that apply to the segment. Each segment group consists of zero or more
         * base segments and the dimensions that are applied to those base segments.
         * </p>
         * 
         * @param segmentGroups
         *        A list of one or more segment groups that apply to the segment. Each segment group consists of zero or
         *        more base segments and the dimensions that are applied to those base segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentGroups(SegmentGroupList segmentGroups);

        /**
         * <p>
         * A list of one or more segment groups that apply to the segment. Each segment group consists of zero or more
         * base segments and the dimensions that are applied to those base segments.
         * </p>
         * This is a convenience that creates an instance of the {@link SegmentGroupList.Builder} avoiding the need to
         * create one manually via {@link SegmentGroupList#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentGroupList.Builder#build()} is called immediately and its
         * result is passed to {@link #segmentGroups(SegmentGroupList)}.
         * 
         * @param segmentGroups
         *        a consumer that will call methods on {@link SegmentGroupList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentGroups(SegmentGroupList)
         */
        default Builder segmentGroups(Consumer<SegmentGroupList.Builder> segmentGroups) {
            return segmentGroups(SegmentGroupList.builder().applyMutation(segmentGroups).build());
        }

        /**
         * <p>
         * The segment type. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is
         * based on endpoint data that's reported by your app. Dynamic segments can change over time.
         * </p>
         * </li>
         * <li>
         * <p>
         * IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on
         * endpoint definitions that you import from a file. Imported segments are static; they don't change over time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param segmentType
         *        The segment type. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and
         *        is based on endpoint data that's reported by your app. Dynamic segments can change over time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is
         *        based on endpoint definitions that you import from a file. Imported segments are static; they don't
         *        change over time.
         *        </p>
         *        </li>
         * @see SegmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentType
         */
        Builder segmentType(String segmentType);

        /**
         * <p>
         * The segment type. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is
         * based on endpoint data that's reported by your app. Dynamic segments can change over time.
         * </p>
         * </li>
         * <li>
         * <p>
         * IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on
         * endpoint definitions that you import from a file. Imported segments are static; they don't change over time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param segmentType
         *        The segment type. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and
         *        is based on endpoint data that's reported by your app. Dynamic segments can change over time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is
         *        based on endpoint definitions that you import from a file. Imported segments are static; they don't
         *        change over time.
         *        </p>
         *        </li>
         * @see SegmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentType
         */
        Builder segmentType(SegmentType segmentType);

        /**
         * <p>
         * A string-to-string map of key-value pairs that identifies the tags that are associated with the segment. Each
         * tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        A string-to-string map of key-value pairs that identifies the tags that are associated with the
         *        segment. Each tag consists of a required tag key and an associated tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The version number of the segment.
         * </p>
         * 
         * @param version
         *        The version number of the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String arn;

        private String creationDate;

        private SegmentDimensions dimensions;

        private String id;

        private SegmentImportResource importDefinition;

        private String lastModifiedDate;

        private String name;

        private SegmentGroupList segmentGroups;

        private String segmentType;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentResponse model) {
            applicationId(model.applicationId);
            arn(model.arn);
            creationDate(model.creationDate);
            dimensions(model.dimensions);
            id(model.id);
            importDefinition(model.importDefinition);
            lastModifiedDate(model.lastModifiedDate);
            name(model.name);
            segmentGroups(model.segmentGroups);
            segmentType(model.segmentType);
            tags(model.tags);
            version(model.version);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final SegmentDimensions.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(SegmentDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(SegmentDimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final SegmentImportResource.Builder getImportDefinition() {
            return importDefinition != null ? importDefinition.toBuilder() : null;
        }

        @Override
        public final Builder importDefinition(SegmentImportResource importDefinition) {
            this.importDefinition = importDefinition;
            return this;
        }

        public final void setImportDefinition(SegmentImportResource.BuilderImpl importDefinition) {
            this.importDefinition = importDefinition != null ? importDefinition.build() : null;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final SegmentGroupList.Builder getSegmentGroups() {
            return segmentGroups != null ? segmentGroups.toBuilder() : null;
        }

        @Override
        public final Builder segmentGroups(SegmentGroupList segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        public final void setSegmentGroups(SegmentGroupList.BuilderImpl segmentGroups) {
            this.segmentGroups = segmentGroups != null ? segmentGroups.build() : null;
        }

        public final String getSegmentTypeAsString() {
            return segmentType;
        }

        @Override
        public final Builder segmentType(String segmentType) {
            this.segmentType = segmentType;
            return this;
        }

        @Override
        public final Builder segmentType(SegmentType segmentType) {
            this.segmentType(segmentType == null ? null : segmentType.toString());
            return this;
        }

        public final void setSegmentType(String segmentType) {
            this.segmentType = segmentType;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public SegmentResponse build() {
            return new SegmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
