/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the content and settings for a message template that can be used in messages that are sent through the
 * email channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailTemplateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailTemplateRequest.Builder, EmailTemplateRequest> {
    private static final SdkField<String> HTML_PART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailTemplateRequest::htmlPart)).setter(setter(Builder::htmlPart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlPart").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailTemplateRequest::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(EmailTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEXT_PART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailTemplateRequest::textPart)).setter(setter(Builder::textPart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextPart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTML_PART_FIELD,
            SUBJECT_FIELD, TAGS_FIELD, TEXT_PART_FIELD));

    private static final long serialVersionUID = 1L;

    private final String htmlPart;

    private final String subject;

    private final Map<String, String> tags;

    private final String textPart;

    private EmailTemplateRequest(BuilderImpl builder) {
        this.htmlPart = builder.htmlPart;
        this.subject = builder.subject;
        this.tags = builder.tags;
        this.textPart = builder.textPart;
    }

    /**
     * <p>
     * The message body, in HTML format, to use in email messages that are based on the message template. We recommend
     * using HTML format for email clients that support HTML. You can include links, formatted text, and more in an HTML
     * message.
     * </p>
     * 
     * @return The message body, in HTML format, to use in email messages that are based on the message template. We
     *         recommend using HTML format for email clients that support HTML. You can include links, formatted text,
     *         and more in an HTML message.
     */
    public String htmlPart() {
        return htmlPart;
    }

    /**
     * <p>
     * The subject line, or title, to use in email messages that are based on the message template.
     * </p>
     * 
     * @return The subject line, or title, to use in email messages that are based on the message template.
     */
    public String subject() {
        return subject;
    }

    /**
     * <p>
     * A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag
     * consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A string-to-string map of key-value pairs that defines the tags to associate with the message template.
     *         Each tag consists of a required tag key and an associated tag value.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The message body, in text format, to use in email messages that are based on the message template. We recommend
     * using text format for email clients that don't support HTML and clients that are connected to high-latency
     * networks, such as mobile devices.
     * </p>
     * 
     * @return The message body, in text format, to use in email messages that are based on the message template. We
     *         recommend using text format for email clients that don't support HTML and clients that are connected to
     *         high-latency networks, such as mobile devices.
     */
    public String textPart() {
        return textPart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(htmlPart());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(textPart());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailTemplateRequest)) {
            return false;
        }
        EmailTemplateRequest other = (EmailTemplateRequest) obj;
        return Objects.equals(htmlPart(), other.htmlPart()) && Objects.equals(subject(), other.subject())
                && Objects.equals(tags(), other.tags()) && Objects.equals(textPart(), other.textPart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EmailTemplateRequest").add("HtmlPart", htmlPart()).add("Subject", subject()).add("Tags", tags())
                .add("TextPart", textPart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HtmlPart":
            return Optional.ofNullable(clazz.cast(htmlPart()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TextPart":
            return Optional.ofNullable(clazz.cast(textPart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailTemplateRequest, T> g) {
        return obj -> g.apply((EmailTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailTemplateRequest> {
        /**
         * <p>
         * The message body, in HTML format, to use in email messages that are based on the message template. We
         * recommend using HTML format for email clients that support HTML. You can include links, formatted text, and
         * more in an HTML message.
         * </p>
         * 
         * @param htmlPart
         *        The message body, in HTML format, to use in email messages that are based on the message template. We
         *        recommend using HTML format for email clients that support HTML. You can include links, formatted
         *        text, and more in an HTML message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlPart(String htmlPart);

        /**
         * <p>
         * The subject line, or title, to use in email messages that are based on the message template.
         * </p>
         * 
         * @param subject
         *        The subject line, or title, to use in email messages that are based on the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each
         * tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        A string-to-string map of key-value pairs that defines the tags to associate with the message
         *        template. Each tag consists of a required tag key and an associated tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The message body, in text format, to use in email messages that are based on the message template. We
         * recommend using text format for email clients that don't support HTML and clients that are connected to
         * high-latency networks, such as mobile devices.
         * </p>
         * 
         * @param textPart
         *        The message body, in text format, to use in email messages that are based on the message template. We
         *        recommend using text format for email clients that don't support HTML and clients that are connected
         *        to high-latency networks, such as mobile devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textPart(String textPart);
    }

    static final class BuilderImpl implements Builder {
        private String htmlPart;

        private String subject;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String textPart;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailTemplateRequest model) {
            htmlPart(model.htmlPart);
            subject(model.subject);
            tags(model.tags);
            textPart(model.textPart);
        }

        public final String getHtmlPart() {
            return htmlPart;
        }

        @Override
        public final Builder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final void setHtmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final String getTextPart() {
            return textPart;
        }

        @Override
        public final Builder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        public final void setTextPart(String textPart) {
            this.textPart = textPart;
        }

        @Override
        public EmailTemplateRequest build() {
            return new EmailTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
