/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the dimensions for an event filter that determines when a campaign is sent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventDimensions implements SdkPojo, Serializable, ToCopyableBuilder<EventDimensions.Builder, EventDimensions> {
    private static final SdkField<Map<String, AttributeDimension>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, AttributeDimension>> builder(MarshallingType.MAP)
            .getter(getter(EventDimensions::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<SetDimension> EVENT_TYPE_FIELD = SdkField.<SetDimension> builder(MarshallingType.SDK_POJO)
            .getter(getter(EventDimensions::eventType)).setter(setter(Builder::eventType)).constructor(SetDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()).build();

    private static final SdkField<Map<String, MetricDimension>> METRICS_FIELD = SdkField
            .<Map<String, MetricDimension>> builder(MarshallingType.MAP)
            .getter(getter(EventDimensions::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MetricDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            EVENT_TYPE_FIELD, METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, AttributeDimension> attributes;

    private final SetDimension eventType;

    private final Map<String, MetricDimension> metrics;

    private EventDimensions(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.eventType = builder.eventType;
        this.metrics = builder.metrics;
    }

    /**
     * <p>
     * One or more custom attributes that your app reports to Amazon Pinpoint. You can use these attributes as selection
     * criteria when you create an event filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more custom attributes that your app reports to Amazon Pinpoint. You can use these attributes as
     *         selection criteria when you create an event filter.
     */
    public Map<String, AttributeDimension> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The name of the event that causes the campaign to be sent. This can be a standard type of event that Amazon
     * Pinpoint generates, such as _session.start, or a custom event that's specific to your app.
     * </p>
     * 
     * @return The name of the event that causes the campaign to be sent. This can be a standard type of event that
     *         Amazon Pinpoint generates, such as _session.start, or a custom event that's specific to your app.
     */
    public SetDimension eventType() {
        return eventType;
    }

    /**
     * <p>
     * One or more custom metrics that your app reports to Amazon Pinpoint. You can use these metrics as selection
     * criteria when you create an event filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more custom metrics that your app reports to Amazon Pinpoint. You can use these metrics as
     *         selection criteria when you create an event filter.
     */
    public Map<String, MetricDimension> metrics() {
        return metrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDimensions)) {
            return false;
        }
        EventDimensions other = (EventDimensions) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(eventType(), other.eventType())
                && Objects.equals(metrics(), other.metrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventDimensions").add("Attributes", attributes()).add("EventType", eventType())
                .add("Metrics", metrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventDimensions, T> g) {
        return obj -> g.apply((EventDimensions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventDimensions> {
        /**
         * <p>
         * One or more custom attributes that your app reports to Amazon Pinpoint. You can use these attributes as
         * selection criteria when you create an event filter.
         * </p>
         * 
         * @param attributes
         *        One or more custom attributes that your app reports to Amazon Pinpoint. You can use these attributes
         *        as selection criteria when you create an event filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, AttributeDimension> attributes);

        /**
         * <p>
         * The name of the event that causes the campaign to be sent. This can be a standard type of event that Amazon
         * Pinpoint generates, such as _session.start, or a custom event that's specific to your app.
         * </p>
         * 
         * @param eventType
         *        The name of the event that causes the campaign to be sent. This can be a standard type of event that
         *        Amazon Pinpoint generates, such as _session.start, or a custom event that's specific to your app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(SetDimension eventType);

        /**
         * <p>
         * The name of the event that causes the campaign to be sent. This can be a standard type of event that Amazon
         * Pinpoint generates, such as _session.start, or a custom event that's specific to your app.
         * </p>
         * This is a convenience that creates an instance of the {@link SetDimension.Builder} avoiding the need to
         * create one manually via {@link SetDimension#builder()}.
         *
         * When the {@link Consumer} completes, {@link SetDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #eventType(SetDimension)}.
         * 
         * @param eventType
         *        a consumer that will call methods on {@link SetDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventType(SetDimension)
         */
        default Builder eventType(Consumer<SetDimension.Builder> eventType) {
            return eventType(SetDimension.builder().applyMutation(eventType).build());
        }

        /**
         * <p>
         * One or more custom metrics that your app reports to Amazon Pinpoint. You can use these metrics as selection
         * criteria when you create an event filter.
         * </p>
         * 
         * @param metrics
         *        One or more custom metrics that your app reports to Amazon Pinpoint. You can use these metrics as
         *        selection criteria when you create an event filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Map<String, MetricDimension> metrics);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AttributeDimension> attributes = DefaultSdkAutoConstructMap.getInstance();

        private SetDimension eventType;

        private Map<String, MetricDimension> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventDimensions model) {
            attributes(model.attributes);
            eventType(model.eventType);
            metrics(model.metrics);
        }

        public final Map<String, AttributeDimension.Builder> getAttributes() {
            return attributes != null ? CollectionUtils.mapValues(attributes, AttributeDimension::toBuilder) : null;
        }

        @Override
        public final Builder attributes(Map<String, AttributeDimension> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, AttributeDimension.BuilderImpl> attributes) {
            this.attributes = MapOfAttributeDimensionCopier.copyFromBuilder(attributes);
        }

        public final SetDimension.Builder getEventType() {
            return eventType != null ? eventType.toBuilder() : null;
        }

        @Override
        public final Builder eventType(SetDimension eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(SetDimension.BuilderImpl eventType) {
            this.eventType = eventType != null ? eventType.build() : null;
        }

        public final Map<String, MetricDimension.Builder> getMetrics() {
            return metrics != null ? CollectionUtils.mapValues(metrics, MetricDimension::toBuilder) : null;
        }

        @Override
        public final Builder metrics(Map<String, MetricDimension> metrics) {
            this.metrics = MapOfMetricDimensionCopier.copy(metrics);
            return this;
        }

        public final void setMetrics(Map<String, MetricDimension.BuilderImpl> metrics) {
            this.metrics = MapOfMetricDimensionCopier.copyFromBuilder(metrics);
        }

        @Override
        public EventDimensions build() {
            return new EventDimensions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
