/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailTemplateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailTemplateRequest> {
    private static final SdkField<String> HTML_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EmailTemplateRequest.getter(EmailTemplateRequest::htmlPart)).setter(EmailTemplateRequest.setter(Builder::htmlPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlPart").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EmailTemplateRequest.getter(EmailTemplateRequest::subject)).setter(EmailTemplateRequest.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(EmailTemplateRequest.getter(EmailTemplateRequest::tags)).setter(EmailTemplateRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_PART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EmailTemplateRequest.getter(EmailTemplateRequest::textPart)).setter(EmailTemplateRequest.setter(Builder::textPart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextPart").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTML_PART_FIELD, SUBJECT_FIELD, TAGS_FIELD, TEXT_PART_FIELD));
    private static final long serialVersionUID = 1L;
    private final String htmlPart;
    private final String subject;
    private final Map<String, String> tags;
    private final String textPart;

    private EmailTemplateRequest(BuilderImpl builder) {
        this.htmlPart = builder.htmlPart;
        this.subject = builder.subject;
        this.tags = builder.tags;
        this.textPart = builder.textPart;
    }

    public String htmlPart() {
        return this.htmlPart;
    }

    public String subject() {
        return this.subject;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String textPart() {
        return this.textPart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.htmlPart());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.textPart());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailTemplateRequest)) {
            return false;
        }
        EmailTemplateRequest other = (EmailTemplateRequest)obj;
        return Objects.equals(this.htmlPart(), other.htmlPart()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.textPart(), other.textPart());
    }

    public String toString() {
        return ToString.builder((String)"EmailTemplateRequest").add("HtmlPart", (Object)this.htmlPart()).add("Subject", (Object)this.subject()).add("Tags", this.tags()).add("TextPart", (Object)this.textPart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HtmlPart": {
                return Optional.ofNullable(clazz.cast(this.htmlPart()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TextPart": {
                return Optional.ofNullable(clazz.cast(this.textPart()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailTemplateRequest, T> g) {
        return obj -> g.apply((EmailTemplateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String htmlPart;
        private String subject;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String textPart;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailTemplateRequest model) {
            this.htmlPart(model.htmlPart);
            this.subject(model.subject);
            this.tags(model.tags);
            this.textPart(model.textPart);
        }

        public final String getHtmlPart() {
            return this.htmlPart;
        }

        @Override
        public final Builder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final void setHtmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        public final String getTextPart() {
            return this.textPart;
        }

        @Override
        public final Builder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        public final void setTextPart(String textPart) {
            this.textPart = textPart;
        }

        public EmailTemplateRequest build() {
            return new EmailTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailTemplateRequest> {
        public Builder htmlPart(String var1);

        public Builder subject(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder textPart(String var1);
    }
}

