/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDedicatedIpWarmupAttributesRequest
extends PinpointEmailRequest
implements ToCopyableBuilder<Builder, PutDedicatedIpWarmupAttributesRequest> {
    private static final SdkField<String> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutDedicatedIpWarmupAttributesRequest.getter(PutDedicatedIpWarmupAttributesRequest::ip)).setter(PutDedicatedIpWarmupAttributesRequest.setter(Builder::ip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IP").build()}).build();
    private static final SdkField<Integer> WARMUP_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PutDedicatedIpWarmupAttributesRequest.getter(PutDedicatedIpWarmupAttributesRequest::warmupPercentage)).setter(PutDedicatedIpWarmupAttributesRequest.setter(Builder::warmupPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmupPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, WARMUP_PERCENTAGE_FIELD));
    private final String ip;
    private final Integer warmupPercentage;

    private PutDedicatedIpWarmupAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.ip = builder.ip;
        this.warmupPercentage = builder.warmupPercentage;
    }

    public String ip() {
        return this.ip;
    }

    public Integer warmupPercentage() {
        return this.warmupPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmupPercentage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDedicatedIpWarmupAttributesRequest)) {
            return false;
        }
        PutDedicatedIpWarmupAttributesRequest other = (PutDedicatedIpWarmupAttributesRequest)((Object)obj);
        return Objects.equals(this.ip(), other.ip()) && Objects.equals(this.warmupPercentage(), other.warmupPercentage());
    }

    public String toString() {
        return ToString.builder((String)"PutDedicatedIpWarmupAttributesRequest").add("Ip", (Object)this.ip()).add("WarmupPercentage", (Object)this.warmupPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "WarmupPercentage": {
                return Optional.ofNullable(clazz.cast(this.warmupPercentage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDedicatedIpWarmupAttributesRequest, T> g) {
        return obj -> g.apply((PutDedicatedIpWarmupAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailRequest.BuilderImpl
    implements Builder {
        private String ip;
        private Integer warmupPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDedicatedIpWarmupAttributesRequest model) {
            super(model);
            this.ip(model.ip);
            this.warmupPercentage(model.warmupPercentage);
        }

        public final String getIp() {
            return this.ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        public final Integer getWarmupPercentage() {
            return this.warmupPercentage;
        }

        @Override
        public final Builder warmupPercentage(Integer warmupPercentage) {
            this.warmupPercentage = warmupPercentage;
            return this;
        }

        public final void setWarmupPercentage(Integer warmupPercentage) {
            this.warmupPercentage = warmupPercentage;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDedicatedIpWarmupAttributesRequest build() {
            return new PutDedicatedIpWarmupAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDedicatedIpWarmupAttributesRequest> {
        public Builder ip(String var1);

        public Builder warmupPercentage(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

