/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about the volume of email sent on each day of the analysis period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DailyVolume implements SdkPojo, Serializable, ToCopyableBuilder<DailyVolume.Builder, DailyVolume> {
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DailyVolume::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<VolumeStatistics> VOLUME_STATISTICS_FIELD = SdkField
            .<VolumeStatistics> builder(MarshallingType.SDK_POJO).getter(getter(DailyVolume::volumeStatistics))
            .setter(setter(Builder::volumeStatistics)).constructor(VolumeStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeStatistics").build()).build();

    private static final SdkField<List<DomainIspPlacement>> DOMAIN_ISP_PLACEMENTS_FIELD = SdkField
            .<List<DomainIspPlacement>> builder(MarshallingType.LIST)
            .getter(getter(DailyVolume::domainIspPlacements))
            .setter(setter(Builder::domainIspPlacements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIspPlacements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainIspPlacement> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainIspPlacement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_FIELD,
            VOLUME_STATISTICS_FIELD, DOMAIN_ISP_PLACEMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant startDate;

    private final VolumeStatistics volumeStatistics;

    private final List<DomainIspPlacement> domainIspPlacements;

    private DailyVolume(BuilderImpl builder) {
        this.startDate = builder.startDate;
        this.volumeStatistics = builder.volumeStatistics;
        this.domainIspPlacements = builder.domainIspPlacements;
    }

    /**
     * <p>
     * The date that the DailyVolume metrics apply to, in Unix time.
     * </p>
     * 
     * @return The date that the DailyVolume metrics apply to, in Unix time.
     */
    public Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * An object that contains inbox placement metrics for a specific day in the analysis period.
     * </p>
     * 
     * @return An object that contains inbox placement metrics for a specific day in the analysis period.
     */
    public VolumeStatistics volumeStatistics() {
        return volumeStatistics;
    }

    /**
     * <p>
     * An object that contains inbox placement metrics for a specified day in the analysis period, broken out by the
     * recipient's email provider.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object that contains inbox placement metrics for a specified day in the analysis period, broken out by
     *         the recipient's email provider.
     */
    public List<DomainIspPlacement> domainIspPlacements() {
        return domainIspPlacements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(volumeStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(domainIspPlacements());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DailyVolume)) {
            return false;
        }
        DailyVolume other = (DailyVolume) obj;
        return Objects.equals(startDate(), other.startDate()) && Objects.equals(volumeStatistics(), other.volumeStatistics())
                && Objects.equals(domainIspPlacements(), other.domainIspPlacements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DailyVolume").add("StartDate", startDate()).add("VolumeStatistics", volumeStatistics())
                .add("DomainIspPlacements", domainIspPlacements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "VolumeStatistics":
            return Optional.ofNullable(clazz.cast(volumeStatistics()));
        case "DomainIspPlacements":
            return Optional.ofNullable(clazz.cast(domainIspPlacements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DailyVolume, T> g) {
        return obj -> g.apply((DailyVolume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DailyVolume> {
        /**
         * <p>
         * The date that the DailyVolume metrics apply to, in Unix time.
         * </p>
         * 
         * @param startDate
         *        The date that the DailyVolume metrics apply to, in Unix time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * An object that contains inbox placement metrics for a specific day in the analysis period.
         * </p>
         * 
         * @param volumeStatistics
         *        An object that contains inbox placement metrics for a specific day in the analysis period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatistics(VolumeStatistics volumeStatistics);

        /**
         * <p>
         * An object that contains inbox placement metrics for a specific day in the analysis period.
         * </p>
         * This is a convenience that creates an instance of the {@link VolumeStatistics.Builder} avoiding the need to
         * create one manually via {@link VolumeStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #volumeStatistics(VolumeStatistics)}.
         * 
         * @param volumeStatistics
         *        a consumer that will call methods on {@link VolumeStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeStatistics(VolumeStatistics)
         */
        default Builder volumeStatistics(Consumer<VolumeStatistics.Builder> volumeStatistics) {
            return volumeStatistics(VolumeStatistics.builder().applyMutation(volumeStatistics).build());
        }

        /**
         * <p>
         * An object that contains inbox placement metrics for a specified day in the analysis period, broken out by the
         * recipient's email provider.
         * </p>
         * 
         * @param domainIspPlacements
         *        An object that contains inbox placement metrics for a specified day in the analysis period, broken out
         *        by the recipient's email provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIspPlacements(Collection<DomainIspPlacement> domainIspPlacements);

        /**
         * <p>
         * An object that contains inbox placement metrics for a specified day in the analysis period, broken out by the
         * recipient's email provider.
         * </p>
         * 
         * @param domainIspPlacements
         *        An object that contains inbox placement metrics for a specified day in the analysis period, broken out
         *        by the recipient's email provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIspPlacements(DomainIspPlacement... domainIspPlacements);

        /**
         * <p>
         * An object that contains inbox placement metrics for a specified day in the analysis period, broken out by the
         * recipient's email provider.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainIspPlacement>.Builder} avoiding the
         * need to create one manually via {@link List<DomainIspPlacement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainIspPlacement>.Builder#build()} is called immediately
         * and its result is passed to {@link #domainIspPlacements(List<DomainIspPlacement>)}.
         * 
         * @param domainIspPlacements
         *        a consumer that will call methods on {@link List<DomainIspPlacement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainIspPlacements(List<DomainIspPlacement>)
         */
        Builder domainIspPlacements(Consumer<DomainIspPlacement.Builder>... domainIspPlacements);
    }

    static final class BuilderImpl implements Builder {
        private Instant startDate;

        private VolumeStatistics volumeStatistics;

        private List<DomainIspPlacement> domainIspPlacements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DailyVolume model) {
            startDate(model.startDate);
            volumeStatistics(model.volumeStatistics);
            domainIspPlacements(model.domainIspPlacements);
        }

        public final Instant getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final VolumeStatistics.Builder getVolumeStatistics() {
            return volumeStatistics != null ? volumeStatistics.toBuilder() : null;
        }

        @Override
        public final Builder volumeStatistics(VolumeStatistics volumeStatistics) {
            this.volumeStatistics = volumeStatistics;
            return this;
        }

        public final void setVolumeStatistics(VolumeStatistics.BuilderImpl volumeStatistics) {
            this.volumeStatistics = volumeStatistics != null ? volumeStatistics.build() : null;
        }

        public final Collection<DomainIspPlacement.Builder> getDomainIspPlacements() {
            return domainIspPlacements != null ? domainIspPlacements.stream().map(DomainIspPlacement::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainIspPlacements(Collection<DomainIspPlacement> domainIspPlacements) {
            this.domainIspPlacements = DomainIspPlacementsCopier.copy(domainIspPlacements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainIspPlacements(DomainIspPlacement... domainIspPlacements) {
            domainIspPlacements(Arrays.asList(domainIspPlacements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainIspPlacements(Consumer<DomainIspPlacement.Builder>... domainIspPlacements) {
            domainIspPlacements(Stream.of(domainIspPlacements).map(c -> DomainIspPlacement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDomainIspPlacements(Collection<DomainIspPlacement.BuilderImpl> domainIspPlacements) {
            this.domainIspPlacements = DomainIspPlacementsCopier.copyFromBuilder(domainIspPlacements);
        }

        @Override
        public DailyVolume build() {
            return new DailyVolume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
