/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEmailIdentitiesRequest
extends PinpointEmailRequest
implements ToCopyableBuilder<Builder, ListEmailIdentitiesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListEmailIdentitiesRequest.getter(ListEmailIdentitiesRequest::nextToken)).setter(ListEmailIdentitiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListEmailIdentitiesRequest.getter(ListEmailIdentitiesRequest::pageSize)).setter(ListEmailIdentitiesRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD));
    private final String nextToken;
    private final Integer pageSize;

    private ListEmailIdentitiesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEmailIdentitiesRequest)) {
            return false;
        }
        ListEmailIdentitiesRequest other = (ListEmailIdentitiesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public String toString() {
        return ToString.builder((String)"ListEmailIdentitiesRequest").add("NextToken", (Object)this.nextToken()).add("PageSize", (Object)this.pageSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEmailIdentitiesRequest, T> g) {
        return obj -> g.apply((ListEmailIdentitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEmailIdentitiesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.pageSize(model.pageSize);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEmailIdentitiesRequest build() {
            return new ListEmailIdentitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointEmailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEmailIdentitiesRequest> {
        public Builder nextToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

