/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to enable or disable the automatic IP address warm-up feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountDedicatedIpWarmupAttributesRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<PutAccountDedicatedIpWarmupAttributesRequest.Builder, PutAccountDedicatedIpWarmupAttributesRequest> {
    private static final SdkField<Boolean> AUTO_WARMUP_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutAccountDedicatedIpWarmupAttributesRequest::autoWarmupEnabled))
            .setter(setter(Builder::autoWarmupEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoWarmupEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_WARMUP_ENABLED_FIELD));

    private final Boolean autoWarmupEnabled;

    private PutAccountDedicatedIpWarmupAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.autoWarmupEnabled = builder.autoWarmupEnabled;
    }

    /**
     * <p>
     * Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your Amazon
     * Pinpoint account in the current AWS Region. Set to <code>true</code> to enable the automatic warm-up feature, or
     * set to <code>false</code> to disable it.
     * </p>
     * 
     * @return Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with
     *         your Amazon Pinpoint account in the current AWS Region. Set to <code>true</code> to enable the automatic
     *         warm-up feature, or set to <code>false</code> to disable it.
     */
    public Boolean autoWarmupEnabled() {
        return autoWarmupEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoWarmupEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountDedicatedIpWarmupAttributesRequest)) {
            return false;
        }
        PutAccountDedicatedIpWarmupAttributesRequest other = (PutAccountDedicatedIpWarmupAttributesRequest) obj;
        return Objects.equals(autoWarmupEnabled(), other.autoWarmupEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutAccountDedicatedIpWarmupAttributesRequest").add("AutoWarmupEnabled", autoWarmupEnabled())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoWarmupEnabled":
            return Optional.ofNullable(clazz.cast(autoWarmupEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountDedicatedIpWarmupAttributesRequest, T> g) {
        return obj -> g.apply((PutAccountDedicatedIpWarmupAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutAccountDedicatedIpWarmupAttributesRequest> {
        /**
         * <p>
         * Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with your
         * Amazon Pinpoint account in the current AWS Region. Set to <code>true</code> to enable the automatic warm-up
         * feature, or set to <code>false</code> to disable it.
         * </p>
         * 
         * @param autoWarmupEnabled
         *        Enables or disables the automatic warm-up feature for dedicated IP addresses that are associated with
         *        your Amazon Pinpoint account in the current AWS Region. Set to <code>true</code> to enable the
         *        automatic warm-up feature, or set to <code>false</code> to disable it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoWarmupEnabled(Boolean autoWarmupEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private Boolean autoWarmupEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountDedicatedIpWarmupAttributesRequest model) {
            super(model);
            autoWarmupEnabled(model.autoWarmupEnabled);
        }

        public final Boolean getAutoWarmupEnabled() {
            return autoWarmupEnabled;
        }

        @Override
        public final Builder autoWarmupEnabled(Boolean autoWarmupEnabled) {
            this.autoWarmupEnabled = autoWarmupEnabled;
            return this;
        }

        public final void setAutoWarmupEnabled(Boolean autoWarmupEnabled) {
            this.autoWarmupEnabled = autoWarmupEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountDedicatedIpWarmupAttributesRequest build() {
            return new PutAccountDedicatedIpWarmupAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
