/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the deliverability data for a specific campaign. This data is available for a campaign only
 * if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (
 * <code>PutDeliverabilityDashboardOption</code> operation).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainDeliverabilityCampaign implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainDeliverabilityCampaign.Builder, DomainDeliverabilityCampaign> {
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CampaignId").getter(getter(DomainDeliverabilityCampaign::campaignId))
            .setter(setter(Builder::campaignId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignId").build()).build();

    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageUrl").getter(getter(DomainDeliverabilityCampaign::imageUrl)).setter(setter(Builder::imageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(DomainDeliverabilityCampaign::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromAddress").getter(getter(DomainDeliverabilityCampaign::fromAddress))
            .setter(setter(Builder::fromAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()).build();

    private static final SdkField<List<String>> SENDING_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SendingIps")
            .getter(getter(DomainDeliverabilityCampaign::sendingIps))
            .setter(setter(Builder::sendingIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> FIRST_SEEN_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FirstSeenDateTime").getter(getter(DomainDeliverabilityCampaign::firstSeenDateTime))
            .setter(setter(Builder::firstSeenDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSeenDateTime").build()).build();

    private static final SdkField<Instant> LAST_SEEN_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSeenDateTime").getter(getter(DomainDeliverabilityCampaign::lastSeenDateTime))
            .setter(setter(Builder::lastSeenDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSeenDateTime").build()).build();

    private static final SdkField<Long> INBOX_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("InboxCount").getter(getter(DomainDeliverabilityCampaign::inboxCount))
            .setter(setter(Builder::inboxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboxCount").build()).build();

    private static final SdkField<Long> SPAM_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("SpamCount")
            .getter(getter(DomainDeliverabilityCampaign::spamCount)).setter(setter(Builder::spamCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpamCount").build()).build();

    private static final SdkField<Double> READ_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ReadRate").getter(getter(DomainDeliverabilityCampaign::readRate)).setter(setter(Builder::readRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadRate").build()).build();

    private static final SdkField<Double> DELETE_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DeleteRate").getter(getter(DomainDeliverabilityCampaign::deleteRate))
            .setter(setter(Builder::deleteRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteRate").build()).build();

    private static final SdkField<Double> READ_DELETE_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ReadDeleteRate").getter(getter(DomainDeliverabilityCampaign::readDeleteRate))
            .setter(setter(Builder::readDeleteRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadDeleteRate").build()).build();

    private static final SdkField<Long> PROJECTED_VOLUME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ProjectedVolume").getter(getter(DomainDeliverabilityCampaign::projectedVolume))
            .setter(setter(Builder::projectedVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectedVolume").build()).build();

    private static final SdkField<List<String>> ESPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Esps")
            .getter(getter(DomainDeliverabilityCampaign::esps))
            .setter(setter(Builder::esps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Esps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ID_FIELD,
            IMAGE_URL_FIELD, SUBJECT_FIELD, FROM_ADDRESS_FIELD, SENDING_IPS_FIELD, FIRST_SEEN_DATE_TIME_FIELD,
            LAST_SEEN_DATE_TIME_FIELD, INBOX_COUNT_FIELD, SPAM_COUNT_FIELD, READ_RATE_FIELD, DELETE_RATE_FIELD,
            READ_DELETE_RATE_FIELD, PROJECTED_VOLUME_FIELD, ESPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String campaignId;

    private final String imageUrl;

    private final String subject;

    private final String fromAddress;

    private final List<String> sendingIps;

    private final Instant firstSeenDateTime;

    private final Instant lastSeenDateTime;

    private final Long inboxCount;

    private final Long spamCount;

    private final Double readRate;

    private final Double deleteRate;

    private final Double readDeleteRate;

    private final Long projectedVolume;

    private final List<String> esps;

    private DomainDeliverabilityCampaign(BuilderImpl builder) {
        this.campaignId = builder.campaignId;
        this.imageUrl = builder.imageUrl;
        this.subject = builder.subject;
        this.fromAddress = builder.fromAddress;
        this.sendingIps = builder.sendingIps;
        this.firstSeenDateTime = builder.firstSeenDateTime;
        this.lastSeenDateTime = builder.lastSeenDateTime;
        this.inboxCount = builder.inboxCount;
        this.spamCount = builder.spamCount;
        this.readRate = builder.readRate;
        this.deleteRate = builder.deleteRate;
        this.readDeleteRate = builder.readDeleteRate;
        this.projectedVolume = builder.projectedVolume;
        this.esps = builder.esps;
    }

    /**
     * <p>
     * The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this identifier to a
     * campaign. This value is not the same as the campaign identifier that Amazon Pinpoint assigns to campaigns that
     * you create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this
     *         identifier to a campaign. This value is not the same as the campaign identifier that Amazon Pinpoint
     *         assigns to campaigns that you create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint
     *         console.
     */
    public String campaignId() {
        return campaignId;
    }

    /**
     * <p>
     * The URL of an image that contains a snapshot of the email message that was sent.
     * </p>
     * 
     * @return The URL of an image that contains a snapshot of the email message that was sent.
     */
    public String imageUrl() {
        return imageUrl;
    }

    /**
     * <p>
     * The subject line, or title, of the email message.
     * </p>
     * 
     * @return The subject line, or title, of the email message.
     */
    public String subject() {
        return subject;
    }

    /**
     * <p>
     * The verified email address that the email message was sent from.
     * </p>
     * 
     * @return The verified email address that the email message was sent from.
     */
    public String fromAddress() {
        return fromAddress;
    }

    /**
     * Returns true if the SendingIps property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSendingIps() {
        return sendingIps != null && !(sendingIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses that were used to send the email message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSendingIps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IP addresses that were used to send the email message.
     */
    public List<String> sendingIps() {
        return sendingIps;
    }

    /**
     * <p>
     * The first time, in Unix time format, when the email message was delivered to any recipient's inbox. This value
     * can help you determine how long it took for a campaign to deliver an email message.
     * </p>
     * 
     * @return The first time, in Unix time format, when the email message was delivered to any recipient's inbox. This
     *         value can help you determine how long it took for a campaign to deliver an email message.
     */
    public Instant firstSeenDateTime() {
        return firstSeenDateTime;
    }

    /**
     * <p>
     * The last time, in Unix time format, when the email message was delivered to any recipient's inbox. This value can
     * help you determine how long it took for a campaign to deliver an email message.
     * </p>
     * 
     * @return The last time, in Unix time format, when the email message was delivered to any recipient's inbox. This
     *         value can help you determine how long it took for a campaign to deliver an email message.
     */
    public Instant lastSeenDateTime() {
        return lastSeenDateTime;
    }

    /**
     * <p>
     * The number of email messages that were delivered to recipients’ inboxes.
     * </p>
     * 
     * @return The number of email messages that were delivered to recipients’ inboxes.
     */
    public Long inboxCount() {
        return inboxCount;
    }

    /**
     * <p>
     * The number of email messages that were delivered to recipients' spam or junk mail folders.
     * </p>
     * 
     * @return The number of email messages that were delivered to recipients' spam or junk mail folders.
     */
    public Long spamCount() {
        return spamCount;
    }

    /**
     * <p>
     * The percentage of email messages that were opened by recipients. Due to technical limitations, this value only
     * includes recipients who opened the message by using an email client that supports images.
     * </p>
     * 
     * @return The percentage of email messages that were opened by recipients. Due to technical limitations, this value
     *         only includes recipients who opened the message by using an email client that supports images.
     */
    public Double readRate() {
        return readRate;
    }

    /**
     * <p>
     * The percentage of email messages that were deleted by recipients, without being opened first. Due to technical
     * limitations, this value only includes recipients who opened the message by using an email client that supports
     * images.
     * </p>
     * 
     * @return The percentage of email messages that were deleted by recipients, without being opened first. Due to
     *         technical limitations, this value only includes recipients who opened the message by using an email
     *         client that supports images.
     */
    public Double deleteRate() {
        return deleteRate;
    }

    /**
     * <p>
     * The percentage of email messages that were opened and then deleted by recipients. Due to technical limitations,
     * this value only includes recipients who opened the message by using an email client that supports images.
     * </p>
     * 
     * @return The percentage of email messages that were opened and then deleted by recipients. Due to technical
     *         limitations, this value only includes recipients who opened the message by using an email client that
     *         supports images.
     */
    public Double readDeleteRate() {
        return readDeleteRate;
    }

    /**
     * <p>
     * The projected number of recipients that the email message was sent to.
     * </p>
     * 
     * @return The projected number of recipients that the email message was sent to.
     */
    public Long projectedVolume() {
        return projectedVolume;
    }

    /**
     * Returns true if the Esps property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEsps() {
        return esps != null && !(esps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The major email providers who handled the email message.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEsps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The major email providers who handled the email message.
     */
    public List<String> esps() {
        return esps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasSendingIps() ? sendingIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(firstSeenDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastSeenDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(inboxCount());
        hashCode = 31 * hashCode + Objects.hashCode(spamCount());
        hashCode = 31 * hashCode + Objects.hashCode(readRate());
        hashCode = 31 * hashCode + Objects.hashCode(deleteRate());
        hashCode = 31 * hashCode + Objects.hashCode(readDeleteRate());
        hashCode = 31 * hashCode + Objects.hashCode(projectedVolume());
        hashCode = 31 * hashCode + Objects.hashCode(hasEsps() ? esps() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDeliverabilityCampaign)) {
            return false;
        }
        DomainDeliverabilityCampaign other = (DomainDeliverabilityCampaign) obj;
        return Objects.equals(campaignId(), other.campaignId()) && Objects.equals(imageUrl(), other.imageUrl())
                && Objects.equals(subject(), other.subject()) && Objects.equals(fromAddress(), other.fromAddress())
                && hasSendingIps() == other.hasSendingIps() && Objects.equals(sendingIps(), other.sendingIps())
                && Objects.equals(firstSeenDateTime(), other.firstSeenDateTime())
                && Objects.equals(lastSeenDateTime(), other.lastSeenDateTime())
                && Objects.equals(inboxCount(), other.inboxCount()) && Objects.equals(spamCount(), other.spamCount())
                && Objects.equals(readRate(), other.readRate()) && Objects.equals(deleteRate(), other.deleteRate())
                && Objects.equals(readDeleteRate(), other.readDeleteRate())
                && Objects.equals(projectedVolume(), other.projectedVolume()) && hasEsps() == other.hasEsps()
                && Objects.equals(esps(), other.esps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DomainDeliverabilityCampaign").add("CampaignId", campaignId()).add("ImageUrl", imageUrl())
                .add("Subject", subject()).add("FromAddress", fromAddress())
                .add("SendingIps", hasSendingIps() ? sendingIps() : null).add("FirstSeenDateTime", firstSeenDateTime())
                .add("LastSeenDateTime", lastSeenDateTime()).add("InboxCount", inboxCount()).add("SpamCount", spamCount())
                .add("ReadRate", readRate()).add("DeleteRate", deleteRate()).add("ReadDeleteRate", readDeleteRate())
                .add("ProjectedVolume", projectedVolume()).add("Esps", hasEsps() ? esps() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignId":
            return Optional.ofNullable(clazz.cast(campaignId()));
        case "ImageUrl":
            return Optional.ofNullable(clazz.cast(imageUrl()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "FromAddress":
            return Optional.ofNullable(clazz.cast(fromAddress()));
        case "SendingIps":
            return Optional.ofNullable(clazz.cast(sendingIps()));
        case "FirstSeenDateTime":
            return Optional.ofNullable(clazz.cast(firstSeenDateTime()));
        case "LastSeenDateTime":
            return Optional.ofNullable(clazz.cast(lastSeenDateTime()));
        case "InboxCount":
            return Optional.ofNullable(clazz.cast(inboxCount()));
        case "SpamCount":
            return Optional.ofNullable(clazz.cast(spamCount()));
        case "ReadRate":
            return Optional.ofNullable(clazz.cast(readRate()));
        case "DeleteRate":
            return Optional.ofNullable(clazz.cast(deleteRate()));
        case "ReadDeleteRate":
            return Optional.ofNullable(clazz.cast(readDeleteRate()));
        case "ProjectedVolume":
            return Optional.ofNullable(clazz.cast(projectedVolume()));
        case "Esps":
            return Optional.ofNullable(clazz.cast(esps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainDeliverabilityCampaign, T> g) {
        return obj -> g.apply((DomainDeliverabilityCampaign) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainDeliverabilityCampaign> {
        /**
         * <p>
         * The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this identifier
         * to a campaign. This value is not the same as the campaign identifier that Amazon Pinpoint assigns to
         * campaigns that you create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint console.
         * </p>
         * 
         * @param campaignId
         *        The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this
         *        identifier to a campaign. This value is not the same as the campaign identifier that Amazon Pinpoint
         *        assigns to campaigns that you create and manage by using the Amazon Pinpoint API or the Amazon
         *        Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignId(String campaignId);

        /**
         * <p>
         * The URL of an image that contains a snapshot of the email message that was sent.
         * </p>
         * 
         * @param imageUrl
         *        The URL of an image that contains a snapshot of the email message that was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUrl(String imageUrl);

        /**
         * <p>
         * The subject line, or title, of the email message.
         * </p>
         * 
         * @param subject
         *        The subject line, or title, of the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The verified email address that the email message was sent from.
         * </p>
         * 
         * @param fromAddress
         *        The verified email address that the email message was sent from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAddress(String fromAddress);

        /**
         * <p>
         * The IP addresses that were used to send the email message.
         * </p>
         * 
         * @param sendingIps
         *        The IP addresses that were used to send the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingIps(Collection<String> sendingIps);

        /**
         * <p>
         * The IP addresses that were used to send the email message.
         * </p>
         * 
         * @param sendingIps
         *        The IP addresses that were used to send the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingIps(String... sendingIps);

        /**
         * <p>
         * The first time, in Unix time format, when the email message was delivered to any recipient's inbox. This
         * value can help you determine how long it took for a campaign to deliver an email message.
         * </p>
         * 
         * @param firstSeenDateTime
         *        The first time, in Unix time format, when the email message was delivered to any recipient's inbox.
         *        This value can help you determine how long it took for a campaign to deliver an email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSeenDateTime(Instant firstSeenDateTime);

        /**
         * <p>
         * The last time, in Unix time format, when the email message was delivered to any recipient's inbox. This value
         * can help you determine how long it took for a campaign to deliver an email message.
         * </p>
         * 
         * @param lastSeenDateTime
         *        The last time, in Unix time format, when the email message was delivered to any recipient's inbox.
         *        This value can help you determine how long it took for a campaign to deliver an email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeenDateTime(Instant lastSeenDateTime);

        /**
         * <p>
         * The number of email messages that were delivered to recipients’ inboxes.
         * </p>
         * 
         * @param inboxCount
         *        The number of email messages that were delivered to recipients’ inboxes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboxCount(Long inboxCount);

        /**
         * <p>
         * The number of email messages that were delivered to recipients' spam or junk mail folders.
         * </p>
         * 
         * @param spamCount
         *        The number of email messages that were delivered to recipients' spam or junk mail folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spamCount(Long spamCount);

        /**
         * <p>
         * The percentage of email messages that were opened by recipients. Due to technical limitations, this value
         * only includes recipients who opened the message by using an email client that supports images.
         * </p>
         * 
         * @param readRate
         *        The percentage of email messages that were opened by recipients. Due to technical limitations, this
         *        value only includes recipients who opened the message by using an email client that supports images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readRate(Double readRate);

        /**
         * <p>
         * The percentage of email messages that were deleted by recipients, without being opened first. Due to
         * technical limitations, this value only includes recipients who opened the message by using an email client
         * that supports images.
         * </p>
         * 
         * @param deleteRate
         *        The percentage of email messages that were deleted by recipients, without being opened first. Due to
         *        technical limitations, this value only includes recipients who opened the message by using an email
         *        client that supports images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteRate(Double deleteRate);

        /**
         * <p>
         * The percentage of email messages that were opened and then deleted by recipients. Due to technical
         * limitations, this value only includes recipients who opened the message by using an email client that
         * supports images.
         * </p>
         * 
         * @param readDeleteRate
         *        The percentage of email messages that were opened and then deleted by recipients. Due to technical
         *        limitations, this value only includes recipients who opened the message by using an email client that
         *        supports images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readDeleteRate(Double readDeleteRate);

        /**
         * <p>
         * The projected number of recipients that the email message was sent to.
         * </p>
         * 
         * @param projectedVolume
         *        The projected number of recipients that the email message was sent to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedVolume(Long projectedVolume);

        /**
         * <p>
         * The major email providers who handled the email message.
         * </p>
         * 
         * @param esps
         *        The major email providers who handled the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder esps(Collection<String> esps);

        /**
         * <p>
         * The major email providers who handled the email message.
         * </p>
         * 
         * @param esps
         *        The major email providers who handled the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder esps(String... esps);
    }

    static final class BuilderImpl implements Builder {
        private String campaignId;

        private String imageUrl;

        private String subject;

        private String fromAddress;

        private List<String> sendingIps = DefaultSdkAutoConstructList.getInstance();

        private Instant firstSeenDateTime;

        private Instant lastSeenDateTime;

        private Long inboxCount;

        private Long spamCount;

        private Double readRate;

        private Double deleteRate;

        private Double readDeleteRate;

        private Long projectedVolume;

        private List<String> esps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDeliverabilityCampaign model) {
            campaignId(model.campaignId);
            imageUrl(model.imageUrl);
            subject(model.subject);
            fromAddress(model.fromAddress);
            sendingIps(model.sendingIps);
            firstSeenDateTime(model.firstSeenDateTime);
            lastSeenDateTime(model.lastSeenDateTime);
            inboxCount(model.inboxCount);
            spamCount(model.spamCount);
            readRate(model.readRate);
            deleteRate(model.deleteRate);
            readDeleteRate(model.readDeleteRate);
            projectedVolume(model.projectedVolume);
            esps(model.esps);
        }

        public final String getCampaignId() {
            return campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        public final String getImageUrl() {
            return imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getFromAddress() {
            return fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        public final Collection<String> getSendingIps() {
            if (sendingIps instanceof SdkAutoConstructList) {
                return null;
            }
            return sendingIps;
        }

        @Override
        public final Builder sendingIps(Collection<String> sendingIps) {
            this.sendingIps = IpListCopier.copy(sendingIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendingIps(String... sendingIps) {
            sendingIps(Arrays.asList(sendingIps));
            return this;
        }

        public final void setSendingIps(Collection<String> sendingIps) {
            this.sendingIps = IpListCopier.copy(sendingIps);
        }

        public final Instant getFirstSeenDateTime() {
            return firstSeenDateTime;
        }

        @Override
        public final Builder firstSeenDateTime(Instant firstSeenDateTime) {
            this.firstSeenDateTime = firstSeenDateTime;
            return this;
        }

        public final void setFirstSeenDateTime(Instant firstSeenDateTime) {
            this.firstSeenDateTime = firstSeenDateTime;
        }

        public final Instant getLastSeenDateTime() {
            return lastSeenDateTime;
        }

        @Override
        public final Builder lastSeenDateTime(Instant lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
            return this;
        }

        public final void setLastSeenDateTime(Instant lastSeenDateTime) {
            this.lastSeenDateTime = lastSeenDateTime;
        }

        public final Long getInboxCount() {
            return inboxCount;
        }

        @Override
        public final Builder inboxCount(Long inboxCount) {
            this.inboxCount = inboxCount;
            return this;
        }

        public final void setInboxCount(Long inboxCount) {
            this.inboxCount = inboxCount;
        }

        public final Long getSpamCount() {
            return spamCount;
        }

        @Override
        public final Builder spamCount(Long spamCount) {
            this.spamCount = spamCount;
            return this;
        }

        public final void setSpamCount(Long spamCount) {
            this.spamCount = spamCount;
        }

        public final Double getReadRate() {
            return readRate;
        }

        @Override
        public final Builder readRate(Double readRate) {
            this.readRate = readRate;
            return this;
        }

        public final void setReadRate(Double readRate) {
            this.readRate = readRate;
        }

        public final Double getDeleteRate() {
            return deleteRate;
        }

        @Override
        public final Builder deleteRate(Double deleteRate) {
            this.deleteRate = deleteRate;
            return this;
        }

        public final void setDeleteRate(Double deleteRate) {
            this.deleteRate = deleteRate;
        }

        public final Double getReadDeleteRate() {
            return readDeleteRate;
        }

        @Override
        public final Builder readDeleteRate(Double readDeleteRate) {
            this.readDeleteRate = readDeleteRate;
            return this;
        }

        public final void setReadDeleteRate(Double readDeleteRate) {
            this.readDeleteRate = readDeleteRate;
        }

        public final Long getProjectedVolume() {
            return projectedVolume;
        }

        @Override
        public final Builder projectedVolume(Long projectedVolume) {
            this.projectedVolume = projectedVolume;
            return this;
        }

        public final void setProjectedVolume(Long projectedVolume) {
            this.projectedVolume = projectedVolume;
        }

        public final Collection<String> getEsps() {
            if (esps instanceof SdkAutoConstructList) {
                return null;
            }
            return esps;
        }

        @Override
        public final Builder esps(Collection<String> esps) {
            this.esps = EspsCopier.copy(esps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder esps(String... esps) {
            esps(Arrays.asList(esps));
            return this;
        }

        public final void setEsps(Collection<String> esps) {
            this.esps = EspsCopier.copy(esps);
        }

        @Override
        public DomainDeliverabilityCampaign build() {
            return new DomainDeliverabilityCampaign(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
