/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to return details about an email identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEmailIdentityRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<GetEmailIdentityRequest.Builder, GetEmailIdentityRequest> {
    private static final SdkField<String> EMAIL_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailIdentity").getter(getter(GetEmailIdentityRequest::emailIdentity))
            .setter(setter(Builder::emailIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailIdentity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITY_FIELD));

    private final String emailIdentity;

    private GetEmailIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.emailIdentity = builder.emailIdentity;
    }

    /**
     * <p>
     * The email identity that you want to retrieve details for.
     * </p>
     * 
     * @return The email identity that you want to retrieve details for.
     */
    public String emailIdentity() {
        return emailIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailIdentity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEmailIdentityRequest)) {
            return false;
        }
        GetEmailIdentityRequest other = (GetEmailIdentityRequest) obj;
        return Objects.equals(emailIdentity(), other.emailIdentity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetEmailIdentityRequest").add("EmailIdentity", emailIdentity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailIdentity":
            return Optional.ofNullable(clazz.cast(emailIdentity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEmailIdentityRequest, T> g) {
        return obj -> g.apply((GetEmailIdentityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetEmailIdentityRequest> {
        /**
         * <p>
         * The email identity that you want to retrieve details for.
         * </p>
         * 
         * @param emailIdentity
         *        The email identity that you want to retrieve details for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailIdentity(String emailIdentity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private String emailIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEmailIdentityRequest model) {
            super(model);
            emailIdentity(model.emailIdentity);
        }

        public final String getEmailIdentity() {
            return emailIdentity;
        }

        @Override
        public final Builder emailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        public final void setEmailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEmailIdentityRequest build() {
            return new GetEmailIdentityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
