/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time
 * range. This data is available for a domain only if you enabled the Deliverability dashboard (
 * <code>PutDeliverabilityDashboardOption</code> operation) for the domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainDeliverabilityCampaignsRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<ListDomainDeliverabilityCampaignsRequest.Builder, ListDomainDeliverabilityCampaignsRequest> {
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate").getter(getter(ListDomainDeliverabilityCampaignsRequest::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate").getter(getter(ListDomainDeliverabilityCampaignsRequest::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EndDate").build()).build();

    private static final SdkField<String> SUBSCRIBED_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscribedDomain").getter(getter(ListDomainDeliverabilityCampaignsRequest::subscribedDomain))
            .setter(setter(Builder::subscribedDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SubscribedDomain").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDomainDeliverabilityCampaignsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListDomainDeliverabilityCampaignsRequest::pageSize))
            .setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_DATE_FIELD,
            END_DATE_FIELD, SUBSCRIBED_DOMAIN_FIELD, NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD));

    private final Instant startDate;

    private final Instant endDate;

    private final String subscribedDomain;

    private final String nextToken;

    private final Integer pageSize;

    private ListDomainDeliverabilityCampaignsRequest(BuilderImpl builder) {
        super(builder);
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.subscribedDomain = builder.subscribedDomain;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * The first day, in Unix time format, that you want to obtain deliverability data for.
     * </p>
     * 
     * @return The first day, in Unix time format, that you want to obtain deliverability data for.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less
     * than or equal to 30 days after the value of the <code>StartDate</code> parameter.
     * </p>
     * 
     * @return The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be
     *         less than or equal to 30 days after the value of the <code>StartDate</code> parameter.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * The domain to obtain deliverability data for.
     * </p>
     * 
     * @return The domain to obtain deliverability data for.
     */
    public final String subscribedDomain() {
        return subscribedDomain;
    }

    /**
     * <p>
     * A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation.
     * This token indicates the position of a campaign in the list of campaigns.
     * </p>
     * 
     * @return A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code>
     *         operation. This token indicates the position of a campaign in the list of campaigns.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to include in response to a single call to the
     * <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number that
     * you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use to
     * obtain additional results.
     * </p>
     * 
     * @return The maximum number of results to include in response to a single call to the
     *         <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the
     *         number that you specify in this parameter, the response includes a <code>NextToken</code> element, which
     *         you can use to obtain additional results.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(subscribedDomain());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainDeliverabilityCampaignsRequest)) {
            return false;
        }
        ListDomainDeliverabilityCampaignsRequest other = (ListDomainDeliverabilityCampaignsRequest) obj;
        return Objects.equals(startDate(), other.startDate()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(subscribedDomain(), other.subscribedDomain()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDomainDeliverabilityCampaignsRequest").add("StartDate", startDate())
                .add("EndDate", endDate()).add("SubscribedDomain", subscribedDomain()).add("NextToken", nextToken())
                .add("PageSize", pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "SubscribedDomain":
            return Optional.ofNullable(clazz.cast(subscribedDomain()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainDeliverabilityCampaignsRequest, T> g) {
        return obj -> g.apply((ListDomainDeliverabilityCampaignsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDomainDeliverabilityCampaignsRequest> {
        /**
         * <p>
         * The first day, in Unix time format, that you want to obtain deliverability data for.
         * </p>
         * 
         * @param startDate
         *        The first day, in Unix time format, that you want to obtain deliverability data for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The last day, in Unix time format, that you want to obtain deliverability data for. This value has to be less
         * than or equal to 30 days after the value of the <code>StartDate</code> parameter.
         * </p>
         * 
         * @param endDate
         *        The last day, in Unix time format, that you want to obtain deliverability data for. This value has to
         *        be less than or equal to 30 days after the value of the <code>StartDate</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * The domain to obtain deliverability data for.
         * </p>
         * 
         * @param subscribedDomain
         *        The domain to obtain deliverability data for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedDomain(String subscribedDomain);

        /**
         * <p>
         * A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code> operation.
         * This token indicates the position of a campaign in the list of campaigns.
         * </p>
         * 
         * @param nextToken
         *        A token that’s returned from a previous call to the <code>ListDomainDeliverabilityCampaigns</code>
         *        operation. This token indicates the position of a campaign in the list of campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to include in response to a single call to the
         * <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the number
         * that you specify in this parameter, the response includes a <code>NextToken</code> element, which you can use
         * to obtain additional results.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of results to include in response to a single call to the
         *        <code>ListDomainDeliverabilityCampaigns</code> operation. If the number of results is larger than the
         *        number that you specify in this parameter, the response includes a <code>NextToken</code> element,
         *        which you can use to obtain additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private Instant startDate;

        private Instant endDate;

        private String subscribedDomain;

        private String nextToken;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainDeliverabilityCampaignsRequest model) {
            super(model);
            startDate(model.startDate);
            endDate(model.endDate);
            subscribedDomain(model.subscribedDomain);
            nextToken(model.nextToken);
            pageSize(model.pageSize);
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getSubscribedDomain() {
            return subscribedDomain;
        }

        public final void setSubscribedDomain(String subscribedDomain) {
            this.subscribedDomain = subscribedDomain;
        }

        @Override
        public final Builder subscribedDomain(String subscribedDomain) {
            this.subscribedDomain = subscribedDomain;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDomainDeliverabilityCampaignsRequest build() {
            return new ListDomainDeliverabilityCampaignsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
