/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to add an event destination to a configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationSetEventDestinationRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<CreateConfigurationSetEventDestinationRequest.Builder, CreateConfigurationSetEventDestinationRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName")
            .getter(getter(CreateConfigurationSetEventDestinationRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()).build();

    private static final SdkField<String> EVENT_DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDestinationName")
            .getter(getter(CreateConfigurationSetEventDestinationRequest::eventDestinationName))
            .setter(setter(Builder::eventDestinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestinationName").build())
            .build();

    private static final SdkField<EventDestinationDefinition> EVENT_DESTINATION_FIELD = SdkField
            .<EventDestinationDefinition> builder(MarshallingType.SDK_POJO).memberName("EventDestination")
            .getter(getter(CreateConfigurationSetEventDestinationRequest::eventDestination))
            .setter(setter(Builder::eventDestination)).constructor(EventDestinationDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            EVENT_DESTINATION_NAME_FIELD, EVENT_DESTINATION_FIELD));

    private final String configurationSetName;

    private final String eventDestinationName;

    private final EventDestinationDefinition eventDestination;

    private CreateConfigurationSetEventDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestinationName = builder.eventDestinationName;
        this.eventDestination = builder.eventDestination;
    }

    /**
     * <p>
     * The name of the configuration set that you want to add an event destination to.
     * </p>
     * 
     * @return The name of the configuration set that you want to add an event destination to.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * A name that identifies the event destination within the configuration set.
     * </p>
     * 
     * @return A name that identifies the event destination within the configuration set.
     */
    public final String eventDestinationName() {
        return eventDestinationName;
    }

    /**
     * <p>
     * An object that defines the event destination.
     * </p>
     * 
     * @return An object that defines the event destination.
     */
    public final EventDestinationDefinition eventDestination() {
        return eventDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(eventDestinationName());
        hashCode = 31 * hashCode + Objects.hashCode(eventDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationSetEventDestinationRequest)) {
            return false;
        }
        CreateConfigurationSetEventDestinationRequest other = (CreateConfigurationSetEventDestinationRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(eventDestinationName(), other.eventDestinationName())
                && Objects.equals(eventDestination(), other.eventDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfigurationSetEventDestinationRequest")
                .add("ConfigurationSetName", configurationSetName()).add("EventDestinationName", eventDestinationName())
                .add("EventDestination", eventDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "EventDestinationName":
            return Optional.ofNullable(clazz.cast(eventDestinationName()));
        case "EventDestination":
            return Optional.ofNullable(clazz.cast(eventDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationSetEventDestinationRequest, T> g) {
        return obj -> g.apply((CreateConfigurationSetEventDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfigurationSetEventDestinationRequest> {
        /**
         * <p>
         * The name of the configuration set that you want to add an event destination to.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set that you want to add an event destination to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * A name that identifies the event destination within the configuration set.
         * </p>
         * 
         * @param eventDestinationName
         *        A name that identifies the event destination within the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinationName(String eventDestinationName);

        /**
         * <p>
         * An object that defines the event destination.
         * </p>
         * 
         * @param eventDestination
         *        An object that defines the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestination(EventDestinationDefinition eventDestination);

        /**
         * <p>
         * An object that defines the event destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventDestinationDefinition.Builder}
         * avoiding the need to create one manually via {@link EventDestinationDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventDestinationDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #eventDestination(EventDestinationDefinition)}.
         * 
         * @param eventDestination
         *        a consumer that will call methods on {@link EventDestinationDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDestination(EventDestinationDefinition)
         */
        default Builder eventDestination(Consumer<EventDestinationDefinition.Builder> eventDestination) {
            return eventDestination(EventDestinationDefinition.builder().applyMutation(eventDestination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private String configurationSetName;

        private String eventDestinationName;

        private EventDestinationDefinition eventDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationSetEventDestinationRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            eventDestinationName(model.eventDestinationName);
            eventDestination(model.eventDestination);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getEventDestinationName() {
            return eventDestinationName;
        }

        public final void setEventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
        }

        @Override
        public final Builder eventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
            return this;
        }

        public final EventDestinationDefinition.Builder getEventDestination() {
            return eventDestination != null ? eventDestination.toBuilder() : null;
        }

        public final void setEventDestination(EventDestinationDefinition.BuilderImpl eventDestination) {
            this.eventDestination = eventDestination != null ? eventDestination.build() : null;
        }

        @Override
        public final Builder eventDestination(EventDestinationDefinition eventDestination) {
            this.eventDestination = eventDestination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationSetEventDestinationRequest build() {
            return new CreateConfigurationSetEventDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
