/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class BlacklistReportCopier {
    static Map<String, List<BlacklistEntry>> copy(Map<String, ? extends Collection<? extends BlacklistEntry>> blacklistReportParam) {
        Map<String, List<BlacklistEntry>> map;
        if (blacklistReportParam == null || blacklistReportParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<BlacklistEntry>> modifiableMap = new LinkedHashMap<>();
            blacklistReportParam.forEach((key, value) -> {
                List<BlacklistEntry> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<BlacklistEntry> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<BlacklistEntry>> copyFromBuilder(
            Map<String, ? extends Collection<? extends BlacklistEntry.Builder>> blacklistReportParam) {
        Map<String, List<BlacklistEntry>> map;
        if (blacklistReportParam == null || blacklistReportParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<BlacklistEntry>> modifiableMap = new LinkedHashMap<>();
            blacklistReportParam.forEach((key, value) -> {
                List<BlacklistEntry> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<BlacklistEntry> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        BlacklistEntry member = entry.build();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<BlacklistEntry.Builder>> copyToBuilder(
            Map<String, ? extends Collection<? extends BlacklistEntry>> blacklistReportParam) {
        Map<String, List<BlacklistEntry.Builder>> map;
        if (blacklistReportParam == null || blacklistReportParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<BlacklistEntry.Builder>> modifiableMap = new LinkedHashMap<>();
            blacklistReportParam.forEach((key, value) -> {
                List<BlacklistEntry.Builder> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<BlacklistEntry.Builder> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        BlacklistEntry.Builder member = entry.toBuilder();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
