/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The raw email message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RawMessage implements SdkPojo, Serializable, ToCopyableBuilder<RawMessage.Builder, RawMessage> {
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Data").getter(getter(RawMessage::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes data;

    private RawMessage(BuilderImpl builder) {
        this.data = builder.data;
    }

    /**
     * <p>
     * The raw email message. The message has to meet the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The message has to contain a header and a body, separated by one blank line.
     * </p>
     * </li>
     * <li>
     * <p>
     * All of the required header fields must be present in the message.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each part of a multipart MIME message must be formatted properly.
     * </p>
     * </li>
     * <li>
     * <p>
     * Attachments must be in a file format that Amazon Pinpoint supports.
     * </p>
     * </li>
     * <li>
     * <p>
     * The entire message must be Base64 encoded.
     * </p>
     * </li>
     * <li>
     * <p>
     * If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you
     * should encode that content to ensure that recipients' email clients render the message properly.
     * </p>
     * </li>
     * <li>
     * <p>
     * The length of any single line of text in the message can't exceed 1,000 characters. This restriction is defined
     * in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The raw email message. The message has to meet the following criteria:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The message has to contain a header and a body, separated by one blank line.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         All of the required header fields must be present in the message.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each part of a multipart MIME message must be formatted properly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Attachments must be in a file format that Amazon Pinpoint supports.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The entire message must be Base64 encoded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character
     *         range, you should encode that content to ensure that recipients' email clients render the message
     *         properly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The length of any single line of text in the message can't exceed 1,000 characters. This restriction is
     *         defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
     *         </p>
     *         </li>
     */
    public final SdkBytes data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RawMessage)) {
            return false;
        }
        RawMessage other = (RawMessage) obj;
        return Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RawMessage").add("Data", data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RawMessage, T> g) {
        return obj -> g.apply((RawMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RawMessage> {
        /**
         * <p>
         * The raw email message. The message has to meet the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The message has to contain a header and a body, separated by one blank line.
         * </p>
         * </li>
         * <li>
         * <p>
         * All of the required header fields must be present in the message.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each part of a multipart MIME message must be formatted properly.
         * </p>
         * </li>
         * <li>
         * <p>
         * Attachments must be in a file format that Amazon Pinpoint supports.
         * </p>
         * </li>
         * <li>
         * <p>
         * The entire message must be Base64 encoded.
         * </p>
         * </li>
         * <li>
         * <p>
         * If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range,
         * you should encode that content to ensure that recipients' email clients render the message properly.
         * </p>
         * </li>
         * <li>
         * <p>
         * The length of any single line of text in the message can't exceed 1,000 characters. This restriction is
         * defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param data
         *        The raw email message. The message has to meet the following criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The message has to contain a header and a body, separated by one blank line.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        All of the required header fields must be present in the message.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each part of a multipart MIME message must be formatted properly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Attachments must be in a file format that Amazon Pinpoint supports.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The entire message must be Base64 encoded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character
         *        range, you should encode that content to ensure that recipients' email clients render the message
         *        properly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The length of any single line of text in the message can't exceed 1,000 characters. This restriction
         *        is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SdkBytes data);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes data;

        private BuilderImpl() {
        }

        private BuilderImpl(RawMessage model) {
            data(model.data);
        }

        public final ByteBuffer getData() {
            return data == null ? null : data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        @Override
        @Transient
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        @Override
        public RawMessage build() {
            return new RawMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
