/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to add a custom domain for tracking open and click events to a configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutConfigurationSetTrackingOptionsRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<PutConfigurationSetTrackingOptionsRequest.Builder, PutConfigurationSetTrackingOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(PutConfigurationSetTrackingOptionsRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()).build();

    private static final SdkField<String> CUSTOM_REDIRECT_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomRedirectDomain").getter(getter(PutConfigurationSetTrackingOptionsRequest::customRedirectDomain))
            .setter(setter(Builder::customRedirectDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRedirectDomain").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            CUSTOM_REDIRECT_DOMAIN_FIELD));

    private final String configurationSetName;

    private final String customRedirectDomain;

    private PutConfigurationSetTrackingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.customRedirectDomain = builder.customRedirectDomain;
    }

    /**
     * <p>
     * The name of the configuration set that you want to add a custom tracking domain to.
     * </p>
     * 
     * @return The name of the configuration set that you want to add a custom tracking domain to.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * <p>
     * The domain that you want to use to track open and click events.
     * </p>
     * 
     * @return The domain that you want to use to track open and click events.
     */
    public final String customRedirectDomain() {
        return customRedirectDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(customRedirectDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutConfigurationSetTrackingOptionsRequest)) {
            return false;
        }
        PutConfigurationSetTrackingOptionsRequest other = (PutConfigurationSetTrackingOptionsRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(customRedirectDomain(), other.customRedirectDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutConfigurationSetTrackingOptionsRequest").add("ConfigurationSetName", configurationSetName())
                .add("CustomRedirectDomain", customRedirectDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "CustomRedirectDomain":
            return Optional.ofNullable(clazz.cast(customRedirectDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutConfigurationSetTrackingOptionsRequest, T> g) {
        return obj -> g.apply((PutConfigurationSetTrackingOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutConfigurationSetTrackingOptionsRequest> {
        /**
         * <p>
         * The name of the configuration set that you want to add a custom tracking domain to.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set that you want to add a custom tracking domain to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * <p>
         * The domain that you want to use to track open and click events.
         * </p>
         * 
         * @param customRedirectDomain
         *        The domain that you want to use to track open and click events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRedirectDomain(String customRedirectDomain);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private String configurationSetName;

        private String customRedirectDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(PutConfigurationSetTrackingOptionsRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            customRedirectDomain(model.customRedirectDomain);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final String getCustomRedirectDomain() {
            return customRedirectDomain;
        }

        public final void setCustomRedirectDomain(String customRedirectDomain) {
            this.customRedirectDomain = customRedirectDomain;
        }

        @Override
        public final Builder customRedirectDomain(String customRedirectDomain) {
            this.customRedirectDomain = customRedirectDomain;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutConfigurationSetTrackingOptionsRequest build() {
            return new PutConfigurationSetTrackingOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
