/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pinpointemail.DefaultPinpointEmailAsyncClient;
import software.amazon.awssdk.services.pinpointemail.DefaultPinpointEmailBaseClientBuilder;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailAsyncClient;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailAsyncClientBuilder;
import software.amazon.awssdk.services.pinpointemail.PinpointEmailServiceClientConfiguration;
import software.amazon.awssdk.services.pinpointemail.endpoints.PinpointEmailEndpointProvider;

@SdkInternalApi
final class DefaultPinpointEmailAsyncClientBuilder
extends DefaultPinpointEmailBaseClientBuilder<PinpointEmailAsyncClientBuilder, PinpointEmailAsyncClient>
implements PinpointEmailAsyncClientBuilder {
    DefaultPinpointEmailAsyncClientBuilder() {
    }

    @Override
    public DefaultPinpointEmailAsyncClientBuilder endpointProvider(PinpointEmailEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PinpointEmailAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultPinpointEmailAsyncClientBuilder.validateClientOptions(clientConfiguration);
        PinpointEmailServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPinpointEmailAsyncClient client = new DefaultPinpointEmailAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PinpointEmailServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PinpointEmailServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

