/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DomainDeliverabilityCampaignListCopier {
    static List<DomainDeliverabilityCampaign> copy(
            Collection<? extends DomainDeliverabilityCampaign> domainDeliverabilityCampaignListParam) {
        List<DomainDeliverabilityCampaign> list;
        if (domainDeliverabilityCampaignListParam == null
                || domainDeliverabilityCampaignListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DomainDeliverabilityCampaign> modifiableList = new ArrayList<>(domainDeliverabilityCampaignListParam.size());
            domainDeliverabilityCampaignListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DomainDeliverabilityCampaign> copyFromBuilder(
            Collection<? extends DomainDeliverabilityCampaign.Builder> domainDeliverabilityCampaignListParam) {
        List<DomainDeliverabilityCampaign> list;
        if (domainDeliverabilityCampaignListParam == null
                || domainDeliverabilityCampaignListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DomainDeliverabilityCampaign> modifiableList = new ArrayList<>(domainDeliverabilityCampaignListParam.size());
            domainDeliverabilityCampaignListParam.forEach(entry -> {
                DomainDeliverabilityCampaign member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DomainDeliverabilityCampaign.Builder> copyToBuilder(
            Collection<? extends DomainDeliverabilityCampaign> domainDeliverabilityCampaignListParam) {
        List<DomainDeliverabilityCampaign.Builder> list;
        if (domainDeliverabilityCampaignListParam == null
                || domainDeliverabilityCampaignListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DomainDeliverabilityCampaign.Builder> modifiableList = new ArrayList<>(
                    domainDeliverabilityCampaignListParam.size());
            domainDeliverabilityCampaignListParam.forEach(entry -> {
                DomainDeliverabilityCampaign.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
