/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a dedicated IP address that is associated with your Amazon Pinpoint account.
 * </p>
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DedicatedIp implements SdkPojo, Serializable, ToCopyableBuilder<DedicatedIp.Builder, DedicatedIp> {
    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ip")
            .getter(getter(DedicatedIp::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()).build();

    private static final SdkField<String> WARMUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WarmupStatus").getter(getter(DedicatedIp::warmupStatusAsString)).setter(setter(Builder::warmupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmupStatus").build()).build();

    private static final SdkField<Integer> WARMUP_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WarmupPercentage").getter(getter(DedicatedIp::warmupPercentage))
            .setter(setter(Builder::warmupPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmupPercentage").build()).build();

    private static final SdkField<String> POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolName").getter(getter(DedicatedIp::poolName)).setter(setter(Builder::poolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, WARMUP_STATUS_FIELD,
            WARMUP_PERCENTAGE_FIELD, POOL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ip;

    private final String warmupStatus;

    private final Integer warmupPercentage;

    private final String poolName;

    private DedicatedIp(BuilderImpl builder) {
        this.ip = builder.ip;
        this.warmupStatus = builder.warmupStatus;
        this.warmupPercentage = builder.warmupPercentage;
        this.poolName = builder.poolName;
    }

    /**
     * <p>
     * An IP address that is reserved for use by your Amazon Pinpoint account.
     * </p>
     * 
     * @return An IP address that is reserved for use by your Amazon Pinpoint account.
     */
    public final String ip() {
        return ip;
    }

    /**
     * <p>
     * The warm-up status of a dedicated IP address. The status can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> – The IP address isn't ready to use because the dedicated IP warm-up process is ongoing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DONE</code> – The dedicated IP warm-up process is complete, and the IP address is ready to use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #warmupStatus} will
     * return {@link WarmupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #warmupStatusAsString}.
     * </p>
     * 
     * @return The warm-up status of a dedicated IP address. The status can have one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> – The IP address isn't ready to use because the dedicated IP warm-up process is
     *         ongoing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DONE</code> – The dedicated IP warm-up process is complete, and the IP address is ready to use.
     *         </p>
     *         </li>
     * @see WarmupStatus
     */
    public final WarmupStatus warmupStatus() {
        return WarmupStatus.fromValue(warmupStatus);
    }

    /**
     * <p>
     * The warm-up status of a dedicated IP address. The status can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> – The IP address isn't ready to use because the dedicated IP warm-up process is ongoing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DONE</code> – The dedicated IP warm-up process is complete, and the IP address is ready to use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #warmupStatus} will
     * return {@link WarmupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #warmupStatusAsString}.
     * </p>
     * 
     * @return The warm-up status of a dedicated IP address. The status can have one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> – The IP address isn't ready to use because the dedicated IP warm-up process is
     *         ongoing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DONE</code> – The dedicated IP warm-up process is complete, and the IP address is ready to use.
     *         </p>
     *         </li>
     * @see WarmupStatus
     */
    public final String warmupStatusAsString() {
        return warmupStatus;
    }

    /**
     * <p>
     * Indicates how complete the dedicated IP warm-up process is. When this value equals 1, the address has completed
     * the warm-up process and is ready for use.
     * </p>
     * 
     * @return Indicates how complete the dedicated IP warm-up process is. When this value equals 1, the address has
     *         completed the warm-up process and is ready for use.
     */
    public final Integer warmupPercentage() {
        return warmupPercentage;
    }

    /**
     * <p>
     * The name of the dedicated IP pool that the IP address is associated with.
     * </p>
     * 
     * @return The name of the dedicated IP pool that the IP address is associated with.
     */
    public final String poolName() {
        return poolName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(warmupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(warmupPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(poolName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DedicatedIp)) {
            return false;
        }
        DedicatedIp other = (DedicatedIp) obj;
        return Objects.equals(ip(), other.ip()) && Objects.equals(warmupStatusAsString(), other.warmupStatusAsString())
                && Objects.equals(warmupPercentage(), other.warmupPercentage()) && Objects.equals(poolName(), other.poolName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DedicatedIp").add("Ip", ip()).add("WarmupStatus", warmupStatusAsString())
                .add("WarmupPercentage", warmupPercentage()).add("PoolName", poolName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "WarmupStatus":
            return Optional.ofNullable(clazz.cast(warmupStatusAsString()));
        case "WarmupPercentage":
            return Optional.ofNullable(clazz.cast(warmupPercentage()));
        case "PoolName":
            return Optional.ofNullable(clazz.cast(poolName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ip", IP_FIELD);
        map.put("WarmupStatus", WARMUP_STATUS_FIELD);
        map.put("WarmupPercentage", WARMUP_PERCENTAGE_FIELD);
        map.put("PoolName", POOL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DedicatedIp, T> g) {
        return obj -> g.apply((DedicatedIp) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DedicatedIp> {
        /**
         * <p>
         * An IP address that is reserved for use by your Amazon Pinpoint account.
         * </p>
         * 
         * @param ip
         *        An IP address that is reserved for use by your Amazon Pinpoint account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * <p>
         * The warm-up status of a dedicated IP address. The status can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> – The IP address isn't ready to use because the dedicated IP warm-up process is
         * ongoing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DONE</code> – The dedicated IP warm-up process is complete, and the IP address is ready to use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param warmupStatus
         *        The warm-up status of a dedicated IP address. The status can have one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> – The IP address isn't ready to use because the dedicated IP warm-up process
         *        is ongoing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DONE</code> – The dedicated IP warm-up process is complete, and the IP address is ready to use.
         *        </p>
         *        </li>
         * @see WarmupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmupStatus
         */
        Builder warmupStatus(String warmupStatus);

        /**
         * <p>
         * The warm-up status of a dedicated IP address. The status can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> – The IP address isn't ready to use because the dedicated IP warm-up process is
         * ongoing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DONE</code> – The dedicated IP warm-up process is complete, and the IP address is ready to use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param warmupStatus
         *        The warm-up status of a dedicated IP address. The status can have one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> – The IP address isn't ready to use because the dedicated IP warm-up process
         *        is ongoing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DONE</code> – The dedicated IP warm-up process is complete, and the IP address is ready to use.
         *        </p>
         *        </li>
         * @see WarmupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WarmupStatus
         */
        Builder warmupStatus(WarmupStatus warmupStatus);

        /**
         * <p>
         * Indicates how complete the dedicated IP warm-up process is. When this value equals 1, the address has
         * completed the warm-up process and is ready for use.
         * </p>
         * 
         * @param warmupPercentage
         *        Indicates how complete the dedicated IP warm-up process is. When this value equals 1, the address has
         *        completed the warm-up process and is ready for use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmupPercentage(Integer warmupPercentage);

        /**
         * <p>
         * The name of the dedicated IP pool that the IP address is associated with.
         * </p>
         * 
         * @param poolName
         *        The name of the dedicated IP pool that the IP address is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolName(String poolName);
    }

    static final class BuilderImpl implements Builder {
        private String ip;

        private String warmupStatus;

        private Integer warmupPercentage;

        private String poolName;

        private BuilderImpl() {
        }

        private BuilderImpl(DedicatedIp model) {
            ip(model.ip);
            warmupStatus(model.warmupStatus);
            warmupPercentage(model.warmupPercentage);
            poolName(model.poolName);
        }

        public final String getIp() {
            return ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final String getWarmupStatus() {
            return warmupStatus;
        }

        public final void setWarmupStatus(String warmupStatus) {
            this.warmupStatus = warmupStatus;
        }

        @Override
        public final Builder warmupStatus(String warmupStatus) {
            this.warmupStatus = warmupStatus;
            return this;
        }

        @Override
        public final Builder warmupStatus(WarmupStatus warmupStatus) {
            this.warmupStatus(warmupStatus == null ? null : warmupStatus.toString());
            return this;
        }

        public final Integer getWarmupPercentage() {
            return warmupPercentage;
        }

        public final void setWarmupPercentage(Integer warmupPercentage) {
            this.warmupPercentage = warmupPercentage;
        }

        @Override
        public final Builder warmupPercentage(Integer warmupPercentage) {
            this.warmupPercentage = warmupPercentage;
            return this;
        }

        public final String getPoolName() {
            return poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        @Override
        public DedicatedIp build() {
            return new DedicatedIp(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
