/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of details about the email-sending capabilities of your Amazon Pinpoint account in the current AWS Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountResponse extends PinpointEmailResponse implements
        ToCopyableBuilder<GetAccountResponse.Builder, GetAccountResponse> {
    private static final SdkField<SendQuota> SEND_QUOTA_FIELD = SdkField.<SendQuota> builder(MarshallingType.SDK_POJO)
            .memberName("SendQuota").getter(getter(GetAccountResponse::sendQuota)).setter(setter(Builder::sendQuota))
            .constructor(SendQuota::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendQuota").build()).build();

    private static final SdkField<Boolean> SENDING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SendingEnabled").getter(getter(GetAccountResponse::sendingEnabled))
            .setter(setter(Builder::sendingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingEnabled").build()).build();

    private static final SdkField<Boolean> DEDICATED_IP_AUTO_WARMUP_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DedicatedIpAutoWarmupEnabled")
            .getter(getter(GetAccountResponse::dedicatedIpAutoWarmupEnabled))
            .setter(setter(Builder::dedicatedIpAutoWarmupEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedIpAutoWarmupEnabled")
                    .build()).build();

    private static final SdkField<String> ENFORCEMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnforcementStatus").getter(getter(GetAccountResponse::enforcementStatus))
            .setter(setter(Builder::enforcementStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforcementStatus").build()).build();

    private static final SdkField<Boolean> PRODUCTION_ACCESS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ProductionAccessEnabled").getter(getter(GetAccountResponse::productionAccessEnabled))
            .setter(setter(Builder::productionAccessEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionAccessEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEND_QUOTA_FIELD,
            SENDING_ENABLED_FIELD, DEDICATED_IP_AUTO_WARMUP_ENABLED_FIELD, ENFORCEMENT_STATUS_FIELD,
            PRODUCTION_ACCESS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SendQuota sendQuota;

    private final Boolean sendingEnabled;

    private final Boolean dedicatedIpAutoWarmupEnabled;

    private final String enforcementStatus;

    private final Boolean productionAccessEnabled;

    private GetAccountResponse(BuilderImpl builder) {
        super(builder);
        this.sendQuota = builder.sendQuota;
        this.sendingEnabled = builder.sendingEnabled;
        this.dedicatedIpAutoWarmupEnabled = builder.dedicatedIpAutoWarmupEnabled;
        this.enforcementStatus = builder.enforcementStatus;
        this.productionAccessEnabled = builder.productionAccessEnabled;
    }

    /**
     * <p>
     * An object that contains information about the per-day and per-second sending limits for your Amazon Pinpoint
     * account in the current AWS Region.
     * </p>
     * 
     * @return An object that contains information about the per-day and per-second sending limits for your Amazon
     *         Pinpoint account in the current AWS Region.
     */
    public final SendQuota sendQuota() {
        return sendQuota;
    }

    /**
     * <p>
     * Indicates whether or not email sending is enabled for your Amazon Pinpoint account in the current AWS Region.
     * </p>
     * 
     * @return Indicates whether or not email sending is enabled for your Amazon Pinpoint account in the current AWS
     *         Region.
     */
    public final Boolean sendingEnabled() {
        return sendingEnabled;
    }

    /**
     * <p>
     * Indicates whether or not the automatic warm-up feature is enabled for dedicated IP addresses that are associated
     * with your account.
     * </p>
     * 
     * @return Indicates whether or not the automatic warm-up feature is enabled for dedicated IP addresses that are
     *         associated with your account.
     */
    public final Boolean dedicatedIpAutoWarmupEnabled() {
        return dedicatedIpAutoWarmupEnabled;
    }

    /**
     * <p>
     * The reputation status of your Amazon Pinpoint account. The status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HEALTHY</code> – There are no reputation-related issues that currently impact your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROBATION</code> – We've identified some issues with your Amazon Pinpoint account. We're placing your
     * account under review while you work on correcting these issues.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SHUTDOWN</code> – Your account's ability to send email is currently paused because of an issue with the
     * email sent from your account. When you correct the issue, you can contact us and request that your account's
     * ability to send email is resumed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The reputation status of your Amazon Pinpoint account. The status can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code> – There are no reputation-related issues that currently impact your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROBATION</code> – We've identified some issues with your Amazon Pinpoint account. We're placing
     *         your account under review while you work on correcting these issues.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHUTDOWN</code> – Your account's ability to send email is currently paused because of an issue with
     *         the email sent from your account. When you correct the issue, you can contact us and request that your
     *         account's ability to send email is resumed.
     *         </p>
     *         </li>
     */
    public final String enforcementStatus() {
        return enforcementStatus;
    }

    /**
     * <p>
     * Indicates whether or not your account has production access in the current AWS Region.
     * </p>
     * <p>
     * If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the
     * sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send
     * in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your
     * maximum sending rate) is 1.
     * </p>
     * <p>
     * If the value is <code>true</code>, then your account has production access. When your account has production
     * access, you can send email to any address. The sending quota and maximum sending rate for your account vary based
     * on your specific use case.
     * </p>
     * 
     * @return Indicates whether or not your account has production access in the current AWS Region.</p>
     *         <p>
     *         If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in
     *         the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails
     *         you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can
     *         send per second (your maximum sending rate) is 1.
     *         </p>
     *         <p>
     *         If the value is <code>true</code>, then your account has production access. When your account has
     *         production access, you can send email to any address. The sending quota and maximum sending rate for your
     *         account vary based on your specific use case.
     */
    public final Boolean productionAccessEnabled() {
        return productionAccessEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sendQuota());
        hashCode = 31 * hashCode + Objects.hashCode(sendingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedIpAutoWarmupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(enforcementStatus());
        hashCode = 31 * hashCode + Objects.hashCode(productionAccessEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountResponse)) {
            return false;
        }
        GetAccountResponse other = (GetAccountResponse) obj;
        return Objects.equals(sendQuota(), other.sendQuota()) && Objects.equals(sendingEnabled(), other.sendingEnabled())
                && Objects.equals(dedicatedIpAutoWarmupEnabled(), other.dedicatedIpAutoWarmupEnabled())
                && Objects.equals(enforcementStatus(), other.enforcementStatus())
                && Objects.equals(productionAccessEnabled(), other.productionAccessEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountResponse").add("SendQuota", sendQuota()).add("SendingEnabled", sendingEnabled())
                .add("DedicatedIpAutoWarmupEnabled", dedicatedIpAutoWarmupEnabled())
                .add("EnforcementStatus", enforcementStatus()).add("ProductionAccessEnabled", productionAccessEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SendQuota":
            return Optional.ofNullable(clazz.cast(sendQuota()));
        case "SendingEnabled":
            return Optional.ofNullable(clazz.cast(sendingEnabled()));
        case "DedicatedIpAutoWarmupEnabled":
            return Optional.ofNullable(clazz.cast(dedicatedIpAutoWarmupEnabled()));
        case "EnforcementStatus":
            return Optional.ofNullable(clazz.cast(enforcementStatus()));
        case "ProductionAccessEnabled":
            return Optional.ofNullable(clazz.cast(productionAccessEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SendQuota", SEND_QUOTA_FIELD);
        map.put("SendingEnabled", SENDING_ENABLED_FIELD);
        map.put("DedicatedIpAutoWarmupEnabled", DEDICATED_IP_AUTO_WARMUP_ENABLED_FIELD);
        map.put("EnforcementStatus", ENFORCEMENT_STATUS_FIELD);
        map.put("ProductionAccessEnabled", PRODUCTION_ACCESS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountResponse, T> g) {
        return obj -> g.apply((GetAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountResponse> {
        /**
         * <p>
         * An object that contains information about the per-day and per-second sending limits for your Amazon Pinpoint
         * account in the current AWS Region.
         * </p>
         * 
         * @param sendQuota
         *        An object that contains information about the per-day and per-second sending limits for your Amazon
         *        Pinpoint account in the current AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendQuota(SendQuota sendQuota);

        /**
         * <p>
         * An object that contains information about the per-day and per-second sending limits for your Amazon Pinpoint
         * account in the current AWS Region.
         * </p>
         * This is a convenience method that creates an instance of the {@link SendQuota.Builder} avoiding the need to
         * create one manually via {@link SendQuota#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SendQuota.Builder#build()} is called immediately and its result
         * is passed to {@link #sendQuota(SendQuota)}.
         * 
         * @param sendQuota
         *        a consumer that will call methods on {@link SendQuota.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sendQuota(SendQuota)
         */
        default Builder sendQuota(Consumer<SendQuota.Builder> sendQuota) {
            return sendQuota(SendQuota.builder().applyMutation(sendQuota).build());
        }

        /**
         * <p>
         * Indicates whether or not email sending is enabled for your Amazon Pinpoint account in the current AWS Region.
         * </p>
         * 
         * @param sendingEnabled
         *        Indicates whether or not email sending is enabled for your Amazon Pinpoint account in the current AWS
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingEnabled(Boolean sendingEnabled);

        /**
         * <p>
         * Indicates whether or not the automatic warm-up feature is enabled for dedicated IP addresses that are
         * associated with your account.
         * </p>
         * 
         * @param dedicatedIpAutoWarmupEnabled
         *        Indicates whether or not the automatic warm-up feature is enabled for dedicated IP addresses that are
         *        associated with your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedIpAutoWarmupEnabled(Boolean dedicatedIpAutoWarmupEnabled);

        /**
         * <p>
         * The reputation status of your Amazon Pinpoint account. The status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HEALTHY</code> – There are no reputation-related issues that currently impact your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROBATION</code> – We've identified some issues with your Amazon Pinpoint account. We're placing your
         * account under review while you work on correcting these issues.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SHUTDOWN</code> – Your account's ability to send email is currently paused because of an issue with the
         * email sent from your account. When you correct the issue, you can contact us and request that your account's
         * ability to send email is resumed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param enforcementStatus
         *        The reputation status of your Amazon Pinpoint account. The status can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code> – There are no reputation-related issues that currently impact your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROBATION</code> – We've identified some issues with your Amazon Pinpoint account. We're placing
         *        your account under review while you work on correcting these issues.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHUTDOWN</code> – Your account's ability to send email is currently paused because of an issue
         *        with the email sent from your account. When you correct the issue, you can contact us and request that
         *        your account's ability to send email is resumed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforcementStatus(String enforcementStatus);

        /**
         * <p>
         * Indicates whether or not your account has production access in the current AWS Region.
         * </p>
         * <p>
         * If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is in the
         * sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can
         * send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per
         * second (your maximum sending rate) is 1.
         * </p>
         * <p>
         * If the value is <code>true</code>, then your account has production access. When your account has production
         * access, you can send email to any address. The sending quota and maximum sending rate for your account vary
         * based on your specific use case.
         * </p>
         * 
         * @param productionAccessEnabled
         *        Indicates whether or not your account has production access in the current AWS Region.</p>
         *        <p>
         *        If the value is <code>false</code>, then your account is in the <i>sandbox</i>. When your account is
         *        in the sandbox, you can only send email to verified identities. Additionally, the maximum number of
         *        emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails
         *        you can send per second (your maximum sending rate) is 1.
         *        </p>
         *        <p>
         *        If the value is <code>true</code>, then your account has production access. When your account has
         *        production access, you can send email to any address. The sending quota and maximum sending rate for
         *        your account vary based on your specific use case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productionAccessEnabled(Boolean productionAccessEnabled);
    }

    static final class BuilderImpl extends PinpointEmailResponse.BuilderImpl implements Builder {
        private SendQuota sendQuota;

        private Boolean sendingEnabled;

        private Boolean dedicatedIpAutoWarmupEnabled;

        private String enforcementStatus;

        private Boolean productionAccessEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountResponse model) {
            super(model);
            sendQuota(model.sendQuota);
            sendingEnabled(model.sendingEnabled);
            dedicatedIpAutoWarmupEnabled(model.dedicatedIpAutoWarmupEnabled);
            enforcementStatus(model.enforcementStatus);
            productionAccessEnabled(model.productionAccessEnabled);
        }

        public final SendQuota.Builder getSendQuota() {
            return sendQuota != null ? sendQuota.toBuilder() : null;
        }

        public final void setSendQuota(SendQuota.BuilderImpl sendQuota) {
            this.sendQuota = sendQuota != null ? sendQuota.build() : null;
        }

        @Override
        public final Builder sendQuota(SendQuota sendQuota) {
            this.sendQuota = sendQuota;
            return this;
        }

        public final Boolean getSendingEnabled() {
            return sendingEnabled;
        }

        public final void setSendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
        }

        @Override
        public final Builder sendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
            return this;
        }

        public final Boolean getDedicatedIpAutoWarmupEnabled() {
            return dedicatedIpAutoWarmupEnabled;
        }

        public final void setDedicatedIpAutoWarmupEnabled(Boolean dedicatedIpAutoWarmupEnabled) {
            this.dedicatedIpAutoWarmupEnabled = dedicatedIpAutoWarmupEnabled;
        }

        @Override
        public final Builder dedicatedIpAutoWarmupEnabled(Boolean dedicatedIpAutoWarmupEnabled) {
            this.dedicatedIpAutoWarmupEnabled = dedicatedIpAutoWarmupEnabled;
            return this;
        }

        public final String getEnforcementStatus() {
            return enforcementStatus;
        }

        public final void setEnforcementStatus(String enforcementStatus) {
            this.enforcementStatus = enforcementStatus;
        }

        @Override
        public final Builder enforcementStatus(String enforcementStatus) {
            this.enforcementStatus = enforcementStatus;
            return this;
        }

        public final Boolean getProductionAccessEnabled() {
            return productionAccessEnabled;
        }

        public final void setProductionAccessEnabled(Boolean productionAccessEnabled) {
            this.productionAccessEnabled = productionAccessEnabled;
        }

        @Override
        public final Builder productionAccessEnabled(Boolean productionAccessEnabled) {
            this.productionAccessEnabled = productionAccessEnabled;
            return this;
        }

        @Override
        public GetAccountResponse build() {
            return new GetAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
