/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about the amount of email that was delivered to recipients.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeStatistics.Builder, VolumeStatistics> {
    private static final SdkField<Long> INBOX_RAW_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("InboxRawCount").getter(getter(VolumeStatistics::inboxRawCount)).setter(setter(Builder::inboxRawCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboxRawCount").build()).build();

    private static final SdkField<Long> SPAM_RAW_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SpamRawCount").getter(getter(VolumeStatistics::spamRawCount)).setter(setter(Builder::spamRawCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpamRawCount").build()).build();

    private static final SdkField<Long> PROJECTED_INBOX_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ProjectedInbox").getter(getter(VolumeStatistics::projectedInbox))
            .setter(setter(Builder::projectedInbox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectedInbox").build()).build();

    private static final SdkField<Long> PROJECTED_SPAM_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ProjectedSpam").getter(getter(VolumeStatistics::projectedSpam)).setter(setter(Builder::projectedSpam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectedSpam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INBOX_RAW_COUNT_FIELD,
            SPAM_RAW_COUNT_FIELD, PROJECTED_INBOX_FIELD, PROJECTED_SPAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long inboxRawCount;

    private final Long spamRawCount;

    private final Long projectedInbox;

    private final Long projectedSpam;

    private VolumeStatistics(BuilderImpl builder) {
        this.inboxRawCount = builder.inboxRawCount;
        this.spamRawCount = builder.spamRawCount;
        this.projectedInbox = builder.projectedInbox;
        this.projectedSpam = builder.projectedSpam;
    }

    /**
     * <p>
     * The total number of emails that arrived in recipients' inboxes.
     * </p>
     * 
     * @return The total number of emails that arrived in recipients' inboxes.
     */
    public final Long inboxRawCount() {
        return inboxRawCount;
    }

    /**
     * <p>
     * The total number of emails that arrived in recipients' spam or junk mail folders.
     * </p>
     * 
     * @return The total number of emails that arrived in recipients' spam or junk mail folders.
     */
    public final Long spamRawCount() {
        return spamRawCount;
    }

    /**
     * <p>
     * An estimate of the percentage of emails sent from the current domain that will arrive in recipients' inboxes.
     * </p>
     * 
     * @return An estimate of the percentage of emails sent from the current domain that will arrive in recipients'
     *         inboxes.
     */
    public final Long projectedInbox() {
        return projectedInbox;
    }

    /**
     * <p>
     * An estimate of the percentage of emails sent from the current domain that will arrive in recipients' spam or junk
     * mail folders.
     * </p>
     * 
     * @return An estimate of the percentage of emails sent from the current domain that will arrive in recipients' spam
     *         or junk mail folders.
     */
    public final Long projectedSpam() {
        return projectedSpam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inboxRawCount());
        hashCode = 31 * hashCode + Objects.hashCode(spamRawCount());
        hashCode = 31 * hashCode + Objects.hashCode(projectedInbox());
        hashCode = 31 * hashCode + Objects.hashCode(projectedSpam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatistics)) {
            return false;
        }
        VolumeStatistics other = (VolumeStatistics) obj;
        return Objects.equals(inboxRawCount(), other.inboxRawCount()) && Objects.equals(spamRawCount(), other.spamRawCount())
                && Objects.equals(projectedInbox(), other.projectedInbox())
                && Objects.equals(projectedSpam(), other.projectedSpam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeStatistics").add("InboxRawCount", inboxRawCount()).add("SpamRawCount", spamRawCount())
                .add("ProjectedInbox", projectedInbox()).add("ProjectedSpam", projectedSpam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InboxRawCount":
            return Optional.ofNullable(clazz.cast(inboxRawCount()));
        case "SpamRawCount":
            return Optional.ofNullable(clazz.cast(spamRawCount()));
        case "ProjectedInbox":
            return Optional.ofNullable(clazz.cast(projectedInbox()));
        case "ProjectedSpam":
            return Optional.ofNullable(clazz.cast(projectedSpam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InboxRawCount", INBOX_RAW_COUNT_FIELD);
        map.put("SpamRawCount", SPAM_RAW_COUNT_FIELD);
        map.put("ProjectedInbox", PROJECTED_INBOX_FIELD);
        map.put("ProjectedSpam", PROJECTED_SPAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VolumeStatistics, T> g) {
        return obj -> g.apply((VolumeStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeStatistics> {
        /**
         * <p>
         * The total number of emails that arrived in recipients' inboxes.
         * </p>
         * 
         * @param inboxRawCount
         *        The total number of emails that arrived in recipients' inboxes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboxRawCount(Long inboxRawCount);

        /**
         * <p>
         * The total number of emails that arrived in recipients' spam or junk mail folders.
         * </p>
         * 
         * @param spamRawCount
         *        The total number of emails that arrived in recipients' spam or junk mail folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spamRawCount(Long spamRawCount);

        /**
         * <p>
         * An estimate of the percentage of emails sent from the current domain that will arrive in recipients' inboxes.
         * </p>
         * 
         * @param projectedInbox
         *        An estimate of the percentage of emails sent from the current domain that will arrive in recipients'
         *        inboxes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedInbox(Long projectedInbox);

        /**
         * <p>
         * An estimate of the percentage of emails sent from the current domain that will arrive in recipients' spam or
         * junk mail folders.
         * </p>
         * 
         * @param projectedSpam
         *        An estimate of the percentage of emails sent from the current domain that will arrive in recipients'
         *        spam or junk mail folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectedSpam(Long projectedSpam);
    }

    static final class BuilderImpl implements Builder {
        private Long inboxRawCount;

        private Long spamRawCount;

        private Long projectedInbox;

        private Long projectedSpam;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatistics model) {
            inboxRawCount(model.inboxRawCount);
            spamRawCount(model.spamRawCount);
            projectedInbox(model.projectedInbox);
            projectedSpam(model.projectedSpam);
        }

        public final Long getInboxRawCount() {
            return inboxRawCount;
        }

        public final void setInboxRawCount(Long inboxRawCount) {
            this.inboxRawCount = inboxRawCount;
        }

        @Override
        public final Builder inboxRawCount(Long inboxRawCount) {
            this.inboxRawCount = inboxRawCount;
            return this;
        }

        public final Long getSpamRawCount() {
            return spamRawCount;
        }

        public final void setSpamRawCount(Long spamRawCount) {
            this.spamRawCount = spamRawCount;
        }

        @Override
        public final Builder spamRawCount(Long spamRawCount) {
            this.spamRawCount = spamRawCount;
            return this;
        }

        public final Long getProjectedInbox() {
            return projectedInbox;
        }

        public final void setProjectedInbox(Long projectedInbox) {
            this.projectedInbox = projectedInbox;
        }

        @Override
        public final Builder projectedInbox(Long projectedInbox) {
            this.projectedInbox = projectedInbox;
            return this;
        }

        public final Long getProjectedSpam() {
            return projectedSpam;
        }

        public final void setProjectedSpam(Long projectedSpam) {
            this.projectedSpam = projectedSpam;
        }

        @Override
        public final Builder projectedSpam(Long projectedSpam) {
            this.projectedSpam = projectedSpam;
            return this;
        }

        @Override
        public VolumeStatistics build() {
            return new VolumeStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
