/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointemail.model.DailyVolume;
import software.amazon.awssdk.services.pinpointemail.model.DailyVolumesCopier;
import software.amazon.awssdk.services.pinpointemail.model.OverallVolume;
import software.amazon.awssdk.services.pinpointemail.model.PinpointEmailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDomainStatisticsReportResponse
extends PinpointEmailResponse
implements ToCopyableBuilder<Builder, GetDomainStatisticsReportResponse> {
    private static final SdkField<OverallVolume> OVERALL_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverallVolume").getter(GetDomainStatisticsReportResponse.getter(GetDomainStatisticsReportResponse::overallVolume)).setter(GetDomainStatisticsReportResponse.setter(Builder::overallVolume)).constructor(OverallVolume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverallVolume").build()}).build();
    private static final SdkField<List<DailyVolume>> DAILY_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DailyVolumes").getter(GetDomainStatisticsReportResponse.getter(GetDomainStatisticsReportResponse::dailyVolumes)).setter(GetDomainStatisticsReportResponse.setter(Builder::dailyVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyVolumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DailyVolume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERALL_VOLUME_FIELD, DAILY_VOLUMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDomainStatisticsReportResponse.memberNameToFieldInitializer();
    private final OverallVolume overallVolume;
    private final List<DailyVolume> dailyVolumes;

    private GetDomainStatisticsReportResponse(BuilderImpl builder) {
        super(builder);
        this.overallVolume = builder.overallVolume;
        this.dailyVolumes = builder.dailyVolumes;
    }

    public final OverallVolume overallVolume() {
        return this.overallVolume;
    }

    public final boolean hasDailyVolumes() {
        return this.dailyVolumes != null && !(this.dailyVolumes instanceof SdkAutoConstructList);
    }

    public final List<DailyVolume> dailyVolumes() {
        return this.dailyVolumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.overallVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDailyVolumes() ? this.dailyVolumes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainStatisticsReportResponse)) {
            return false;
        }
        GetDomainStatisticsReportResponse other = (GetDomainStatisticsReportResponse)((Object)obj);
        return Objects.equals(this.overallVolume(), other.overallVolume()) && this.hasDailyVolumes() == other.hasDailyVolumes() && Objects.equals(this.dailyVolumes(), other.dailyVolumes());
    }

    public final String toString() {
        return ToString.builder((String)"GetDomainStatisticsReportResponse").add("OverallVolume", (Object)this.overallVolume()).add("DailyVolumes", this.hasDailyVolumes() ? this.dailyVolumes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OverallVolume": {
                return Optional.ofNullable(clazz.cast(this.overallVolume()));
            }
            case "DailyVolumes": {
                return Optional.ofNullable(clazz.cast(this.dailyVolumes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OverallVolume", OVERALL_VOLUME_FIELD);
        map.put("DailyVolumes", DAILY_VOLUMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDomainStatisticsReportResponse, T> g) {
        return obj -> g.apply((GetDomainStatisticsReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointEmailResponse.BuilderImpl
    implements Builder {
        private OverallVolume overallVolume;
        private List<DailyVolume> dailyVolumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainStatisticsReportResponse model) {
            super(model);
            this.overallVolume(model.overallVolume);
            this.dailyVolumes(model.dailyVolumes);
        }

        public final OverallVolume.Builder getOverallVolume() {
            return this.overallVolume != null ? this.overallVolume.toBuilder() : null;
        }

        public final void setOverallVolume(OverallVolume.BuilderImpl overallVolume) {
            this.overallVolume = overallVolume != null ? overallVolume.build() : null;
        }

        @Override
        public final Builder overallVolume(OverallVolume overallVolume) {
            this.overallVolume = overallVolume;
            return this;
        }

        public final List<DailyVolume.Builder> getDailyVolumes() {
            List<DailyVolume.Builder> result = DailyVolumesCopier.copyToBuilder(this.dailyVolumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDailyVolumes(Collection<DailyVolume.BuilderImpl> dailyVolumes) {
            this.dailyVolumes = DailyVolumesCopier.copyFromBuilder(dailyVolumes);
        }

        @Override
        public final Builder dailyVolumes(Collection<DailyVolume> dailyVolumes) {
            this.dailyVolumes = DailyVolumesCopier.copy(dailyVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dailyVolumes(DailyVolume ... dailyVolumes) {
            this.dailyVolumes(Arrays.asList(dailyVolumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dailyVolumes(Consumer<DailyVolume.Builder> ... dailyVolumes) {
            this.dailyVolumes(Stream.of(dailyVolumes).map(c -> (DailyVolume)((DailyVolume.Builder)DailyVolume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDomainStatisticsReportResponse build() {
            return new GetDomainStatisticsReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointEmailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDomainStatisticsReportResponse> {
        public Builder overallVolume(OverallVolume var1);

        default public Builder overallVolume(Consumer<OverallVolume.Builder> overallVolume) {
            return this.overallVolume((OverallVolume)((OverallVolume.Builder)OverallVolume.builder().applyMutation(overallVolume)).build());
        }

        public Builder dailyVolumes(Collection<DailyVolume> var1);

        public Builder dailyVolumes(DailyVolume ... var1);

        public Builder dailyVolumes(Consumer<DailyVolume.Builder> ... var1);
    }
}

