/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to enable or disable DKIM signing of email that you send from an email identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEmailIdentityDkimAttributesRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<PutEmailIdentityDkimAttributesRequest.Builder, PutEmailIdentityDkimAttributesRequest> {
    private static final SdkField<String> EMAIL_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailIdentity").getter(getter(PutEmailIdentityDkimAttributesRequest::emailIdentity))
            .setter(setter(Builder::emailIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailIdentity").build()).build();

    private static final SdkField<Boolean> SIGNING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SigningEnabled").getter(getter(PutEmailIdentityDkimAttributesRequest::signingEnabled))
            .setter(setter(Builder::signingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITY_FIELD,
            SIGNING_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String emailIdentity;

    private final Boolean signingEnabled;

    private PutEmailIdentityDkimAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.emailIdentity = builder.emailIdentity;
        this.signingEnabled = builder.signingEnabled;
    }

    /**
     * <p>
     * The email identity that you want to change the DKIM settings for.
     * </p>
     * 
     * @return The email identity that you want to change the DKIM settings for.
     */
    public final String emailIdentity() {
        return emailIdentity;
    }

    /**
     * <p>
     * Sets the DKIM signing configuration for the identity.
     * </p>
     * <p>
     * When you set this value <code>true</code>, then the messages that Amazon Pinpoint sends from the identity are
     * DKIM-signed. When you set this value to <code>false</code>, then the messages that Amazon Pinpoint sends from the
     * identity aren't DKIM-signed.
     * </p>
     * 
     * @return Sets the DKIM signing configuration for the identity.</p>
     *         <p>
     *         When you set this value <code>true</code>, then the messages that Amazon Pinpoint sends from the identity
     *         are DKIM-signed. When you set this value to <code>false</code>, then the messages that Amazon Pinpoint
     *         sends from the identity aren't DKIM-signed.
     */
    public final Boolean signingEnabled() {
        return signingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(signingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEmailIdentityDkimAttributesRequest)) {
            return false;
        }
        PutEmailIdentityDkimAttributesRequest other = (PutEmailIdentityDkimAttributesRequest) obj;
        return Objects.equals(emailIdentity(), other.emailIdentity()) && Objects.equals(signingEnabled(), other.signingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEmailIdentityDkimAttributesRequest").add("EmailIdentity", emailIdentity())
                .add("SigningEnabled", signingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailIdentity":
            return Optional.ofNullable(clazz.cast(emailIdentity()));
        case "SigningEnabled":
            return Optional.ofNullable(clazz.cast(signingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmailIdentity", EMAIL_IDENTITY_FIELD);
        map.put("SigningEnabled", SIGNING_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEmailIdentityDkimAttributesRequest, T> g) {
        return obj -> g.apply((PutEmailIdentityDkimAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutEmailIdentityDkimAttributesRequest> {
        /**
         * <p>
         * The email identity that you want to change the DKIM settings for.
         * </p>
         * 
         * @param emailIdentity
         *        The email identity that you want to change the DKIM settings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailIdentity(String emailIdentity);

        /**
         * <p>
         * Sets the DKIM signing configuration for the identity.
         * </p>
         * <p>
         * When you set this value <code>true</code>, then the messages that Amazon Pinpoint sends from the identity are
         * DKIM-signed. When you set this value to <code>false</code>, then the messages that Amazon Pinpoint sends from
         * the identity aren't DKIM-signed.
         * </p>
         * 
         * @param signingEnabled
         *        Sets the DKIM signing configuration for the identity.</p>
         *        <p>
         *        When you set this value <code>true</code>, then the messages that Amazon Pinpoint sends from the
         *        identity are DKIM-signed. When you set this value to <code>false</code>, then the messages that Amazon
         *        Pinpoint sends from the identity aren't DKIM-signed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingEnabled(Boolean signingEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private String emailIdentity;

        private Boolean signingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEmailIdentityDkimAttributesRequest model) {
            super(model);
            emailIdentity(model.emailIdentity);
            signingEnabled(model.signingEnabled);
        }

        public final String getEmailIdentity() {
            return emailIdentity;
        }

        public final void setEmailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
        }

        @Override
        public final Builder emailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        public final Boolean getSigningEnabled() {
            return signingEnabled;
        }

        public final void setSigningEnabled(Boolean signingEnabled) {
            this.signingEnabled = signingEnabled;
        }

        @Override
        public final Builder signingEnabled(Boolean signingEnabled) {
            this.signingEnabled = signingEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEmailIdentityDkimAttributesRequest build() {
            return new PutEmailIdentityDkimAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
