/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class BlacklistReportCopier {
    static Map<String, List<BlacklistEntry>> copy(Map<String, ? extends Collection<BlacklistEntry>> blacklistReportParam) {
        if (blacklistReportParam == null || blacklistReportParam instanceof SdkAutoConstructMap) {
            return DefaultSdkAutoConstructMap.getInstance();
        }
        Map<String, List<BlacklistEntry>> blacklistReportParamCopy = blacklistReportParam.entrySet().stream()
                .collect(HashMap::new, (m, e) -> m.put(e.getKey(), BlacklistEntriesCopier.copy(e.getValue())), HashMap::putAll);
        return Collections.unmodifiableMap(blacklistReportParamCopy);
    }
}
