/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the
 * campaign sent email by using a domain that the Deliverability dashboard is enabled for (
 * <code>PutDeliverabilityDashboardOption</code> operation).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainDeliverabilityCampaignRequest extends PinpointEmailRequest implements
        ToCopyableBuilder<GetDomainDeliverabilityCampaignRequest.Builder, GetDomainDeliverabilityCampaignRequest> {
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDomainDeliverabilityCampaignRequest::campaignId)).setter(setter(Builder::campaignId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CampaignId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ID_FIELD));

    private final String campaignId;

    private GetDomainDeliverabilityCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.campaignId = builder.campaignId;
    }

    /**
     * <p>
     * The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this identifier to a
     * campaign. This value is not the same as the campaign identifier that Amazon Pinpoint assigns to campaigns that
     * you create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this
     *         identifier to a campaign. This value is not the same as the campaign identifier that Amazon Pinpoint
     *         assigns to campaigns that you create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint
     *         console.
     */
    public String campaignId() {
        return campaignId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaignId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainDeliverabilityCampaignRequest)) {
            return false;
        }
        GetDomainDeliverabilityCampaignRequest other = (GetDomainDeliverabilityCampaignRequest) obj;
        return Objects.equals(campaignId(), other.campaignId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDomainDeliverabilityCampaignRequest").add("CampaignId", campaignId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignId":
            return Optional.ofNullable(clazz.cast(campaignId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainDeliverabilityCampaignRequest, T> g) {
        return obj -> g.apply((GetDomainDeliverabilityCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDomainDeliverabilityCampaignRequest> {
        /**
         * <p>
         * The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this identifier
         * to a campaign. This value is not the same as the campaign identifier that Amazon Pinpoint assigns to
         * campaigns that you create and manage by using the Amazon Pinpoint API or the Amazon Pinpoint console.
         * </p>
         * 
         * @param campaignId
         *        The unique identifier for the campaign. Amazon Pinpoint automatically generates and assigns this
         *        identifier to a campaign. This value is not the same as the campaign identifier that Amazon Pinpoint
         *        assigns to campaigns that you create and manage by using the Amazon Pinpoint API or the Amazon
         *        Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignId(String campaignId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointEmailRequest.BuilderImpl implements Builder {
        private String campaignId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainDeliverabilityCampaignRequest model) {
            super(model);
            campaignId(model.campaignId);
        }

        public final String getCampaignId() {
            return campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDomainDeliverabilityCampaignRequest build() {
            return new GetDomainDeliverabilityCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
