/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointemail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that includes statistics that are related to the domain that you specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainStatisticsReportResponse extends PinpointEmailResponse implements
        ToCopyableBuilder<GetDomainStatisticsReportResponse.Builder, GetDomainStatisticsReportResponse> {
    private static final SdkField<OverallVolume> OVERALL_VOLUME_FIELD = SdkField
            .<OverallVolume> builder(MarshallingType.SDK_POJO).getter(getter(GetDomainStatisticsReportResponse::overallVolume))
            .setter(setter(Builder::overallVolume)).constructor(OverallVolume::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverallVolume").build()).build();

    private static final SdkField<List<DailyVolume>> DAILY_VOLUMES_FIELD = SdkField
            .<List<DailyVolume>> builder(MarshallingType.LIST)
            .getter(getter(GetDomainStatisticsReportResponse::dailyVolumes))
            .setter(setter(Builder::dailyVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyVolumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DailyVolume> builder(MarshallingType.SDK_POJO)
                                            .constructor(DailyVolume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERALL_VOLUME_FIELD,
            DAILY_VOLUMES_FIELD));

    private final OverallVolume overallVolume;

    private final List<DailyVolume> dailyVolumes;

    private GetDomainStatisticsReportResponse(BuilderImpl builder) {
        super(builder);
        this.overallVolume = builder.overallVolume;
        this.dailyVolumes = builder.dailyVolumes;
    }

    /**
     * <p>
     * An object that contains deliverability metrics for the domain that you specified. The data in this object is a
     * summary of all of the data that was collected from the <code>StartDate</code> to the <code>EndDate</code>.
     * </p>
     * 
     * @return An object that contains deliverability metrics for the domain that you specified. The data in this object
     *         is a summary of all of the data that was collected from the <code>StartDate</code> to the
     *         <code>EndDate</code>.
     */
    public OverallVolume overallVolume() {
        return overallVolume;
    }

    /**
     * <p>
     * An object that contains deliverability metrics for the domain that you specified. This object contains data for
     * each day, starting on the <code>StartDate</code> and ending on the <code>EndDate</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object that contains deliverability metrics for the domain that you specified. This object contains
     *         data for each day, starting on the <code>StartDate</code> and ending on the <code>EndDate</code>.
     */
    public List<DailyVolume> dailyVolumes() {
        return dailyVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(overallVolume());
        hashCode = 31 * hashCode + Objects.hashCode(dailyVolumes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainStatisticsReportResponse)) {
            return false;
        }
        GetDomainStatisticsReportResponse other = (GetDomainStatisticsReportResponse) obj;
        return Objects.equals(overallVolume(), other.overallVolume()) && Objects.equals(dailyVolumes(), other.dailyVolumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDomainStatisticsReportResponse").add("OverallVolume", overallVolume())
                .add("DailyVolumes", dailyVolumes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OverallVolume":
            return Optional.ofNullable(clazz.cast(overallVolume()));
        case "DailyVolumes":
            return Optional.ofNullable(clazz.cast(dailyVolumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainStatisticsReportResponse, T> g) {
        return obj -> g.apply((GetDomainStatisticsReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointEmailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDomainStatisticsReportResponse> {
        /**
         * <p>
         * An object that contains deliverability metrics for the domain that you specified. The data in this object is
         * a summary of all of the data that was collected from the <code>StartDate</code> to the <code>EndDate</code>.
         * </p>
         * 
         * @param overallVolume
         *        An object that contains deliverability metrics for the domain that you specified. The data in this
         *        object is a summary of all of the data that was collected from the <code>StartDate</code> to the
         *        <code>EndDate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overallVolume(OverallVolume overallVolume);

        /**
         * <p>
         * An object that contains deliverability metrics for the domain that you specified. The data in this object is
         * a summary of all of the data that was collected from the <code>StartDate</code> to the <code>EndDate</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link OverallVolume.Builder} avoiding the need to
         * create one manually via {@link OverallVolume#builder()}.
         *
         * When the {@link Consumer} completes, {@link OverallVolume.Builder#build()} is called immediately and its
         * result is passed to {@link #overallVolume(OverallVolume)}.
         * 
         * @param overallVolume
         *        a consumer that will call methods on {@link OverallVolume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overallVolume(OverallVolume)
         */
        default Builder overallVolume(Consumer<OverallVolume.Builder> overallVolume) {
            return overallVolume(OverallVolume.builder().applyMutation(overallVolume).build());
        }

        /**
         * <p>
         * An object that contains deliverability metrics for the domain that you specified. This object contains data
         * for each day, starting on the <code>StartDate</code> and ending on the <code>EndDate</code>.
         * </p>
         * 
         * @param dailyVolumes
         *        An object that contains deliverability metrics for the domain that you specified. This object contains
         *        data for each day, starting on the <code>StartDate</code> and ending on the <code>EndDate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyVolumes(Collection<DailyVolume> dailyVolumes);

        /**
         * <p>
         * An object that contains deliverability metrics for the domain that you specified. This object contains data
         * for each day, starting on the <code>StartDate</code> and ending on the <code>EndDate</code>.
         * </p>
         * 
         * @param dailyVolumes
         *        An object that contains deliverability metrics for the domain that you specified. This object contains
         *        data for each day, starting on the <code>StartDate</code> and ending on the <code>EndDate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyVolumes(DailyVolume... dailyVolumes);

        /**
         * <p>
         * An object that contains deliverability metrics for the domain that you specified. This object contains data
         * for each day, starting on the <code>StartDate</code> and ending on the <code>EndDate</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DailyVolume>.Builder} avoiding the need to
         * create one manually via {@link List<DailyVolume>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DailyVolume>.Builder#build()} is called immediately and its
         * result is passed to {@link #dailyVolumes(List<DailyVolume>)}.
         * 
         * @param dailyVolumes
         *        a consumer that will call methods on {@link List<DailyVolume>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dailyVolumes(List<DailyVolume>)
         */
        Builder dailyVolumes(Consumer<DailyVolume.Builder>... dailyVolumes);
    }

    static final class BuilderImpl extends PinpointEmailResponse.BuilderImpl implements Builder {
        private OverallVolume overallVolume;

        private List<DailyVolume> dailyVolumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainStatisticsReportResponse model) {
            super(model);
            overallVolume(model.overallVolume);
            dailyVolumes(model.dailyVolumes);
        }

        public final OverallVolume.Builder getOverallVolume() {
            return overallVolume != null ? overallVolume.toBuilder() : null;
        }

        @Override
        public final Builder overallVolume(OverallVolume overallVolume) {
            this.overallVolume = overallVolume;
            return this;
        }

        public final void setOverallVolume(OverallVolume.BuilderImpl overallVolume) {
            this.overallVolume = overallVolume != null ? overallVolume.build() : null;
        }

        public final Collection<DailyVolume.Builder> getDailyVolumes() {
            return dailyVolumes != null ? dailyVolumes.stream().map(DailyVolume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dailyVolumes(Collection<DailyVolume> dailyVolumes) {
            this.dailyVolumes = DailyVolumesCopier.copy(dailyVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dailyVolumes(DailyVolume... dailyVolumes) {
            dailyVolumes(Arrays.asList(dailyVolumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dailyVolumes(Consumer<DailyVolume.Builder>... dailyVolumes) {
            dailyVolumes(Stream.of(dailyVolumes).map(c -> DailyVolume.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDailyVolumes(Collection<DailyVolume.BuilderImpl> dailyVolumes) {
            this.dailyVolumes = DailyVolumesCopier.copyFromBuilder(dailyVolumes);
        }

        @Override
        public GetDomainStatisticsReportResponse build() {
            return new GetDomainStatisticsReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
