/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoice;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.pinpointsmsvoice.model.AlreadyExistsException;
import software.amazon.awssdk.services.pinpointsmsvoice.model.BadRequestException;
import software.amazon.awssdk.services.pinpointsmsvoice.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoice.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoice.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoice.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoice.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoice.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoice.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoice.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoice.model.GetConfigurationSetEventDestinationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoice.model.GetConfigurationSetEventDestinationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoice.model.InternalServiceErrorException;
import software.amazon.awssdk.services.pinpointsmsvoice.model.LimitExceededException;
import software.amazon.awssdk.services.pinpointsmsvoice.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointsmsvoice.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.pinpointsmsvoice.model.NotFoundException;
import software.amazon.awssdk.services.pinpointsmsvoice.model.PinpointSmsVoiceException;
import software.amazon.awssdk.services.pinpointsmsvoice.model.SendVoiceMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoice.model.SendVoiceMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoice.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpointsmsvoice.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoice.model.UpdateConfigurationSetEventDestinationResponse;

/**
 * Service client for accessing Pinpoint SMS Voice. This can be created using the static {@link #builder()} method.
 *
 * Pinpoint SMS and Voice Messaging public facing APIs
 */
@Generated("software.amazon.awssdk:codegen")
public interface PinpointSmsVoiceClient extends SdkClient {
    String SERVICE_NAME = "sms-voice";

    /**
     * Create a {@link PinpointSmsVoiceClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PinpointSmsVoiceClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PinpointSmsVoiceClient}.
     */
    static PinpointSmsVoiceClientBuilder builder() {
        return new DefaultPinpointSmsVoiceClientBuilder();
    }

    /**
     * Create a new configuration set. After you create the configuration set, you can add one or more event
     * destinations to it.
     *
     * @param createConfigurationSetRequest
     *        A request to create a new configuration set.
     * @return Result of the CreateConfigurationSet operation returned by the service.
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws LimitExceededException
     *         LimitExceededException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws AlreadyExistsException
     *         AlreadyExistsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.CreateConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/CreateConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest)
            throws TooManyRequestsException, BadRequestException, LimitExceededException, InternalServiceErrorException,
            AlreadyExistsException, AwsServiceException, SdkClientException, PinpointSmsVoiceException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new configuration set. After you create the configuration set, you can add one or more event
     * destinations to it.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationSetRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationSetRequest.Builder} to create a
     *        request. A request to create a new configuration set.
     * @return Result of the CreateConfigurationSet operation returned by the service.
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws LimitExceededException
     *         LimitExceededException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws AlreadyExistsException
     *         AlreadyExistsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.CreateConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/CreateConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetResponse createConfigurationSet(
            Consumer<CreateConfigurationSetRequest.Builder> createConfigurationSetRequest) throws TooManyRequestsException,
            BadRequestException, LimitExceededException, InternalServiceErrorException, AlreadyExistsException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceException {
        return createConfigurationSet(CreateConfigurationSetRequest.builder().applyMutation(createConfigurationSetRequest)
                .build());
    }

    /**
     * Create a new event destination in a configuration set.
     *
     * @param createConfigurationSetEventDestinationRequest
     *        Create a new event destination in a configuration set.
     * @return Result of the CreateConfigurationSetEventDestination operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException
     * @throws LimitExceededException
     *         LimitExceededException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws NotFoundException
     *         NotFoundException
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws AlreadyExistsException
     *         AlreadyExistsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.CreateConfigurationSetEventDestination
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(
            CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest)
            throws BadRequestException, LimitExceededException, InternalServiceErrorException, NotFoundException,
            TooManyRequestsException, AlreadyExistsException, AwsServiceException, SdkClientException, PinpointSmsVoiceException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new event destination in a configuration set.<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. Create a new event destination in a configuration set.
     * @return Result of the CreateConfigurationSetEventDestination operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException
     * @throws LimitExceededException
     *         LimitExceededException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws NotFoundException
     *         NotFoundException
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws AlreadyExistsException
     *         AlreadyExistsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.CreateConfigurationSetEventDestination
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationSetEventDestinationResponse createConfigurationSetEventDestination(
            Consumer<CreateConfigurationSetEventDestinationRequest.Builder> createConfigurationSetEventDestinationRequest)
            throws BadRequestException, LimitExceededException, InternalServiceErrorException, NotFoundException,
            TooManyRequestsException, AlreadyExistsException, AwsServiceException, SdkClientException, PinpointSmsVoiceException {
        return createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(createConfigurationSetEventDestinationRequest).build());
    }

    /**
     * Deletes an existing configuration set.
     *
     * @param deleteConfigurationSetRequest
     * @return Result of the DeleteConfigurationSet operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.DeleteConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/DeleteConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an existing configuration set.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfigurationSetRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationSetRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConfigurationSet operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.DeleteConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/DeleteConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetResponse deleteConfigurationSet(
            Consumer<DeleteConfigurationSetRequest.Builder> deleteConfigurationSetRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceException {
        return deleteConfigurationSet(DeleteConfigurationSetRequest.builder().applyMutation(deleteConfigurationSetRequest)
                .build());
    }

    /**
     * Deletes an event destination in a configuration set.
     *
     * @param deleteConfigurationSetEventDestinationRequest
     * @return Result of the DeleteConfigurationSetEventDestination operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.DeleteConfigurationSetEventDestination
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(
            DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an event destination in a configuration set.<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationSetEventDestinationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteConfigurationSetEventDestination operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.DeleteConfigurationSetEventDestination
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationSetEventDestinationResponse deleteConfigurationSetEventDestination(
            Consumer<DeleteConfigurationSetEventDestinationRequest.Builder> deleteConfigurationSetEventDestinationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceException {
        return deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest.builder()
                .applyMutation(deleteConfigurationSetEventDestinationRequest).build());
    }

    /**
     * Obtain information about an event destination, including the types of events it reports, the Amazon Resource Name
     * (ARN) of the destination, and the name of the event destination.
     *
     * @param getConfigurationSetEventDestinationsRequest
     * @return Result of the GetConfigurationSetEventDestinations operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.GetConfigurationSetEventDestinations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/GetConfigurationSetEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationSetEventDestinationsResponse getConfigurationSetEventDestinations(
            GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceException {
        throw new UnsupportedOperationException();
    }

    /**
     * Obtain information about an event destination, including the types of events it reports, the Amazon Resource Name
     * (ARN) of the destination, and the name of the event destination.<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetConfigurationSetEventDestinationsRequest.Builder} avoiding the need to create one manually via
     * {@link GetConfigurationSetEventDestinationsRequest#builder()}
     * </p>
     *
     * @param getConfigurationSetEventDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link GetConfigurationSetEventDestinationsRequest.Builder}
     *        to create a request.
     * @return Result of the GetConfigurationSetEventDestinations operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.GetConfigurationSetEventDestinations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/GetConfigurationSetEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationSetEventDestinationsResponse getConfigurationSetEventDestinations(
            Consumer<GetConfigurationSetEventDestinationsRequest.Builder> getConfigurationSetEventDestinationsRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceException {
        return getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest.builder()
                .applyMutation(getConfigurationSetEventDestinationsRequest).build());
    }

    /**
     * List all of the configuration sets associated with your Amazon Pinpoint account in the current region.
     *
     * @param listConfigurationSetsRequest
     * @return Result of the ListConfigurationSets operation returned by the service.
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/ListConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationSetsResponse listConfigurationSets(ListConfigurationSetsRequest listConfigurationSetsRequest)
            throws TooManyRequestsException, BadRequestException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceException {
        throw new UnsupportedOperationException();
    }

    /**
     * List all of the configuration sets associated with your Amazon Pinpoint account in the current region.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigurationSetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListConfigurationSets operation returned by the service.
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/ListConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationSetsResponse listConfigurationSets(
            Consumer<ListConfigurationSetsRequest.Builder> listConfigurationSetsRequest) throws TooManyRequestsException,
            BadRequestException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceException {
        return listConfigurationSets(ListConfigurationSetsRequest.builder().applyMutation(listConfigurationSetsRequest).build());
    }

    /**
     * Create a new voice message and send it to a recipient's phone number.
     *
     * @param sendVoiceMessageRequest
     *        SendVoiceMessageRequest
     * @return Result of the SendVoiceMessage operation returned by the service.
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.SendVoiceMessage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/SendVoiceMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default SendVoiceMessageResponse sendVoiceMessage(SendVoiceMessageRequest sendVoiceMessageRequest)
            throws TooManyRequestsException, BadRequestException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new voice message and send it to a recipient's phone number.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendVoiceMessageRequest.Builder} avoiding the need
     * to create one manually via {@link SendVoiceMessageRequest#builder()}
     * </p>
     *
     * @param sendVoiceMessageRequest
     *        A {@link Consumer} that will call methods on {@link SendVoiceMessageRequest.Builder} to create a request.
     *        SendVoiceMessageRequest
     * @return Result of the SendVoiceMessage operation returned by the service.
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.SendVoiceMessage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/SendVoiceMessage"
     *      target="_top">AWS API Documentation</a>
     */
    default SendVoiceMessageResponse sendVoiceMessage(Consumer<SendVoiceMessageRequest.Builder> sendVoiceMessageRequest)
            throws TooManyRequestsException, BadRequestException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceException {
        return sendVoiceMessage(SendVoiceMessageRequest.builder().applyMutation(sendVoiceMessageRequest).build());
    }

    /**
     * Update an event destination in a configuration set. An event destination is a location that you publish
     * information about your voice calls to. For example, you can log an event to an Amazon CloudWatch destination when
     * a call fails.
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        UpdateConfigurationSetEventDestinationRequest
     * @return Result of the UpdateConfigurationSetEventDestination operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.UpdateConfigurationSetEventDestination
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(
            UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an event destination in a configuration set. An event destination is a location that you publish
     * information about your voice calls to. For example, you can log an event to an Amazon CloudWatch destination when
     * a call fails.<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. UpdateConfigurationSetEventDestinationRequest
     * @return Result of the UpdateConfigurationSetEventDestination operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException
     * @throws TooManyRequestsException
     *         TooManyRequestsException
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServiceErrorException
     *         InternalServiceErrorException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceClient.UpdateConfigurationSetEventDestination
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-2018-09-05/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationSetEventDestinationResponse updateConfigurationSetEventDestination(
            Consumer<UpdateConfigurationSetEventDestinationRequest.Builder> updateConfigurationSetEventDestinationRequest)
            throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceException {
        return updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(updateConfigurationSetEventDestinationRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("sms-voice.pinpoint");
    }
}
