/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * UpdateConfigurationSetEventDestinationRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationSetEventDestinationRequest extends PinpointSmsVoiceRequest implements
        ToCopyableBuilder<UpdateConfigurationSetEventDestinationRequest.Builder, UpdateConfigurationSetEventDestinationRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateConfigurationSetEventDestinationRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationSetName").build()).build();

    private static final SdkField<EventDestinationDefinition> EVENT_DESTINATION_FIELD = SdkField
            .<EventDestinationDefinition> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateConfigurationSetEventDestinationRequest::eventDestination))
            .setter(setter(Builder::eventDestination)).constructor(EventDestinationDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestination").build()).build();

    private static final SdkField<String> EVENT_DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateConfigurationSetEventDestinationRequest::eventDestinationName))
            .setter(setter(Builder::eventDestinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EventDestinationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            EVENT_DESTINATION_FIELD, EVENT_DESTINATION_NAME_FIELD));

    private final String configurationSetName;

    private final EventDestinationDefinition eventDestination;

    private final String eventDestinationName;

    private UpdateConfigurationSetEventDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.eventDestination = builder.eventDestination;
        this.eventDestinationName = builder.eventDestinationName;
    }

    /**
     * ConfigurationSetName
     * 
     * @return ConfigurationSetName
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * Returns the value of the EventDestination property for this object.
     * 
     * @return The value of the EventDestination property for this object.
     */
    public EventDestinationDefinition eventDestination() {
        return eventDestination;
    }

    /**
     * EventDestinationName
     * 
     * @return EventDestinationName
     */
    public String eventDestinationName() {
        return eventDestinationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(eventDestination());
        hashCode = 31 * hashCode + Objects.hashCode(eventDestinationName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationSetEventDestinationRequest)) {
            return false;
        }
        UpdateConfigurationSetEventDestinationRequest other = (UpdateConfigurationSetEventDestinationRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(eventDestination(), other.eventDestination())
                && Objects.equals(eventDestinationName(), other.eventDestinationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateConfigurationSetEventDestinationRequest")
                .add("ConfigurationSetName", configurationSetName()).add("EventDestination", eventDestination())
                .add("EventDestinationName", eventDestinationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "EventDestination":
            return Optional.ofNullable(clazz.cast(eventDestination()));
        case "EventDestinationName":
            return Optional.ofNullable(clazz.cast(eventDestinationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationSetEventDestinationRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationSetEventDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfigurationSetEventDestinationRequest> {
        /**
         * ConfigurationSetName
         * 
         * @param configurationSetName
         *        ConfigurationSetName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * Sets the value of the EventDestination property for this object.
         *
         * @param eventDestination
         *        The new value for the EventDestination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestination(EventDestinationDefinition eventDestination);

        /**
         * Sets the value of the EventDestination property for this object.
         *
         * This is a convenience that creates an instance of the {@link EventDestinationDefinition.Builder} avoiding the
         * need to create one manually via {@link EventDestinationDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventDestinationDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #eventDestination(EventDestinationDefinition)}.
         * 
         * @param eventDestination
         *        a consumer that will call methods on {@link EventDestinationDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDestination(EventDestinationDefinition)
         */
        default Builder eventDestination(Consumer<EventDestinationDefinition.Builder> eventDestination) {
            return eventDestination(EventDestinationDefinition.builder().applyMutation(eventDestination).build());
        }

        /**
         * EventDestinationName
         * 
         * @param eventDestinationName
         *        EventDestinationName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDestinationName(String eventDestinationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceRequest.BuilderImpl implements Builder {
        private String configurationSetName;

        private EventDestinationDefinition eventDestination;

        private String eventDestinationName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationSetEventDestinationRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            eventDestination(model.eventDestination);
            eventDestinationName(model.eventDestinationName);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final EventDestinationDefinition.Builder getEventDestination() {
            return eventDestination != null ? eventDestination.toBuilder() : null;
        }

        @Override
        public final Builder eventDestination(EventDestinationDefinition eventDestination) {
            this.eventDestination = eventDestination;
            return this;
        }

        public final void setEventDestination(EventDestinationDefinition.BuilderImpl eventDestination) {
            this.eventDestination = eventDestination != null ? eventDestination.build() : null;
        }

        public final String getEventDestinationName() {
            return eventDestinationName;
        }

        @Override
        public final Builder eventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
            return this;
        }

        public final void setEventDestinationName(String eventDestinationName) {
            this.eventDestinationName = eventDestinationName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationSetEventDestinationRequest build() {
            return new UpdateConfigurationSetEventDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
