/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An object that defines a single event destination.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventDestinationDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<EventDestinationDefinition.Builder, EventDestinationDefinition> {
    private static final SdkField<CloudWatchLogsDestination> CLOUD_WATCH_LOGS_DESTINATION_FIELD = SdkField
            .<CloudWatchLogsDestination> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLogsDestination")
            .getter(getter(EventDestinationDefinition::cloudWatchLogsDestination))
            .setter(setter(Builder::cloudWatchLogsDestination)).constructor(CloudWatchLogsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsDestination").build())
            .build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(EventDestinationDefinition::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<KinesisFirehoseDestination> KINESIS_FIREHOSE_DESTINATION_FIELD = SdkField
            .<KinesisFirehoseDestination> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisFirehoseDestination")
            .getter(getter(EventDestinationDefinition::kinesisFirehoseDestination))
            .setter(setter(Builder::kinesisFirehoseDestination))
            .constructor(KinesisFirehoseDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseDestination").build())
            .build();

    private static final SdkField<List<String>> MATCHING_EVENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchingEventTypes")
            .getter(getter(EventDestinationDefinition::matchingEventTypesAsStrings))
            .setter(setter(Builder::matchingEventTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchingEventTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SnsDestination> SNS_DESTINATION_FIELD = SdkField
            .<SnsDestination> builder(MarshallingType.SDK_POJO).memberName("SnsDestination")
            .getter(getter(EventDestinationDefinition::snsDestination)).setter(setter(Builder::snsDestination))
            .constructor(SnsDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsDestination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOGS_DESTINATION_FIELD, ENABLED_FIELD, KINESIS_FIREHOSE_DESTINATION_FIELD, MATCHING_EVENT_TYPES_FIELD,
            SNS_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudWatchLogsDestination cloudWatchLogsDestination;

    private final Boolean enabled;

    private final KinesisFirehoseDestination kinesisFirehoseDestination;

    private final List<String> matchingEventTypes;

    private final SnsDestination snsDestination;

    private EventDestinationDefinition(BuilderImpl builder) {
        this.cloudWatchLogsDestination = builder.cloudWatchLogsDestination;
        this.enabled = builder.enabled;
        this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
        this.matchingEventTypes = builder.matchingEventTypes;
        this.snsDestination = builder.snsDestination;
    }

    /**
     * Returns the value of the CloudWatchLogsDestination property for this object.
     * 
     * @return The value of the CloudWatchLogsDestination property for this object.
     */
    public CloudWatchLogsDestination cloudWatchLogsDestination() {
        return cloudWatchLogsDestination;
    }

    /**
     * Indicates whether or not the event destination is enabled. If the event destination is enabled, then Amazon
     * Pinpoint sends response data to the specified event destination.
     * 
     * @return Indicates whether or not the event destination is enabled. If the event destination is enabled, then
     *         Amazon Pinpoint sends response data to the specified event destination.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * Returns the value of the KinesisFirehoseDestination property for this object.
     * 
     * @return The value of the KinesisFirehoseDestination property for this object.
     */
    public KinesisFirehoseDestination kinesisFirehoseDestination() {
        return kinesisFirehoseDestination;
    }

    /**
     * Returns the value of the MatchingEventTypes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchingEventTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the MatchingEventTypes property for this object.
     */
    public List<EventType> matchingEventTypes() {
        return EventTypesCopier.copyStringToEnum(matchingEventTypes);
    }

    /**
     * Returns true if the MatchingEventTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMatchingEventTypes() {
        return matchingEventTypes != null && !(matchingEventTypes instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the MatchingEventTypes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchingEventTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the MatchingEventTypes property for this object.
     */
    public List<String> matchingEventTypesAsStrings() {
        return matchingEventTypes;
    }

    /**
     * Returns the value of the SnsDestination property for this object.
     * 
     * @return The value of the SnsDestination property for this object.
     */
    public SnsDestination snsDestination() {
        return snsDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseDestination());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchingEventTypes() ? matchingEventTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snsDestination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDestinationDefinition)) {
            return false;
        }
        EventDestinationDefinition other = (EventDestinationDefinition) obj;
        return Objects.equals(cloudWatchLogsDestination(), other.cloudWatchLogsDestination())
                && Objects.equals(enabled(), other.enabled())
                && Objects.equals(kinesisFirehoseDestination(), other.kinesisFirehoseDestination())
                && hasMatchingEventTypes() == other.hasMatchingEventTypes()
                && Objects.equals(matchingEventTypesAsStrings(), other.matchingEventTypesAsStrings())
                && Objects.equals(snsDestination(), other.snsDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EventDestinationDefinition").add("CloudWatchLogsDestination", cloudWatchLogsDestination())
                .add("Enabled", enabled()).add("KinesisFirehoseDestination", kinesisFirehoseDestination())
                .add("MatchingEventTypes", hasMatchingEventTypes() ? matchingEventTypesAsStrings() : null)
                .add("SnsDestination", snsDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogsDestination":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsDestination()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "KinesisFirehoseDestination":
            return Optional.ofNullable(clazz.cast(kinesisFirehoseDestination()));
        case "MatchingEventTypes":
            return Optional.ofNullable(clazz.cast(matchingEventTypesAsStrings()));
        case "SnsDestination":
            return Optional.ofNullable(clazz.cast(snsDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventDestinationDefinition, T> g) {
        return obj -> g.apply((EventDestinationDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventDestinationDefinition> {
        /**
         * Sets the value of the CloudWatchLogsDestination property for this object.
         *
         * @param cloudWatchLogsDestination
         *        The new value for the CloudWatchLogsDestination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsDestination(CloudWatchLogsDestination cloudWatchLogsDestination);

        /**
         * Sets the value of the CloudWatchLogsDestination property for this object.
         *
         * This is a convenience that creates an instance of the {@link CloudWatchLogsDestination.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLogsDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLogsDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLogsDestination(CloudWatchLogsDestination)}.
         * 
         * @param cloudWatchLogsDestination
         *        a consumer that will call methods on {@link CloudWatchLogsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsDestination(CloudWatchLogsDestination)
         */
        default Builder cloudWatchLogsDestination(Consumer<CloudWatchLogsDestination.Builder> cloudWatchLogsDestination) {
            return cloudWatchLogsDestination(CloudWatchLogsDestination.builder().applyMutation(cloudWatchLogsDestination).build());
        }

        /**
         * Indicates whether or not the event destination is enabled. If the event destination is enabled, then Amazon
         * Pinpoint sends response data to the specified event destination.
         * 
         * @param enabled
         *        Indicates whether or not the event destination is enabled. If the event destination is enabled, then
         *        Amazon Pinpoint sends response data to the specified event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * Sets the value of the KinesisFirehoseDestination property for this object.
         *
         * @param kinesisFirehoseDestination
         *        The new value for the KinesisFirehoseDestination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination);

        /**
         * Sets the value of the KinesisFirehoseDestination property for this object.
         *
         * This is a convenience that creates an instance of the {@link KinesisFirehoseDestination.Builder} avoiding the
         * need to create one manually via {@link KinesisFirehoseDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #kinesisFirehoseDestination(KinesisFirehoseDestination)}.
         * 
         * @param kinesisFirehoseDestination
         *        a consumer that will call methods on {@link KinesisFirehoseDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseDestination(KinesisFirehoseDestination)
         */
        default Builder kinesisFirehoseDestination(Consumer<KinesisFirehoseDestination.Builder> kinesisFirehoseDestination) {
            return kinesisFirehoseDestination(KinesisFirehoseDestination.builder().applyMutation(kinesisFirehoseDestination)
                    .build());
        }

        /**
         * Sets the value of the MatchingEventTypes property for this object.
         *
         * @param matchingEventTypes
         *        The new value for the MatchingEventTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypesWithStrings(Collection<String> matchingEventTypes);

        /**
         * Sets the value of the MatchingEventTypes property for this object.
         *
         * @param matchingEventTypes
         *        The new value for the MatchingEventTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypesWithStrings(String... matchingEventTypes);

        /**
         * Sets the value of the MatchingEventTypes property for this object.
         *
         * @param matchingEventTypes
         *        The new value for the MatchingEventTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypes(Collection<EventType> matchingEventTypes);

        /**
         * Sets the value of the MatchingEventTypes property for this object.
         *
         * @param matchingEventTypes
         *        The new value for the MatchingEventTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingEventTypes(EventType... matchingEventTypes);

        /**
         * Sets the value of the SnsDestination property for this object.
         *
         * @param snsDestination
         *        The new value for the SnsDestination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsDestination(SnsDestination snsDestination);

        /**
         * Sets the value of the SnsDestination property for this object.
         *
         * This is a convenience that creates an instance of the {@link SnsDestination.Builder} avoiding the need to
         * create one manually via {@link SnsDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnsDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #snsDestination(SnsDestination)}.
         * 
         * @param snsDestination
         *        a consumer that will call methods on {@link SnsDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snsDestination(SnsDestination)
         */
        default Builder snsDestination(Consumer<SnsDestination.Builder> snsDestination) {
            return snsDestination(SnsDestination.builder().applyMutation(snsDestination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchLogsDestination cloudWatchLogsDestination;

        private Boolean enabled;

        private KinesisFirehoseDestination kinesisFirehoseDestination;

        private List<String> matchingEventTypes = DefaultSdkAutoConstructList.getInstance();

        private SnsDestination snsDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDestinationDefinition model) {
            cloudWatchLogsDestination(model.cloudWatchLogsDestination);
            enabled(model.enabled);
            kinesisFirehoseDestination(model.kinesisFirehoseDestination);
            matchingEventTypesWithStrings(model.matchingEventTypes);
            snsDestination(model.snsDestination);
        }

        public final CloudWatchLogsDestination.Builder getCloudWatchLogsDestination() {
            return cloudWatchLogsDestination != null ? cloudWatchLogsDestination.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLogsDestination(CloudWatchLogsDestination cloudWatchLogsDestination) {
            this.cloudWatchLogsDestination = cloudWatchLogsDestination;
            return this;
        }

        public final void setCloudWatchLogsDestination(CloudWatchLogsDestination.BuilderImpl cloudWatchLogsDestination) {
            this.cloudWatchLogsDestination = cloudWatchLogsDestination != null ? cloudWatchLogsDestination.build() : null;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final KinesisFirehoseDestination.Builder getKinesisFirehoseDestination() {
            return kinesisFirehoseDestination != null ? kinesisFirehoseDestination.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination;
            return this;
        }

        public final void setKinesisFirehoseDestination(KinesisFirehoseDestination.BuilderImpl kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination != null ? kinesisFirehoseDestination.build() : null;
        }

        public final Collection<String> getMatchingEventTypes() {
            if (matchingEventTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return matchingEventTypes;
        }

        @Override
        public final Builder matchingEventTypesWithStrings(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypesWithStrings(String... matchingEventTypes) {
            matchingEventTypesWithStrings(Arrays.asList(matchingEventTypes));
            return this;
        }

        @Override
        public final Builder matchingEventTypes(Collection<EventType> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copyEnumToString(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypes(EventType... matchingEventTypes) {
            matchingEventTypes(Arrays.asList(matchingEventTypes));
            return this;
        }

        public final void setMatchingEventTypes(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
        }

        public final SnsDestination.Builder getSnsDestination() {
            return snsDestination != null ? snsDestination.toBuilder() : null;
        }

        @Override
        public final Builder snsDestination(SnsDestination snsDestination) {
            this.snsDestination = snsDestination;
            return this;
        }

        public final void setSnsDestination(SnsDestination.BuilderImpl snsDestination) {
            this.snsDestination = snsDestination != null ? snsDestination.build() : null;
        }

        @Override
        public EventDestinationDefinition build() {
            return new EventDestinationDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
