/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An object that defines a message that contains SSML-formatted text.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SSMLMessageType implements SdkPojo, Serializable, ToCopyableBuilder<SSMLMessageType.Builder, SSMLMessageType> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(SSMLMessageType::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(SSMLMessageType::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> VOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceId").getter(getter(SSMLMessageType::voiceId)).setter(setter(Builder::voiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            TEXT_FIELD, VOICE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String languageCode;

    private final String text;

    private final String voiceId;

    private SSMLMessageType(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.text = builder.text;
        this.voiceId = builder.voiceId;
    }

    /**
     * The language to use when delivering the message. For a complete list of supported languages, see the Amazon Polly
     * Developer Guide.
     * 
     * @return The language to use when delivering the message. For a complete list of supported languages, see the
     *         Amazon Polly Developer Guide.
     */
    public final String languageCode() {
        return languageCode;
    }

    /**
     * The SSML-formatted text to deliver to the recipient.
     * 
     * @return The SSML-formatted text to deliver to the recipient.
     */
    public final String text() {
        return text;
    }

    /**
     * The name of the voice that you want to use to deliver the message. For a complete list of supported voices, see
     * the Amazon Polly Developer Guide.
     * 
     * @return The name of the voice that you want to use to deliver the message. For a complete list of supported
     *         voices, see the Amazon Polly Developer Guide.
     */
    public final String voiceId() {
        return voiceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(voiceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSMLMessageType)) {
            return false;
        }
        SSMLMessageType other = (SSMLMessageType) obj;
        return Objects.equals(languageCode(), other.languageCode()) && Objects.equals(text(), other.text())
                && Objects.equals(voiceId(), other.voiceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SSMLMessageType").add("LanguageCode", languageCode()).add("Text", text())
                .add("VoiceId", voiceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "VoiceId":
            return Optional.ofNullable(clazz.cast(voiceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SSMLMessageType, T> g) {
        return obj -> g.apply((SSMLMessageType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SSMLMessageType> {
        /**
         * The language to use when delivering the message. For a complete list of supported languages, see the Amazon
         * Polly Developer Guide.
         * 
         * @param languageCode
         *        The language to use when delivering the message. For a complete list of supported languages, see the
         *        Amazon Polly Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * The SSML-formatted text to deliver to the recipient.
         * 
         * @param text
         *        The SSML-formatted text to deliver to the recipient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * The name of the voice that you want to use to deliver the message. For a complete list of supported voices,
         * see the Amazon Polly Developer Guide.
         * 
         * @param voiceId
         *        The name of the voice that you want to use to deliver the message. For a complete list of supported
         *        voices, see the Amazon Polly Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceId(String voiceId);
    }

    static final class BuilderImpl implements Builder {
        private String languageCode;

        private String text;

        private String voiceId;

        private BuilderImpl() {
        }

        private BuilderImpl(SSMLMessageType model) {
            languageCode(model.languageCode);
            text(model.text);
            voiceId(model.voiceId);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getText() {
            return text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getVoiceId() {
            return voiceId;
        }

        @Override
        public final Builder voiceId(String voiceId) {
            this.voiceId = voiceId;
            return this;
        }

        public final void setVoiceId(String voiceId) {
            this.voiceId = voiceId;
        }

        @Override
        public SSMLMessageType build() {
            return new SSMLMessageType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
