/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * SendVoiceMessageRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendVoiceMessageRequest extends PinpointSmsVoiceRequest implements
        ToCopyableBuilder<SendVoiceMessageRequest.Builder, SendVoiceMessageRequest> {
    private static final SdkField<String> CALLER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallerId").getter(getter(SendVoiceMessageRequest::callerId)).setter(setter(Builder::callerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerId").build()).build();

    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSetName").getter(getter(SendVoiceMessageRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<VoiceMessageContent> CONTENT_FIELD = SdkField
            .<VoiceMessageContent> builder(MarshallingType.SDK_POJO).memberName("Content")
            .getter(getter(SendVoiceMessageRequest::content)).setter(setter(Builder::content))
            .constructor(VoiceMessageContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationPhoneNumber").getter(getter(SendVoiceMessageRequest::destinationPhoneNumber))
            .setter(setter(Builder::destinationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build())
            .build();

    private static final SdkField<String> ORIGINATION_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationPhoneNumber").getter(getter(SendVoiceMessageRequest::originationPhoneNumber))
            .setter(setter(Builder::originationPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationPhoneNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_ID_FIELD,
            CONFIGURATION_SET_NAME_FIELD, CONTENT_FIELD, DESTINATION_PHONE_NUMBER_FIELD, ORIGINATION_PHONE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CallerId", CALLER_ID_FIELD);
                    put("ConfigurationSetName", CONFIGURATION_SET_NAME_FIELD);
                    put("Content", CONTENT_FIELD);
                    put("DestinationPhoneNumber", DESTINATION_PHONE_NUMBER_FIELD);
                    put("OriginationPhoneNumber", ORIGINATION_PHONE_NUMBER_FIELD);
                }
            });

    private final String callerId;

    private final String configurationSetName;

    private final VoiceMessageContent content;

    private final String destinationPhoneNumber;

    private final String originationPhoneNumber;

    private SendVoiceMessageRequest(BuilderImpl builder) {
        super(builder);
        this.callerId = builder.callerId;
        this.configurationSetName = builder.configurationSetName;
        this.content = builder.content;
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.originationPhoneNumber = builder.originationPhoneNumber;
    }

    /**
     * The phone number that appears on recipients' devices when they receive the message.
     * 
     * @return The phone number that appears on recipients' devices when they receive the message.
     */
    public final String callerId() {
        return callerId;
    }

    /**
     * The name of the configuration set that you want to use to send the message.
     * 
     * @return The name of the configuration set that you want to use to send the message.
     */
    public final String configurationSetName() {
        return configurationSetName;
    }

    /**
     * Returns the value of the Content property for this object.
     * 
     * @return The value of the Content property for this object.
     */
    public final VoiceMessageContent content() {
        return content;
    }

    /**
     * The phone number that you want to send the voice message to.
     * 
     * @return The phone number that you want to send the voice message to.
     */
    public final String destinationPhoneNumber() {
        return destinationPhoneNumber;
    }

    /**
     * The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone
     * number that appears on recipients' devices when they receive the message, because you can specify a CallerId
     * parameter in the request.
     * 
     * @return The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the
     *         phone number that appears on recipients' devices when they receive the message, because you can specify a
     *         CallerId parameter in the request.
     */
    public final String originationPhoneNumber() {
        return originationPhoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callerId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(originationPhoneNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendVoiceMessageRequest)) {
            return false;
        }
        SendVoiceMessageRequest other = (SendVoiceMessageRequest) obj;
        return Objects.equals(callerId(), other.callerId())
                && Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(content(), other.content())
                && Objects.equals(destinationPhoneNumber(), other.destinationPhoneNumber())
                && Objects.equals(originationPhoneNumber(), other.originationPhoneNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendVoiceMessageRequest").add("CallerId", callerId())
                .add("ConfigurationSetName", configurationSetName()).add("Content", content())
                .add("DestinationPhoneNumber", destinationPhoneNumber()).add("OriginationPhoneNumber", originationPhoneNumber())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerId":
            return Optional.ofNullable(clazz.cast(callerId()));
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "DestinationPhoneNumber":
            return Optional.ofNullable(clazz.cast(destinationPhoneNumber()));
        case "OriginationPhoneNumber":
            return Optional.ofNullable(clazz.cast(originationPhoneNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SendVoiceMessageRequest, T> g) {
        return obj -> g.apply((SendVoiceMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendVoiceMessageRequest> {
        /**
         * The phone number that appears on recipients' devices when they receive the message.
         * 
         * @param callerId
         *        The phone number that appears on recipients' devices when they receive the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerId(String callerId);

        /**
         * The name of the configuration set that you want to use to send the message.
         * 
         * @param configurationSetName
         *        The name of the configuration set that you want to use to send the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * Sets the value of the Content property for this object.
         *
         * @param content
         *        The new value for the Content property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(VoiceMessageContent content);

        /**
         * Sets the value of the Content property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VoiceMessageContent.Builder} avoiding the
         * need to create one manually via {@link VoiceMessageContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceMessageContent.Builder#build()} is called immediately and
         * its result is passed to {@link #content(VoiceMessageContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link VoiceMessageContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(VoiceMessageContent)
         */
        default Builder content(Consumer<VoiceMessageContent.Builder> content) {
            return content(VoiceMessageContent.builder().applyMutation(content).build());
        }

        /**
         * The phone number that you want to send the voice message to.
         * 
         * @param destinationPhoneNumber
         *        The phone number that you want to send the voice message to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPhoneNumber(String destinationPhoneNumber);

        /**
         * The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the phone
         * number that appears on recipients' devices when they receive the message, because you can specify a CallerId
         * parameter in the request.
         * 
         * @param originationPhoneNumber
         *        The phone number that Amazon Pinpoint should use to send the voice message. This isn't necessarily the
         *        phone number that appears on recipients' devices when they receive the message, because you can
         *        specify a CallerId parameter in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationPhoneNumber(String originationPhoneNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointSmsVoiceRequest.BuilderImpl implements Builder {
        private String callerId;

        private String configurationSetName;

        private VoiceMessageContent content;

        private String destinationPhoneNumber;

        private String originationPhoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SendVoiceMessageRequest model) {
            super(model);
            callerId(model.callerId);
            configurationSetName(model.configurationSetName);
            content(model.content);
            destinationPhoneNumber(model.destinationPhoneNumber);
            originationPhoneNumber(model.originationPhoneNumber);
        }

        public final String getCallerId() {
            return callerId;
        }

        public final void setCallerId(String callerId) {
            this.callerId = callerId;
        }

        @Override
        public final Builder callerId(String callerId) {
            this.callerId = callerId;
            return this;
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final VoiceMessageContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(VoiceMessageContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(VoiceMessageContent content) {
            this.content = content;
            return this;
        }

        public final String getDestinationPhoneNumber() {
            return destinationPhoneNumber;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final String getOriginationPhoneNumber() {
            return originationPhoneNumber;
        }

        public final void setOriginationPhoneNumber(String originationPhoneNumber) {
            this.originationPhoneNumber = originationPhoneNumber;
        }

        @Override
        public final Builder originationPhoneNumber(String originationPhoneNumber) {
            this.originationPhoneNumber = originationPhoneNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendVoiceMessageRequest build() {
            return new SendVoiceMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
