/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An object that contains information about an event destination that sends data to Amazon Kinesis Data Firehose.
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisFirehoseDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisFirehoseDestination.Builder, KinesisFirehoseDestination> {
    private static final SdkField<String> DELIVERY_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStreamArn").getter(getter(KinesisFirehoseDestination::deliveryStreamArn))
            .setter(setter(Builder::deliveryStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamArn").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(KinesisFirehoseDestination::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_ARN_FIELD,
            IAM_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deliveryStreamArn;

    private final String iamRoleArn;

    private KinesisFirehoseDestination(BuilderImpl builder) {
        this.deliveryStreamArn = builder.deliveryStreamArn;
        this.iamRoleArn = builder.iamRoleArn;
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM role that can write data to an Amazon Kinesis Data Firehose stream.
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that can write data to an Amazon Kinesis Data Firehose
     *         stream.
     */
    public final String deliveryStreamArn() {
        return deliveryStreamArn;
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose destination that you want to use in the event
     * destination.
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose destination that you want to use in
     *         the event destination.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseDestination)) {
            return false;
        }
        KinesisFirehoseDestination other = (KinesisFirehoseDestination) obj;
        return Objects.equals(deliveryStreamArn(), other.deliveryStreamArn()) && Objects.equals(iamRoleArn(), other.iamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisFirehoseDestination").add("DeliveryStreamArn", deliveryStreamArn())
                .add("IamRoleArn", iamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamArn":
            return Optional.ofNullable(clazz.cast(deliveryStreamArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeliveryStreamArn", DELIVERY_STREAM_ARN_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisFirehoseDestination, T> g) {
        return obj -> g.apply((KinesisFirehoseDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisFirehoseDestination> {
        /**
         * The Amazon Resource Name (ARN) of an IAM role that can write data to an Amazon Kinesis Data Firehose stream.
         * 
         * @param deliveryStreamArn
         *        The Amazon Resource Name (ARN) of an IAM role that can write data to an Amazon Kinesis Data Firehose
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamArn(String deliveryStreamArn);

        /**
         * The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose destination that you want to use in the
         * event destination.
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose destination that you want to use in
         *        the event destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryStreamArn;

        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseDestination model) {
            deliveryStreamArn(model.deliveryStreamArn);
            iamRoleArn(model.iamRoleArn);
        }

        public final String getDeliveryStreamArn() {
            return deliveryStreamArn;
        }

        public final void setDeliveryStreamArn(String deliveryStreamArn) {
            this.deliveryStreamArn = deliveryStreamArn;
        }

        @Override
        public final Builder deliveryStreamArn(String deliveryStreamArn) {
            this.deliveryStreamArn = deliveryStreamArn;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        @Override
        public KinesisFirehoseDestination build() {
            return new KinesisFirehoseDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
