/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An object that contains a voice message and information about the recipient that you want to send it to.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceMessageContent implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceMessageContent.Builder, VoiceMessageContent> {
    private static final SdkField<CallInstructionsMessageType> CALL_INSTRUCTIONS_MESSAGE_FIELD = SdkField
            .<CallInstructionsMessageType> builder(MarshallingType.SDK_POJO)
            .getter(getter(VoiceMessageContent::callInstructionsMessage)).setter(setter(Builder::callInstructionsMessage))
            .constructor(CallInstructionsMessageType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallInstructionsMessage").build())
            .build();

    private static final SdkField<PlainTextMessageType> PLAIN_TEXT_MESSAGE_FIELD = SdkField
            .<PlainTextMessageType> builder(MarshallingType.SDK_POJO).getter(getter(VoiceMessageContent::plainTextMessage))
            .setter(setter(Builder::plainTextMessage)).constructor(PlainTextMessageType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlainTextMessage").build()).build();

    private static final SdkField<SSMLMessageType> SSML_MESSAGE_FIELD = SdkField
            .<SSMLMessageType> builder(MarshallingType.SDK_POJO).getter(getter(VoiceMessageContent::ssmlMessage))
            .setter(setter(Builder::ssmlMessage)).constructor(SSMLMessageType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSMLMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CALL_INSTRUCTIONS_MESSAGE_FIELD, PLAIN_TEXT_MESSAGE_FIELD, SSML_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final CallInstructionsMessageType callInstructionsMessage;

    private final PlainTextMessageType plainTextMessage;

    private final SSMLMessageType ssmlMessage;

    private VoiceMessageContent(BuilderImpl builder) {
        this.callInstructionsMessage = builder.callInstructionsMessage;
        this.plainTextMessage = builder.plainTextMessage;
        this.ssmlMessage = builder.ssmlMessage;
    }

    /**
     * Returns the value of the CallInstructionsMessage property for this object.
     * 
     * @return The value of the CallInstructionsMessage property for this object.
     */
    public CallInstructionsMessageType callInstructionsMessage() {
        return callInstructionsMessage;
    }

    /**
     * Returns the value of the PlainTextMessage property for this object.
     * 
     * @return The value of the PlainTextMessage property for this object.
     */
    public PlainTextMessageType plainTextMessage() {
        return plainTextMessage;
    }

    /**
     * Returns the value of the SSMLMessage property for this object.
     * 
     * @return The value of the SSMLMessage property for this object.
     */
    public SSMLMessageType ssmlMessage() {
        return ssmlMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callInstructionsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(plainTextMessage());
        hashCode = 31 * hashCode + Objects.hashCode(ssmlMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceMessageContent)) {
            return false;
        }
        VoiceMessageContent other = (VoiceMessageContent) obj;
        return Objects.equals(callInstructionsMessage(), other.callInstructionsMessage())
                && Objects.equals(plainTextMessage(), other.plainTextMessage())
                && Objects.equals(ssmlMessage(), other.ssmlMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VoiceMessageContent").add("CallInstructionsMessage", callInstructionsMessage())
                .add("PlainTextMessage", plainTextMessage()).add("SSMLMessage", ssmlMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallInstructionsMessage":
            return Optional.ofNullable(clazz.cast(callInstructionsMessage()));
        case "PlainTextMessage":
            return Optional.ofNullable(clazz.cast(plainTextMessage()));
        case "SSMLMessage":
            return Optional.ofNullable(clazz.cast(ssmlMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceMessageContent, T> g) {
        return obj -> g.apply((VoiceMessageContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceMessageContent> {
        /**
         * Sets the value of the CallInstructionsMessage property for this object.
         *
         * @param callInstructionsMessage
         *        The new value for the CallInstructionsMessage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callInstructionsMessage(CallInstructionsMessageType callInstructionsMessage);

        /**
         * Sets the value of the CallInstructionsMessage property for this object.
         *
         * This is a convenience that creates an instance of the {@link CallInstructionsMessageType.Builder} avoiding
         * the need to create one manually via {@link CallInstructionsMessageType#builder()}.
         *
         * When the {@link Consumer} completes, {@link CallInstructionsMessageType.Builder#build()} is called
         * immediately and its result is passed to {@link #callInstructionsMessage(CallInstructionsMessageType)}.
         * 
         * @param callInstructionsMessage
         *        a consumer that will call methods on {@link CallInstructionsMessageType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callInstructionsMessage(CallInstructionsMessageType)
         */
        default Builder callInstructionsMessage(Consumer<CallInstructionsMessageType.Builder> callInstructionsMessage) {
            return callInstructionsMessage(CallInstructionsMessageType.builder().applyMutation(callInstructionsMessage).build());
        }

        /**
         * Sets the value of the PlainTextMessage property for this object.
         *
         * @param plainTextMessage
         *        The new value for the PlainTextMessage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plainTextMessage(PlainTextMessageType plainTextMessage);

        /**
         * Sets the value of the PlainTextMessage property for this object.
         *
         * This is a convenience that creates an instance of the {@link PlainTextMessageType.Builder} avoiding the need
         * to create one manually via {@link PlainTextMessageType#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlainTextMessageType.Builder#build()} is called immediately and
         * its result is passed to {@link #plainTextMessage(PlainTextMessageType)}.
         * 
         * @param plainTextMessage
         *        a consumer that will call methods on {@link PlainTextMessageType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #plainTextMessage(PlainTextMessageType)
         */
        default Builder plainTextMessage(Consumer<PlainTextMessageType.Builder> plainTextMessage) {
            return plainTextMessage(PlainTextMessageType.builder().applyMutation(plainTextMessage).build());
        }

        /**
         * Sets the value of the SSMLMessage property for this object.
         *
         * @param ssmlMessage
         *        The new value for the SSMLMessage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmlMessage(SSMLMessageType ssmlMessage);

        /**
         * Sets the value of the SSMLMessage property for this object.
         *
         * This is a convenience that creates an instance of the {@link SSMLMessageType.Builder} avoiding the need to
         * create one manually via {@link SSMLMessageType#builder()}.
         *
         * When the {@link Consumer} completes, {@link SSMLMessageType.Builder#build()} is called immediately and its
         * result is passed to {@link #ssmlMessage(SSMLMessageType)}.
         * 
         * @param ssmlMessage
         *        a consumer that will call methods on {@link SSMLMessageType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmlMessage(SSMLMessageType)
         */
        default Builder ssmlMessage(Consumer<SSMLMessageType.Builder> ssmlMessage) {
            return ssmlMessage(SSMLMessageType.builder().applyMutation(ssmlMessage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CallInstructionsMessageType callInstructionsMessage;

        private PlainTextMessageType plainTextMessage;

        private SSMLMessageType ssmlMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceMessageContent model) {
            callInstructionsMessage(model.callInstructionsMessage);
            plainTextMessage(model.plainTextMessage);
            ssmlMessage(model.ssmlMessage);
        }

        public final CallInstructionsMessageType.Builder getCallInstructionsMessage() {
            return callInstructionsMessage != null ? callInstructionsMessage.toBuilder() : null;
        }

        @Override
        public final Builder callInstructionsMessage(CallInstructionsMessageType callInstructionsMessage) {
            this.callInstructionsMessage = callInstructionsMessage;
            return this;
        }

        public final void setCallInstructionsMessage(CallInstructionsMessageType.BuilderImpl callInstructionsMessage) {
            this.callInstructionsMessage = callInstructionsMessage != null ? callInstructionsMessage.build() : null;
        }

        public final PlainTextMessageType.Builder getPlainTextMessage() {
            return plainTextMessage != null ? plainTextMessage.toBuilder() : null;
        }

        @Override
        public final Builder plainTextMessage(PlainTextMessageType plainTextMessage) {
            this.plainTextMessage = plainTextMessage;
            return this;
        }

        public final void setPlainTextMessage(PlainTextMessageType.BuilderImpl plainTextMessage) {
            this.plainTextMessage = plainTextMessage != null ? plainTextMessage.build() : null;
        }

        public final SSMLMessageType.Builder getSsmlMessage() {
            return ssmlMessage != null ? ssmlMessage.toBuilder() : null;
        }

        @Override
        public final Builder ssmlMessage(SSMLMessageType ssmlMessage) {
            this.ssmlMessage = ssmlMessage;
            return this;
        }

        public final void setSsmlMessage(SSMLMessageType.BuilderImpl ssmlMessage) {
            this.ssmlMessage = ssmlMessage != null ? ssmlMessage.build() : null;
        }

        @Override
        public VoiceMessageContent build() {
            return new VoiceMessageContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
