/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeKeywordsResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<DescribeKeywordsResponse.Builder, DescribeKeywordsResponse> {
    private static final SdkField<String> ORIGINATION_IDENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentityArn").getter(getter(DescribeKeywordsResponse::originationIdentityArn))
            .setter(setter(Builder::originationIdentityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentityArn").build())
            .build();

    private static final SdkField<String> ORIGINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationIdentity").getter(getter(DescribeKeywordsResponse::originationIdentity))
            .setter(setter(Builder::originationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentity").build())
            .build();

    private static final SdkField<List<KeywordInformation>> KEYWORDS_FIELD = SdkField
            .<List<KeywordInformation>> builder(MarshallingType.LIST)
            .memberName("Keywords")
            .getter(getter(DescribeKeywordsResponse::keywords))
            .setter(setter(Builder::keywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeywordInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeywordInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeKeywordsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORIGINATION_IDENTITY_ARN_FIELD, ORIGINATION_IDENTITY_FIELD, KEYWORDS_FIELD, NEXT_TOKEN_FIELD));

    private final String originationIdentityArn;

    private final String originationIdentity;

    private final List<KeywordInformation> keywords;

    private final String nextToken;

    private DescribeKeywordsResponse(BuilderImpl builder) {
        super(builder);
        this.originationIdentityArn = builder.originationIdentityArn;
        this.originationIdentity = builder.originationIdentity;
        this.keywords = builder.keywords;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity.
     * </p>
     * 
     * @return The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity.
     */
    public final String originationIdentityArn() {
        return originationIdentityArn;
    }

    /**
     * <p>
     * The PhoneNumberId or PoolId that is associated with the OriginationIdentity.
     * </p>
     * 
     * @return The PhoneNumberId or PoolId that is associated with the OriginationIdentity.
     */
    public final String originationIdentity() {
        return originationIdentity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keywords property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeywords() {
        return keywords != null && !(keywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of KeywordInformation objects that contain the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeywords} method.
     * </p>
     * 
     * @return An array of KeywordInformation objects that contain the results.
     */
    public final List<KeywordInformation> keywords() {
        return keywords;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. If this field is empty then there are no more
     * results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. If this field is empty then there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentityArn());
        hashCode = 31 * hashCode + Objects.hashCode(originationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeywords() ? keywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeywordsResponse)) {
            return false;
        }
        DescribeKeywordsResponse other = (DescribeKeywordsResponse) obj;
        return Objects.equals(originationIdentityArn(), other.originationIdentityArn())
                && Objects.equals(originationIdentity(), other.originationIdentity()) && hasKeywords() == other.hasKeywords()
                && Objects.equals(keywords(), other.keywords()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeKeywordsResponse").add("OriginationIdentityArn", originationIdentityArn())
                .add("OriginationIdentity", originationIdentity()).add("Keywords", hasKeywords() ? keywords() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginationIdentityArn":
            return Optional.ofNullable(clazz.cast(originationIdentityArn()));
        case "OriginationIdentity":
            return Optional.ofNullable(clazz.cast(originationIdentity()));
        case "Keywords":
            return Optional.ofNullable(clazz.cast(keywords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeywordsResponse, T> g) {
        return obj -> g.apply((DescribeKeywordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeKeywordsResponse> {
        /**
         * <p>
         * The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity.
         * </p>
         * 
         * @param originationIdentityArn
         *        The PhoneNumberArn or PoolArn that is associated with the OriginationIdentity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentityArn(String originationIdentityArn);

        /**
         * <p>
         * The PhoneNumberId or PoolId that is associated with the OriginationIdentity.
         * </p>
         * 
         * @param originationIdentity
         *        The PhoneNumberId or PoolId that is associated with the OriginationIdentity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentity(String originationIdentity);

        /**
         * <p>
         * An array of KeywordInformation objects that contain the results.
         * </p>
         * 
         * @param keywords
         *        An array of KeywordInformation objects that contain the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(Collection<KeywordInformation> keywords);

        /**
         * <p>
         * An array of KeywordInformation objects that contain the results.
         * </p>
         * 
         * @param keywords
         *        An array of KeywordInformation objects that contain the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(KeywordInformation... keywords);

        /**
         * <p>
         * An array of KeywordInformation objects that contain the results.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<KeywordInformation>.Builder}
         * avoiding the need to create one manually via {@link List<KeywordInformation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeywordInformation>.Builder#build()} is called immediately
         * and its result is passed to {@link #keywords(List<KeywordInformation>)}.
         * 
         * @param keywords
         *        a consumer that will call methods on {@link List<KeywordInformation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keywords(List<KeywordInformation>)
         */
        Builder keywords(Consumer<KeywordInformation.Builder>... keywords);

        /**
         * <p>
         * The token to be used for the next set of paginated results. If this field is empty then there are no more
         * results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. If this field is empty then there are no
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String originationIdentityArn;

        private String originationIdentity;

        private List<KeywordInformation> keywords = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeywordsResponse model) {
            super(model);
            originationIdentityArn(model.originationIdentityArn);
            originationIdentity(model.originationIdentity);
            keywords(model.keywords);
            nextToken(model.nextToken);
        }

        public final String getOriginationIdentityArn() {
            return originationIdentityArn;
        }

        public final void setOriginationIdentityArn(String originationIdentityArn) {
            this.originationIdentityArn = originationIdentityArn;
        }

        @Override
        public final Builder originationIdentityArn(String originationIdentityArn) {
            this.originationIdentityArn = originationIdentityArn;
            return this;
        }

        public final String getOriginationIdentity() {
            return originationIdentity;
        }

        public final void setOriginationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
        }

        @Override
        public final Builder originationIdentity(String originationIdentity) {
            this.originationIdentity = originationIdentity;
            return this;
        }

        public final List<KeywordInformation.Builder> getKeywords() {
            List<KeywordInformation.Builder> result = KeywordInformationListCopier.copyToBuilder(this.keywords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeywords(Collection<KeywordInformation.BuilderImpl> keywords) {
            this.keywords = KeywordInformationListCopier.copyFromBuilder(keywords);
        }

        @Override
        public final Builder keywords(Collection<KeywordInformation> keywords) {
            this.keywords = KeywordInformationListCopier.copy(keywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(KeywordInformation... keywords) {
            keywords(Arrays.asList(keywords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(Consumer<KeywordInformation.Builder>... keywords) {
            keywords(Stream.of(keywords).map(c -> KeywordInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeKeywordsResponse build() {
            return new DescribeKeywordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
