/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPoolOriginationIdentitiesResponse extends PinpointSmsVoiceV2Response implements
        ToCopyableBuilder<ListPoolOriginationIdentitiesResponse.Builder, ListPoolOriginationIdentitiesResponse> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolArn").getter(getter(ListPoolOriginationIdentitiesResponse::poolArn))
            .setter(setter(Builder::poolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(ListPoolOriginationIdentitiesResponse::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<List<OriginationIdentityMetadata>> ORIGINATION_IDENTITIES_FIELD = SdkField
            .<List<OriginationIdentityMetadata>> builder(MarshallingType.LIST)
            .memberName("OriginationIdentities")
            .getter(getter(ListPoolOriginationIdentitiesResponse::originationIdentities))
            .setter(setter(Builder::originationIdentities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationIdentities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OriginationIdentityMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(OriginationIdentityMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPoolOriginationIdentitiesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD, POOL_ID_FIELD,
            ORIGINATION_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));

    private final String poolArn;

    private final String poolId;

    private final List<OriginationIdentityMetadata> originationIdentities;

    private final String nextToken;

    private ListPoolOriginationIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.poolArn = builder.poolArn;
        this.poolId = builder.poolId;
        this.originationIdentities = builder.originationIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the pool.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the pool.
     */
    public final String poolArn() {
        return poolArn;
    }

    /**
     * <p>
     * The unique PoolId of the pool.
     * </p>
     * 
     * @return The unique PoolId of the pool.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * For responses, this returns true if the service returned a value for the OriginationIdentities property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOriginationIdentities() {
        return originationIdentities != null && !(originationIdentities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of any OriginationIdentityMetadata objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOriginationIdentities} method.
     * </p>
     * 
     * @return An array of any OriginationIdentityMetadata objects.
     */
    public final List<OriginationIdentityMetadata> originationIdentities() {
        return originationIdentities;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results. If this field is empty then there are no more
     * results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results. If this field is empty then there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(hasOriginationIdentities() ? originationIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoolOriginationIdentitiesResponse)) {
            return false;
        }
        ListPoolOriginationIdentitiesResponse other = (ListPoolOriginationIdentitiesResponse) obj;
        return Objects.equals(poolArn(), other.poolArn()) && Objects.equals(poolId(), other.poolId())
                && hasOriginationIdentities() == other.hasOriginationIdentities()
                && Objects.equals(originationIdentities(), other.originationIdentities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPoolOriginationIdentitiesResponse").add("PoolArn", poolArn()).add("PoolId", poolId())
                .add("OriginationIdentities", hasOriginationIdentities() ? originationIdentities() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolArn":
            return Optional.ofNullable(clazz.cast(poolArn()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "OriginationIdentities":
            return Optional.ofNullable(clazz.cast(originationIdentities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPoolOriginationIdentitiesResponse, T> g) {
        return obj -> g.apply((ListPoolOriginationIdentitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointSmsVoiceV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPoolOriginationIdentitiesResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the pool.
         * </p>
         * 
         * @param poolArn
         *        The Amazon Resource Name (ARN) for the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolArn(String poolArn);

        /**
         * <p>
         * The unique PoolId of the pool.
         * </p>
         * 
         * @param poolId
         *        The unique PoolId of the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * An array of any OriginationIdentityMetadata objects.
         * </p>
         * 
         * @param originationIdentities
         *        An array of any OriginationIdentityMetadata objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentities(Collection<OriginationIdentityMetadata> originationIdentities);

        /**
         * <p>
         * An array of any OriginationIdentityMetadata objects.
         * </p>
         * 
         * @param originationIdentities
         *        An array of any OriginationIdentityMetadata objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationIdentities(OriginationIdentityMetadata... originationIdentities);

        /**
         * <p>
         * An array of any OriginationIdentityMetadata objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <OriginationIdentityMetadata>.Builder} avoiding the need to create one manually via {@link List
         * <OriginationIdentityMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OriginationIdentityMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #originationIdentities(List<OriginationIdentityMetadata>)}.
         * 
         * @param originationIdentities
         *        a consumer that will call methods on {@link List<OriginationIdentityMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originationIdentities(List<OriginationIdentityMetadata>)
         */
        Builder originationIdentities(Consumer<OriginationIdentityMetadata.Builder>... originationIdentities);

        /**
         * <p>
         * The token to be used for the next set of paginated results. If this field is empty then there are no more
         * results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results. If this field is empty then there are no
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PinpointSmsVoiceV2Response.BuilderImpl implements Builder {
        private String poolArn;

        private String poolId;

        private List<OriginationIdentityMetadata> originationIdentities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoolOriginationIdentitiesResponse model) {
            super(model);
            poolArn(model.poolArn);
            poolId(model.poolId);
            originationIdentities(model.originationIdentities);
            nextToken(model.nextToken);
        }

        public final String getPoolArn() {
            return poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final List<OriginationIdentityMetadata.Builder> getOriginationIdentities() {
            List<OriginationIdentityMetadata.Builder> result = OriginationIdentityMetadataListCopier
                    .copyToBuilder(this.originationIdentities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOriginationIdentities(Collection<OriginationIdentityMetadata.BuilderImpl> originationIdentities) {
            this.originationIdentities = OriginationIdentityMetadataListCopier.copyFromBuilder(originationIdentities);
        }

        @Override
        public final Builder originationIdentities(Collection<OriginationIdentityMetadata> originationIdentities) {
            this.originationIdentities = OriginationIdentityMetadataListCopier.copy(originationIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originationIdentities(OriginationIdentityMetadata... originationIdentities) {
            originationIdentities(Arrays.asList(originationIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originationIdentities(Consumer<OriginationIdentityMetadata.Builder>... originationIdentities) {
            originationIdentities(Stream.of(originationIdentities)
                    .map(c -> OriginationIdentityMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPoolOriginationIdentitiesResponse build() {
            return new ListPoolOriginationIdentitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
