/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccessDeniedException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConflictException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeletePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.InternalServerException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Exception;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutKeywordResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ThrottlingException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdateEventDestinationResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ValidationException;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.AssociateOriginationIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreateOptOutListRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.CreatePoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteConfigurationSetRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteDefaultMessageTypeRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteDefaultSenderIdRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteKeywordRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteOptOutListRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteOptedOutNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeletePoolRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteTextMessageSpendLimitOverrideRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DeleteVoiceMessageSpendLimitOverrideRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeConfigurationSetsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeKeywordsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeOptOutListsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeOptedOutNumbersRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribePhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribePoolsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeSenderIdsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DescribeSpendLimitsRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.DisassociateOriginationIdentityRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.ListPoolOriginationIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.PutKeywordRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.PutOptedOutNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.ReleasePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.RequestPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SendTextMessageRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SendVoiceMessageRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SetDefaultMessageTypeRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SetDefaultSenderIdRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SetTextMessageSpendLimitOverrideRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.SetVoiceMessageSpendLimitOverrideRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UpdateEventDestinationRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UpdatePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.pinpointsmsvoicev2.transform.UpdatePoolRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link PinpointSmsVoiceV2Client}.
 *
 * @see PinpointSmsVoiceV2Client#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPinpointSmsVoiceV2Client implements PinpointSmsVoiceV2Client {
    private static final Logger log = Logger.loggerFor(DefaultPinpointSmsVoiceV2Client.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPinpointSmsVoiceV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates the specified origination identity with a pool.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an Error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     * <p>
     * If the origination identity configuration doesn't match the pool's configuration, an Error is returned.
     * </p>
     *
     * @param associateOriginationIdentityRequest
     * @return Result of the AssociateOriginationIdentity operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.AssociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/AssociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateOriginationIdentityResponse associateOriginationIdentity(
            AssociateOriginationIdentityRequest associateOriginationIdentityRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateOriginationIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateOriginationIdentityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateOriginationIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateOriginationIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateOriginationIdentityRequest, AssociateOriginationIdentityResponse>()
                            .withOperationName("AssociateOriginationIdentity").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateOriginationIdentityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateOriginationIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new configuration set. After you create the configuration set, you can add one or more event
     * destinations to it.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to the SMS and voice messages that you send.
     * </p>
     * <p>
     * When you send a message, you can optionally specify a single configuration set.
     * </p>
     *
     * @param createConfigurationSetRequest
     * @return Result of the CreateConfigurationSet operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConfigurationSetResponse createConfigurationSet(CreateConfigurationSetRequest createConfigurationSetRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConfigurationSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConfigurationSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConfigurationSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConfigurationSet");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateConfigurationSetRequest, CreateConfigurationSetResponse>()
                            .withOperationName("CreateConfigurationSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createConfigurationSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateConfigurationSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new event destination in a configuration set.
     * </p>
     * <p>
     * An event destination is a location where you send message events. The event options are Amazon CloudWatch, Amazon
     * Kinesis Data Firehose, or Amazon SNS. For example, when a message is delivered successfully, you can send
     * information about that event to an event destination, or send notifications to endpoints that are subscribed to
     * an Amazon SNS topic.
     * </p>
     * <p>
     * Each configuration set can contain between 0 and 5 event destinations. Each event destination can contain a
     * reference to a single destination, such as a CloudWatch or Kinesis Data Firehose destination.
     * </p>
     *
     * @param createEventDestinationRequest
     * @return Result of the CreateEventDestination operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEventDestinationResponse createEventDestination(CreateEventDestinationRequest createEventDestinationRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEventDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEventDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEventDestinationRequest, CreateEventDestinationResponse>()
                            .withOperationName("CreateEventDestination").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createEventDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEventDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new opt-out list.
     * </p>
     * <p>
     * If the opt-out list name already exists, an Error is returned.
     * </p>
     * <p>
     * An opt-out list is a list of phone numbers that are opted out, meaning you can't send SMS or voice messages to
     * them. If end user replies with the keyword "STOP," an entry for the phone number is added to the opt-out list. In
     * addition to STOP, your recipients can use any supported opt-out keyword, such as CANCEL or OPTOUT. For a list of
     * supported opt-out keywords, see <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-manage.html#channels-sms-manage-optout"> SMS
     * opt out </a> in the <i>Amazon Pinpoint User Guide</i>.
     * </p>
     *
     * @param createOptOutListRequest
     * @return Result of the CreateOptOutList operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreateOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreateOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateOptOutListResponse createOptOutList(CreateOptOutListRequest createOptOutListRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOptOutListResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateOptOutListResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOptOutListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOptOutList");

            return clientHandler.execute(new ClientExecutionParams<CreateOptOutListRequest, CreateOptOutListResponse>()
                    .withOperationName("CreateOptOutList").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createOptOutListRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOptOutListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new pool and associates the specified origination identity to the pool. A pool can include one or more
     * phone numbers and SenderIds that are associated with your Amazon Web Services account.
     * </p>
     * <p>
     * The new pool inherits its configuration from the specified origination identity. This includes keywords, message
     * type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't
     * inherited from the origination identity and defaults to false.
     * </p>
     * <p>
     * If the origination identity is a phone number and is already associated with another pool, an Error is returned.
     * A sender ID can be associated with multiple pools.
     * </p>
     *
     * @param createPoolRequest
     * @return Result of the CreatePool operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.CreatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/CreatePool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePoolResponse createPool(CreatePoolRequest createPoolRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePool");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePoolRequest, CreatePoolResponse>().withOperationName("CreatePool")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createPoolRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing configuration set.
     * </p>
     * <p>
     * A configuration set is a set of rules that you apply to voice and SMS messages that you send. In a configuration
     * set, you can specify a destination for specific types of events related to voice and SMS messages.
     * </p>
     *
     * @param deleteConfigurationSetRequest
     * @return Result of the DeleteConfigurationSet operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteConfigurationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteConfigurationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConfigurationSetResponse deleteConfigurationSet(DeleteConfigurationSetRequest deleteConfigurationSetRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConfigurationSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConfigurationSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConfigurationSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigurationSet");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigurationSetRequest, DeleteConfigurationSetResponse>()
                            .withOperationName("DeleteConfigurationSet").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteConfigurationSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConfigurationSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing default message type on a configuration set.
     * </p>
     * <p>
     * A message type is a type of messages that you plan to send. If you send account-related messages or
     * time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     *
     * @param deleteDefaultMessageTypeRequest
     * @return Result of the DeleteDefaultMessageType operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDefaultMessageTypeResponse deleteDefaultMessageType(
            DeleteDefaultMessageTypeRequest deleteDefaultMessageTypeRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDefaultMessageTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDefaultMessageTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDefaultMessageTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDefaultMessageType");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDefaultMessageTypeRequest, DeleteDefaultMessageTypeResponse>()
                            .withOperationName("DeleteDefaultMessageType").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteDefaultMessageTypeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDefaultMessageTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing default sender ID on a configuration set.
     * </p>
     * <p>
     * A default sender ID is the identity that appears on recipients' devices when they receive SMS messages. Support
     * for sender ID capabilities varies by country or region.
     * </p>
     *
     * @param deleteDefaultSenderIdRequest
     * @return Result of the DeleteDefaultSenderId operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDefaultSenderIdResponse deleteDefaultSenderId(DeleteDefaultSenderIdRequest deleteDefaultSenderIdRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDefaultSenderIdResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDefaultSenderIdResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDefaultSenderIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDefaultSenderId");

            return clientHandler.execute(new ClientExecutionParams<DeleteDefaultSenderIdRequest, DeleteDefaultSenderIdResponse>()
                    .withOperationName("DeleteDefaultSenderId").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDefaultSenderIdRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDefaultSenderIdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing event destination.
     * </p>
     * <p>
     * An event destination is a location where you send response information about the messages that you send. For
     * example, when a message is delivered successfully, you can send information about that event to an Amazon
     * CloudWatch destination, or send notifications to endpoints that are subscribed to an Amazon SNS topic.
     * </p>
     *
     * @param deleteEventDestinationRequest
     * @return Result of the DeleteEventDestination operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEventDestinationResponse deleteEventDestination(DeleteEventDestinationRequest deleteEventDestinationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEventDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEventDestinationRequest, DeleteEventDestinationResponse>()
                            .withOperationName("DeleteEventDestination").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteEventDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEventDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing keyword from an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a
     * customizable message.
     * </p>
     * <p>
     * Keywords "HELP" and "STOP" can't be deleted or modified.
     * </p>
     *
     * @param deleteKeywordRequest
     * @return Result of the DeleteKeyword operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteKeywordResponse deleteKeyword(DeleteKeywordRequest deleteKeywordRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteKeywordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteKeywordResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKeywordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKeyword");

            return clientHandler.execute(new ClientExecutionParams<DeleteKeywordRequest, DeleteKeywordResponse>()
                    .withOperationName("DeleteKeyword").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteKeywordRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteKeywordRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing opt-out list. All opted out phone numbers in the opt-out list are deleted.
     * </p>
     * <p>
     * If the specified opt-out list name doesn't exist or is in-use by an origination phone number or pool, an Error is
     * returned.
     * </p>
     *
     * @param deleteOptOutListRequest
     * @return Result of the DeleteOptOutList operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteOptOutList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptOutList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOptOutListResponse deleteOptOutList(DeleteOptOutListRequest deleteOptOutListRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOptOutListResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteOptOutListResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOptOutListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOptOutList");

            return clientHandler.execute(new ClientExecutionParams<DeleteOptOutListRequest, DeleteOptOutListResponse>()
                    .withOperationName("DeleteOptOutList").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteOptOutListRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOptOutListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing opted out destination phone number from the specified opt-out list.
     * </p>
     * <p>
     * Each destination phone number can only be deleted once every 30 days.
     * </p>
     * <p>
     * If the specified destination phone number doesn't exist or if the opt-out list doesn't exist, an Error is
     * returned.
     * </p>
     *
     * @param deleteOptedOutNumberRequest
     * @return Result of the DeleteOptedOutNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOptedOutNumberResponse deleteOptedOutNumber(DeleteOptedOutNumberRequest deleteOptedOutNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOptedOutNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteOptedOutNumberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOptedOutNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOptedOutNumber");

            return clientHandler.execute(new ClientExecutionParams<DeleteOptedOutNumberRequest, DeleteOptedOutNumberResponse>()
                    .withOperationName("DeleteOptedOutNumber").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteOptedOutNumberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOptedOutNumberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing pool. Deleting a pool disassociates all origination identities from that pool.
     * </p>
     * <p>
     * If the pool status isn't active or if deletion protection is enabled, an Error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param deletePoolRequest
     * @return Result of the DeletePool operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeletePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeletePool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePoolResponse deletePool(DeletePoolRequest deletePoolRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePool");

            return clientHandler
                    .execute(new ClientExecutionParams<DeletePoolRequest, DeletePoolResponse>().withOperationName("DeletePool")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deletePoolRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeletePoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an account-level monthly spending limit override for sending text messages. Deleting a spend limit
     * override will set the <code>EnforcedLimit</code> to equal the <code>MaxLimit</code>, which is controlled by
     * Amazon Web Services. For more information on spend limits (quotas) see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas </a> in the
     * <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     *
     * @param deleteTextMessageSpendLimitOverrideRequest
     * @return Result of the DeleteTextMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTextMessageSpendLimitOverrideResponse deleteTextMessageSpendLimitOverride(
            DeleteTextMessageSpendLimitOverrideRequest deleteTextMessageSpendLimitOverrideRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTextMessageSpendLimitOverrideResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTextMessageSpendLimitOverrideResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteTextMessageSpendLimitOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTextMessageSpendLimitOverride");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTextMessageSpendLimitOverrideRequest, DeleteTextMessageSpendLimitOverrideResponse>()
                            .withOperationName("DeleteTextMessageSpendLimitOverride").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteTextMessageSpendLimitOverrideRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTextMessageSpendLimitOverrideRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an account level monthly spend limit override for sending voice messages. Deleting a spend limit override
     * sets the <code>EnforcedLimit</code> equal to the <code>MaxLimit</code>, which is controlled by Amazon Web
     * Services. For more information on spending limits (quotas) see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html">Amazon Pinpoint quotas</a> in the
     * <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     *
     * @param deleteVoiceMessageSpendLimitOverrideRequest
     * @return Result of the DeleteVoiceMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DeleteVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DeleteVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVoiceMessageSpendLimitOverrideResponse deleteVoiceMessageSpendLimitOverride(
            DeleteVoiceMessageSpendLimitOverrideRequest deleteVoiceMessageSpendLimitOverrideRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVoiceMessageSpendLimitOverrideResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteVoiceMessageSpendLimitOverrideResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteVoiceMessageSpendLimitOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceMessageSpendLimitOverride");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceMessageSpendLimitOverrideRequest, DeleteVoiceMessageSpendLimitOverrideResponse>()
                            .withOperationName("DeleteVoiceMessageSpendLimitOverride").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteVoiceMessageSpendLimitOverrideRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVoiceMessageSpendLimitOverrideRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The supported account attributes include account tier,
     * which indicates whether your account is in the sandbox or production environment. When you're ready to move your
     * account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
     * </p>
     * <p>
     * New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web
     * Services end recipients and SMS or voice recipients from fraud and abuse.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse>()
                            .withOperationName("DescribeAccountAttributes").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAccountAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The supported account attributes include account tier,
     * which indicates whether your account is in the sandbox or production environment. When you're ready to move your
     * account out of the sandbox, create an Amazon Web Services Support case for a service limit increase request.
     * </p>
     * <p>
     * New Amazon Pinpoint accounts are placed into an SMS or voice sandbox. The sandbox protects both Amazon Web
     * Services end recipients and SMS or voice recipients from fraud and abuse.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccountAttributes(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable responses = client.describeAccountAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable responses = client
     *             .describeAccountAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountAttributesIterable responses = client.describeAccountAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountAttributes(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountAttributesIterable describeAccountAttributesPaginator(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeAccountAttributesIterable(this, applyPaginatorUserAgent(describeAccountAttributesRequest));
    }

    /**
     * <p>
     * Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota
     * includes the quota name, current usage toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of
     * configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more
     * information see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html"> Amazon Pinpoint
     * quotas </a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountLimitsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountLimits");

            return clientHandler.execute(new ClientExecutionParams<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse>()
                    .withOperationName("DescribeAccountLimits").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAccountLimitsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAccountLimitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the current Amazon Pinpoint SMS Voice V2 resource quotas for your account. The description for a quota
     * includes the quota name, current usage toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum number of
     * configuration sets, opt-out lists, phone numbers, and pools that you can create in a given Region. For more
     * information see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/quotas.html"> Amazon Pinpoint
     * quotas </a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAccountLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable responses = client
     *             .describeAccountLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeAccountLimitsIterable responses = client.describeAccountLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAccountLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAccountLimitsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountLimitsIterable describeAccountLimitsPaginator(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeAccountLimitsIterable(this, applyPaginatorUserAgent(describeAccountLimitsRequest));
    }

    /**
     * <p>
     * Describes the specified configuration sets or all in your account.
     * </p>
     * <p>
     * If you specify configuration set names, the output includes information for only the specified configuration
     * sets. If you specify filters, the output includes information for only those configuration sets that meet the
     * filter criteria. If you don't specify configuration set names or filters, the output includes information for all
     * configuration sets.
     * </p>
     * <p>
     * If you specify a configuration set name that isn't valid, an error is returned.
     * </p>
     *
     * @param describeConfigurationSetsRequest
     * @return Result of the DescribeConfigurationSets operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationSetsResponse describeConfigurationSets(
            DescribeConfigurationSetsRequest describeConfigurationSetsRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConfigurationSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConfigurationSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConfigurationSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationSets");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationSetsRequest, DescribeConfigurationSetsResponse>()
                            .withOperationName("DescribeConfigurationSets").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConfigurationSetsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConfigurationSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified configuration sets or all in your account.
     * </p>
     * <p>
     * If you specify configuration set names, the output includes information for only the specified configuration
     * sets. If you specify filters, the output includes information for only those configuration sets that meet the
     * filter criteria. If you don't specify configuration set names or filters, the output includes information for all
     * configuration sets.
     * </p>
     * <p>
     * If you specify a configuration set name that isn't valid, an error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigurationSets(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable responses = client.describeConfigurationSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable responses = client
     *             .describeConfigurationSetsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeConfigurationSetsIterable responses = client.describeConfigurationSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationSets(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigurationSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeConfigurationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeConfigurationSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationSetsIterable describeConfigurationSetsPaginator(
            DescribeConfigurationSetsRequest describeConfigurationSetsRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return new DescribeConfigurationSetsIterable(this, applyPaginatorUserAgent(describeConfigurationSetsRequest));
    }

    /**
     * <p>
     * Describes the specified keywords or all keywords on your origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a
     * customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an Error is returned.
     * </p>
     *
     * @param describeKeywordsRequest
     * @return Result of the DescribeKeywords operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeKeywordsResponse describeKeywords(DescribeKeywordsRequest describeKeywordsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeKeywordsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeKeywordsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeKeywordsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeKeywords");

            return clientHandler.execute(new ClientExecutionParams<DescribeKeywordsRequest, DescribeKeywordsResponse>()
                    .withOperationName("DescribeKeywords").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeKeywordsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeKeywordsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified keywords or all keywords on your origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a
     * customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an Error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeKeywords(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable responses = client.describeKeywordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable responses = client
     *             .describeKeywordsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeKeywordsIterable responses = client.describeKeywordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeKeywords(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeKeywordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeKeywordsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeKeywords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeKeywords"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeKeywordsIterable describeKeywordsPaginator(DescribeKeywordsRequest describeKeywordsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeKeywordsIterable(this, applyPaginatorUserAgent(describeKeywordsRequest));
    }

    /**
     * <p>
     * Describes the specified opt-out list or all opt-out lists in your account.
     * </p>
     * <p>
     * If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out
     * lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the
     * output includes information for all opt-out lists.
     * </p>
     * <p>
     * If you specify an opt-out list name that isn't valid, an Error is returned.
     * </p>
     *
     * @param describeOptOutListsRequest
     * @return Result of the DescribeOptOutLists operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOptOutListsResponse describeOptOutLists(DescribeOptOutListsRequest describeOptOutListsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOptOutListsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeOptOutListsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOptOutListsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOptOutLists");

            return clientHandler.execute(new ClientExecutionParams<DescribeOptOutListsRequest, DescribeOptOutListsResponse>()
                    .withOperationName("DescribeOptOutLists").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeOptOutListsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeOptOutListsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified opt-out list or all opt-out lists in your account.
     * </p>
     * <p>
     * If you specify opt-out list names, the output includes information for only the specified opt-out lists. Opt-out
     * lists include only those that meet the filter criteria. If you don't specify opt-out list names or filters, the
     * output includes information for all opt-out lists.
     * </p>
     * <p>
     * If you specify an opt-out list name that isn't valid, an Error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOptOutLists(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable responses = client.describeOptOutListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable responses = client
     *             .describeOptOutListsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptOutListsIterable responses = client.describeOptOutListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptOutLists(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptOutListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOptOutListsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptOutLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptOutLists"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOptOutListsIterable describeOptOutListsPaginator(DescribeOptOutListsRequest describeOptOutListsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeOptOutListsIterable(this, applyPaginatorUserAgent(describeOptOutListsRequest));
    }

    /**
     * <p>
     * Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
     * </p>
     * <p>
     * If you specify opted out numbers, the output includes information for only the specified opted out numbers. If
     * you specify filters, the output includes information for only those opted out numbers that meet the filter
     * criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out
     * destination numbers in your opt-out list.
     * </p>
     * <p>
     * If you specify an opted out number that isn't valid, an Error is returned.
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     * @return Result of the DescribeOptedOutNumbers operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOptedOutNumbersResponse describeOptedOutNumbers(DescribeOptedOutNumbersRequest describeOptedOutNumbersRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOptedOutNumbersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeOptedOutNumbersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOptedOutNumbersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOptedOutNumbers");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOptedOutNumbersRequest, DescribeOptedOutNumbersResponse>()
                            .withOperationName("DescribeOptedOutNumbers").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeOptedOutNumbersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOptedOutNumbersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list.
     * </p>
     * <p>
     * If you specify opted out numbers, the output includes information for only the specified opted out numbers. If
     * you specify filters, the output includes information for only those opted out numbers that meet the filter
     * criteria. If you don't specify opted out numbers or filters, the output includes information for all opted out
     * destination numbers in your opt-out list.
     * </p>
     * <p>
     * If you specify an opted out number that isn't valid, an Error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOptedOutNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable responses = client.describeOptedOutNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable responses = client
     *             .describeOptedOutNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeOptedOutNumbersIterable responses = client.describeOptedOutNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptedOutNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOptedOutNumbersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeOptedOutNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeOptedOutNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOptedOutNumbersIterable describeOptedOutNumbersPaginator(
            DescribeOptedOutNumbersRequest describeOptedOutNumbersRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        return new DescribeOptedOutNumbersIterable(this, applyPaginatorUserAgent(describeOptedOutNumbersRequest));
    }

    /**
     * <p>
     * Describes the specified origination phone number, or all the phone numbers in your account.
     * </p>
     * <p>
     * If you specify phone number IDs, the output includes information for only the specified phone numbers. If you
     * specify filters, the output includes information for only those phone numbers that meet the filter criteria. If
     * you don't specify phone number IDs or filters, the output includes information for all phone numbers.
     * </p>
     * <p>
     * If you specify a phone number ID that isn't valid, an Error is returned.
     * </p>
     *
     * @param describePhoneNumbersRequest
     * @return Result of the DescribePhoneNumbers operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePhoneNumbersResponse describePhoneNumbers(DescribePhoneNumbersRequest describePhoneNumbersRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePhoneNumbersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePhoneNumbersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePhoneNumbersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePhoneNumbers");

            return clientHandler.execute(new ClientExecutionParams<DescribePhoneNumbersRequest, DescribePhoneNumbersResponse>()
                    .withOperationName("DescribePhoneNumbers").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describePhoneNumbersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribePhoneNumbersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified origination phone number, or all the phone numbers in your account.
     * </p>
     * <p>
     * If you specify phone number IDs, the output includes information for only the specified phone numbers. If you
     * specify filters, the output includes information for only those phone numbers that meet the filter criteria. If
     * you don't specify phone number IDs or filters, the output includes information for all phone numbers.
     * </p>
     * <p>
     * If you specify a phone number ID that isn't valid, an Error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePhoneNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable responses = client.describePhoneNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable responses = client
     *             .describePhoneNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePhoneNumbersIterable responses = client.describePhoneNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePhoneNumbers(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePhoneNumbersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePhoneNumbersIterable describePhoneNumbersPaginator(DescribePhoneNumbersRequest describePhoneNumbersRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribePhoneNumbersIterable(this, applyPaginatorUserAgent(describePhoneNumbersRequest));
    }

    /**
     * <p>
     * Retrieves the specified pools or all pools associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify pool IDs, the output includes information for only the specified pools. If you specify filters,
     * the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs
     * or filters, the output includes information for all pools.
     * </p>
     * <p>
     * If you specify a pool ID that isn't valid, an Error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param describePoolsRequest
     * @return Result of the DescribePools operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePoolsResponse describePools(DescribePoolsRequest describePoolsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePoolsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribePoolsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePoolsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePools");

            return clientHandler.execute(new ClientExecutionParams<DescribePoolsRequest, DescribePoolsResponse>()
                    .withOperationName("DescribePools").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describePoolsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribePoolsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the specified pools or all pools associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify pool IDs, the output includes information for only the specified pools. If you specify filters,
     * the output includes information for only those pools that meet the filter criteria. If you don't specify pool IDs
     * or filters, the output includes information for all pools.
     * </p>
     * <p>
     * If you specify a pool ID that isn't valid, an Error is returned.
     * </p>
     * <p>
     * A pool is a collection of phone numbers and SenderIds. A pool can include one or more phone numbers and SenderIds
     * that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePools(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable responses = client.describePoolsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable responses = client
     *             .describePoolsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribePoolsIterable responses = client.describePoolsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePools(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePoolsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribePools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribePools"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePoolsIterable describePoolsPaginator(DescribePoolsRequest describePoolsRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribePoolsIterable(this, applyPaginatorUserAgent(describePoolsRequest));
    }

    /**
     * <p>
     * Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify
     * filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't
     * specify SenderIds or filters, the output includes information for all SenderIds.
     * </p>
     * <p>
     * f you specify a sender ID that isn't valid, an Error is returned.
     * </p>
     *
     * @param describeSenderIdsRequest
     * @return Result of the DescribeSenderIds operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSenderIdsResponse describeSenderIds(DescribeSenderIdsRequest describeSenderIdsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSenderIdsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSenderIdsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSenderIdsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSenderIds");

            return clientHandler.execute(new ClientExecutionParams<DescribeSenderIdsRequest, DescribeSenderIdsResponse>()
                    .withOperationName("DescribeSenderIds").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeSenderIdsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSenderIdsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify SenderIds, the output includes information for only the specified SenderIds. If you specify
     * filters, the output includes information for only those SenderIds that meet the filter criteria. If you don't
     * specify SenderIds or filters, the output includes information for all SenderIds.
     * </p>
     * <p>
     * f you specify a sender ID that isn't valid, an Error is returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSenderIds(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable responses = client.describeSenderIdsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable responses = client
     *             .describeSenderIdsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSenderIdsIterable responses = client.describeSenderIdsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSenderIds(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSenderIdsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSenderIds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSenderIds"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSenderIdsIterable describeSenderIdsPaginator(DescribeSenderIdsRequest describeSenderIdsRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeSenderIdsIterable(this, applyPaginatorUserAgent(describeSenderIdsRequest));
    }

    /**
     * <p>
     * Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region.
     * For more information on increasing your monthly spend limit, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html">
     * Requesting increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User
     * Guide</i>.
     * </p>
     *
     * @param describeSpendLimitsRequest
     * @return Result of the DescribeSpendLimits operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSpendLimitsResponse describeSpendLimits(DescribeSpendLimitsRequest describeSpendLimitsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSpendLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSpendLimitsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSpendLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSpendLimits");

            return clientHandler.execute(new ClientExecutionParams<DescribeSpendLimitsRequest, DescribeSpendLimitsResponse>()
                    .withOperationName("DescribeSpendLimits").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeSpendLimitsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSpendLimitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial monthly spend limit in a given Region.
     * For more information on increasing your monthly spend limit, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html">
     * Requesting increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSpendLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable responses = client.describeSpendLimitsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable responses = client
     *             .describeSpendLimitsPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.DescribeSpendLimitsIterable responses = client.describeSpendLimitsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSpendLimits(software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSpendLimitsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DescribeSpendLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DescribeSpendLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSpendLimitsIterable describeSpendLimitsPaginator(DescribeSpendLimitsRequest describeSpendLimitsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new DescribeSpendLimitsIterable(this, applyPaginatorUserAgent(describeSpendLimitsRequest));
    }

    /**
     * <p>
     * Removes the specified origination identity from an existing pool.
     * </p>
     * <p>
     * If the origination identity isn't associated with the specified pool, an Error is returned.
     * </p>
     *
     * @param disassociateOriginationIdentityRequest
     * @return Result of the DisassociateOriginationIdentity operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.DisassociateOriginationIdentity
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/DisassociateOriginationIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateOriginationIdentityResponse disassociateOriginationIdentity(
            DisassociateOriginationIdentityRequest disassociateOriginationIdentityRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateOriginationIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateOriginationIdentityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateOriginationIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateOriginationIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateOriginationIdentityRequest, DisassociateOriginationIdentityResponse>()
                            .withOperationName("DisassociateOriginationIdentity").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateOriginationIdentityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateOriginationIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all associated origination identities in your pool.
     * </p>
     * <p>
     * If you specify filters, the output includes information for only those origination identities that meet the
     * filter criteria.
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     * @return Result of the ListPoolOriginationIdentities operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPoolOriginationIdentitiesResponse listPoolOriginationIdentities(
            ListPoolOriginationIdentitiesRequest listPoolOriginationIdentitiesRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPoolOriginationIdentitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPoolOriginationIdentitiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPoolOriginationIdentitiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPoolOriginationIdentities");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPoolOriginationIdentitiesRequest, ListPoolOriginationIdentitiesResponse>()
                            .withOperationName("ListPoolOriginationIdentities").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listPoolOriginationIdentitiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPoolOriginationIdentitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all associated origination identities in your pool.
     * </p>
     * <p>
     * If you specify filters, the output includes information for only those origination identities that meet the
     * filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPoolOriginationIdentities(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable responses = client.listPoolOriginationIdentitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable responses = client
     *             .listPoolOriginationIdentitiesPaginator(request);
     *     for (software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pinpointsmsvoicev2.paginators.ListPoolOriginationIdentitiesIterable responses = client.listPoolOriginationIdentitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPoolOriginationIdentities(software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPoolOriginationIdentitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListPoolOriginationIdentities
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListPoolOriginationIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPoolOriginationIdentitiesIterable listPoolOriginationIdentitiesPaginator(
            ListPoolOriginationIdentitiesRequest listPoolOriginationIdentitiesRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        return new ListPoolOriginationIdentitiesIterable(this, applyPaginatorUserAgent(listPoolOriginationIdentitiesRequest));
    }

    /**
     * <p>
     * List all tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a keyword configuration on an origination phone number or pool.
     * </p>
     * <p>
     * A keyword is a word that you can search for on a particular phone number or pool. It is also a specific word or
     * phrase that an end user can send to your number to elicit a response, such as an informational message or a
     * special offer. When your number receives a message that begins with a keyword, Amazon Pinpoint responds with a
     * customizable message.
     * </p>
     * <p>
     * If you specify a keyword that isn't valid, an Error is returned.
     * </p>
     *
     * @param putKeywordRequest
     * @return Result of the PutKeyword operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.PutKeyword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutKeyword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutKeywordResponse putKeyword(PutKeywordRequest putKeywordRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutKeywordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutKeywordResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putKeywordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutKeyword");

            return clientHandler
                    .execute(new ClientExecutionParams<PutKeywordRequest, PutKeywordResponse>().withOperationName("PutKeyword")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putKeywordRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutKeywordRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an opted out destination phone number in the opt-out list.
     * </p>
     * <p>
     * If the destination phone number isn't valid or if the specified opt-out list doesn't exist, an Error is returned.
     * </p>
     *
     * @param putOptedOutNumberRequest
     * @return Result of the PutOptedOutNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.PutOptedOutNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/PutOptedOutNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutOptedOutNumberResponse putOptedOutNumber(PutOptedOutNumberRequest putOptedOutNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutOptedOutNumberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutOptedOutNumberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putOptedOutNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutOptedOutNumber");

            return clientHandler.execute(new ClientExecutionParams<PutOptedOutNumberRequest, PutOptedOutNumberResponse>()
                    .withOperationName("PutOptedOutNumber").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putOptedOutNumberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutOptedOutNumberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Releases an existing origination phone number in your account. Once released, a phone number is no longer
     * available for sending messages.
     * </p>
     * <p>
     * If the origination phone number has deletion protection enabled or is associated with a pool, an Error is
     * returned.
     * </p>
     *
     * @param releasePhoneNumberRequest
     * @return Result of the ReleasePhoneNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.ReleasePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/ReleasePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ReleasePhoneNumberResponse releasePhoneNumber(ReleasePhoneNumberRequest releasePhoneNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ReleasePhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ReleasePhoneNumberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, releasePhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ReleasePhoneNumber");

            return clientHandler.execute(new ClientExecutionParams<ReleasePhoneNumberRequest, ReleasePhoneNumberResponse>()
                    .withOperationName("ReleasePhoneNumber").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(releasePhoneNumberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ReleasePhoneNumberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Request an origination phone number for use in your account. For more information on phone number request see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-request-number.html"> Requesting a
     * number </a> in the <i>Amazon Pinpoint User Guide</i>.
     * </p>
     *
     * @param requestPhoneNumberRequest
     * @return Result of the RequestPhoneNumber operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.RequestPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/RequestPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RequestPhoneNumberResponse requestPhoneNumber(RequestPhoneNumberRequest requestPhoneNumberRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RequestPhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RequestPhoneNumberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, requestPhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RequestPhoneNumber");

            return clientHandler.execute(new ClientExecutionParams<RequestPhoneNumberRequest, RequestPhoneNumberResponse>()
                    .withOperationName("RequestPhoneNumber").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(requestPhoneNumberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RequestPhoneNumberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new text message and sends it to a recipient's phone number.
     * </p>
     * <p>
     * SMS throughput limits are measured in Message Parts per Second (MPS). Your MPS limit depends on the destination
     * country of your messages, as well as the type of phone number (origination number) that you use to send the
     * message. For more information, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-limitations-mps.html">Message Parts per
     * Second (MPS) limits</a> in the <i>Amazon Pinpoint User Guide</i>.
     * </p>
     *
     * @param sendTextMessageRequest
     * @return Result of the SendTextMessage operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SendTextMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendTextMessage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SendTextMessageResponse sendTextMessage(SendTextMessageRequest sendTextMessageRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendTextMessageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendTextMessageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendTextMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendTextMessage");

            return clientHandler.execute(new ClientExecutionParams<SendTextMessageRequest, SendTextMessageResponse>()
                    .withOperationName("SendTextMessage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(sendTextMessageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SendTextMessageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows you to send a request that sends a text message through Amazon Pinpoint. This operation uses <a
     * href="http://aws.amazon.com/polly/">Amazon Polly</a> to convert a text script into a voice message.
     * </p>
     *
     * @param sendVoiceMessageRequest
     * @return Result of the SendVoiceMessage operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SendVoiceMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SendVoiceMessage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SendVoiceMessageResponse sendVoiceMessage(SendVoiceMessageRequest sendVoiceMessageRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendVoiceMessageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendVoiceMessageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendVoiceMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendVoiceMessage");

            return clientHandler.execute(new ClientExecutionParams<SendVoiceMessageRequest, SendVoiceMessageResponse>()
                    .withOperationName("SendVoiceMessage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(sendVoiceMessageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SendVoiceMessageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the default message type on a configuration set.
     * </p>
     * <p>
     * Choose the category of SMS messages that you plan to send from this account. If you send account-related messages
     * or time-sensitive messages such as one-time passcodes, choose <b>Transactional</b>. If you plan to send messages
     * that contain marketing material or other promotional content, choose <b>Promotional</b>. This setting applies to
     * your entire Amazon Web Services account.
     * </p>
     *
     * @param setDefaultMessageTypeRequest
     * @return Result of the SetDefaultMessageType operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetDefaultMessageType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultMessageType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetDefaultMessageTypeResponse setDefaultMessageType(SetDefaultMessageTypeRequest setDefaultMessageTypeRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SetDefaultMessageTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SetDefaultMessageTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setDefaultMessageTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetDefaultMessageType");

            return clientHandler.execute(new ClientExecutionParams<SetDefaultMessageTypeRequest, SetDefaultMessageTypeResponse>()
                    .withOperationName("SetDefaultMessageType").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(setDefaultMessageTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetDefaultMessageTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets default sender ID on a configuration set.
     * </p>
     * <p>
     * When sending a text message to a destination country that supports sender IDs, the default sender ID on the
     * configuration set specified will be used if no dedicated origination phone numbers or registered sender IDs are
     * available in your account.
     * </p>
     *
     * @param setDefaultSenderIdRequest
     * @return Result of the SetDefaultSenderId operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetDefaultSenderId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetDefaultSenderId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetDefaultSenderIdResponse setDefaultSenderId(SetDefaultSenderIdRequest setDefaultSenderIdRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SetDefaultSenderIdResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SetDefaultSenderIdResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setDefaultSenderIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetDefaultSenderId");

            return clientHandler.execute(new ClientExecutionParams<SetDefaultSenderIdRequest, SetDefaultSenderIdResponse>()
                    .withOperationName("SetDefaultSenderId").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(setDefaultSenderIdRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetDefaultSenderIdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending text messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     *
     * @param setTextMessageSpendLimitOverrideRequest
     * @return Result of the SetTextMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetTextMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetTextMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetTextMessageSpendLimitOverrideResponse setTextMessageSpendLimitOverride(
            SetTextMessageSpendLimitOverrideRequest setTextMessageSpendLimitOverrideRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SetTextMessageSpendLimitOverrideResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SetTextMessageSpendLimitOverrideResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                setTextMessageSpendLimitOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetTextMessageSpendLimitOverride");

            return clientHandler
                    .execute(new ClientExecutionParams<SetTextMessageSpendLimitOverrideRequest, SetTextMessageSpendLimitOverrideResponse>()
                            .withOperationName("SetTextMessageSpendLimitOverride").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(setTextMessageSpendLimitOverrideRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SetTextMessageSpendLimitOverrideRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets an account level monthly spend limit override for sending voice messages. The requested spend limit must be
     * less than or equal to the <code>MaxLimit</code>, which is set by Amazon Web Services.
     * </p>
     *
     * @param setVoiceMessageSpendLimitOverrideRequest
     * @return Result of the SetVoiceMessageSpendLimitOverride operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.SetVoiceMessageSpendLimitOverride
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/SetVoiceMessageSpendLimitOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetVoiceMessageSpendLimitOverrideResponse setVoiceMessageSpendLimitOverride(
            SetVoiceMessageSpendLimitOverrideRequest setVoiceMessageSpendLimitOverrideRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SetVoiceMessageSpendLimitOverrideResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SetVoiceMessageSpendLimitOverrideResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                setVoiceMessageSpendLimitOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetVoiceMessageSpendLimitOverride");

            return clientHandler
                    .execute(new ClientExecutionParams<SetVoiceMessageSpendLimitOverrideRequest, SetVoiceMessageSpendLimitOverrideResponse>()
                            .withOperationName("SetVoiceMessageSpendLimitOverride").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(setVoiceMessageSpendLimitOverrideRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SetVoiceMessageSpendLimitOverrideRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon Pinpoint SMS Voice, version 2 resource. When
     * you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of
     * 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more
     * information about tags, see <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging Amazon Pinpoint
     * resources</a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the association of the specified tags from an Amazon Pinpoint SMS Voice V2 resource. For more information
     * on tags see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/tagging-resources.html"> Tagging
     * Amazon Pinpoint resources</a> in the <i>Amazon Pinpoint Developer Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            AccessDeniedException, ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs
     * and Kinesis Data Firehose. You can also enable or disable the event destination.
     * </p>
     * <p>
     * You may want to update an event destination to change its matching event types or updating the destination
     * resource ARN. You can't change an event destination's type between CloudWatch Logs, Kinesis Data Firehose, and
     * Amazon SNS.
     * </p>
     *
     * @param updateEventDestinationRequest
     * @return Result of the UpdateEventDestination operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdateEventDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdateEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEventDestinationResponse updateEventDestination(UpdateEventDestinationRequest updateEventDestinationRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEventDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEventDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEventDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateEventDestinationRequest, UpdateEventDestinationResponse>()
                            .withOperationName("UpdateEventDestination").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateEventDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateEventDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or
     * disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or
     * disable deletion protection.
     * </p>
     * <p>
     * If the origination phone number is associated with a pool, an Error is returned.
     * </p>
     *
     * @param updatePhoneNumberRequest
     * @return Result of the UpdatePhoneNumber operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePhoneNumberResponse updatePhoneNumber(UpdatePhoneNumberRequest updatePhoneNumberRequest)
            throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePhoneNumberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePhoneNumber");

            return clientHandler.execute(new ClientExecutionParams<UpdatePhoneNumberRequest, UpdatePhoneNumberResponse>()
                    .withOperationName("UpdatePhoneNumber").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updatePhoneNumberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePhoneNumberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way
     * messaging, change the <code>TwoWayChannelArn</code>, enable or disable self-managed opt-outs, enable or disable
     * deletion protection, and enable or disable shared routes.
     * </p>
     *
     * @param updatePoolRequest
     * @return Result of the UpdatePool operation returned by the service.
     * @throws ThrottlingException
     *         An error that occurred because too many requests were sent during a certain amount of time.
     * @throws AccessDeniedException
     *         The request was denied because you don't have sufficient permissions to access the resource.
     * @throws ResourceNotFoundException
     *         A requested resource couldn't be found.
     * @throws ValidationException
     *         A validation exception for a field.
     * @throws ConflictException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time or it could be that the requested action isn't valid for
     *         the current state or configuration of the resource.
     * @throws InternalServerException
     *         The API encountered an unexpected error and couldn't complete the request. You might be able to
     *         successfully issue the request again in the future.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PinpointSmsVoiceV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PinpointSmsVoiceV2Client.UpdatePool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-sms-voice-v2-2022-03-31/UpdatePool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePoolResponse updatePool(UpdatePoolRequest updatePoolRequest) throws ThrottlingException, AccessDeniedException,
            ResourceNotFoundException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, PinpointSmsVoiceV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePoolResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePoolResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint SMS Voice V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePool");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdatePoolRequest, UpdatePoolResponse>().withOperationName("UpdatePool")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updatePoolRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdatePoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(PinpointSmsVoiceV2Exception::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends PinpointSmsVoiceV2Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
