/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current resource quotas associated with an Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountLimit implements SdkPojo, Serializable, ToCopyableBuilder<AccountLimit.Builder, AccountLimit> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AccountLimit::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Long> USED_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Used")
            .getter(getter(AccountLimit::used)).setter(setter(Builder::used))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Used").build()).build();

    private static final SdkField<Long> MAX_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Max")
            .getter(getter(AccountLimit::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, USED_FIELD,
            MAX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Long used;

    private final Long max;

    private AccountLimit(BuilderImpl builder) {
        this.name = builder.name;
        this.used = builder.used;
        this.max = builder.max;
    }

    /**
     * <p>
     * The name of the attribute to apply the account limit to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AccountLimitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the attribute to apply the account limit to.
     * @see AccountLimitName
     */
    public final AccountLimitName name() {
        return AccountLimitName.fromValue(name);
    }

    /**
     * <p>
     * The name of the attribute to apply the account limit to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AccountLimitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the attribute to apply the account limit to.
     * @see AccountLimitName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The current amount that has been spent, in US dollars.
     * </p>
     * 
     * @return The current amount that has been spent, in US dollars.
     */
    public final Long used() {
        return used;
    }

    /**
     * <p>
     * The Amazon Web Services set limit for that resource type, in US dollars.
     * </p>
     * 
     * @return The Amazon Web Services set limit for that resource type, in US dollars.
     */
    public final Long max() {
        return max;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(used());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLimit)) {
            return false;
        }
        AccountLimit other = (AccountLimit) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(used(), other.used())
                && Objects.equals(max(), other.max());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountLimit").add("Name", nameAsString()).add("Used", used()).add("Max", max()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Used":
            return Optional.ofNullable(clazz.cast(used()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountLimit, T> g) {
        return obj -> g.apply((AccountLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountLimit> {
        /**
         * <p>
         * The name of the attribute to apply the account limit to.
         * </p>
         * 
         * @param name
         *        The name of the attribute to apply the account limit to.
         * @see AccountLimitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountLimitName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the attribute to apply the account limit to.
         * </p>
         * 
         * @param name
         *        The name of the attribute to apply the account limit to.
         * @see AccountLimitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountLimitName
         */
        Builder name(AccountLimitName name);

        /**
         * <p>
         * The current amount that has been spent, in US dollars.
         * </p>
         * 
         * @param used
         *        The current amount that has been spent, in US dollars.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder used(Long used);

        /**
         * <p>
         * The Amazon Web Services set limit for that resource type, in US dollars.
         * </p>
         * 
         * @param max
         *        The Amazon Web Services set limit for that resource type, in US dollars.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Long max);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Long used;

        private Long max;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLimit model) {
            name(model.name);
            used(model.used);
            max(model.max);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AccountLimitName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Long getUsed() {
            return used;
        }

        public final void setUsed(Long used) {
            this.used = used;
        }

        @Override
        public final Builder used(Long used) {
            this.used = used;
            return this;
        }

        public final Long getMax() {
            return max;
        }

        public final void setMax(Long max) {
            this.max = max;
        }

        @Override
        public final Builder max(Long max) {
            this.max = max;
            return this;
        }

        @Override
        public AccountLimit build() {
            return new AccountLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
