/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the current Amazon Pinpoint monthly spend limits for sending voice and text messages. For more information
 * on increasing your monthly spend limit, see <a
 * href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-awssupport-spend-threshold.html"> Requesting
 * increases to your monthly SMS spending quota for Amazon Pinpoint </a> in the <i>Amazon Pinpoint User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpendLimit implements SdkPojo, Serializable, ToCopyableBuilder<SpendLimit.Builder, SpendLimit> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SpendLimit::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Long> ENFORCED_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EnforcedLimit").getter(getter(SpendLimit::enforcedLimit)).setter(setter(Builder::enforcedLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforcedLimit").build()).build();

    private static final SdkField<Long> MAX_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("MaxLimit")
            .getter(getter(SpendLimit::maxLimit)).setter(setter(Builder::maxLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxLimit").build()).build();

    private static final SdkField<Boolean> OVERRIDDEN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Overridden").getter(getter(SpendLimit::overridden)).setter(setter(Builder::overridden))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overridden").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ENFORCED_LIMIT_FIELD, MAX_LIMIT_FIELD, OVERRIDDEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Long enforcedLimit;

    private final Long maxLimit;

    private final Boolean overridden;

    private SpendLimit(BuilderImpl builder) {
        this.name = builder.name;
        this.enforcedLimit = builder.enforcedLimit;
        this.maxLimit = builder.maxLimit;
        this.overridden = builder.overridden;
    }

    /**
     * <p>
     * The name for the SpendLimit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SpendLimitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name for the SpendLimit.
     * @see SpendLimitName
     */
    public final SpendLimitName name() {
        return SpendLimitName.fromValue(name);
    }

    /**
     * <p>
     * The name for the SpendLimit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SpendLimitName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name for the SpendLimit.
     * @see SpendLimitName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The maximum amount of money, in US dollars, that you want to be able to spend sending messages each month. This
     * value has to be less than or equal to the amount in <code>MaxLimit</code>. To use this custom limit,
     * <code>Overridden</code> must be set to true.
     * </p>
     * 
     * @return The maximum amount of money, in US dollars, that you want to be able to spend sending messages each
     *         month. This value has to be less than or equal to the amount in <code>MaxLimit</code>. To use this custom
     *         limit, <code>Overridden</code> must be set to true.
     */
    public final Long enforcedLimit() {
        return enforcedLimit;
    }

    /**
     * <p>
     * The maximum amount of money that you are able to spend to send messages each month, in US dollars.
     * </p>
     * 
     * @return The maximum amount of money that you are able to spend to send messages each month, in US dollars.
     */
    public final Long maxLimit() {
        return maxLimit;
    }

    /**
     * <p>
     * When set to <code>True</code>, the value that has been specified in the <code>EnforcedLimit</code> is used to
     * determine the maximum amount in US dollars that can be spent to send messages each month, in US dollars.
     * </p>
     * 
     * @return When set to <code>True</code>, the value that has been specified in the <code>EnforcedLimit</code> is
     *         used to determine the maximum amount in US dollars that can be spent to send messages each month, in US
     *         dollars.
     */
    public final Boolean overridden() {
        return overridden;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enforcedLimit());
        hashCode = 31 * hashCode + Objects.hashCode(maxLimit());
        hashCode = 31 * hashCode + Objects.hashCode(overridden());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpendLimit)) {
            return false;
        }
        SpendLimit other = (SpendLimit) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(enforcedLimit(), other.enforcedLimit())
                && Objects.equals(maxLimit(), other.maxLimit()) && Objects.equals(overridden(), other.overridden());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpendLimit").add("Name", nameAsString()).add("EnforcedLimit", enforcedLimit())
                .add("MaxLimit", maxLimit()).add("Overridden", overridden()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "EnforcedLimit":
            return Optional.ofNullable(clazz.cast(enforcedLimit()));
        case "MaxLimit":
            return Optional.ofNullable(clazz.cast(maxLimit()));
        case "Overridden":
            return Optional.ofNullable(clazz.cast(overridden()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpendLimit, T> g) {
        return obj -> g.apply((SpendLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpendLimit> {
        /**
         * <p>
         * The name for the SpendLimit.
         * </p>
         * 
         * @param name
         *        The name for the SpendLimit.
         * @see SpendLimitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpendLimitName
         */
        Builder name(String name);

        /**
         * <p>
         * The name for the SpendLimit.
         * </p>
         * 
         * @param name
         *        The name for the SpendLimit.
         * @see SpendLimitName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpendLimitName
         */
        Builder name(SpendLimitName name);

        /**
         * <p>
         * The maximum amount of money, in US dollars, that you want to be able to spend sending messages each month.
         * This value has to be less than or equal to the amount in <code>MaxLimit</code>. To use this custom limit,
         * <code>Overridden</code> must be set to true.
         * </p>
         * 
         * @param enforcedLimit
         *        The maximum amount of money, in US dollars, that you want to be able to spend sending messages each
         *        month. This value has to be less than or equal to the amount in <code>MaxLimit</code>. To use this
         *        custom limit, <code>Overridden</code> must be set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforcedLimit(Long enforcedLimit);

        /**
         * <p>
         * The maximum amount of money that you are able to spend to send messages each month, in US dollars.
         * </p>
         * 
         * @param maxLimit
         *        The maximum amount of money that you are able to spend to send messages each month, in US dollars.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLimit(Long maxLimit);

        /**
         * <p>
         * When set to <code>True</code>, the value that has been specified in the <code>EnforcedLimit</code> is used to
         * determine the maximum amount in US dollars that can be spent to send messages each month, in US dollars.
         * </p>
         * 
         * @param overridden
         *        When set to <code>True</code>, the value that has been specified in the <code>EnforcedLimit</code> is
         *        used to determine the maximum amount in US dollars that can be spent to send messages each month, in
         *        US dollars.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overridden(Boolean overridden);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Long enforcedLimit;

        private Long maxLimit;

        private Boolean overridden;

        private BuilderImpl() {
        }

        private BuilderImpl(SpendLimit model) {
            name(model.name);
            enforcedLimit(model.enforcedLimit);
            maxLimit(model.maxLimit);
            overridden(model.overridden);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(SpendLimitName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Long getEnforcedLimit() {
            return enforcedLimit;
        }

        public final void setEnforcedLimit(Long enforcedLimit) {
            this.enforcedLimit = enforcedLimit;
        }

        @Override
        public final Builder enforcedLimit(Long enforcedLimit) {
            this.enforcedLimit = enforcedLimit;
            return this;
        }

        public final Long getMaxLimit() {
            return maxLimit;
        }

        public final void setMaxLimit(Long maxLimit) {
            this.maxLimit = maxLimit;
        }

        @Override
        public final Builder maxLimit(Long maxLimit) {
            this.maxLimit = maxLimit;
            return this;
        }

        public final Boolean getOverridden() {
            return overridden;
        }

        public final void setOverridden(Boolean overridden) {
            this.overridden = overridden;
        }

        @Override
        public final Builder overridden(Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        @Override
        public SpendLimit build() {
            return new SpendLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
